/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner.iterative.rule;

import com.google.common.collect.ImmutableMap;
import io.trino.spi.Plugin;
import io.trino.spi.type.BooleanType;
import io.trino.spi.type.Type;
import io.trino.sql.ir.Booleans;
import io.trino.sql.ir.Expression;
import io.trino.sql.planner.Symbol;
import io.trino.sql.planner.assertions.ExpressionMatcher;
import io.trino.sql.planner.assertions.PlanMatchPattern;
import io.trino.sql.planner.iterative.Rule;
import io.trino.sql.planner.iterative.rule.PushOffsetThroughProject;
import io.trino.sql.planner.iterative.rule.test.BaseRuleTest;
import io.trino.sql.planner.plan.Assignments;
import io.trino.sql.planner.plan.PlanNode;
import java.util.Map;
import org.junit.jupiter.api.Test;

public class TestPushOffsetThroughProject
extends BaseRuleTest {
    public TestPushOffsetThroughProject() {
        super(new Plugin[0]);
    }

    @Test
    public void testPushdownOffsetNonIdentityProjection() {
        this.tester().assertThat((Rule<?>)new PushOffsetThroughProject()).on(p -> {
            Symbol a = p.symbol("a", (Type)BooleanType.BOOLEAN);
            return p.offset(5L, (PlanNode)p.project(Assignments.of((Symbol)a, (Expression)Booleans.TRUE), (PlanNode)p.values(new Symbol[0])));
        }).matches(PlanMatchPattern.strictProject((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"b", (Object)PlanMatchPattern.expression((Expression)Booleans.TRUE)), PlanMatchPattern.offset(5L, PlanMatchPattern.values(new String[0]))));
    }

    @Test
    public void testDoNotPushdownOffsetThroughIdentityProjection() {
        this.tester().assertThat((Rule<?>)new PushOffsetThroughProject()).on(p -> {
            Symbol a = p.symbol("a");
            return p.offset(5L, (PlanNode)p.project(Assignments.of((Symbol)a, (Expression)a.toSymbolReference()), (PlanNode)p.values(a)));
        }).doesNotFire();
    }
}

