/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner.optimizations;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import io.trino.metadata.Metadata;
import io.trino.spi.connector.SortOrder;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.IntegerType;
import io.trino.spi.type.Type;
import io.trino.spi.type.VarcharType;
import io.trino.sql.ir.Cast;
import io.trino.sql.ir.Comparison;
import io.trino.sql.ir.Constant;
import io.trino.sql.ir.Expression;
import io.trino.sql.ir.IsNull;
import io.trino.sql.ir.Not;
import io.trino.sql.ir.Reference;
import io.trino.sql.planner.PlanOptimizers;
import io.trino.sql.planner.RuleStatsRecorder;
import io.trino.sql.planner.assertions.BasePlanTest;
import io.trino.sql.planner.assertions.ExpectedValueProvider;
import io.trino.sql.planner.assertions.ExpressionMatcher;
import io.trino.sql.planner.assertions.PlanMatchPattern;
import io.trino.sql.planner.iterative.IterativeOptimizer;
import io.trino.sql.planner.iterative.rule.GatherAndMergeWindows;
import io.trino.sql.planner.iterative.rule.RemoveRedundantIdentityProjections;
import io.trino.sql.planner.optimizations.PlanOptimizer;
import io.trino.sql.planner.optimizations.UnaliasSymbolReferences;
import io.trino.sql.planner.plan.DataOrganizationSpecification;
import io.trino.sql.planner.plan.FrameBoundType;
import io.trino.sql.planner.plan.JoinType;
import io.trino.sql.planner.plan.WindowFrameType;
import io.trino.sql.planner.plan.WindowNode;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.intellij.lang.annotations.Language;
import org.junit.jupiter.api.Test;

public class TestMergeWindows
extends BasePlanTest {
    private static final String SUPPKEY_ALIAS = "SUPPKEY";
    private static final String ORDERKEY_ALIAS = "ORDERKEY";
    private static final String SHIPDATE_ALIAS = "SHIPDATE";
    private static final String QUANTITY_ALIAS = "QUANTITY";
    private static final String DISCOUNT_ALIAS = "DISCOUNT";
    private static final String EXTENDEDPRICE_ALIAS = "EXTENDEDPRICE";
    private static final PlanMatchPattern LINEITEM_TABLESCAN_DOQSS = PlanMatchPattern.tableScan("lineitem", (Map<String, String>)ImmutableMap.of((Object)"QUANTITY", (Object)"quantity", (Object)"DISCOUNT", (Object)"discount", (Object)"SUPPKEY", (Object)"suppkey", (Object)"ORDERKEY", (Object)"orderkey", (Object)"SHIPDATE", (Object)"shipdate"));
    private static final PlanMatchPattern LINEITEM_TABLESCAN_DOQS = PlanMatchPattern.tableScan("lineitem", (Map<String, String>)ImmutableMap.of((Object)"QUANTITY", (Object)"quantity", (Object)"DISCOUNT", (Object)"discount", (Object)"SUPPKEY", (Object)"suppkey", (Object)"ORDERKEY", (Object)"orderkey"));
    private static final PlanMatchPattern LINEITEM_TABLESCAN_DEOQS = PlanMatchPattern.tableScan("lineitem", (Map<String, String>)ImmutableMap.of((Object)"QUANTITY", (Object)"quantity", (Object)"SUPPKEY", (Object)"suppkey", (Object)"ORDERKEY", (Object)"orderkey", (Object)"DISCOUNT", (Object)"discount", (Object)"EXTENDEDPRICE", (Object)"extendedprice"));
    private static final WindowNode.Frame COMMON_FRAME = new WindowNode.Frame(WindowFrameType.ROWS, FrameBoundType.UNBOUNDED_PRECEDING, Optional.empty(), Optional.empty(), FrameBoundType.CURRENT_ROW, Optional.empty(), Optional.empty());
    private final ExpectedValueProvider<DataOrganizationSpecification> specificationA = PlanMatchPattern.specification((List<String>)ImmutableList.of((Object)"SUPPKEY"), (List<String>)ImmutableList.of((Object)"ORDERKEY"), (Map<String, SortOrder>)ImmutableMap.of((Object)"ORDERKEY", (Object)SortOrder.ASC_NULLS_LAST));
    private final ExpectedValueProvider<DataOrganizationSpecification> specificationB = PlanMatchPattern.specification((List<String>)ImmutableList.of((Object)"ORDERKEY"), (List<String>)ImmutableList.of((Object)"SHIPDATE"), (Map<String, SortOrder>)ImmutableMap.of((Object)"SHIPDATE", (Object)SortOrder.ASC_NULLS_LAST));

    public TestMergeWindows() {
        super((Map<String, String>)ImmutableMap.of());
    }

    @Test
    public void testMergeableWindowsAllOptimizers() {
        String sql = "SELECT SUM(quantity) OVER (PARTITION BY suppkey ORDER BY orderkey ROWS BETWEEN UNBOUNDED PRECEDING AND CURRENT ROW) sum_quantity_A, SUM(quantity) OVER (PARTITION BY orderkey ORDER BY shipdate ROWS BETWEEN UNBOUNDED PRECEDING AND CURRENT ROW) sum_quantity_B, SUM(discount) OVER (PARTITION BY suppkey ORDER BY orderkey ROWS BETWEEN UNBOUNDED PRECEDING AND CURRENT ROW) sum_discount_A FROM lineitem";
        PlanMatchPattern pattern = PlanMatchPattern.anyTree(PlanMatchPattern.window(windowMatcherBuilder -> windowMatcherBuilder.specification(this.specificationA).addFunction(PlanMatchPattern.windowFunction("sum", (List<String>)ImmutableList.of((Object)QUANTITY_ALIAS), COMMON_FRAME)).addFunction(PlanMatchPattern.windowFunction("sum", (List<String>)ImmutableList.of((Object)DISCOUNT_ALIAS), COMMON_FRAME)), PlanMatchPattern.anyTree(PlanMatchPattern.window(windowMatcherBuilder -> windowMatcherBuilder.specification(this.specificationB).addFunction(PlanMatchPattern.windowFunction("sum", (List<String>)ImmutableList.of((Object)QUANTITY_ALIAS), COMMON_FRAME)), LINEITEM_TABLESCAN_DOQSS))));
        this.assertPlan(sql, pattern);
    }

    @Test
    public void testIdenticalWindowSpecificationsABA() {
        String sql = "SELECT SUM(quantity) OVER (PARTITION BY suppkey ORDER BY orderkey ROWS BETWEEN UNBOUNDED PRECEDING AND CURRENT ROW) sum_quantity_A, SUM(quantity) OVER (PARTITION BY orderkey ORDER BY shipdate ROWS BETWEEN UNBOUNDED PRECEDING AND CURRENT ROW) sum_quantity_B, SUM(discount) OVER (PARTITION BY suppkey ORDER BY orderkey ROWS BETWEEN UNBOUNDED PRECEDING AND CURRENT ROW) sum_discount_A FROM lineitem";
        this.assertUnitPlan(sql, PlanMatchPattern.anyTree(PlanMatchPattern.window(windowMatcherBuilder -> windowMatcherBuilder.specification(this.specificationA).addFunction(PlanMatchPattern.windowFunction("sum", (List<String>)ImmutableList.of((Object)QUANTITY_ALIAS), COMMON_FRAME)).addFunction(PlanMatchPattern.windowFunction("sum", (List<String>)ImmutableList.of((Object)DISCOUNT_ALIAS), COMMON_FRAME)), PlanMatchPattern.project(PlanMatchPattern.window(windowMatcherBuilder -> windowMatcherBuilder.specification(this.specificationB).addFunction(PlanMatchPattern.windowFunction("sum", (List<String>)ImmutableList.of((Object)QUANTITY_ALIAS), COMMON_FRAME)), LINEITEM_TABLESCAN_DOQSS)))));
    }

    @Test
    public void testIdenticalWindowSpecificationsABcpA() {
        String sql = "SELECT SUM(quantity) OVER (PARTITION BY suppkey ORDER BY orderkey ROWS BETWEEN UNBOUNDED PRECEDING AND CURRENT ROW) sum_quantity_A, NTH_VALUE(quantity, 1) OVER (PARTITION BY orderkey ORDER BY shipdate ROWS BETWEEN UNBOUNDED PRECEDING AND CURRENT ROW) first_quantity_B, SUM(discount) OVER (PARTITION BY suppkey ORDER BY orderkey ROWS BETWEEN UNBOUNDED PRECEDING AND CURRENT ROW) sum_discount_A FROM lineitem";
        this.assertUnitPlan(sql, PlanMatchPattern.anyTree(PlanMatchPattern.window(windowMatcherBuilder -> windowMatcherBuilder.specification(this.specificationA).addFunction(PlanMatchPattern.windowFunction("sum", (List<String>)ImmutableList.of((Object)DISCOUNT_ALIAS), COMMON_FRAME)).addFunction(PlanMatchPattern.windowFunction("sum", (List<String>)ImmutableList.of((Object)QUANTITY_ALIAS), COMMON_FRAME)), PlanMatchPattern.project(PlanMatchPattern.window(windowMatcherBuilder -> windowMatcherBuilder.specification(this.specificationB).addFunction(PlanMatchPattern.windowFunction("nth_value", (List<String>)ImmutableList.of((Object)QUANTITY_ALIAS, (Object)"ONE"), COMMON_FRAME)), PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"ONE", (Object)PlanMatchPattern.expression((Expression)new Cast((Expression)new Reference((Type)IntegerType.INTEGER, "expr"), (Type)BigintType.BIGINT))), PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"expr", (Object)PlanMatchPattern.expression((Expression)new Constant((Type)IntegerType.INTEGER, (Object)1L))), LINEITEM_TABLESCAN_DOQSS)))))));
    }

    @Test
    public void testIdenticalWindowSpecificationsABfilterA() {
        String sql = "SELECT  sum_discount_A,   SUM(quantity) OVER (PARTITION BY suppkey ORDER BY orderkey ROWS BETWEEN UNBOUNDED PRECEDING AND CURRENT ROW) sum_quantity_A,   SUM(quantity) OVER (PARTITION BY orderkey ORDER BY shipdate ROWS BETWEEN UNBOUNDED PRECEDING AND CURRENT ROW) sum_quantity_B FROM (  SELECT    *,     SUM(discount) OVER (PARTITION BY suppkey ORDER BY orderkey ROWS BETWEEN UNBOUNDED PRECEDING AND CURRENT ROW) sum_discount_A   FROM lineitem)WHERE shipdate IS NOT NULL";
        this.assertUnitPlan(sql, PlanMatchPattern.anyTree(PlanMatchPattern.window(windowMatcherBuilder -> windowMatcherBuilder.specification(this.specificationA).addFunction(PlanMatchPattern.windowFunction("sum", (List<String>)ImmutableList.of((Object)QUANTITY_ALIAS), COMMON_FRAME)), PlanMatchPattern.project(PlanMatchPattern.window(windowMatcherBuilder -> windowMatcherBuilder.specification(this.specificationB).addFunction(PlanMatchPattern.windowFunction("sum", (List<String>)ImmutableList.of((Object)QUANTITY_ALIAS), COMMON_FRAME)), PlanMatchPattern.filter((Expression)new Not((Expression)new IsNull((Expression)new Reference((Type)VarcharType.VARCHAR, SHIPDATE_ALIAS))), PlanMatchPattern.project(PlanMatchPattern.window(windowMatcherBuilder -> windowMatcherBuilder.specification(this.specificationA).addFunction(PlanMatchPattern.windowFunction("sum", (List<String>)ImmutableList.of((Object)DISCOUNT_ALIAS), COMMON_FRAME)), LINEITEM_TABLESCAN_DOQSS))))))));
    }

    @Test
    public void testIdenticalWindowSpecificationsAAcpA() {
        String sql = "SELECT SUM(quantity) OVER (PARTITION BY suppkey ORDER BY orderkey ROWS BETWEEN UNBOUNDED PRECEDING AND CURRENT ROW) sum_quantity_A, NTH_VALUE(quantity, 1) OVER (PARTITION BY suppkey ORDER BY orderkey ROWS BETWEEN UNBOUNDED PRECEDING AND CURRENT ROW) first_quantity_A, SUM(discount) OVER (PARTITION BY suppkey ORDER BY orderkey ROWS BETWEEN UNBOUNDED PRECEDING AND CURRENT ROW) sum_discount_A FROM lineitem";
        this.assertUnitPlan(sql, PlanMatchPattern.anyTree(PlanMatchPattern.window(windowMatcherBuilder -> windowMatcherBuilder.specification(this.specificationA).addFunction(PlanMatchPattern.windowFunction("sum", (List<String>)ImmutableList.of((Object)DISCOUNT_ALIAS), COMMON_FRAME)).addFunction(PlanMatchPattern.windowFunction("nth_value", (List<String>)ImmutableList.of((Object)QUANTITY_ALIAS, (Object)"ONE"), COMMON_FRAME)).addFunction(PlanMatchPattern.windowFunction("sum", (List<String>)ImmutableList.of((Object)QUANTITY_ALIAS), COMMON_FRAME)), PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"ONE", (Object)PlanMatchPattern.expression((Expression)new Cast((Expression)new Reference((Type)IntegerType.INTEGER, "expr"), (Type)BigintType.BIGINT))), PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"expr", (Object)PlanMatchPattern.expression((Expression)new Constant((Type)IntegerType.INTEGER, (Object)1L))), LINEITEM_TABLESCAN_DOQS)))));
    }

    @Test
    public void testIdenticalWindowSpecificationsAAfilterA() {
        String sql = "SELECT  sum_discount_A,   SUM(quantity) OVER (PARTITION BY suppkey ORDER BY orderkey ROWS BETWEEN UNBOUNDED PRECEDING AND CURRENT ROW) sum_quantity_A,   AVG(quantity) OVER (PARTITION BY suppkey ORDER BY orderkey ROWS BETWEEN UNBOUNDED PRECEDING AND CURRENT ROW) avg_quantity_A FROM (  SELECT    *,     SUM(discount) OVER (PARTITION BY suppkey ORDER BY orderkey ROWS BETWEEN UNBOUNDED PRECEDING AND CURRENT ROW) sum_discount_A   FROM lineitem)WHERE shipdate IS NOT NULL";
        this.assertUnitPlan(sql, PlanMatchPattern.anyTree(PlanMatchPattern.window(windowMatcherBuilder -> windowMatcherBuilder.specification(this.specificationA).addFunction(PlanMatchPattern.windowFunction("sum", (List<String>)ImmutableList.of((Object)QUANTITY_ALIAS), COMMON_FRAME)).addFunction(PlanMatchPattern.windowFunction("avg", (List<String>)ImmutableList.of((Object)QUANTITY_ALIAS), COMMON_FRAME)), PlanMatchPattern.project(PlanMatchPattern.filter((Expression)new Not((Expression)new IsNull((Expression)new Reference((Type)VarcharType.VARCHAR, SHIPDATE_ALIAS))), PlanMatchPattern.project(PlanMatchPattern.window(windowMatcherBuilder -> windowMatcherBuilder.specification(this.specificationA).addFunction(PlanMatchPattern.windowFunction("sum", (List<String>)ImmutableList.of((Object)DISCOUNT_ALIAS), COMMON_FRAME)), LINEITEM_TABLESCAN_DOQSS)))))));
    }

    @Test
    public void testIdenticalWindowSpecificationsDefaultFrame() {
        ExpectedValueProvider<DataOrganizationSpecification> specificationC = PlanMatchPattern.specification((List<String>)ImmutableList.of((Object)SUPPKEY_ALIAS), (List<String>)ImmutableList.of((Object)ORDERKEY_ALIAS), (Map<String, SortOrder>)ImmutableMap.of((Object)ORDERKEY_ALIAS, (Object)SortOrder.ASC_NULLS_LAST));
        ExpectedValueProvider<DataOrganizationSpecification> specificationD = PlanMatchPattern.specification((List<String>)ImmutableList.of((Object)ORDERKEY_ALIAS), (List<String>)ImmutableList.of((Object)SHIPDATE_ALIAS), (Map<String, SortOrder>)ImmutableMap.of((Object)SHIPDATE_ALIAS, (Object)SortOrder.ASC_NULLS_LAST));
        String sql = "SELECT SUM(quantity) OVER (PARTITION By suppkey ORDER BY orderkey), SUM(quantity) OVER (PARTITION BY orderkey ORDER BY shipdate), SUM(discount) OVER (PARTITION BY suppkey ORDER BY orderkey) FROM lineitem";
        this.assertUnitPlan(sql, PlanMatchPattern.anyTree(PlanMatchPattern.window(windowMatcherBuilder -> windowMatcherBuilder.specification(specificationC).addFunction(PlanMatchPattern.windowFunction("sum", (List<String>)ImmutableList.of((Object)QUANTITY_ALIAS), WindowNode.Frame.DEFAULT_FRAME)).addFunction(PlanMatchPattern.windowFunction("sum", (List<String>)ImmutableList.of((Object)DISCOUNT_ALIAS), WindowNode.Frame.DEFAULT_FRAME)), PlanMatchPattern.project(PlanMatchPattern.window(windowMatcherBuilder -> windowMatcherBuilder.specification(specificationD).addFunction(PlanMatchPattern.windowFunction("sum", (List<String>)ImmutableList.of((Object)QUANTITY_ALIAS), WindowNode.Frame.DEFAULT_FRAME)), LINEITEM_TABLESCAN_DOQSS)))));
    }

    @Test
    public void testMergeDifferentFrames() {
        WindowNode.Frame frameC = new WindowNode.Frame(WindowFrameType.ROWS, FrameBoundType.UNBOUNDED_PRECEDING, Optional.empty(), Optional.empty(), FrameBoundType.CURRENT_ROW, Optional.empty(), Optional.empty());
        ExpectedValueProvider<DataOrganizationSpecification> specificationC = PlanMatchPattern.specification((List<String>)ImmutableList.of((Object)SUPPKEY_ALIAS), (List<String>)ImmutableList.of((Object)ORDERKEY_ALIAS), (Map<String, SortOrder>)ImmutableMap.of((Object)ORDERKEY_ALIAS, (Object)SortOrder.ASC_NULLS_LAST));
        WindowNode.Frame frameD = new WindowNode.Frame(WindowFrameType.ROWS, FrameBoundType.CURRENT_ROW, Optional.empty(), Optional.empty(), FrameBoundType.UNBOUNDED_FOLLOWING, Optional.empty(), Optional.empty());
        String sql = "SELECT SUM(quantity) OVER (PARTITION BY suppkey ORDER BY orderkey ROWS BETWEEN UNBOUNDED PRECEDING AND CURRENT ROW) sum_quantity_C, AVG(quantity) OVER (PARTITION BY suppkey ORDER BY orderkey ROWS BETWEEN CURRENT ROW AND UNBOUNDED FOLLOWING) avg_quantity_D, SUM(discount) OVER (PARTITION BY suppkey ORDER BY orderkey ROWS BETWEEN UNBOUNDED PRECEDING AND CURRENT ROW) sum_discount_C FROM lineitem";
        this.assertUnitPlan(sql, PlanMatchPattern.anyTree(PlanMatchPattern.window(windowMatcherBuilder -> windowMatcherBuilder.specification(specificationC).addFunction(PlanMatchPattern.windowFunction("avg", (List<String>)ImmutableList.of((Object)QUANTITY_ALIAS), frameD)).addFunction(PlanMatchPattern.windowFunction("sum", (List<String>)ImmutableList.of((Object)DISCOUNT_ALIAS), frameC)).addFunction(PlanMatchPattern.windowFunction("sum", (List<String>)ImmutableList.of((Object)QUANTITY_ALIAS), frameC)), LINEITEM_TABLESCAN_DOQS)));
    }

    @Test
    public void testMergeDifferentFramesWithDefault() {
        WindowNode.Frame frameD = new WindowNode.Frame(WindowFrameType.ROWS, FrameBoundType.CURRENT_ROW, Optional.empty(), Optional.empty(), FrameBoundType.UNBOUNDED_FOLLOWING, Optional.empty(), Optional.empty());
        ExpectedValueProvider<DataOrganizationSpecification> specificationD = PlanMatchPattern.specification((List<String>)ImmutableList.of((Object)SUPPKEY_ALIAS), (List<String>)ImmutableList.of((Object)ORDERKEY_ALIAS), (Map<String, SortOrder>)ImmutableMap.of((Object)ORDERKEY_ALIAS, (Object)SortOrder.ASC_NULLS_LAST));
        String sql = "SELECT SUM(quantity) OVER (PARTITION BY suppkey ORDER BY orderkey) sum_quantity_C, AVG(quantity) OVER (PARTITION BY suppkey ORDER BY orderkey ROWS BETWEEN CURRENT ROW AND UNBOUNDED FOLLOWING) avg_quantity_D, SUM(discount) OVER (PARTITION BY suppkey ORDER BY orderkey) sum_discount_C FROM lineitem";
        this.assertUnitPlan(sql, PlanMatchPattern.anyTree(PlanMatchPattern.window(windowMatcherBuilder -> windowMatcherBuilder.specification(specificationD).addFunction(PlanMatchPattern.windowFunction("avg", (List<String>)ImmutableList.of((Object)QUANTITY_ALIAS), frameD)).addFunction(PlanMatchPattern.windowFunction("sum", (List<String>)ImmutableList.of((Object)DISCOUNT_ALIAS), WindowNode.Frame.DEFAULT_FRAME)).addFunction(PlanMatchPattern.windowFunction("sum", (List<String>)ImmutableList.of((Object)QUANTITY_ALIAS), WindowNode.Frame.DEFAULT_FRAME)), LINEITEM_TABLESCAN_DOQS)));
    }

    @Test
    public void testNotMergeAcrossJoinBranches() {
        String rOrderkeyAlias = "R_ORDERKEY";
        String rShipdateAlias = "R_SHIPDATE";
        String rQuantityAlias = "R_QUANTITY";
        String sql = "WITH foo AS (SELECT suppkey, orderkey, partkey, SUM(discount) OVER (PARTITION BY orderkey ORDER BY shipdate, quantity DESC ROWS BETWEEN UNBOUNDED PRECEDING AND CURRENT ROW) a FROM lineitem WHERE (partkey = 272 OR partkey = 273) AND suppkey > 50 ), bar AS ( SELECT suppkey, orderkey, partkey, AVG(quantity) OVER (PARTITION BY orderkey ORDER BY shipdate, quantity DESC ROWS BETWEEN UNBOUNDED PRECEDING AND CURRENT ROW) b FROM lineitem WHERE (partkey = 272 OR partkey = 273) AND suppkey > 50 )SELECT * FROM foo, bar WHERE foo.a = bar.b";
        ExpectedValueProvider<DataOrganizationSpecification> leftSpecification = PlanMatchPattern.specification((List<String>)ImmutableList.of((Object)ORDERKEY_ALIAS), (List<String>)ImmutableList.of((Object)SHIPDATE_ALIAS, (Object)QUANTITY_ALIAS), (Map<String, SortOrder>)ImmutableMap.of((Object)SHIPDATE_ALIAS, (Object)SortOrder.ASC_NULLS_LAST, (Object)QUANTITY_ALIAS, (Object)SortOrder.DESC_NULLS_LAST));
        ExpectedValueProvider<DataOrganizationSpecification> rightSpecification = PlanMatchPattern.specification((List<String>)ImmutableList.of((Object)rOrderkeyAlias), (List<String>)ImmutableList.of((Object)rShipdateAlias, (Object)rQuantityAlias), (Map<String, SortOrder>)ImmutableMap.of((Object)rShipdateAlias, (Object)SortOrder.ASC_NULLS_LAST, (Object)rQuantityAlias, (Object)SortOrder.DESC_NULLS_LAST));
        ImmutableMap.Builder leftTableScanBuilder = ImmutableMap.builder();
        leftTableScanBuilder.put((Object)DISCOUNT_ALIAS, (Object)"discount");
        leftTableScanBuilder.put((Object)ORDERKEY_ALIAS, (Object)"orderkey");
        leftTableScanBuilder.put((Object)"PARTKEY", (Object)"partkey");
        leftTableScanBuilder.put((Object)SUPPKEY_ALIAS, (Object)"suppkey");
        leftTableScanBuilder.put((Object)QUANTITY_ALIAS, (Object)"quantity");
        leftTableScanBuilder.put((Object)SHIPDATE_ALIAS, (Object)"shipdate");
        PlanMatchPattern leftTableScan = PlanMatchPattern.tableScan("lineitem", (Map<String, String>)leftTableScanBuilder.buildOrThrow());
        PlanMatchPattern rightTableScan = PlanMatchPattern.tableScan("lineitem", (Map<String, String>)ImmutableMap.of((Object)rOrderkeyAlias, (Object)"orderkey", (Object)"R_PARTKEY", (Object)"partkey", (Object)"R_SUPPKEY", (Object)"suppkey", (Object)rQuantityAlias, (Object)"quantity", (Object)rShipdateAlias, (Object)"shipdate"));
        this.assertUnitPlan(sql, PlanMatchPattern.anyTree(PlanMatchPattern.filter((Expression)new Comparison(Comparison.Operator.EQUAL, (Expression)new Reference((Type)BigintType.BIGINT, "SUM"), (Expression)new Reference((Type)BigintType.BIGINT, "AVG")), PlanMatchPattern.join(JoinType.INNER, builder -> builder.left(PlanMatchPattern.any(PlanMatchPattern.window(windowMatcherBuilder -> windowMatcherBuilder.specification(leftSpecification).addFunction("SUM", PlanMatchPattern.windowFunction("sum", (List<String>)ImmutableList.of((Object)DISCOUNT_ALIAS), COMMON_FRAME)), PlanMatchPattern.any(leftTableScan)))).right(PlanMatchPattern.any(PlanMatchPattern.window(windowMatcherBuilder -> windowMatcherBuilder.specification(rightSpecification).addFunction("AVG", PlanMatchPattern.windowFunction("avg", (List<String>)ImmutableList.of((Object)rQuantityAlias), COMMON_FRAME)), PlanMatchPattern.any(rightTableScan))))))));
    }

    @Test
    public void testNotMergeDifferentPartition() {
        String sql = "SELECT SUM(discount) OVER (PARTITION BY suppkey ORDER BY orderkey ROWS BETWEEN UNBOUNDED PRECEDING AND CURRENT ROW) sum_extendedprice_A, SUM(quantity) over (PARTITION BY quantity ORDER BY orderkey ROWS BETWEEN UNBOUNDED PRECEDING AND CURRENT ROW) sum_quantity_C FROM lineitem";
        ExpectedValueProvider<DataOrganizationSpecification> specificationC = PlanMatchPattern.specification((List<String>)ImmutableList.of((Object)QUANTITY_ALIAS), (List<String>)ImmutableList.of((Object)ORDERKEY_ALIAS), (Map<String, SortOrder>)ImmutableMap.of((Object)ORDERKEY_ALIAS, (Object)SortOrder.ASC_NULLS_LAST));
        this.assertUnitPlan(sql, PlanMatchPattern.anyTree(PlanMatchPattern.window(windowMatcherBuilder -> windowMatcherBuilder.specification(this.specificationA).addFunction(PlanMatchPattern.windowFunction("sum", (List<String>)ImmutableList.of((Object)DISCOUNT_ALIAS), COMMON_FRAME)), PlanMatchPattern.project(PlanMatchPattern.window(windowMatcherBuilder -> windowMatcherBuilder.specification(specificationC).addFunction(PlanMatchPattern.windowFunction("sum", (List<String>)ImmutableList.of((Object)QUANTITY_ALIAS), COMMON_FRAME)), LINEITEM_TABLESCAN_DOQS)))));
    }

    @Test
    public void testNotMergeDifferentOrderBy() {
        String sql = "SELECT SUM(discount) OVER (PARTITION BY suppkey ORDER BY orderkey ROWS BETWEEN UNBOUNDED PRECEDING AND CURRENT ROW) sum_extendedprice_A, SUM(quantity) OVER (PARTITION BY suppkey ORDER BY quantity ROWS BETWEEN UNBOUNDED PRECEDING AND CURRENT ROW) sum_quantity_C FROM lineitem";
        ExpectedValueProvider<DataOrganizationSpecification> specificationC = PlanMatchPattern.specification((List<String>)ImmutableList.of((Object)SUPPKEY_ALIAS), (List<String>)ImmutableList.of((Object)QUANTITY_ALIAS), (Map<String, SortOrder>)ImmutableMap.of((Object)QUANTITY_ALIAS, (Object)SortOrder.ASC_NULLS_LAST));
        this.assertUnitPlan(sql, PlanMatchPattern.anyTree(PlanMatchPattern.window(windowMatcherBuilder -> windowMatcherBuilder.specification(specificationC).addFunction(PlanMatchPattern.windowFunction("sum", (List<String>)ImmutableList.of((Object)QUANTITY_ALIAS), COMMON_FRAME)), PlanMatchPattern.project(PlanMatchPattern.window(windowMatcherBuilder -> windowMatcherBuilder.specification(this.specificationA).addFunction(PlanMatchPattern.windowFunction("sum", (List<String>)ImmutableList.of((Object)DISCOUNT_ALIAS), COMMON_FRAME)), LINEITEM_TABLESCAN_DOQS)))));
    }

    @Test
    public void testNotMergeDifferentOrdering() {
        String sql = "SELECT SUM(extendedprice) OVER (PARTITION BY suppkey ORDER BY orderkey ROWS BETWEEN UNBOUNDED PRECEDING AND CURRENT ROW) sum_extendedprice_A, SUM(quantity) over (PARTITION BY suppkey ORDER BY orderkey DESC ROWS BETWEEN UNBOUNDED PRECEDING AND CURRENT ROW) sum_quantity_C, SUM(discount) over (PARTITION BY suppkey ORDER BY orderkey ROWS BETWEEN UNBOUNDED PRECEDING AND CURRENT ROW) sum_discount_A FROM lineitem";
        ExpectedValueProvider<DataOrganizationSpecification> specificationC = PlanMatchPattern.specification((List<String>)ImmutableList.of((Object)SUPPKEY_ALIAS), (List<String>)ImmutableList.of((Object)ORDERKEY_ALIAS), (Map<String, SortOrder>)ImmutableMap.of((Object)ORDERKEY_ALIAS, (Object)SortOrder.DESC_NULLS_LAST));
        this.assertUnitPlan(sql, PlanMatchPattern.anyTree(PlanMatchPattern.window(windowMatcherBuilder -> windowMatcherBuilder.specification(specificationC).addFunction(PlanMatchPattern.windowFunction("sum", (List<String>)ImmutableList.of((Object)QUANTITY_ALIAS), COMMON_FRAME)), PlanMatchPattern.project(PlanMatchPattern.window(windowMatcherBuilder -> windowMatcherBuilder.specification(this.specificationA).addFunction(PlanMatchPattern.windowFunction("sum", (List<String>)ImmutableList.of((Object)EXTENDEDPRICE_ALIAS), COMMON_FRAME)).addFunction(PlanMatchPattern.windowFunction("sum", (List<String>)ImmutableList.of((Object)DISCOUNT_ALIAS), COMMON_FRAME)), LINEITEM_TABLESCAN_DEOQS)))));
    }

    @Test
    public void testNotMergeDifferentNullOrdering() {
        String sql = "SELECT SUM(extendedprice) OVER (PARTITION BY suppkey ORDER BY orderkey ROWS BETWEEN UNBOUNDED PRECEDING AND CURRENT ROW) sum_extendedprice_A, SUM(quantity) OVER (PARTITION BY suppkey ORDER BY orderkey NULLS FIRST ROWS BETWEEN UNBOUNDED PRECEDING AND CURRENT ROW) sum_quantity_C, SUM(discount) OVER (PARTITION BY suppkey ORDER BY orderkey ROWS BETWEEN UNBOUNDED PRECEDING AND CURRENT ROW) sum_discount_A FROM lineitem";
        ExpectedValueProvider<DataOrganizationSpecification> specificationC = PlanMatchPattern.specification((List<String>)ImmutableList.of((Object)SUPPKEY_ALIAS), (List<String>)ImmutableList.of((Object)ORDERKEY_ALIAS), (Map<String, SortOrder>)ImmutableMap.of((Object)ORDERKEY_ALIAS, (Object)SortOrder.ASC_NULLS_FIRST));
        this.assertUnitPlan(sql, PlanMatchPattern.anyTree(PlanMatchPattern.window(windowMatcherBuilder -> windowMatcherBuilder.specification(this.specificationA).addFunction(PlanMatchPattern.windowFunction("sum", (List<String>)ImmutableList.of((Object)EXTENDEDPRICE_ALIAS), COMMON_FRAME)).addFunction(PlanMatchPattern.windowFunction("sum", (List<String>)ImmutableList.of((Object)DISCOUNT_ALIAS), COMMON_FRAME)), PlanMatchPattern.project(PlanMatchPattern.window(windowMatcherBuilder -> windowMatcherBuilder.specification(specificationC).addFunction(PlanMatchPattern.windowFunction("sum", (List<String>)ImmutableList.of((Object)QUANTITY_ALIAS), COMMON_FRAME)), LINEITEM_TABLESCAN_DEOQS)))));
    }

    private void assertUnitPlan(@Language(value="SQL") String sql, PlanMatchPattern pattern) {
        ImmutableList optimizers = ImmutableList.of((Object)new UnaliasSymbolReferences(), (Object)new IterativeOptimizer(this.getPlanTester().getPlannerContext(), new RuleStatsRecorder(), this.getPlanTester().getStatsCalculator(), this.getPlanTester().getEstimatedExchangesCostCalculator(), (Set)ImmutableSet.builder().add((Object)new RemoveRedundantIdentityProjections()).addAll((Iterable)GatherAndMergeWindows.rules()).addAll((Iterable)PlanOptimizers.columnPruningRules((Metadata)this.getPlanTester().getPlannerContext().getMetadata())).build()));
        this.assertPlan(sql, pattern, (List<PlanOptimizer>)optimizers);
    }
}

