/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.query;

import com.google.common.collect.ImmutableMap;
import io.trino.Session;
import io.trino.plugin.tpch.TpchPlugin;
import io.trino.spi.Plugin;
import io.trino.sql.query.QueryAssertions;
import io.trino.testing.QueryRunner;
import io.trino.testing.StandaloneQueryRunner;
import io.trino.testing.TestingSession;
import java.util.Map;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInstance;
import org.junit.jupiter.api.parallel.Execution;
import org.junit.jupiter.api.parallel.ExecutionMode;

@TestInstance(value=TestInstance.Lifecycle.PER_CLASS)
@Execution(value=ExecutionMode.CONCURRENT)
public class TestWith {
    private final QueryAssertions assertions;

    public TestWith() {
        Session session = TestingSession.testSessionBuilder().setCatalog("test_catalog").setSchema("tiny").build();
        StandaloneQueryRunner runner = new StandaloneQueryRunner(session);
        runner.installPlugin((Plugin)new TpchPlugin());
        runner.createCatalog("test_catalog", "tpch", (Map)ImmutableMap.of((Object)"tpch.splits-per-node", (Object)"1"));
        this.assertions = new QueryAssertions((QueryRunner)runner);
    }

    @AfterAll
    public void teardown() {
        this.assertions.close();
    }

    @Test
    public void testWithHiddenFields() {
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query(String.format("SELECT count(*) FROM information_schema.columns WHERE table_catalog = '%s' and table_schema = '%s' and table_name = 'nation' and column_name = 'row_number'", "test_catalog", "tiny")))).matches("VALUES BIGINT '0'");
        this.assertions.execute("SELECT min(row_number) FROM nation");
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("WITH t(a, b, c, d) AS (TABLE nation) SELECT a, b FROM t WHERE a = 1"))).matches("VALUES (BIGINT '1', CAST('ARGENTINA' AS VARCHAR(25)))");
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("WITH t AS (TABLE nation) SELECT * FROM t"))).matches("SELECT * FROM nation");
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("WITH t AS (TABLE nation) SELECT min(row_number) FROM t"))).failure().hasMessage("line 1:37: Column 'row_number' cannot be resolved");
    }
}

