/*
 * Decompiled with CFR 0.152.
 */
package io.trino.util;

import com.google.common.base.Throwables;
import io.trino.util.AutoCloseableCloser;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestAutoCloseableCloser {
    @Test
    public void testEmpty() throws Exception {
        AutoCloseableCloser closer = AutoCloseableCloser.create();
        closer.close();
    }

    @Test
    public void testAllClosed() {
        TestAutoCloseableCloser.assertAllClosed(TestAutoCloseableCloser.succeedingCloseable(), TestAutoCloseableCloser.succeedingCloseable());
        TestAutoCloseableCloser.assertAllClosed(TestAutoCloseableCloser.failingCloseable(new RuntimeException()), TestAutoCloseableCloser.failingCloseable(new RuntimeException()));
        TestAutoCloseableCloser.assertAllClosed(TestAutoCloseableCloser.failingCloseable(new Exception()), TestAutoCloseableCloser.failingCloseable(new Exception()));
        TestAutoCloseableCloser.assertAllClosed(TestAutoCloseableCloser.failingCloseable(new Error()), TestAutoCloseableCloser.failingCloseable(new Error()));
        TestAutoCloseableCloser.assertAllClosed(TestAutoCloseableCloser.failingCloseable(new Throwable()), TestAutoCloseableCloser.failingCloseable(new Throwable()));
        TestAutoCloseableCloser.assertAllClosed(TestAutoCloseableCloser.failingCloseable(new Throwable()), TestAutoCloseableCloser.failingCloseable(new Throwable()), TestAutoCloseableCloser.failingCloseable(new Throwable()));
    }

    @Test
    public void testSuppressedException() {
        RuntimeException runtimeException = new RuntimeException();
        Exception exception = new Exception();
        Error error = new Error();
        AutoCloseableCloser closer = AutoCloseableCloser.create();
        closer.register((AutoCloseable)TestAutoCloseableCloser.failingCloseable(error));
        closer.register((AutoCloseable)TestAutoCloseableCloser.failingCloseable(error));
        closer.register((AutoCloseable)TestAutoCloseableCloser.failingCloseable(exception));
        closer.register((AutoCloseable)TestAutoCloseableCloser.failingCloseable(exception));
        closer.register((AutoCloseable)TestAutoCloseableCloser.failingCloseable(runtimeException));
        closer.register((AutoCloseable)TestAutoCloseableCloser.failingCloseable(runtimeException));
        Assertions.assertThatThrownBy(() -> ((AutoCloseableCloser)closer).close()).isInstanceOfSatisfying(Exception.class, t -> {
            Assertions.assertThat((Throwable)t).isSameAs((Object)runtimeException);
            Assertions.assertThat((Throwable)t.getSuppressed()[0]).isSameAs((Object)exception);
            Assertions.assertThat((Throwable)t.getSuppressed()[1]).isSameAs((Object)exception);
            Assertions.assertThat((Throwable)t.getSuppressed()[2]).isSameAs((Object)error);
            Assertions.assertThat((Throwable)t.getSuppressed()[3]).isSameAs((Object)error);
        });
    }

    private static void assertAllClosed(TestAutoCloseable ... closeables) {
        AutoCloseableCloser closer = AutoCloseableCloser.create();
        for (TestAutoCloseable closeable : closeables) {
            closer.register((AutoCloseable)closeable);
        }
        try {
            closer.close();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        for (TestAutoCloseable closeable : closeables) {
            Assertions.assertThat((boolean)closeable.isClosed()).isTrue();
        }
    }

    private static TestAutoCloseable succeedingCloseable() {
        return new TestAutoCloseable(null);
    }

    private static TestAutoCloseable failingCloseable(Throwable t) {
        return new TestAutoCloseable(t);
    }

    private static class TestAutoCloseable
    implements AutoCloseable {
        private final Throwable failure;
        private boolean closed;

        private TestAutoCloseable(Throwable failure) {
            this.failure = failure;
        }

        public boolean isClosed() {
            return this.closed;
        }

        @Override
        public void close() throws Exception {
            this.closed = true;
            if (this.failure != null) {
                Throwables.throwIfInstanceOf((Throwable)this.failure, Exception.class);
                Throwables.throwIfUnchecked((Throwable)this.failure);
                throw new AssertionError((Object)this.failure);
            }
        }
    }
}

