/*
 * Decompiled with CFR 0.152.
 */
package io.trino.connector;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.io.Files;
import com.google.errorprone.annotations.ThreadSafe;
import com.google.inject.Inject;
import io.airlift.configuration.ConfigurationLoader;
import io.airlift.log.Logger;
import io.trino.Session;
import io.trino.connector.CatalogConnector;
import io.trino.connector.CatalogFactory;
import io.trino.connector.ConnectorServices;
import io.trino.connector.ConnectorServicesProvider;
import io.trino.connector.StaticCatalogManagerConfig;
import io.trino.connector.system.GlobalSystemConnector;
import io.trino.metadata.Catalog;
import io.trino.metadata.CatalogManager;
import io.trino.server.ForStartup;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.TrinoException;
import io.trino.spi.catalog.CatalogName;
import io.trino.spi.catalog.CatalogProperties;
import io.trino.spi.connector.CatalogHandle;
import io.trino.spi.connector.ConnectorName;
import io.trino.util.Executors;
import jakarta.annotation.PreDestroy;
import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicReference;

@ThreadSafe
public class StaticCatalogManager
implements CatalogManager,
ConnectorServicesProvider {
    private static final Logger log = Logger.get(StaticCatalogManager.class);
    private final CatalogFactory catalogFactory;
    private final List<CatalogProperties> catalogProperties;
    private final Executor executor;
    private final ConcurrentMap<CatalogName, CatalogConnector> catalogs = new ConcurrentHashMap<CatalogName, CatalogConnector>();
    private final AtomicReference<State> state = new AtomicReference<State>(State.CREATED);

    @Inject
    public StaticCatalogManager(CatalogFactory catalogFactory, StaticCatalogManagerConfig config, @ForStartup Executor executor) {
        this.catalogFactory = Objects.requireNonNull(catalogFactory, "catalogFactory is null");
        List disabledCatalogs = (List)MoreObjects.firstNonNull(config.getDisabledCatalogs(), (Object)ImmutableList.of());
        ImmutableList.Builder catalogProperties = ImmutableList.builder();
        for (File file : StaticCatalogManager.listCatalogFiles(config.getCatalogConfigurationDir())) {
            HashMap properties;
            String catalogName = Files.getNameWithoutExtension((String)file.getName());
            Preconditions.checkArgument((!catalogName.equals("system") ? 1 : 0) != 0, (Object)"Catalog name SYSTEM is reserved for internal usage");
            if (disabledCatalogs.contains(catalogName)) {
                log.info("Skipping disabled catalog %s", new Object[]{catalogName});
                continue;
            }
            try {
                properties = new HashMap(ConfigurationLoader.loadPropertiesFrom((String)file.getPath()));
            }
            catch (IOException e) {
                throw new UncheckedIOException("Error reading catalog property file " + String.valueOf(file), e);
            }
            String connectorName = (String)properties.remove("connector.name");
            Preconditions.checkState((connectorName != null ? 1 : 0) != 0, (String)"Catalog configuration %s does not contain connector.name", (Object)file.getAbsoluteFile());
            if (connectorName.indexOf(45) >= 0) {
                String deprecatedConnectorName = connectorName;
                connectorName = connectorName.replace('-', '_');
                log.warn("Catalog '%s' is using the deprecated connector name '%s'. The correct connector name is '%s'", new Object[]{catalogName, deprecatedConnectorName, connectorName});
            }
            catalogProperties.add((Object)new CatalogProperties(CatalogHandle.createRootCatalogHandle((CatalogName)new CatalogName(catalogName), (CatalogHandle.CatalogVersion)new CatalogHandle.CatalogVersion("default")), new ConnectorName(connectorName), (Map)ImmutableMap.copyOf(properties)));
        }
        this.catalogProperties = catalogProperties.build();
        this.executor = Objects.requireNonNull(executor, "executor is null");
    }

    private static List<File> listCatalogFiles(File catalogsDirectory) {
        if (catalogsDirectory == null || !catalogsDirectory.isDirectory()) {
            return ImmutableList.of();
        }
        File[] files = catalogsDirectory.listFiles();
        if (files == null) {
            return ImmutableList.of();
        }
        return (List)Arrays.stream(files).filter(File::isFile).filter(file -> file.getName().endsWith(".properties")).collect(ImmutableList.toImmutableList());
    }

    @PreDestroy
    public void stop() {
        if (this.state.getAndSet(State.STOPPED) == State.STOPPED) {
            return;
        }
        for (CatalogConnector connector : this.catalogs.values()) {
            connector.shutdown();
        }
        this.catalogs.clear();
    }

    @Override
    public void loadInitialCatalogs() {
        if (!this.state.compareAndSet(State.CREATED, State.INITIALIZED)) {
            return;
        }
        Executors.executeUntilFailure(this.executor, (Collection)this.catalogProperties.stream().map(catalog -> () -> {
            CatalogName catalogName = catalog.catalogHandle().getCatalogName();
            log.info("-- Loading catalog %s --", new Object[]{catalogName});
            CatalogConnector newCatalog = this.catalogFactory.createCatalog((CatalogProperties)catalog);
            this.catalogs.put(catalogName, newCatalog);
            log.info("-- Added catalog %s using connector %s --", new Object[]{catalogName, catalog.connectorName()});
            return null;
        }).collect(ImmutableList.toImmutableList()));
    }

    @Override
    public Set<CatalogName> getCatalogNames() {
        return ImmutableSet.copyOf(this.catalogs.keySet());
    }

    @Override
    public Optional<Catalog> getCatalog(CatalogName catalogName) {
        return Optional.ofNullable((CatalogConnector)this.catalogs.get(catalogName)).map(CatalogConnector::getCatalog);
    }

    @Override
    public void ensureCatalogsLoaded(Session session, List<CatalogProperties> catalogs) {
        List missingCatalogs = (List)catalogs.stream().filter(catalog -> !this.catalogs.containsKey(catalog.catalogHandle().getCatalogName())).collect(ImmutableList.toImmutableList());
        if (!missingCatalogs.isEmpty()) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.CATALOG_NOT_AVAILABLE, "Missing catalogs: " + String.valueOf(missingCatalogs));
        }
    }

    @Override
    public void pruneCatalogs(Set<CatalogHandle> catalogsInUse) {
    }

    @Override
    public Optional<CatalogProperties> getCatalogProperties(CatalogHandle catalogHandle) {
        return Optional.empty();
    }

    @Override
    public Set<CatalogHandle> getActiveCatalogs() {
        return ImmutableSet.of();
    }

    @Override
    public ConnectorServices getConnectorServices(CatalogHandle catalogHandle) {
        CatalogConnector catalogConnector = (CatalogConnector)this.catalogs.get(catalogHandle.getCatalogName());
        Preconditions.checkArgument((catalogConnector != null ? 1 : 0) != 0, (String)"No catalog '%s'", (Object)catalogHandle.getCatalogName());
        return catalogConnector.getMaterializedConnector(catalogHandle.getType());
    }

    public void registerGlobalSystemConnector(GlobalSystemConnector connector) {
        Objects.requireNonNull(connector, "connector is null");
        CatalogConnector catalog = this.catalogFactory.createCatalog(GlobalSystemConnector.CATALOG_HANDLE, new ConnectorName("system"), connector);
        if (this.catalogs.putIfAbsent(new CatalogName("system"), catalog) != null) {
            throw new IllegalStateException("Global system catalog already registered");
        }
    }

    @Override
    public void createCatalog(CatalogName catalogName, ConnectorName connectorName, Map<String, String> properties, boolean notExists) {
        throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "CREATE CATALOG is not supported by the static catalog store");
    }

    @Override
    public void dropCatalog(CatalogName catalogName, boolean exists) {
        throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "DROP CATALOG is not supported by the static catalog store");
    }

    private static enum State {
        CREATED,
        INITIALIZED,
        STOPPED;

    }
}

