/*
 * Decompiled with CFR 0.152.
 */
package io.trino.connector;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.errorprone.annotations.ThreadSafe;
import com.google.errorprone.annotations.concurrent.GuardedBy;
import com.google.inject.Inject;
import io.airlift.concurrent.Threads;
import io.airlift.log.Logger;
import io.trino.Session;
import io.trino.connector.CatalogConnector;
import io.trino.connector.CatalogFactory;
import io.trino.connector.ConnectorServices;
import io.trino.connector.ConnectorServicesProvider;
import io.trino.connector.system.GlobalSystemConnector;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.TrinoException;
import io.trino.spi.catalog.CatalogProperties;
import io.trino.spi.connector.CatalogHandle;
import io.trino.spi.connector.ConnectorName;
import io.trino.util.AutoCloseableCloser;
import jakarta.annotation.PreDestroy;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;

@ThreadSafe
public class WorkerDynamicCatalogManager
implements ConnectorServicesProvider {
    private static final Logger log = Logger.get(WorkerDynamicCatalogManager.class);
    private final CatalogFactory catalogFactory;
    private final ReadWriteLock catalogsLock = new ReentrantReadWriteLock();
    private final Lock catalogLoadingLock = this.catalogsLock.readLock();
    private final Lock catalogRemovingLock = this.catalogsLock.writeLock();
    private final ConcurrentMap<CatalogHandle, CatalogConnector> catalogs = new ConcurrentHashMap<CatalogHandle, CatalogConnector>();
    private final ExecutorService executor = Executors.newCachedThreadPool(Threads.daemonThreadsNamed((String)"worker-dynamic-catalog-manager-%s"));
    @GuardedBy(value="catalogsLock")
    private boolean stopped;

    @Inject
    public WorkerDynamicCatalogManager(CatalogFactory catalogFactory) {
        this.catalogFactory = Objects.requireNonNull(catalogFactory, "catalogFactory is null");
    }

    @PreDestroy
    public void stop() throws Exception {
        try (AutoCloseableCloser closer = AutoCloseableCloser.create();){
            this.catalogRemovingLock.lock();
            try {
                if (this.stopped) {
                    return;
                }
                this.stopped = true;
                this.catalogs.values().forEach(catalog -> closer.register(catalog::shutdown));
                this.catalogs.clear();
            }
            finally {
                this.catalogRemovingLock.unlock();
            }
            closer.register(this.executor::shutdownNow);
        }
    }

    @Override
    public void loadInitialCatalogs() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void ensureCatalogsLoaded(Session session, List<CatalogProperties> expectedCatalogs) {
        if (this.getMissingCatalogs(expectedCatalogs).isEmpty()) {
            return;
        }
        this.catalogLoadingLock.lock();
        try {
            if (this.stopped) {
                return;
            }
            List<CatalogProperties> missingCatalogs = this.getMissingCatalogs(expectedCatalogs);
            missingCatalogs.forEach(catalog -> Preconditions.checkArgument((!catalog.catalogHandle().equals((Object)GlobalSystemConnector.CATALOG_HANDLE) ? 1 : 0) != 0, (Object)"Global system catalog not registered"));
            ImmutableList loadedCatalogs = Futures.inCompletionOrder((Iterable)((Iterable)missingCatalogs.stream().map(catalog -> Futures.submit(() -> this.catalogs.computeIfAbsent(catalog.catalogHandle(), ignore -> {
                CatalogConnector newCatalog = this.catalogFactory.createCatalog((CatalogProperties)catalog);
                log.debug("Added catalog: " + String.valueOf(catalog.catalogHandle()));
                return newCatalog;
            }), (Executor)this.executor)).collect(ImmutableList.toImmutableList())));
            LinkedList<Throwable> catalogLoadingExceptions = new LinkedList<Throwable>();
            for (ListenableFuture loadedCatalog : loadedCatalogs) {
                try {
                    loadedCatalog.get();
                }
                catch (ExecutionException e) {
                    if (e.getCause() != null) {
                        catalogLoadingExceptions.add(e.getCause());
                        continue;
                    }
                    catalogLoadingExceptions.add(e);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    catalogLoadingExceptions.add(e);
                }
                finally {
                    loadedCatalog.cancel(true);
                }
            }
            if (!catalogLoadingExceptions.isEmpty()) {
                Throwable firstError = (Throwable)catalogLoadingExceptions.poll();
                while (!catalogLoadingExceptions.isEmpty()) {
                    firstError.addSuppressed((Throwable)catalogLoadingExceptions.poll());
                }
                throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.GENERIC_INTERNAL_ERROR, "Error loading catalogs on worker", firstError);
            }
        }
        finally {
            this.catalogLoadingLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void pruneCatalogs(Set<CatalogHandle> catalogsInUse) {
        ArrayList<CatalogConnector> removedCatalogs = new ArrayList<CatalogConnector>();
        this.catalogRemovingLock.lock();
        try {
            if (this.stopped) {
                return;
            }
            Iterator iterator = this.catalogs.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                if (catalogsInUse.contains(entry.getKey())) continue;
                iterator.remove();
                removedCatalogs.add((CatalogConnector)entry.getValue());
            }
        }
        finally {
            this.catalogRemovingLock.unlock();
        }
        removedCatalogs.forEach(removedCatalog -> Futures.submit(() -> {
            try {
                removedCatalog.shutdown();
                log.debug("Pruned catalog: %s", new Object[]{removedCatalog.getCatalogHandle()});
            }
            catch (Throwable e) {
                log.error(e, "Error shutting down catalog: %s".formatted(removedCatalog));
            }
        }, (Executor)this.executor).state());
    }

    private List<CatalogProperties> getMissingCatalogs(List<CatalogProperties> expectedCatalogs) {
        return (List)expectedCatalogs.stream().filter(catalog -> !this.catalogs.containsKey(catalog.catalogHandle())).collect(ImmutableList.toImmutableList());
    }

    @Override
    public ConnectorServices getConnectorServices(CatalogHandle catalogHandle) {
        CatalogConnector catalogConnector = (CatalogConnector)this.catalogs.get(catalogHandle.getRootCatalogHandle());
        Preconditions.checkArgument((catalogConnector != null ? 1 : 0) != 0, (String)"No catalog '%s'", (Object)catalogHandle.getCatalogName());
        return catalogConnector.getMaterializedConnector(catalogHandle.getType());
    }

    public void registerGlobalSystemConnector(GlobalSystemConnector connector) {
        Objects.requireNonNull(connector, "connector is null");
        this.catalogLoadingLock.lock();
        try {
            if (this.stopped) {
                return;
            }
            CatalogConnector catalog = this.catalogFactory.createCatalog(GlobalSystemConnector.CATALOG_HANDLE, new ConnectorName("system"), connector);
            if (this.catalogs.putIfAbsent(GlobalSystemConnector.CATALOG_HANDLE, catalog) != null) {
                throw new IllegalStateException("Global system catalog already registered");
            }
        }
        finally {
            this.catalogLoadingLock.unlock();
        }
    }
}

