/*
 * Decompiled with CFR 0.152.
 */
package io.trino.memory;

import com.google.common.base.Preconditions;
import io.airlift.configuration.Config;
import io.airlift.configuration.ConfigDescription;
import io.airlift.configuration.DefunctConfig;
import io.airlift.units.DataSize;
import io.airlift.units.Duration;
import jakarta.validation.constraints.NotNull;
import java.util.Locale;
import java.util.concurrent.TimeUnit;

@DefunctConfig(value={"experimental.cluster-memory-manager-enabled", "query.low-memory-killer.enabled", "resources.reserved-system-memory"})
public class MemoryManagerConfig {
    private DataSize maxQueryMemory = DataSize.of((long)20L, (DataSize.Unit)DataSize.Unit.GIGABYTE);
    private DataSize maxQueryTotalMemory;
    private DataSize faultTolerantExecutionCoordinatorTaskMemory = DataSize.of((long)2L, (DataSize.Unit)DataSize.Unit.GIGABYTE);
    private DataSize faultTolerantExecutionTaskMemory = DataSize.of((long)5L, (DataSize.Unit)DataSize.Unit.GIGABYTE);
    private double faultTolerantExecutionTaskMemoryGrowthFactor = 3.0;
    private double faultTolerantExecutionTaskMemoryEstimationQuantile = 0.9;
    private DataSize faultTolerantExecutionTaskRuntimeMemoryEstimationOverhead = DataSize.of((long)1L, (DataSize.Unit)DataSize.Unit.GIGABYTE);
    private boolean faultTolerantExecutionMemoryRequirementIncreaseOnWorkerCrashEnabled = true;
    private DataSize faultTolerantExecutionEagerSpeculativeTasksNodeMemoryOvercommit = DataSize.of((long)20L, (DataSize.Unit)DataSize.Unit.GIGABYTE);
    private LowMemoryQueryKillerPolicy lowMemoryQueryKillerPolicy = LowMemoryQueryKillerPolicy.TOTAL_RESERVATION_ON_BLOCKED_NODES;
    private LowMemoryTaskKillerPolicy lowMemoryTaskKillerPolicy = LowMemoryTaskKillerPolicy.TOTAL_RESERVATION_ON_BLOCKED_NODES;
    private Duration killOnOutOfMemoryDelay = new Duration(30.0, TimeUnit.SECONDS);

    @NotNull
    public DataSize getMaxQueryMemory() {
        return this.maxQueryMemory;
    }

    @Config(value="query.max-memory")
    public MemoryManagerConfig setMaxQueryMemory(DataSize maxQueryMemory) {
        this.maxQueryMemory = maxQueryMemory;
        return this;
    }

    @NotNull
    public DataSize getMaxQueryTotalMemory() {
        if (this.maxQueryTotalMemory == null) {
            return DataSize.succinctBytes((long)(this.maxQueryMemory.toBytes() * 2L));
        }
        return this.maxQueryTotalMemory;
    }

    @Config(value="query.max-total-memory")
    public MemoryManagerConfig setMaxQueryTotalMemory(DataSize maxQueryTotalMemory) {
        this.maxQueryTotalMemory = maxQueryTotalMemory;
        return this;
    }

    @NotNull
    public DataSize getFaultTolerantExecutionCoordinatorTaskMemory() {
        return this.faultTolerantExecutionCoordinatorTaskMemory;
    }

    @Config(value="fault-tolerant-execution-coordinator-task-memory")
    @ConfigDescription(value="Estimated amount of memory a single coordinator task will use when task level retries are used; value is used when allocating nodes for tasks execution")
    public MemoryManagerConfig setFaultTolerantExecutionCoordinatorTaskMemory(DataSize faultTolerantExecutionCoordinatorTaskMemory) {
        this.faultTolerantExecutionCoordinatorTaskMemory = faultTolerantExecutionCoordinatorTaskMemory;
        return this;
    }

    @NotNull
    public DataSize getFaultTolerantExecutionTaskMemory() {
        return this.faultTolerantExecutionTaskMemory;
    }

    @Config(value="fault-tolerant-execution-task-memory")
    @ConfigDescription(value="Estimated amount of memory a single task will use when task level retries are used; value is used when allocating nodes for tasks execution")
    public MemoryManagerConfig setFaultTolerantExecutionTaskMemory(DataSize faultTolerantExecutionTaskMemory) {
        this.faultTolerantExecutionTaskMemory = faultTolerantExecutionTaskMemory;
        return this;
    }

    public double getFaultTolerantExecutionTaskMemoryGrowthFactor() {
        return this.faultTolerantExecutionTaskMemoryGrowthFactor;
    }

    @Config(value="fault-tolerant-execution-task-memory-growth-factor")
    @ConfigDescription(value="Factor by which estimated task memory is increased if task execution runs out of memory; value is used allocating nodes for tasks execution")
    public MemoryManagerConfig setFaultTolerantExecutionTaskMemoryGrowthFactor(double faultTolerantExecutionTaskMemoryGrowthFactor) {
        Preconditions.checkArgument((faultTolerantExecutionTaskMemoryGrowthFactor >= 1.0 ? 1 : 0) != 0, (Object)"faultTolerantExecutionTaskMemoryGrowthFactor must not be less than 1.0");
        this.faultTolerantExecutionTaskMemoryGrowthFactor = faultTolerantExecutionTaskMemoryGrowthFactor;
        return this;
    }

    public double getFaultTolerantExecutionTaskMemoryEstimationQuantile() {
        return this.faultTolerantExecutionTaskMemoryEstimationQuantile;
    }

    @Config(value="fault-tolerant-execution-task-memory-estimation-quantile")
    @ConfigDescription(value="What quantile of memory usage of completed tasks to look at when estimating memory usage for upcoming tasks")
    public MemoryManagerConfig setFaultTolerantExecutionTaskMemoryEstimationQuantile(double faultTolerantExecutionTaskMemoryEstimationQuantile) {
        Preconditions.checkArgument((faultTolerantExecutionTaskMemoryEstimationQuantile >= 0.0 && faultTolerantExecutionTaskMemoryEstimationQuantile <= 1.0 ? 1 : 0) != 0, (Object)"fault-tolerant-execution-task-memory-estimation-quantile must not be in [0.0, 1.0] range");
        this.faultTolerantExecutionTaskMemoryEstimationQuantile = faultTolerantExecutionTaskMemoryEstimationQuantile;
        return this;
    }

    @NotNull
    public DataSize getFaultTolerantExecutionTaskRuntimeMemoryEstimationOverhead() {
        return this.faultTolerantExecutionTaskRuntimeMemoryEstimationOverhead;
    }

    @Config(value="fault-tolerant-execution-task-runtime-memory-estimation-overhead")
    @ConfigDescription(value="Extra memory to account for when estimating actual task runtime memory consumption")
    public MemoryManagerConfig setFaultTolerantExecutionTaskRuntimeMemoryEstimationOverhead(DataSize faultTolerantExecutionTaskRuntimeMemoryEstimationOverhead) {
        this.faultTolerantExecutionTaskRuntimeMemoryEstimationOverhead = faultTolerantExecutionTaskRuntimeMemoryEstimationOverhead;
        return this;
    }

    public boolean isFaultTolerantExecutionMemoryRequirementIncreaseOnWorkerCrashEnabled() {
        return this.faultTolerantExecutionMemoryRequirementIncreaseOnWorkerCrashEnabled;
    }

    @Config(value="fault-tolerant-execution.memory-requirement-increase-on-worker-crash-enabled")
    @ConfigDescription(value="Increase memory requirement for tasks failed due to a suspected worker crash")
    public MemoryManagerConfig setFaultTolerantExecutionMemoryRequirementIncreaseOnWorkerCrashEnabled(boolean faultTolerantExecutionMemoryRequirementIncreaseOnWorkerCrashEnabled) {
        this.faultTolerantExecutionMemoryRequirementIncreaseOnWorkerCrashEnabled = faultTolerantExecutionMemoryRequirementIncreaseOnWorkerCrashEnabled;
        return this;
    }

    public DataSize getFaultTolerantExecutionEagerSpeculativeTasksNodeMemoryOvercommit() {
        return this.faultTolerantExecutionEagerSpeculativeTasksNodeMemoryOvercommit;
    }

    @Config(value="fault-tolerant-execution-eager-speculative-tasks-node_memory-overcommit")
    public MemoryManagerConfig setFaultTolerantExecutionEagerSpeculativeTasksNodeMemoryOvercommit(DataSize faultTolerantExecutionEagerSpeculativeTasksNodeMemoryOvercommit) {
        this.faultTolerantExecutionEagerSpeculativeTasksNodeMemoryOvercommit = faultTolerantExecutionEagerSpeculativeTasksNodeMemoryOvercommit;
        return this;
    }

    public LowMemoryQueryKillerPolicy getLowMemoryQueryKillerPolicy() {
        return this.lowMemoryQueryKillerPolicy;
    }

    @Config(value="query.low-memory-killer.policy")
    public MemoryManagerConfig setLowMemoryQueryKillerPolicy(LowMemoryQueryKillerPolicy lowMemoryQueryKillerPolicy) {
        this.lowMemoryQueryKillerPolicy = lowMemoryQueryKillerPolicy;
        return this;
    }

    public LowMemoryTaskKillerPolicy getLowMemoryTaskKillerPolicy() {
        return this.lowMemoryTaskKillerPolicy;
    }

    @Config(value="task.low-memory-killer.policy")
    public MemoryManagerConfig setLowMemoryTaskKillerPolicy(LowMemoryTaskKillerPolicy lowMemoryTaskKillerPolicy) {
        this.lowMemoryTaskKillerPolicy = lowMemoryTaskKillerPolicy;
        return this;
    }

    @NotNull
    public Duration getKillOnOutOfMemoryDelay() {
        return this.killOnOutOfMemoryDelay;
    }

    @Config(value="query.low-memory-killer.delay")
    @ConfigDescription(value="Delay between cluster running low on memory and invoking killer")
    public MemoryManagerConfig setKillOnOutOfMemoryDelay(Duration killOnOutOfMemoryDelay) {
        this.killOnOutOfMemoryDelay = killOnOutOfMemoryDelay;
        return this;
    }

    public void applyFaultTolerantExecutionDefaults() {
        this.killOnOutOfMemoryDelay = new Duration(0.0, TimeUnit.MINUTES);
    }

    public static enum LowMemoryQueryKillerPolicy {
        NONE,
        TOTAL_RESERVATION,
        TOTAL_RESERVATION_ON_BLOCKED_NODES;


        public static LowMemoryQueryKillerPolicy fromString(String value) {
            return switch (value.toLowerCase(Locale.ENGLISH)) {
                case "none" -> NONE;
                case "total-reservation" -> TOTAL_RESERVATION;
                case "total-reservation-on-blocked-nodes" -> TOTAL_RESERVATION_ON_BLOCKED_NODES;
                default -> throw new IllegalArgumentException(String.format("Unrecognized value: '%s'", value));
            };
        }
    }

    public static enum LowMemoryTaskKillerPolicy {
        NONE,
        TOTAL_RESERVATION_ON_BLOCKED_NODES,
        LEAST_WASTE;


        public static LowMemoryTaskKillerPolicy fromString(String value) {
            return switch (value.toLowerCase(Locale.ENGLISH)) {
                case "none" -> NONE;
                case "total-reservation-on-blocked-nodes" -> TOTAL_RESERVATION_ON_BLOCKED_NODES;
                case "least-waste" -> LEAST_WASTE;
                default -> throw new IllegalArgumentException(String.format("Unrecognized value: '%s'", value));
            };
        }
    }
}

