/*
 * Decompiled with CFR 0.152.
 */
package io.trino.metadata;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import io.trino.spi.function.OperatorType;
import java.util.Locale;

public final class OperatorNameUtil {
    private static final String OPERATOR_PREFIX = "$operator$";

    private OperatorNameUtil() {
    }

    public static boolean isOperatorName(String mangledName) {
        return mangledName.startsWith(OPERATOR_PREFIX);
    }

    public static String mangleOperatorName(OperatorType operatorType) {
        return OPERATOR_PREFIX + operatorType.name();
    }

    @VisibleForTesting
    public static OperatorType unmangleOperator(String mangledName) {
        Preconditions.checkArgument((boolean)mangledName.startsWith(OPERATOR_PREFIX), (String)"not a mangled operator name: %s", (Object)mangledName);
        return OperatorType.valueOf((String)mangledName.substring(OPERATOR_PREFIX.length()).toUpperCase(Locale.ENGLISH));
    }
}

