/*
 * Decompiled with CFR 0.152.
 */
package io.trino.metadata;

import io.trino.execution.TaskId;
import io.trino.metadata.FunctionManager;
import io.trino.metadata.LanguageFunctionProvider;
import io.trino.operator.scalar.SpecializedSqlScalarFunction;
import io.trino.spi.function.FunctionId;
import io.trino.spi.function.InvocationConvention;
import io.trino.spi.function.ScalarFunctionImplementation;
import io.trino.sql.routine.SqlRoutineCompiler;
import io.trino.sql.routine.ir.IrRoutine;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;

public class WorkerLanguageFunctionProvider
implements LanguageFunctionProvider {
    private final Map<TaskId, Map<FunctionId, IrRoutine>> queryFunctions = new ConcurrentHashMap<TaskId, Map<FunctionId, IrRoutine>>();

    @Override
    public void registerTask(TaskId taskId, Map<FunctionId, IrRoutine> functions) {
        this.queryFunctions.computeIfAbsent(taskId, ignored -> functions);
    }

    @Override
    public void unregisterTask(TaskId taskId) {
        this.queryFunctions.remove(taskId);
    }

    @Override
    public ScalarFunctionImplementation specialize(FunctionId functionId, InvocationConvention invocationConvention, FunctionManager functionManager) {
        IrRoutine routine = this.queryFunctions.values().stream().map(queryFunctions -> (IrRoutine)queryFunctions.get(functionId)).filter(Objects::nonNull).findFirst().orElseThrow(() -> new IllegalStateException("Unknown function implementation: " + String.valueOf(functionId)));
        SpecializedSqlScalarFunction function = new SqlRoutineCompiler(functionManager).compile(routine);
        return function.getScalarFunctionImplementation(invocationConvention);
    }
}

