/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.aggregation;

import io.trino.annotation.UsedByGeneratedCode;
import io.trino.operator.aggregation.state.LongState;
import io.trino.spi.block.BlockBuilder;
import io.trino.spi.function.AggregationFunction;
import io.trino.spi.function.AggregationState;
import io.trino.spi.function.CombineFunction;
import io.trino.spi.function.InputFunction;
import io.trino.spi.function.OutputFunction;
import io.trino.spi.function.SqlType;
import io.trino.spi.function.WindowAccumulator;
import io.trino.spi.function.WindowIndex;
import io.trino.spi.type.BigintType;

@AggregationFunction(value="count_if", windowAccumulator=CountIfWindowAccumulator.class)
public final class CountIfAggregation {
    private CountIfAggregation() {
    }

    @InputFunction
    public static void input(@AggregationState LongState state, @SqlType(value="boolean") boolean value) {
        if (value) {
            state.setValue(state.getValue() + 1L);
        }
    }

    @CombineFunction
    public static void combine(@AggregationState LongState state, @AggregationState LongState otherState) {
        state.setValue(state.getValue() + otherState.getValue());
    }

    @OutputFunction(value="bigint")
    public static void output(@AggregationState LongState state, BlockBuilder out) {
        BigintType.BIGINT.writeLong(out, state.getValue());
    }

    public static class CountIfWindowAccumulator
    implements WindowAccumulator {
        private long count;

        @UsedByGeneratedCode
        public CountIfWindowAccumulator() {
        }

        private CountIfWindowAccumulator(long count) {
            this.count = count;
        }

        public long getEstimatedSize() {
            return 8L;
        }

        public WindowAccumulator copy() {
            return new CountIfWindowAccumulator(this.count);
        }

        public void addInput(WindowIndex index, int startPosition, int endPosition) {
            for (int i = startPosition; i <= endPosition; ++i) {
                if (index.isNull(0, i) || !index.getBoolean(0, i)) continue;
                ++this.count;
            }
        }

        public boolean removeInput(WindowIndex index, int startPosition, int endPosition) {
            for (int i = startPosition; i <= endPosition; ++i) {
                if (index.isNull(0, i) || !index.getBoolean(0, i)) continue;
                --this.count;
            }
            return true;
        }

        public void output(BlockBuilder blockBuilder) {
            BigintType.BIGINT.writeLong(blockBuilder, this.count);
        }
    }
}

