/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.aggregation;

import com.google.common.base.Preconditions;
import com.google.common.base.VerifyException;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import io.trino.operator.ParametricImplementation;
import io.trino.operator.aggregation.AggregationFromAnnotationsParser;
import io.trino.operator.aggregation.AggregationFunctionAdapter;
import io.trino.operator.annotations.FunctionsParserHelper;
import io.trino.operator.annotations.ImplementationDependency;
import io.trino.spi.block.ValueBlock;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.function.AggregationState;
import io.trino.spi.function.BlockIndex;
import io.trino.spi.function.BlockPosition;
import io.trino.spi.function.BoundSignature;
import io.trino.spi.function.FunctionNullability;
import io.trino.spi.function.OutputFunction;
import io.trino.spi.function.Signature;
import io.trino.spi.function.SqlNullable;
import io.trino.spi.function.SqlType;
import io.trino.spi.function.TypeParameter;
import io.trino.spi.function.WindowAccumulator;
import io.trino.spi.type.Type;
import io.trino.spi.type.TypeSignature;
import io.trino.sql.analyzer.TypeSignatureTranslator;
import io.trino.util.Reflection;
import java.lang.annotation.Annotation;
import java.lang.invoke.MethodHandle;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Stream;

public class ParametricAggregationImplementation
implements ParametricImplementation {
    private final Signature signature;
    private final Class<?> definitionClass;
    private final MethodHandle inputFunction;
    private final MethodHandle outputFunction;
    private final Optional<MethodHandle> combineFunction;
    private final Optional<Class<? extends WindowAccumulator>> windowAccumulator;
    private final List<AggregateNativeContainerType> argumentNativeContainerTypes;
    private final List<ImplementationDependency> inputDependencies;
    private final List<ImplementationDependency> combineDependencies;
    private final List<ImplementationDependency> outputDependencies;
    private final List<AggregationFunctionAdapter.AggregationParameterKind> inputParameterKinds;
    private final FunctionNullability functionNullability;

    private ParametricAggregationImplementation(Signature signature, Class<?> definitionClass, MethodHandle inputFunction, MethodHandle outputFunction, Optional<MethodHandle> combineFunction, Optional<Class<? extends WindowAccumulator>> windowAccumulator, List<AggregateNativeContainerType> argumentNativeContainerTypes, List<ImplementationDependency> inputDependencies, List<ImplementationDependency> combineDependencies, List<ImplementationDependency> outputDependencies, List<AggregationFunctionAdapter.AggregationParameterKind> inputParameterKinds) {
        this.signature = Objects.requireNonNull(signature, "signature cannot be null");
        this.definitionClass = Objects.requireNonNull(definitionClass, "definition class cannot be null");
        this.inputFunction = Objects.requireNonNull(inputFunction, "inputFunction cannot be null");
        this.outputFunction = Objects.requireNonNull(outputFunction, "outputFunction cannot be null");
        this.combineFunction = Objects.requireNonNull(combineFunction, "combineFunction cannot be null");
        this.windowAccumulator = Objects.requireNonNull(windowAccumulator, "windowAccumulator cannot be null");
        this.argumentNativeContainerTypes = Objects.requireNonNull(argumentNativeContainerTypes, "argumentNativeContainerTypes cannot be null");
        this.inputDependencies = Objects.requireNonNull(inputDependencies, "inputDependencies cannot be null");
        this.outputDependencies = Objects.requireNonNull(outputDependencies, "outputDependencies cannot be null");
        this.combineDependencies = Objects.requireNonNull(combineDependencies, "combineDependencies cannot be null");
        this.inputParameterKinds = Objects.requireNonNull(inputParameterKinds, "inputParameterKinds cannot be null");
        this.functionNullability = new FunctionNullability(true, (List)inputParameterKinds.stream().filter(parameterType -> parameterType != AggregationFunctionAdapter.AggregationParameterKind.BLOCK_INDEX && parameterType != AggregationFunctionAdapter.AggregationParameterKind.STATE).map(AggregationFunctionAdapter.AggregationParameterKind.NULLABLE_BLOCK_INPUT_CHANNEL::equals).collect(ImmutableList.toImmutableList()));
    }

    @Override
    public Signature getSignature() {
        return this.signature;
    }

    @Override
    public boolean hasSpecializedTypeParameters() {
        return false;
    }

    @Override
    public FunctionNullability getFunctionNullability() {
        return this.functionNullability;
    }

    public Class<?> getDefinitionClass() {
        return this.definitionClass;
    }

    public MethodHandle getInputFunction() {
        return this.inputFunction;
    }

    public MethodHandle getOutputFunction() {
        return this.outputFunction;
    }

    public Optional<MethodHandle> getCombineFunction() {
        return this.combineFunction;
    }

    public Optional<Class<? extends WindowAccumulator>> getWindowAccumulator() {
        return this.windowAccumulator;
    }

    public List<ImplementationDependency> getInputDependencies() {
        return this.inputDependencies;
    }

    public List<ImplementationDependency> getOutputDependencies() {
        return this.outputDependencies;
    }

    public List<ImplementationDependency> getCombineDependencies() {
        return this.combineDependencies;
    }

    public List<AggregationFunctionAdapter.AggregationParameterKind> getInputParameterKinds() {
        return this.inputParameterKinds;
    }

    public boolean areTypesAssignable(BoundSignature boundSignature) {
        Preconditions.checkState((this.argumentNativeContainerTypes.size() == boundSignature.getArgumentTypes().size() ? 1 : 0) != 0, (Object)"Number of argument assigned to AggregationImplementation is different than number parsed from annotations.");
        for (int i = 0; i < boundSignature.getArgumentTypes().size(); ++i) {
            Class argumentType = ((Type)boundSignature.getArgumentTypes().get(i)).getJavaType();
            Class<?> methodDeclaredType = this.argumentNativeContainerTypes.get(i).javaType();
            boolean isCurrentBlockPosition = this.argumentNativeContainerTypes.get(i).isBlockPosition();
            if (isCurrentBlockPosition && ValueBlock.class.isAssignableFrom(methodDeclaredType) || methodDeclaredType.isAssignableFrom(argumentType)) continue;
            return false;
        }
        return true;
    }

    public record AggregateNativeContainerType(Class<?> javaType, boolean isBlockPosition) {
    }

    public static final class Parser {
        private final Class<?> aggregationDefinition;
        private final MethodHandle inputHandle;
        private final MethodHandle outputHandle;
        private final Optional<MethodHandle> combineHandle;
        private final Optional<Class<? extends WindowAccumulator>> windowAccumulator;
        private final List<AggregateNativeContainerType> argumentNativeContainerTypes;
        private final List<ImplementationDependency> inputDependencies;
        private final List<ImplementationDependency> combineDependencies;
        private final List<ImplementationDependency> outputDependencies;
        private final List<AggregationFunctionAdapter.AggregationParameterKind> inputParameterKinds;
        private final Signature.Builder signatureBuilder = Signature.builder();
        private final Set<String> literalParameters;
        private final List<TypeParameter> typeParameters;

        private Parser(Class<?> aggregationDefinition, List<AggregationFromAnnotationsParser.AccumulatorStateDetails<?>> stateDetails, Method inputFunction, Method outputFunction, Optional<Method> combineFunction, Optional<Class<? extends WindowAccumulator>> windowAccumulator) {
            this.aggregationDefinition = aggregationDefinition;
            this.literalParameters = FunctionsParserHelper.parseLiteralParameters(inputFunction);
            this.typeParameters = Arrays.asList((TypeParameter[])inputFunction.getAnnotationsByType(TypeParameter.class));
            this.inputDependencies = this.parseImplementationDependencies(inputFunction);
            this.outputDependencies = this.parseImplementationDependencies(outputFunction);
            this.combineDependencies = combineFunction.map(this::parseImplementationDependencies).orElse((List)ImmutableList.of());
            this.inputParameterKinds = Parser.parseInputParameterKinds(inputFunction);
            FunctionsParserHelper.parseLongVariableConstraints(inputFunction, this.signatureBuilder);
            List allDependencies = (List)Stream.of(stateDetails.stream().map(AggregationFromAnnotationsParser.AccumulatorStateDetails::getDependencies).flatMap(Collection::stream), this.inputDependencies.stream(), this.outputDependencies.stream(), this.combineDependencies.stream()).reduce(Stream::concat).orElseGet(Stream::empty).collect(ImmutableList.toImmutableList());
            FunctionsParserHelper.createTypeVariableConstraints(this.typeParameters, allDependencies).forEach(arg_0 -> ((Signature.Builder)this.signatureBuilder).typeVariableConstraint(arg_0));
            this.argumentNativeContainerTypes = Parser.parseSignatureArgumentsTypes(inputFunction);
            this.signatureBuilder.argumentTypes(this.getInputTypesSignatures(inputFunction));
            this.signatureBuilder.returnType(TypeSignatureTranslator.parseTypeSignature(outputFunction.getAnnotation(OutputFunction.class).value(), this.literalParameters));
            this.inputHandle = Reflection.methodHandle(inputFunction);
            this.combineHandle = combineFunction.map(Reflection::methodHandle);
            this.outputHandle = Reflection.methodHandle(outputFunction);
            this.windowAccumulator = windowAccumulator;
        }

        private ParametricAggregationImplementation get() {
            return new ParametricAggregationImplementation(this.signatureBuilder.build(), this.aggregationDefinition, this.inputHandle, this.outputHandle, this.combineHandle, this.windowAccumulator, this.argumentNativeContainerTypes, this.inputDependencies, this.combineDependencies, this.outputDependencies, this.inputParameterKinds);
        }

        public static ParametricAggregationImplementation parseImplementation(Class<?> aggregationDefinition, List<AggregationFromAnnotationsParser.AccumulatorStateDetails<?>> stateDetails, Method inputFunction, Method outputFunction, Optional<Method> combineFunction, Optional<Class<? extends WindowAccumulator>> windowAccumulator) {
            return new Parser(aggregationDefinition, stateDetails, inputFunction, outputFunction, combineFunction, windowAccumulator).get();
        }

        private static List<AggregationFunctionAdapter.AggregationParameterKind> parseInputParameterKinds(Method method) {
            ImmutableList.Builder builder = ImmutableList.builder();
            Annotation[][] annotations = method.getParameterAnnotations();
            String methodName = String.valueOf(method.getDeclaringClass()) + "." + method.getName();
            Preconditions.checkArgument((method.getParameterCount() > 0 ? 1 : 0) != 0, (Object)"At least @AggregationState argument is required for each of aggregation functions.");
            int i = 0;
            if (annotations[0].length == 0) {
                builder.add((Object)AggregationFunctionAdapter.AggregationParameterKind.STATE);
                ++i;
            }
            while (i < annotations.length) {
                Annotation baseTypeAnnotation = Parser.baseTypeAnnotation(annotations[i], methodName);
                if (!ImplementationDependency.isImplementationDependencyAnnotation(baseTypeAnnotation)) {
                    if (baseTypeAnnotation instanceof AggregationState) {
                        builder.add((Object)AggregationFunctionAdapter.AggregationParameterKind.STATE);
                    } else if (baseTypeAnnotation instanceof SqlType) {
                        boolean isParameterBlock = Parser.isParameterBlock(annotations[i]);
                        boolean isParameterNullable = Parser.isParameterNullable(annotations[i]);
                        builder.add((Object)Parser.getInputParameterKind(isParameterNullable, isParameterBlock, methodName));
                    } else if (baseTypeAnnotation instanceof BlockIndex) {
                        builder.add((Object)AggregationFunctionAdapter.AggregationParameterKind.BLOCK_INDEX);
                    } else {
                        throw new VerifyException("Unhandled annotation: " + String.valueOf(baseTypeAnnotation));
                    }
                }
                ++i;
            }
            return builder.build();
        }

        static AggregationFunctionAdapter.AggregationParameterKind getInputParameterKind(boolean isNullable, boolean isBlock, String methodName) {
            if (isBlock) {
                if (isNullable) {
                    return AggregationFunctionAdapter.AggregationParameterKind.NULLABLE_BLOCK_INPUT_CHANNEL;
                }
                return AggregationFunctionAdapter.AggregationParameterKind.BLOCK_INPUT_CHANNEL;
            }
            if (isNullable) {
                throw new IllegalArgumentException(methodName + " contains a parameter with @NullablePosition that is not @BlockPosition");
            }
            return AggregationFunctionAdapter.AggregationParameterKind.INPUT_CHANNEL;
        }

        private static Annotation baseTypeAnnotation(Annotation[] annotations, String methodName) {
            List baseTypes = (List)Arrays.stream(annotations).filter(annotation -> Parser.isAggregationMetaAnnotation(annotation) || annotation instanceof SqlType).collect(ImmutableList.toImmutableList());
            Preconditions.checkArgument((baseTypes.size() == 1 ? 1 : 0) != 0, (String)"Parameter of %s must have exactly one of @SqlType, @BlockIndex", (Object)methodName);
            boolean nullable = Parser.isParameterNullable(annotations);
            boolean isBlock = Parser.isParameterBlock(annotations);
            Annotation annotation2 = (Annotation)baseTypes.getFirst();
            Preconditions.checkArgument((!isBlock && !nullable || annotation2 instanceof SqlType ? 1 : 0) != 0, (String)"%s contains a parameter with @BlockPosition and/or @NullablePosition that is not @SqlType", (Object)methodName);
            return annotation2;
        }

        public static List<AggregateNativeContainerType> parseSignatureArgumentsTypes(Method inputFunction) {
            ImmutableList.Builder builder = ImmutableList.builder();
            for (int i = 0; i < inputFunction.getParameterCount(); ++i) {
                Class parameterType = inputFunction.getParameterTypes()[i];
                Annotation[] annotations = inputFunction.getParameterAnnotations()[i];
                if (parameterType == ConnectorSession.class || FunctionsParserHelper.containsAnnotation(annotations, Parser::isAggregationMetaAnnotation)) continue;
                Optional<Class> nativeContainerType = Arrays.stream(annotations).filter(SqlType.class::isInstance).map(SqlType.class::cast).findFirst().map(SqlType::nativeContainerType);
                if (nativeContainerType.isPresent() && !nativeContainerType.get().equals(Object.class)) {
                    parameterType = nativeContainerType.get();
                }
                builder.add((Object)new AggregateNativeContainerType(parameterType, Parser.isParameterBlock(annotations)));
            }
            return builder.build();
        }

        public List<ImplementationDependency> parseImplementationDependencies(Method inputFunction) {
            ImmutableList.Builder builder = ImmutableList.builder();
            for (Parameter parameter : inputFunction.getParameters()) {
                Class<?> parameterType = parameter.getType();
                if (parameterType == ConnectorSession.class) continue;
                ImplementationDependency.getImplementationDependencyAnnotation(parameter).ifPresent(annotation -> {
                    ImplementationDependency.validateImplementationDependencyAnnotation(inputFunction, annotation, (Set)this.typeParameters.stream().map(TypeParameter::value).collect(ImmutableSet.toImmutableSet()), this.literalParameters);
                    builder.add((Object)ImplementationDependency.Factory.createDependency(annotation, this.literalParameters, parameter.getType()));
                });
            }
            return builder.build();
        }

        public static boolean isParameterNullable(Annotation[] annotations) {
            return FunctionsParserHelper.containsAnnotation(annotations, annotation -> annotation instanceof SqlNullable);
        }

        public static boolean isParameterBlock(Annotation[] annotations) {
            return FunctionsParserHelper.containsAnnotation(annotations, annotation -> annotation instanceof BlockPosition);
        }

        public List<TypeSignature> getInputTypesSignatures(Method inputFunction) {
            Annotation[][] parameterAnnotations;
            ImmutableList.Builder builder = ImmutableList.builder();
            Annotation[][] annotationArray = parameterAnnotations = inputFunction.getParameterAnnotations();
            int n = annotationArray.length;
            for (int i = 0; i < n; ++i) {
                Annotation[] annotations;
                for (Annotation annotation : annotations = annotationArray[i]) {
                    if (!(annotation instanceof SqlType)) continue;
                    String typeName = ((SqlType)annotation).value();
                    builder.add((Object)TypeSignatureTranslator.parseTypeSignature(typeName, this.literalParameters));
                }
            }
            return builder.build();
        }

        private static boolean isAggregationMetaAnnotation(Annotation annotation) {
            return annotation instanceof BlockIndex || annotation instanceof AggregationState || ImplementationDependency.isImplementationDependencyAnnotation(annotation);
        }
    }
}

