/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.index;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.common.util.concurrent.SettableFuture;
import io.airlift.units.DataSize;
import io.trino.operator.FlatHashStrategyCompiler;
import io.trino.operator.PagesIndex;
import io.trino.operator.TaskContext;
import io.trino.operator.index.IndexBuildDriverFactoryProvider;
import io.trino.operator.index.IndexJoinLookupStats;
import io.trino.operator.index.IndexLoader;
import io.trino.operator.index.IndexLookupSource;
import io.trino.operator.join.LookupSourceFactory;
import io.trino.operator.join.LookupSourceProvider;
import io.trino.operator.join.OuterPositionIterator;
import io.trino.operator.join.StaticLookupSourceProvider;
import io.trino.spi.type.Type;
import io.trino.type.BlockTypeOperators;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.OptionalInt;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.function.Supplier;

public class IndexLookupSourceFactory
implements LookupSourceFactory {
    private final List<Type> outputTypes;
    private final Supplier<IndexLoader> indexLoaderSupplier;
    private TaskContext taskContext;
    private final SettableFuture<Void> whenTaskContextSet = SettableFuture.create();

    public IndexLookupSourceFactory(Set<Integer> lookupSourceInputChannels, List<Integer> keyOutputChannels, OptionalInt keyOutputHashChannel, List<Type> outputTypes, IndexBuildDriverFactoryProvider indexBuildDriverFactoryProvider, DataSize maxIndexMemorySize, IndexJoinLookupStats stats, boolean shareIndexLoading, PagesIndex.Factory pagesIndexFactory, FlatHashStrategyCompiler hashStrategyCompiler, BlockTypeOperators blockTypeOperators) {
        this.outputTypes = ImmutableList.copyOf((Collection)Objects.requireNonNull(outputTypes, "outputTypes is null"));
        if (shareIndexLoading) {
            IndexLoader shared = new IndexLoader(lookupSourceInputChannels, keyOutputChannels, keyOutputHashChannel, outputTypes, indexBuildDriverFactoryProvider, 10000, maxIndexMemorySize, stats, pagesIndexFactory, hashStrategyCompiler, blockTypeOperators);
            this.indexLoaderSupplier = () -> shared;
        } else {
            this.indexLoaderSupplier = () -> new IndexLoader(lookupSourceInputChannels, keyOutputChannels, keyOutputHashChannel, outputTypes, indexBuildDriverFactoryProvider, 10000, maxIndexMemorySize, stats, pagesIndexFactory, hashStrategyCompiler, blockTypeOperators);
        }
    }

    @Override
    public List<Type> getTypes() {
        return this.outputTypes;
    }

    @Override
    public List<Type> getOutputTypes() {
        return this.outputTypes;
    }

    @Override
    public void setTaskContext(TaskContext taskContext) {
        this.taskContext = taskContext;
        this.whenTaskContextSet.set(null);
    }

    @Override
    public ListenableFuture<LookupSourceProvider> createLookupSourceProvider() {
        Preconditions.checkState((this.taskContext != null ? 1 : 0) != 0, (Object)"taskContext not set");
        IndexLoader indexLoader = this.indexLoaderSupplier.get();
        indexLoader.setContext(this.taskContext);
        return Futures.immediateFuture((Object)new StaticLookupSourceProvider(new IndexLookupSource(indexLoader)));
    }

    @Override
    public ListenableFuture<Void> whenBuildFinishes() {
        return Futures.transformAsync(this.whenTaskContextSet, ignored -> Futures.transform(this.createLookupSourceProvider(), lookupSourceProvider -> {
            lookupSourceProvider.close();
            return null;
        }, (Executor)MoreExecutors.directExecutor()), (Executor)MoreExecutors.directExecutor());
    }

    @Override
    public int partitions() {
        throw new UnsupportedOperationException();
    }

    @Override
    public OuterPositionIterator getOuterPositionIterator() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void destroy() {
    }
}

