/*
 * Decompiled with CFR 0.152.
 */
package io.trino.server;

import com.google.common.collect.Multimap;
import com.google.inject.Inject;
import io.airlift.concurrent.BoundedExecutor;
import io.airlift.concurrent.ThreadPoolExecutorMBean;
import io.airlift.concurrent.Threads;
import io.airlift.http.client.HttpClient;
import io.airlift.json.JsonCodec;
import io.airlift.units.DataSize;
import io.airlift.units.Duration;
import io.opentelemetry.api.trace.Span;
import io.opentelemetry.api.trace.Tracer;
import io.trino.Session;
import io.trino.execution.DynamicFiltersCollector;
import io.trino.execution.LocationFactory;
import io.trino.execution.NodeTaskMap;
import io.trino.execution.QueryManagerConfig;
import io.trino.execution.RemoteTask;
import io.trino.execution.RemoteTaskFactory;
import io.trino.execution.TaskId;
import io.trino.execution.TaskInfo;
import io.trino.execution.TaskManagerConfig;
import io.trino.execution.TaskStatus;
import io.trino.execution.buffer.OutputBuffers;
import io.trino.metadata.InternalNode;
import io.trino.metadata.Split;
import io.trino.operator.ForScheduler;
import io.trino.server.DynamicFilterService;
import io.trino.server.FailTaskRequest;
import io.trino.server.TaskUpdateRequest;
import io.trino.server.remotetask.HttpRemoteTask;
import io.trino.server.remotetask.RemoteTaskStats;
import io.trino.sql.planner.PlanFragment;
import io.trino.sql.planner.plan.DynamicFilterId;
import io.trino.sql.planner.plan.PlanNodeId;
import jakarta.annotation.PreDestroy;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadPoolExecutor;
import org.weakref.jmx.Managed;
import org.weakref.jmx.Nested;

public class HttpRemoteTaskFactory
implements RemoteTaskFactory {
    private final HttpClient httpClient;
    private final LocationFactory locationFactory;
    private final JsonCodec<TaskStatus> taskStatusCodec;
    private final JsonCodec<DynamicFiltersCollector.VersionedDynamicFilterDomains> dynamicFilterDomainsCodec;
    private final JsonCodec<TaskInfo> taskInfoCodec;
    private final JsonCodec<TaskUpdateRequest> taskUpdateRequestCodec;
    private final JsonCodec<FailTaskRequest> failTaskRequestCoded;
    private final Duration maxErrorDuration;
    private final Duration taskStatusRefreshMaxWait;
    private final Duration taskInfoUpdateInterval;
    private final Duration taskTerminationTimeout;
    private final ExecutorService coreExecutor;
    private final Executor executor;
    private final ThreadPoolExecutorMBean executorMBean;
    private final ScheduledExecutorService updateScheduledExecutor;
    private final ScheduledExecutorService errorScheduledExecutor;
    private final Tracer tracer;
    private final RemoteTaskStats stats;
    private final DynamicFilterService dynamicFilterService;

    @Inject
    public HttpRemoteTaskFactory(QueryManagerConfig config, TaskManagerConfig taskConfig, @ForScheduler HttpClient httpClient, LocationFactory locationFactory, JsonCodec<TaskStatus> taskStatusCodec, JsonCodec<DynamicFiltersCollector.VersionedDynamicFilterDomains> dynamicFilterDomainsCodec, JsonCodec<TaskInfo> taskInfoCodec, JsonCodec<TaskUpdateRequest> taskUpdateRequestCodec, JsonCodec<FailTaskRequest> failTaskRequestCoded, Tracer tracer, RemoteTaskStats stats, DynamicFilterService dynamicFilterService) {
        this.httpClient = httpClient;
        this.locationFactory = locationFactory;
        this.taskStatusCodec = taskStatusCodec;
        this.dynamicFilterDomainsCodec = dynamicFilterDomainsCodec;
        this.taskInfoCodec = taskInfoCodec;
        this.taskUpdateRequestCodec = taskUpdateRequestCodec;
        this.failTaskRequestCoded = failTaskRequestCoded;
        this.maxErrorDuration = config.getRemoteTaskMaxErrorDuration();
        this.taskStatusRefreshMaxWait = taskConfig.getStatusRefreshMaxWait();
        this.taskInfoUpdateInterval = taskConfig.getInfoUpdateInterval();
        this.taskTerminationTimeout = taskConfig.getTaskTerminationTimeout();
        this.coreExecutor = Executors.newCachedThreadPool(Threads.daemonThreadsNamed((String)"remote-task-callback-%s"));
        this.executor = new BoundedExecutor((Executor)this.coreExecutor, config.getRemoteTaskMaxCallbackThreads());
        this.executorMBean = new ThreadPoolExecutorMBean((ThreadPoolExecutor)this.coreExecutor);
        this.tracer = Objects.requireNonNull(tracer, "tracer is null");
        this.stats = Objects.requireNonNull(stats, "stats is null");
        this.dynamicFilterService = Objects.requireNonNull(dynamicFilterService, "dynamicFilterService is null");
        this.updateScheduledExecutor = Executors.newSingleThreadScheduledExecutor(Threads.daemonThreadsNamed((String)"task-info-update-scheduler-%s"));
        this.errorScheduledExecutor = Executors.newSingleThreadScheduledExecutor(Threads.daemonThreadsNamed((String)"remote-task-error-delay-%s"));
    }

    @Managed
    @Nested
    public ThreadPoolExecutorMBean getExecutor() {
        return this.executorMBean;
    }

    @PreDestroy
    public void stop() {
        this.coreExecutor.shutdownNow();
        this.updateScheduledExecutor.shutdownNow();
        this.errorScheduledExecutor.shutdownNow();
    }

    @Override
    public RemoteTask createRemoteTask(Session session, Span stageSpan, TaskId taskId, InternalNode node, boolean speculative, PlanFragment fragment, Multimap<PlanNodeId, Split> initialSplits, OutputBuffers outputBuffers, NodeTaskMap.PartitionedSplitCountTracker partitionedSplitCountTracker, Set<DynamicFilterId> outboundDynamicFilterIds, Optional<DataSize> estimatedMemory, boolean summarizeTaskInfo) {
        return new HttpRemoteTask(session, stageSpan, taskId, node, speculative, this.locationFactory.createTaskLocation(node, taskId), fragment, initialSplits, outputBuffers, this.httpClient, this.executor, this.updateScheduledExecutor, this.errorScheduledExecutor, this.maxErrorDuration, this.taskStatusRefreshMaxWait, this.taskInfoUpdateInterval, this.taskTerminationTimeout, summarizeTaskInfo, this.taskStatusCodec, this.dynamicFilterDomainsCodec, this.taskInfoCodec, this.taskUpdateRequestCodec, this.failTaskRequestCoded, partitionedSplitCountTracker, this.tracer, this.stats, this.dynamicFilterService, outboundDynamicFilterIds, estimatedMemory);
    }
}

