/*
 * Decompiled with CFR 0.152.
 */
package io.trino.server.protocol;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.util.concurrent.AbstractFuture;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.errorprone.annotations.ThreadSafe;
import com.google.errorprone.annotations.concurrent.GuardedBy;
import io.airlift.concurrent.MoreFutures;
import io.airlift.log.Logger;
import io.airlift.slice.Slice;
import io.airlift.units.DataSize;
import io.airlift.units.Duration;
import io.trino.Session;
import io.trino.SystemSessionProperties;
import io.trino.client.ClientCapabilities;
import io.trino.client.Column;
import io.trino.client.FailureInfo;
import io.trino.client.QueryError;
import io.trino.client.QueryResults;
import io.trino.exchange.ExchangeDataSource;
import io.trino.exchange.ExchangeManagerRegistry;
import io.trino.exchange.LazyExchangeDataSource;
import io.trino.execution.BasicStageInfo;
import io.trino.execution.QueryExecution;
import io.trino.execution.QueryInfo;
import io.trino.execution.QueryManager;
import io.trino.execution.QueryState;
import io.trino.execution.StageId;
import io.trino.execution.buffer.PageDeserializer;
import io.trino.execution.buffer.PagesSerdeFactory;
import io.trino.memory.context.AggregatedMemoryContext;
import io.trino.memory.context.LocalMemoryContext;
import io.trino.memory.context.SimpleLocalMemoryContext;
import io.trino.operator.DirectExchangeClientSupplier;
import io.trino.server.ResultQueryInfo;
import io.trino.server.protocol.ProtocolUtil;
import io.trino.server.protocol.QueryInfoUrlFactory;
import io.trino.server.protocol.QueryResultRows;
import io.trino.server.protocol.QueryResultsResponse;
import io.trino.server.protocol.Slug;
import io.trino.spi.ErrorCode;
import io.trino.spi.Page;
import io.trino.spi.QueryId;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.block.BlockEncodingSerde;
import io.trino.spi.exchange.ExchangeId;
import io.trino.spi.security.SelectedRole;
import io.trino.spi.type.Type;
import io.trino.transaction.TransactionId;
import io.trino.util.Ciphers;
import io.trino.util.Failures;
import io.trino.util.MoreLists;
import jakarta.ws.rs.WebApplicationException;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.UriInfo;
import java.net.URI;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalLong;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledExecutorService;

@ThreadSafe
class Query {
    private static final Logger log = Logger.get(Query.class);
    private final QueryManager queryManager;
    private final QueryId queryId;
    private final Session session;
    private final Slug slug;
    private final Optional<URI> queryInfoUrl;
    @GuardedBy(value="this")
    private final ExchangeDataSource exchangeDataSource;
    @GuardedBy(value="this")
    private ListenableFuture<Void> exchangeDataSourceBlocked;
    private final Executor resultsProcessorExecutor;
    private final ScheduledExecutorService timeoutExecutor;
    @GuardedBy(value="this")
    private PageDeserializer deserializer;
    private final boolean supportsParametricDateTime;
    @GuardedBy(value="this")
    private OptionalLong nextToken = OptionalLong.of(0L);
    @GuardedBy(value="this")
    private QueryResults lastResult;
    @GuardedBy(value="this")
    private long lastToken = -1L;
    private volatile boolean resultsConsumed;
    @GuardedBy(value="this")
    private List<Column> columns;
    @GuardedBy(value="this")
    private List<Type> types;
    @GuardedBy(value="this")
    private Optional<String> setCatalog = Optional.empty();
    @GuardedBy(value="this")
    private Optional<String> setSchema = Optional.empty();
    @GuardedBy(value="this")
    private Optional<String> setPath = Optional.empty();
    @GuardedBy(value="this")
    private Optional<String> setAuthorizationUser = Optional.empty();
    @GuardedBy(value="this")
    private boolean resetAuthorizationUser;
    @GuardedBy(value="this")
    private Map<String, String> setSessionProperties = ImmutableMap.of();
    @GuardedBy(value="this")
    private Set<String> resetSessionProperties = ImmutableSet.of();
    @GuardedBy(value="this")
    private Map<String, SelectedRole> setRoles = ImmutableMap.of();
    @GuardedBy(value="this")
    private Map<String, String> addedPreparedStatements = ImmutableMap.of();
    @GuardedBy(value="this")
    private Set<String> deallocatedPreparedStatements = ImmutableSet.of();
    @GuardedBy(value="this")
    private Optional<TransactionId> startedTransactionId = Optional.empty();
    @GuardedBy(value="this")
    private boolean clearTransactionId;
    @GuardedBy(value="this")
    private Optional<Throwable> typeSerializationException = Optional.empty();
    @GuardedBy(value="this")
    private Long updateCount;

    public static Query create(Session session, Slug slug, QueryManager queryManager, Optional<URI> queryInfoUrl, DirectExchangeClientSupplier directExchangeClientSupplier, ExchangeManagerRegistry exchangeManagerRegistry, Executor dataProcessorExecutor, ScheduledExecutorService timeoutExecutor, BlockEncodingSerde blockEncodingSerde) {
        LazyExchangeDataSource exchangeDataSource = new LazyExchangeDataSource(session.getQueryId(), new ExchangeId("query-results-exchange-" + String.valueOf(session.getQueryId())), session.getQuerySpan(), directExchangeClientSupplier, (LocalMemoryContext)new SimpleLocalMemoryContext(AggregatedMemoryContext.newSimpleAggregatedMemoryContext(), Query.class.getSimpleName()), queryManager::outputTaskFailed, SystemSessionProperties.getRetryPolicy(session), exchangeManagerRegistry);
        Query result = new Query(session, slug, queryManager, queryInfoUrl, exchangeDataSource, dataProcessorExecutor, timeoutExecutor, blockEncodingSerde);
        result.queryManager.setOutputInfoListener(result.getQueryId(), result::setQueryOutputInfo);
        result.queryManager.addStateChangeListener(result.getQueryId(), state -> {
            if (state.isDone() || state == QueryState.FINISHING) {
                QueryInfo queryInfo = queryManager.getFullQueryInfo(result.getQueryId());
                result.closeExchangeIfNecessary(new ResultQueryInfo(queryInfo));
            }
        });
        return result;
    }

    private Query(Session session, Slug slug, QueryManager queryManager, Optional<URI> queryInfoUrl, ExchangeDataSource exchangeDataSource, Executor resultsProcessorExecutor, ScheduledExecutorService timeoutExecutor, BlockEncodingSerde blockEncodingSerde) {
        Objects.requireNonNull(session, "session is null");
        Objects.requireNonNull(slug, "slug is null");
        Objects.requireNonNull(queryManager, "queryManager is null");
        Objects.requireNonNull(queryInfoUrl, "queryInfoUrl is null");
        Objects.requireNonNull(exchangeDataSource, "exchangeDataSource is null");
        Objects.requireNonNull(resultsProcessorExecutor, "resultsProcessorExecutor is null");
        Objects.requireNonNull(timeoutExecutor, "timeoutExecutor is null");
        Objects.requireNonNull(blockEncodingSerde, "blockEncodingSerde is null");
        this.queryManager = queryManager;
        this.queryId = session.getQueryId();
        this.session = session;
        this.slug = slug;
        this.queryInfoUrl = queryInfoUrl;
        this.exchangeDataSource = exchangeDataSource;
        this.resultsProcessorExecutor = resultsProcessorExecutor;
        this.timeoutExecutor = timeoutExecutor;
        this.supportsParametricDateTime = session.getClientCapabilities().contains(ClientCapabilities.PARAMETRIC_DATETIME.toString());
        this.deserializer = new PagesSerdeFactory(blockEncodingSerde, SystemSessionProperties.getExchangeCompressionCodec(session)).createDeserializer(session.getExchangeEncryptionKey().map(Ciphers::deserializeAesEncryptionKey));
    }

    public void cancel() {
        this.queryManager.cancelQuery(this.queryId);
        this.dispose();
    }

    public void partialCancel(int id) {
        StageId stageId = new StageId(this.queryId, id);
        this.queryManager.cancelStage(stageId);
    }

    public void fail(Throwable throwable) {
        this.queryManager.failQuery(this.queryId, throwable);
    }

    public synchronized void dispose() {
        this.exchangeDataSource.close();
    }

    public QueryId getQueryId() {
        return this.queryId;
    }

    public boolean isSlugValid(String slug, long token) {
        return this.slug.isValid(Slug.Context.EXECUTING_QUERY, slug, token);
    }

    public QueryInfo getQueryInfo() {
        return this.queryManager.getFullQueryInfo(this.queryId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ListenableFuture<QueryResultsResponse> waitForResults(long token, UriInfo uriInfo, Duration wait, DataSize targetResultSize) {
        ListenableFuture futureStateChange;
        Query query = this;
        synchronized (query) {
            Optional<QueryResults> cachedResult = this.getCachedResult(token);
            if (cachedResult.isPresent()) {
                return Futures.immediateFuture((Object)this.toResultsResponse(cachedResult.get()));
            }
            futureStateChange = this.getFutureStateChange();
        }
        if (!futureStateChange.isDone()) {
            futureStateChange = MoreFutures.addTimeout(futureStateChange, () -> null, (Duration)wait, (ScheduledExecutorService)this.timeoutExecutor);
        }
        return Futures.transform((ListenableFuture)futureStateChange, ignored -> this.getNextResult(token, uriInfo, targetResultSize), (Executor)this.resultsProcessorExecutor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void markResultsConsumedIfReady() {
        if (this.resultsConsumed) {
            return;
        }
        Query query = this;
        synchronized (query) {
            if (!this.resultsConsumed && this.exchangeDataSource.isFinished()) {
                this.queryManager.resultsConsumed(this.queryId);
            }
        }
    }

    private synchronized ListenableFuture<Void> getFutureStateChange() {
        if (!this.exchangeDataSource.isFinished()) {
            if (this.exchangeDataSourceBlocked != null && !this.exchangeDataSourceBlocked.isDone()) {
                return this.exchangeDataSourceBlocked;
            }
            ListenableFuture<Void> blocked = this.exchangeDataSource.isBlocked();
            if (blocked.isDone()) {
                return Futures.immediateVoidFuture();
            }
            this.exchangeDataSourceBlocked = Query.ignoreCancellation(blocked);
            return this.exchangeDataSourceBlocked;
        }
        this.exchangeDataSourceBlocked = null;
        if (!this.resultsConsumed) {
            return Futures.immediateVoidFuture();
        }
        this.queryManager.recordHeartbeat(this.queryId);
        try {
            return this.queryDoneFuture(this.queryManager.getQueryState(this.queryId));
        }
        catch (NoSuchElementException e) {
            return Futures.immediateVoidFuture();
        }
    }

    private static ListenableFuture<Void> ignoreCancellation(ListenableFuture<Void> future) {
        return new AbstractFuture<Void>(){

            public AbstractFuture<Void> propagateFuture(ListenableFuture<? extends Void> future) {
                this.setFuture(future);
                return this;
            }

            public boolean cancel(boolean mayInterruptIfRunning) {
                return false;
            }
        }.propagateFuture(future);
    }

    private synchronized Optional<QueryResults> getCachedResult(long token) {
        if (this.lastResult == null) {
            return Optional.empty();
        }
        if (token == this.lastToken) {
            this.queryManager.recordHeartbeat(this.queryId);
            return Optional.of(this.lastResult);
        }
        if (token < this.lastToken) {
            throw new WebApplicationException(Response.Status.GONE);
        }
        if (this.nextToken.isEmpty()) {
            throw new WebApplicationException(Response.Status.NOT_FOUND);
        }
        if (token != this.nextToken.getAsLong()) {
            throw new WebApplicationException(Response.Status.NOT_FOUND);
        }
        return Optional.empty();
    }

    private synchronized QueryResultsResponse getNextResult(long token, UriInfo uriInfo, DataSize targetResultSize) {
        QueryResultRows resultRows;
        boolean isStarted;
        Optional<QueryResults> cachedResult = this.getCachedResult(token);
        if (cachedResult.isPresent()) {
            return this.toResultsResponse(cachedResult.get());
        }
        Verify.verify((boolean)this.nextToken.isPresent(), (String)"Cannot generate next result when next token is not present", (Object[])new Object[0]);
        Verify.verify((token == this.nextToken.getAsLong() ? 1 : 0) != 0, (String)"Expected token to equal next token", (Object[])new Object[0]);
        ResultQueryInfo queryInfo = this.queryManager.getResultQueryInfo(this.queryId);
        this.queryManager.recordHeartbeat(this.queryId);
        boolean bl = isStarted = queryInfo.state().ordinal() > QueryState.STARTING.ordinal();
        if (isStarted) {
            this.closeExchangeIfNecessary(queryInfo);
            resultRows = this.removePagesFromExchange(queryInfo, targetResultSize.toBytes());
        } else {
            resultRows = QueryResultRows.queryResultRowsBuilder(this.session).build();
        }
        if (queryInfo.updateType() != null && this.updateCount == null) {
            Optional<Long> updatedRowsCount = resultRows.getUpdateCount();
            this.updateCount = updatedRowsCount.orElse(null);
        }
        if (isStarted && (queryInfo.outputStage().isEmpty() || this.exchangeDataSource.isFinished())) {
            this.queryManager.resultsConsumed(this.queryId);
            this.resultsConsumed = true;
            queryInfo = this.queryManager.getResultQueryInfo(this.queryId);
        }
        if (queryInfo.state() != QueryState.FAILED && (!queryInfo.finalQueryInfo() || !this.exchangeDataSource.isFinished() || queryInfo.outputStage().isPresent() && !resultRows.isEmpty())) {
            this.nextToken = OptionalLong.of(token + 1L);
        } else {
            this.nextToken = OptionalLong.empty();
            this.exchangeDataSource.close();
        }
        URI nextResultsUri = null;
        URI partialCancelUri = null;
        if (this.nextToken.isPresent()) {
            long nextToken = this.nextToken.getAsLong();
            nextResultsUri = this.createNextResultsUri(uriInfo, nextToken);
            partialCancelUri = Query.findCancelableLeafStage(queryInfo).map(stage -> this.createPartialCancelUri((int)stage, uriInfo, nextToken)).orElse(null);
        }
        this.setCatalog = queryInfo.setCatalog();
        this.setSchema = queryInfo.setSchema();
        this.setPath = queryInfo.setPath();
        this.setAuthorizationUser = queryInfo.setAuthorizationUser();
        this.resetAuthorizationUser = queryInfo.resetAuthorizationUser();
        this.setSessionProperties = queryInfo.setSessionProperties();
        this.resetSessionProperties = queryInfo.resetSessionProperties();
        this.setRoles = queryInfo.setRoles();
        this.addedPreparedStatements = queryInfo.addedPreparedStatements();
        this.deallocatedPreparedStatements = queryInfo.deallocatedPreparedStatements();
        this.startedTransactionId = queryInfo.startedTransactionId();
        this.clearTransactionId = queryInfo.clearTransactionId();
        QueryResults queryResults = new QueryResults(this.queryId.toString(), QueryInfoUrlFactory.getQueryInfoUri(this.queryInfoUrl, this.queryId, uriInfo), partialCancelUri, nextResultsUri, (List)resultRows.getColumns().orElse(null), (Iterable)(resultRows.isEmpty() ? null : resultRows), ProtocolUtil.toStatementStats(queryInfo), Query.toQueryError(queryInfo, this.typeSerializationException), MoreLists.mappedCopy(queryInfo.warnings(), ProtocolUtil::toClientWarning), queryInfo.updateType(), this.updateCount);
        this.lastToken = token;
        this.lastResult = queryResults;
        return this.toResultsResponse(queryResults);
    }

    private synchronized QueryResultsResponse toResultsResponse(QueryResults queryResults) {
        return new QueryResultsResponse(this.setCatalog, this.setSchema, this.setPath, this.setAuthorizationUser, this.resetAuthorizationUser, this.setSessionProperties, this.resetSessionProperties, this.setRoles, this.addedPreparedStatements, this.deallocatedPreparedStatements, this.startedTransactionId, this.clearTransactionId, this.session.getProtocolHeaders(), queryResults);
    }

    private synchronized QueryResultRows removePagesFromExchange(ResultQueryInfo queryInfo, long targetResultBytes) {
        if (!this.resultsConsumed && queryInfo.outputStage().isEmpty()) {
            return QueryResultRows.queryResultRowsBuilder(this.session).withColumnsAndTypes((List<Column>)ImmutableList.of(), (List<Type>)ImmutableList.of()).build();
        }
        QueryResultRows.Builder resultBuilder = QueryResultRows.queryResultRowsBuilder(this.session).withExceptionConsumer(this::handleSerializationException).withColumnsAndTypes(this.columns, this.types);
        try {
            Slice serializedPage;
            Page page;
            for (long bytes = 0L; bytes < targetResultBytes && (serializedPage = this.exchangeDataSource.pollPage()) != null; bytes += page.getLogicalSizeInBytes()) {
                page = this.deserializer.deserialize(serializedPage);
                resultBuilder.addPage(page);
            }
            if (this.exchangeDataSource.isFinished()) {
                this.exchangeDataSource.close();
                this.deserializer = null;
            }
        }
        catch (Throwable cause) {
            this.queryManager.failQuery(this.queryId, cause);
        }
        return resultBuilder.build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeExchangeIfNecessary(ResultQueryInfo queryInfo) {
        if (queryInfo.state() != QueryState.FAILED && queryInfo.outputStage().isPresent()) {
            return;
        }
        Query query = this;
        synchronized (query) {
            if (queryInfo.state() == QueryState.FAILED || !this.exchangeDataSource.isFinished() && queryInfo.outputStage().isEmpty()) {
                this.exchangeDataSource.close();
            }
        }
    }

    private synchronized void handleSerializationException(Throwable exception) {
        try {
            this.queryManager.failQuery(this.queryId, exception);
        }
        catch (RuntimeException e) {
            log.debug((Throwable)e, "Could not fail query");
        }
        if (this.typeSerializationException.isEmpty()) {
            this.typeSerializationException = Optional.of(exception);
        }
    }

    private synchronized void setQueryOutputInfo(QueryExecution.QueryOutputInfo outputInfo) {
        if (this.columns == null) {
            List<String> columnNames = outputInfo.getColumnNames();
            List<Type> columnTypes = outputInfo.getColumnTypes();
            Preconditions.checkArgument((columnNames.size() == columnTypes.size() ? 1 : 0) != 0, (Object)"Column names and types size mismatch");
            ImmutableList.Builder list = ImmutableList.builder();
            for (int i = 0; i < columnNames.size(); ++i) {
                list.add((Object)ProtocolUtil.createColumn(columnNames.get(i), columnTypes.get(i), this.supportsParametricDateTime));
            }
            this.columns = list.build();
            this.types = outputInfo.getColumnTypes();
        }
        outputInfo.drainInputs(this.exchangeDataSource::addInput);
        if (outputInfo.isNoMoreInputs()) {
            this.exchangeDataSource.noMoreInputs();
        }
    }

    private ListenableFuture<Void> queryDoneFuture(QueryState currentState) {
        if (currentState.isDone()) {
            return Futures.immediateVoidFuture();
        }
        return Futures.transformAsync(this.queryManager.getStateChange(this.queryId, currentState), this::queryDoneFuture, (Executor)MoreExecutors.directExecutor());
    }

    private URI createNextResultsUri(UriInfo uriInfo, long nextToken) {
        return uriInfo.getBaseUriBuilder().replacePath("/v1/statement/executing").path(this.queryId.toString()).path(this.slug.makeSlug(Slug.Context.EXECUTING_QUERY, nextToken)).path(String.valueOf(nextToken)).replaceQuery("").build(new Object[0]);
    }

    private URI createPartialCancelUri(int stage, UriInfo uriInfo, long nextToken) {
        return uriInfo.getBaseUriBuilder().replacePath("/v1/statement/executing/partialCancel").path(this.queryId.toString()).path(String.valueOf(stage)).path(this.slug.makeSlug(Slug.Context.EXECUTING_QUERY, nextToken)).path(String.valueOf(nextToken)).replaceQuery("").build(new Object[0]);
    }

    private static Optional<Integer> findCancelableLeafStage(ResultQueryInfo queryInfo) {
        return queryInfo.outputStage().flatMap(Query::findCancelableLeafStage);
    }

    private static Optional<Integer> findCancelableLeafStage(BasicStageInfo stage) {
        if (stage.getState().isDone()) {
            return Optional.empty();
        }
        for (BasicStageInfo subStage : stage.getSubStages().reversed()) {
            Optional<Integer> leafStage = Query.findCancelableLeafStage(subStage);
            if (!leafStage.isPresent()) continue;
            return leafStage;
        }
        return Optional.of(stage.getStageId().getId());
    }

    private static QueryError toQueryError(ResultQueryInfo queryInfo, Optional<Throwable> exception) {
        if (queryInfo.failureInfo() == null && exception.isPresent()) {
            ErrorCode errorCode = StandardErrorCode.SERIALIZATION_ERROR.toErrorCode();
            FailureInfo failure = Failures.toFailure(exception.get()).toFailureInfo();
            return new QueryError((String)MoreObjects.firstNonNull((Object)failure.getMessage(), (Object)"Internal error"), null, errorCode.getCode(), errorCode.getName(), errorCode.getType().toString(), failure.getErrorLocation(), failure);
        }
        return ProtocolUtil.toQueryError(queryInfo);
    }
}

