/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.gen;

import io.airlift.bytecode.BytecodeBlock;
import io.airlift.bytecode.BytecodeNode;
import io.airlift.bytecode.ParameterizedType;
import io.airlift.bytecode.Scope;
import io.airlift.bytecode.Variable;
import io.airlift.bytecode.control.IfStatement;
import io.airlift.bytecode.expression.BytecodeExpression;
import io.airlift.bytecode.expression.BytecodeExpressions;
import io.trino.annotation.UsedByGeneratedCode;
import io.trino.spi.block.Block;
import io.trino.spi.block.BlockBuilder;
import io.trino.spi.block.BlockBuilderStatus;
import io.trino.spi.block.SqlRow;
import io.trino.spi.type.RowType;
import io.trino.spi.type.Type;
import io.trino.sql.gen.BytecodeGenerator;
import io.trino.sql.gen.BytecodeGeneratorContext;
import io.trino.sql.gen.CallSiteBinder;
import io.trino.sql.gen.SqlTypeBytecodeExpression;
import io.trino.sql.relational.RowExpression;
import io.trino.sql.relational.SpecialForm;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;

public class RowConstructorCodeGenerator
implements BytecodeGenerator {
    private final Type rowType;
    private final List<RowExpression> arguments;
    private static final int MEGAMORPHIC_FIELD_COUNT = 64;

    public RowConstructorCodeGenerator(SpecialForm specialForm) {
        Objects.requireNonNull(specialForm, "specialForm is null");
        this.rowType = specialForm.type();
        this.arguments = specialForm.arguments();
    }

    @Override
    public BytecodeNode generateExpression(BytecodeGeneratorContext context) {
        if (this.arguments.size() > 64) {
            return this.generateExpressionForLargeRows(context);
        }
        BytecodeBlock block = new BytecodeBlock().setDescription("Constructor for " + String.valueOf(this.rowType));
        CallSiteBinder binder = context.getCallSiteBinder();
        Scope scope = context.getScope();
        List types = this.rowType.getTypeParameters();
        Variable fieldBlocks = scope.createTempVariable(Block[].class);
        block.append((BytecodeNode)fieldBlocks.set(BytecodeExpressions.newArray((ParameterizedType)ParameterizedType.type(Block[].class), (int)this.arguments.size())));
        Variable blockBuilder = scope.createTempVariable(BlockBuilder.class);
        for (int i = 0; i < this.arguments.size(); ++i) {
            Type fieldType = (Type)types.get(i);
            Variable field = scope.createTempVariable(fieldType.getJavaType());
            block.append((BytecodeNode)blockBuilder.set(SqlTypeBytecodeExpression.constantType(binder, fieldType).invoke("createBlockBuilder", BlockBuilder.class, new BytecodeExpression[]{BytecodeExpressions.constantNull(BlockBuilderStatus.class), BytecodeExpressions.constantInt((int)1)})));
            block.comment("Clean wasNull and Generate + " + i + "-th field of row");
            block.append((BytecodeNode)context.wasNull().set(BytecodeExpressions.constantFalse()));
            block.append(context.generate(this.arguments.get(i)));
            block.putVariable(field);
            block.append((BytecodeNode)new IfStatement().condition((BytecodeNode)context.wasNull()).ifTrue((BytecodeNode)blockBuilder.invoke("appendNull", BlockBuilder.class, new BytecodeExpression[0]).pop()).ifFalse((BytecodeNode)SqlTypeBytecodeExpression.constantType(binder, fieldType).writeValue((BytecodeExpression)blockBuilder, (BytecodeExpression)field).pop()));
            block.append((BytecodeNode)fieldBlocks.setElement(i, blockBuilder.invoke("build", Block.class, new BytecodeExpression[0])));
        }
        block.append((BytecodeNode)BytecodeExpressions.newInstance(SqlRow.class, (BytecodeExpression[])new BytecodeExpression[]{BytecodeExpressions.constantInt((int)0), fieldBlocks}));
        block.append((BytecodeNode)context.wasNull().set(BytecodeExpressions.constantFalse()));
        return block;
    }

    private BytecodeNode generateExpressionForLargeRows(BytecodeGeneratorContext context) {
        BytecodeBlock block = new BytecodeBlock().setDescription("Constructor for " + String.valueOf(this.rowType));
        CallSiteBinder binder = context.getCallSiteBinder();
        Scope scope = context.getScope();
        List types = this.rowType.getTypeParameters();
        Variable fieldBuilders = scope.createTempVariable(BlockBuilder[].class);
        block.append((BytecodeNode)fieldBuilders.set(BytecodeExpressions.invokeStatic(RowConstructorCodeGenerator.class, (String)"createFieldBlockBuildersForSingleRow", BlockBuilder[].class, (BytecodeExpression[])new BytecodeExpression[]{SqlTypeBytecodeExpression.constantType(binder, this.rowType)})));
        HashMap<Class, Variable> javaTypeTempVariables = new HashMap<Class, Variable>();
        Variable blockBuilder = scope.createTempVariable(BlockBuilder.class);
        for (int i = 0; i < this.arguments.size(); ++i) {
            Type fieldType = (Type)types.get(i);
            Variable field = javaTypeTempVariables.computeIfAbsent(fieldType.getJavaType(), arg_0 -> ((Scope)scope).createTempVariable(arg_0));
            block.append((BytecodeNode)blockBuilder.set(fieldBuilders.getElement(BytecodeExpressions.constantInt((int)i))));
            block.comment("Clean wasNull and Generate + " + i + "-th field of row");
            block.append((BytecodeNode)context.wasNull().set(BytecodeExpressions.constantFalse()));
            block.append(context.generate(this.arguments.get(i)));
            block.putVariable(field);
            block.append((BytecodeNode)new IfStatement().condition((BytecodeNode)context.wasNull()).ifTrue((BytecodeNode)blockBuilder.invoke("appendNull", BlockBuilder.class, new BytecodeExpression[0]).pop()).ifFalse((BytecodeNode)SqlTypeBytecodeExpression.constantType(binder, fieldType).writeValue((BytecodeExpression)blockBuilder, (BytecodeExpression)field).pop()));
        }
        block.append((BytecodeNode)BytecodeExpressions.invokeStatic(RowConstructorCodeGenerator.class, (String)"createSqlRowFromFieldBuildersForSingleRow", SqlRow.class, (BytecodeExpression[])new BytecodeExpression[]{fieldBuilders}));
        block.append((BytecodeNode)context.wasNull().set(BytecodeExpressions.constantFalse()));
        return block;
    }

    @UsedByGeneratedCode
    public static BlockBuilder[] createFieldBlockBuildersForSingleRow(Type rowType) {
        if (!(rowType instanceof RowType)) {
            throw new IllegalArgumentException("Not a row type: " + String.valueOf(rowType));
        }
        List fieldTypes = rowType.getTypeParameters();
        BlockBuilder[] fieldBlockBuilders = new BlockBuilder[fieldTypes.size()];
        for (int i = 0; i < fieldTypes.size(); ++i) {
            fieldBlockBuilders[i] = ((Type)fieldTypes.get(i)).createBlockBuilder(null, 1);
        }
        return fieldBlockBuilders;
    }

    @UsedByGeneratedCode
    public static SqlRow createSqlRowFromFieldBuildersForSingleRow(BlockBuilder[] fieldBuilders) {
        Block[] fieldBlocks = new Block[fieldBuilders.length];
        for (int i = 0; i < fieldBuilders.length; ++i) {
            fieldBlocks[i] = fieldBuilders[i].build();
            if (fieldBlocks[i].getPositionCount() == 1) continue;
            throw new IllegalArgumentException(String.format("builder must only contain a single position, found: %s positions", fieldBlocks[i].getPositionCount()));
        }
        return new SqlRow(0, fieldBlocks);
    }
}

