/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import io.trino.Session;
import io.trino.operator.scalar.TryFunction;
import io.trino.spi.connector.ColumnHandle;
import io.trino.spi.predicate.NullableValue;
import io.trino.sql.PlannerContext;
import io.trino.sql.ir.Booleans;
import io.trino.sql.ir.Constant;
import io.trino.sql.ir.Expression;
import io.trino.sql.planner.IrExpressionInterpreter;
import io.trino.sql.planner.LookupSymbolResolver;
import io.trino.sql.planner.Symbol;
import io.trino.sql.planner.SymbolsExtractor;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public class LayoutConstraintEvaluator {
    private final Map<Symbol, ColumnHandle> assignments;
    private final IrExpressionInterpreter evaluator;
    private final Set<ColumnHandle> arguments;

    public LayoutConstraintEvaluator(PlannerContext plannerContext, Session session, Map<Symbol, ColumnHandle> assignments, Expression expression) {
        this.assignments = ImmutableMap.copyOf(Objects.requireNonNull(assignments, "assignments is null"));
        this.evaluator = new IrExpressionInterpreter(expression, plannerContext, session);
        this.arguments = (Set)SymbolsExtractor.extractUnique(expression).stream().map(assignments::get).collect(ImmutableSet.toImmutableSet());
    }

    public Set<ColumnHandle> getArguments() {
        return this.arguments;
    }

    public boolean isCandidate(Map<ColumnHandle, NullableValue> bindings) {
        Constant constant;
        if (Sets.intersection(bindings.keySet(), this.arguments).isEmpty()) {
            return true;
        }
        LookupSymbolResolver inputs = new LookupSymbolResolver(this.assignments, bindings);
        Expression optimized = TryFunction.evaluate(() -> this.evaluator.optimize(inputs), Booleans.TRUE);
        return !(optimized instanceof Constant) || Boolean.TRUE.equals((constant = (Constant)optimized).value());
    }
}

