/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.ListMultimap;
import io.trino.Session;
import io.trino.json.ir.IrJsonPath;
import io.trino.metadata.ResolvedFunction;
import io.trino.metadata.TableFunctionHandle;
import io.trino.metadata.TableHandle;
import io.trino.operator.table.json.JsonTable;
import io.trino.operator.table.json.JsonTableColumn;
import io.trino.operator.table.json.JsonTableOrdinalityColumn;
import io.trino.operator.table.json.JsonTablePlanCross;
import io.trino.operator.table.json.JsonTablePlanLeaf;
import io.trino.operator.table.json.JsonTablePlanNode;
import io.trino.operator.table.json.JsonTablePlanSingle;
import io.trino.operator.table.json.JsonTablePlanUnion;
import io.trino.operator.table.json.JsonTableQueryColumn;
import io.trino.operator.table.json.JsonTableValueColumn;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.connector.ColumnHandle;
import io.trino.spi.function.table.Argument;
import io.trino.spi.function.table.TableArgument;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.BooleanType;
import io.trino.spi.type.RowType;
import io.trino.spi.type.TinyintType;
import io.trino.spi.type.Type;
import io.trino.spi.type.VarcharType;
import io.trino.sql.NodeUtils;
import io.trino.sql.PlannerContext;
import io.trino.sql.analyzer.Analysis;
import io.trino.sql.analyzer.Field;
import io.trino.sql.analyzer.NamesExtractor;
import io.trino.sql.analyzer.PatternRecognitionAnalysis;
import io.trino.sql.analyzer.RelationType;
import io.trino.sql.analyzer.Scope;
import io.trino.sql.analyzer.SemanticExceptions;
import io.trino.sql.ir.Booleans;
import io.trino.sql.ir.Call;
import io.trino.sql.ir.Cast;
import io.trino.sql.ir.Coalesce;
import io.trino.sql.ir.Comparison;
import io.trino.sql.ir.Constant;
import io.trino.sql.ir.Expression;
import io.trino.sql.ir.IrExpressions;
import io.trino.sql.ir.IrUtils;
import io.trino.sql.ir.Not;
import io.trino.sql.planner.JsonPathTranslator;
import io.trino.sql.planner.LogicalPlanner;
import io.trino.sql.planner.NodeAndMappings;
import io.trino.sql.planner.OrderingScheme;
import io.trino.sql.planner.PlanBuilder;
import io.trino.sql.planner.PlanNodeIdAllocator;
import io.trino.sql.planner.QueryPlanner;
import io.trino.sql.planner.RelationPlan;
import io.trino.sql.planner.ScopeAware;
import io.trino.sql.planner.SubqueryPlanner;
import io.trino.sql.planner.Symbol;
import io.trino.sql.planner.SymbolAllocator;
import io.trino.sql.planner.TranslationMap;
import io.trino.sql.planner.plan.AggregationNode;
import io.trino.sql.planner.plan.Assignments;
import io.trino.sql.planner.plan.DataOrganizationSpecification;
import io.trino.sql.planner.plan.DynamicFilterId;
import io.trino.sql.planner.plan.ExceptNode;
import io.trino.sql.planner.plan.FilterNode;
import io.trino.sql.planner.plan.IntersectNode;
import io.trino.sql.planner.plan.JoinNode;
import io.trino.sql.planner.plan.JoinType;
import io.trino.sql.planner.plan.PatternRecognitionNode;
import io.trino.sql.planner.plan.PlanNode;
import io.trino.sql.planner.plan.ProjectNode;
import io.trino.sql.planner.plan.RowsPerMatch;
import io.trino.sql.planner.plan.SampleNode;
import io.trino.sql.planner.plan.SkipToPosition;
import io.trino.sql.planner.plan.TableFunctionNode;
import io.trino.sql.planner.plan.TableScanNode;
import io.trino.sql.planner.plan.UnionNode;
import io.trino.sql.planner.plan.UnnestNode;
import io.trino.sql.planner.plan.ValuesNode;
import io.trino.sql.planner.plan.WindowNode;
import io.trino.sql.planner.rowpattern.AggregatedSetDescriptor;
import io.trino.sql.planner.rowpattern.AggregationValuePointer;
import io.trino.sql.planner.rowpattern.ClassifierValuePointer;
import io.trino.sql.planner.rowpattern.ExpressionAndValuePointers;
import io.trino.sql.planner.rowpattern.LogicalIndexPointer;
import io.trino.sql.planner.rowpattern.MatchNumberValuePointer;
import io.trino.sql.planner.rowpattern.RowPatternToIrRewriter;
import io.trino.sql.planner.rowpattern.ScalarValuePointer;
import io.trino.sql.planner.rowpattern.ValuePointer;
import io.trino.sql.planner.rowpattern.ir.IrLabel;
import io.trino.sql.planner.rowpattern.ir.IrRowPattern;
import io.trino.sql.tree.AliasedRelation;
import io.trino.sql.tree.AstVisitor;
import io.trino.sql.tree.BooleanLiteral;
import io.trino.sql.tree.ComparisonExpression;
import io.trino.sql.tree.DereferenceExpression;
import io.trino.sql.tree.Except;
import io.trino.sql.tree.Identifier;
import io.trino.sql.tree.Intersect;
import io.trino.sql.tree.Join;
import io.trino.sql.tree.JoinCriteria;
import io.trino.sql.tree.JoinUsing;
import io.trino.sql.tree.JsonPathParameter;
import io.trino.sql.tree.JsonQuery;
import io.trino.sql.tree.JsonTable;
import io.trino.sql.tree.JsonTableColumnDefinition;
import io.trino.sql.tree.JsonTableDefaultPlan;
import io.trino.sql.tree.JsonTablePlan;
import io.trino.sql.tree.JsonTableSpecificPlan;
import io.trino.sql.tree.JsonValue;
import io.trino.sql.tree.LambdaArgumentDeclaration;
import io.trino.sql.tree.Lateral;
import io.trino.sql.tree.MeasureDefinition;
import io.trino.sql.tree.NaturalJoin;
import io.trino.sql.tree.NestedColumns;
import io.trino.sql.tree.Node;
import io.trino.sql.tree.NodeRef;
import io.trino.sql.tree.OrdinalityColumn;
import io.trino.sql.tree.PatternRecognitionRelation;
import io.trino.sql.tree.PatternSearchMode;
import io.trino.sql.tree.PlanLeaf;
import io.trino.sql.tree.PlanParentChild;
import io.trino.sql.tree.PlanSiblings;
import io.trino.sql.tree.QualifiedName;
import io.trino.sql.tree.Query;
import io.trino.sql.tree.QueryColumn;
import io.trino.sql.tree.QuerySpecification;
import io.trino.sql.tree.Relation;
import io.trino.sql.tree.Row;
import io.trino.sql.tree.RowPattern;
import io.trino.sql.tree.SampledRelation;
import io.trino.sql.tree.SetOperation;
import io.trino.sql.tree.SkipTo;
import io.trino.sql.tree.SortItem;
import io.trino.sql.tree.SubqueryExpression;
import io.trino.sql.tree.SubsetDefinition;
import io.trino.sql.tree.Table;
import io.trino.sql.tree.TableFunctionInvocation;
import io.trino.sql.tree.TableSubquery;
import io.trino.sql.tree.Union;
import io.trino.sql.tree.Unnest;
import io.trino.sql.tree.ValueColumn;
import io.trino.sql.tree.Values;
import io.trino.sql.tree.VariableDefinition;
import io.trino.sql.util.AstUtils;
import io.trino.type.Json2016Type;
import java.lang.runtime.SwitchBootstraps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.IntStream;

class RelationPlanner
extends AstVisitor<RelationPlan, Void> {
    private final Analysis analysis;
    private final SymbolAllocator symbolAllocator;
    private final PlanNodeIdAllocator idAllocator;
    private final Map<NodeRef<LambdaArgumentDeclaration>, Symbol> lambdaDeclarationToSymbolMap;
    private final PlannerContext plannerContext;
    private final Optional<TranslationMap> outerContext;
    private final Session session;
    private final SubqueryPlanner subqueryPlanner;
    private final Map<NodeRef<Node>, RelationPlan> recursiveSubqueries;

    RelationPlanner(Analysis analysis, SymbolAllocator symbolAllocator, PlanNodeIdAllocator idAllocator, Map<NodeRef<LambdaArgumentDeclaration>, Symbol> lambdaDeclarationToSymbolMap, PlannerContext plannerContext, Optional<TranslationMap> outerContext, Session session, Map<NodeRef<Node>, RelationPlan> recursiveSubqueries) {
        Objects.requireNonNull(analysis, "analysis is null");
        Objects.requireNonNull(symbolAllocator, "symbolAllocator is null");
        Objects.requireNonNull(idAllocator, "idAllocator is null");
        Objects.requireNonNull(lambdaDeclarationToSymbolMap, "lambdaDeclarationToSymbolMap is null");
        Objects.requireNonNull(plannerContext, "plannerContext is null");
        Objects.requireNonNull(outerContext, "outerContext is null");
        Objects.requireNonNull(session, "session is null");
        Objects.requireNonNull(recursiveSubqueries, "recursiveSubqueries is null");
        this.analysis = analysis;
        this.symbolAllocator = symbolAllocator;
        this.idAllocator = idAllocator;
        this.lambdaDeclarationToSymbolMap = lambdaDeclarationToSymbolMap;
        this.plannerContext = plannerContext;
        this.outerContext = outerContext;
        this.session = session;
        this.subqueryPlanner = new SubqueryPlanner(analysis, symbolAllocator, idAllocator, lambdaDeclarationToSymbolMap, plannerContext, outerContext, session, recursiveSubqueries);
        this.recursiveSubqueries = recursiveSubqueries;
    }

    public static JoinType mapJoinType(Join.Type joinType) {
        return switch (joinType) {
            default -> throw new MatchException(null, null);
            case Join.Type.CROSS, Join.Type.IMPLICIT, Join.Type.INNER -> JoinType.INNER;
            case Join.Type.LEFT -> JoinType.LEFT;
            case Join.Type.RIGHT -> JoinType.RIGHT;
            case Join.Type.FULL -> JoinType.FULL;
        };
    }

    public static SampleNode.Type mapSampleType(SampledRelation.Type sampleType) {
        return switch (sampleType) {
            default -> throw new MatchException(null, null);
            case SampledRelation.Type.BERNOULLI -> SampleNode.Type.BERNOULLI;
            case SampledRelation.Type.SYSTEM -> SampleNode.Type.SYSTEM;
        };
    }

    protected RelationPlan visitNode(Node node, Void context) {
        throw new IllegalStateException("Unsupported node type: " + node.getClass().getName());
    }

    protected RelationPlan visitTable(Table node, Void context) {
        RelationPlan plan;
        RelationPlan expansion = this.recursiveSubqueries.get(NodeRef.of((Node)node));
        if (expansion != null) {
            return new RelationPlan(expansion.getRoot(), expansion.getScope(), expansion.getFieldMappings(), this.outerContext);
        }
        Query namedQuery = this.analysis.getNamedQuery(node);
        Scope scope = this.analysis.getScope((Node)node);
        if (namedQuery != null) {
            RelationPlan subPlan = this.analysis.isExpandableQuery(namedQuery) ? new QueryPlanner(this.analysis, this.symbolAllocator, this.idAllocator, this.lambdaDeclarationToSymbolMap, this.plannerContext, this.outerContext, this.session, this.recursiveSubqueries).planExpand(namedQuery) : (RelationPlan)this.process((Node)namedQuery, null);
            List types = (List)this.analysis.getOutputDescriptor((Node)node).getAllFields().stream().map(Field::getType).collect(ImmutableList.toImmutableList());
            NodeAndMappings coerced = QueryPlanner.coerce(subPlan, types, this.symbolAllocator, this.idAllocator);
            plan = new RelationPlan(coerced.getNode(), scope, coerced.getFields(), this.outerContext);
        } else {
            boolean hasStorageTableFields;
            TableHandle handle = this.analysis.getTableHandle(node);
            ImmutableList.Builder outputSymbolsBuilder = ImmutableList.builder();
            ImmutableMap.Builder columns = ImmutableMap.builder();
            Collection<Field> fields = this.analysis.getMaterializedViewStorageTableFields(node);
            boolean bl = hasStorageTableFields = fields != null;
            if (!hasStorageTableFields) {
                fields = scope.getRelationType().getAllFields();
            }
            for (Field field : fields) {
                Symbol symbol = this.symbolAllocator.newSymbol(field);
                outputSymbolsBuilder.add((Object)symbol);
                columns.put((Object)symbol, (Object)this.analysis.getColumn(field));
            }
            ImmutableList outputSymbols = outputSymbolsBuilder.build();
            boolean updateTarget = this.analysis.isUpdateTarget(node);
            TableScanNode root = TableScanNode.newInstance(this.idAllocator.getNextId(), handle, (List<Symbol>)outputSymbols, (Map<Symbol, ColumnHandle>)columns.buildOrThrow(), updateTarget, Optional.empty());
            plan = new RelationPlan(root, scope, (List<Symbol>)outputSymbols, this.outerContext);
            if (hasStorageTableFields) {
                List types = (List)scope.getRelationType().getAllFields().stream().map(Field::getType).collect(ImmutableList.toImmutableList());
                NodeAndMappings coerced = QueryPlanner.coerce(plan, types, this.symbolAllocator, this.idAllocator);
                plan = new RelationPlan(coerced.getNode(), scope, coerced.getFields(), this.outerContext);
            }
        }
        plan = this.addRowFilters(node, plan);
        plan = this.addColumnMasks(node, plan);
        return plan;
    }

    private RelationPlan addRowFilters(Table node, RelationPlan plan) {
        return this.addRowFilters(node, plan, Function.identity());
    }

    public RelationPlan addRowFilters(Table node, RelationPlan plan, Function<Expression, Expression> predicateTransformation) {
        return this.addRowFilters(node, plan, predicateTransformation, this.analysis::getAccessControlScope);
    }

    public RelationPlan addRowFilters(Table node, RelationPlan plan, Function<Expression, Expression> predicateTransformation, Function<Table, Scope> accessControlScope) {
        List<io.trino.sql.tree.Expression> filters = this.analysis.getRowFilters(node);
        if (filters.isEmpty()) {
            return plan;
        }
        PlanBuilder planBuilder = PlanBuilder.newPlanBuilder(plan, this.analysis, this.lambdaDeclarationToSymbolMap, this.session, this.plannerContext).withScope(accessControlScope.apply(node), plan.getFieldMappings());
        for (io.trino.sql.tree.Expression filter : filters) {
            planBuilder = this.subqueryPlanner.handleSubqueries(planBuilder, filter, this.analysis.getSubqueries((Node)filter));
            Expression predicate = QueryPlanner.coerceIfNecessary(this.analysis, filter, planBuilder.rewrite(filter));
            predicate = predicateTransformation.apply(predicate);
            planBuilder = planBuilder.withNewRoot(new FilterNode(this.idAllocator.getNextId(), planBuilder.getRoot(), predicate));
        }
        return new RelationPlan(planBuilder.getRoot(), plan.getScope(), plan.getFieldMappings(), this.outerContext);
    }

    public RelationPlan addCheckConstraints(List<io.trino.sql.tree.Expression> constraints, Table node, RelationPlan plan, Function<Table, Scope> accessControlScope) {
        if (constraints.isEmpty()) {
            return plan;
        }
        PlanBuilder planBuilder = PlanBuilder.newPlanBuilder(plan, this.analysis, this.lambdaDeclarationToSymbolMap, this.session, this.plannerContext).withScope(accessControlScope.apply(node), plan.getFieldMappings());
        for (io.trino.sql.tree.Expression constraint : constraints) {
            planBuilder = this.subqueryPlanner.handleSubqueries(planBuilder, constraint, this.analysis.getSubqueries((Node)constraint));
            Expression predicate = IrExpressions.ifExpression(new Coalesce(QueryPlanner.coerceIfNecessary(this.analysis, constraint, planBuilder.rewrite(constraint)), Booleans.TRUE, new Expression[0]), Booleans.TRUE, new Cast(LogicalPlanner.failFunction(this.plannerContext.getMetadata(), (ErrorCodeSupplier)StandardErrorCode.CONSTRAINT_VIOLATION, "Check constraint violation: " + String.valueOf(constraint)), (Type)BooleanType.BOOLEAN));
            planBuilder = planBuilder.withNewRoot(new FilterNode(this.idAllocator.getNextId(), planBuilder.getRoot(), predicate));
        }
        return new RelationPlan(planBuilder.getRoot(), plan.getScope(), plan.getFieldMappings(), this.outerContext);
    }

    private RelationPlan addColumnMasks(Table table, RelationPlan plan) {
        Map<String, io.trino.sql.tree.Expression> columnMasks = this.analysis.getColumnMasks(table);
        if (columnMasks.isEmpty()) {
            return plan;
        }
        PlanBuilder planBuilder = PlanBuilder.newPlanBuilder(plan, this.analysis, this.lambdaDeclarationToSymbolMap, this.session, this.plannerContext).withScope(this.analysis.getAccessControlScope(table), plan.getFieldMappings());
        Assignments.Builder assignments = Assignments.builder();
        assignments.putIdentities(planBuilder.getRoot().getOutputSymbols());
        ArrayList<Symbol> fieldMappings = new ArrayList<Symbol>();
        for (int i = 0; i < plan.getDescriptor().getAllFieldCount(); ++i) {
            Field field = plan.getDescriptor().getFieldByIndex(i);
            io.trino.sql.tree.Expression mask = columnMasks.get(field.getName().orElseThrow());
            Symbol symbol = plan.getFieldMappings().get(i);
            Expression projection = symbol.toSymbolReference();
            if (mask != null) {
                planBuilder = this.subqueryPlanner.handleSubqueries(planBuilder, mask, this.analysis.getSubqueries((Node)mask));
                symbol = this.symbolAllocator.newSymbol(symbol);
                projection = QueryPlanner.coerceIfNecessary(this.analysis, mask, planBuilder.rewrite(mask));
            }
            assignments.put(symbol, projection);
            fieldMappings.add(symbol);
        }
        planBuilder = planBuilder.withNewRoot(new ProjectNode(this.idAllocator.getNextId(), planBuilder.getRoot(), assignments.build()));
        return new RelationPlan(planBuilder.getRoot(), plan.getScope(), fieldMappings, this.outerContext);
    }

    protected RelationPlan visitTableFunctionInvocation(TableFunctionInvocation node, Void context) {
        Analysis.TableFunctionInvocationAnalysis functionAnalysis = this.analysis.getTableFunctionAnalysis(node);
        ImmutableList.Builder sources = ImmutableList.builder();
        ImmutableList.Builder sourceProperties = ImmutableList.builder();
        ImmutableList.Builder outputSymbols = ImmutableList.builder();
        RelationType relationType = this.analysis.getScope((Node)node).getRelationType();
        List properOutputs = (List)IntStream.range(0, functionAnalysis.getProperColumnsCount()).mapToObj(relationType::getFieldByIndex).map(this.symbolAllocator::newSymbol).collect(ImmutableList.toImmutableList());
        outputSymbols.addAll((Iterable)properOutputs);
        for (Analysis.TableArgumentAnalysis tableArgument : functionAnalysis.getTableArgumentAnalyses()) {
            RelationPlan sourcePlan = (RelationPlan)this.process((Node)tableArgument.getRelation(), context);
            PlanBuilder sourcePlanBuilder = PlanBuilder.newPlanBuilder(sourcePlan, this.analysis, this.lambdaDeclarationToSymbolMap, this.session, this.plannerContext);
            RelationType sourceRelationType = sourcePlan.getScope().getRelationType();
            int[] fieldIndexForVisibleColumn = new int[sourceRelationType.getVisibleFieldCount()];
            int visibleColumn = 0;
            for (int i = 0; i < sourceRelationType.getAllFieldCount(); ++i) {
                if (sourceRelationType.getFieldByIndex(i).isHidden()) continue;
                fieldIndexForVisibleColumn[visibleColumn] = i;
                ++visibleColumn;
            }
            List requiredColumns = (List)functionAnalysis.getRequiredColumns().get(tableArgument.getArgumentName()).stream().map(column -> fieldIndexForVisibleColumn[column]).map(sourcePlan::getSymbol).collect(ImmutableList.toImmutableList());
            Optional<DataOrganizationSpecification> specification = Optional.empty();
            if (!tableArgument.isRowSemantics()) {
                Object partitionBy = ImmutableList.of();
                if (tableArgument.getPartitionBy().isPresent() && !tableArgument.getPartitionBy().get().isEmpty()) {
                    List<io.trino.sql.tree.Expression> partitioningColumns = tableArgument.getPartitionBy().get();
                    QueryPlanner.PlanAndMappings copartitionCoercions = QueryPlanner.coerce(sourcePlanBuilder, partitioningColumns, this.analysis, this.idAllocator, this.symbolAllocator);
                    sourcePlanBuilder = copartitionCoercions.getSubPlan();
                    partitionBy = (List)partitioningColumns.stream().map(copartitionCoercions::get).collect(ImmutableList.toImmutableList());
                }
                Optional<OrderingScheme> orderBy = Optional.empty();
                if (tableArgument.getOrderBy().isPresent()) {
                    orderBy = Optional.of(QueryPlanner.translateOrderingScheme(tableArgument.getOrderBy().get().getSortItems(), sourcePlanBuilder::translate));
                }
                specification = Optional.of(new DataOrganizationSpecification((List<Symbol>)partitionBy, orderBy));
            }
            ImmutableList.Builder passThroughColumns = ImmutableList.builder();
            if (tableArgument.isPassThroughColumns()) {
                outputSymbols.addAll(sourcePlan.getFieldMappings());
                Set partitionBy = (Set)specification.map(DataOrganizationSpecification::partitionBy).map(ImmutableSet::copyOf).orElse(ImmutableSet.of());
                sourcePlan.getFieldMappings().stream().map(symbol -> new TableFunctionNode.PassThroughColumn((Symbol)symbol, partitionBy.contains(symbol))).forEach(arg_0 -> ((ImmutableList.Builder)passThroughColumns).add(arg_0));
            } else if (tableArgument.getPartitionBy().isPresent()) {
                tableArgument.getPartitionBy().get().stream().map(sourcePlanBuilder::translate).forEach(symbol -> {
                    outputSymbols.add(symbol);
                    passThroughColumns.add((Object)new TableFunctionNode.PassThroughColumn((Symbol)symbol, true));
                });
            }
            sources.add((Object)sourcePlanBuilder.getRoot());
            sourceProperties.add((Object)new TableFunctionNode.TableArgumentProperties(tableArgument.getArgumentName(), tableArgument.isRowSemantics(), tableArgument.isPruneWhenEmpty(), new TableFunctionNode.PassThroughSpecification(tableArgument.isPassThroughColumns(), (List<TableFunctionNode.PassThroughColumn>)passThroughColumns.build()), requiredColumns, specification));
        }
        TableFunctionNode root = new TableFunctionNode(this.idAllocator.getNextId(), functionAnalysis.getFunctionName(), functionAnalysis.getCatalogHandle(), functionAnalysis.getArguments(), properOutputs, (List<PlanNode>)sources.build(), (List<TableFunctionNode.TableArgumentProperties>)sourceProperties.build(), functionAnalysis.getCopartitioningLists(), new TableFunctionHandle(functionAnalysis.getCatalogHandle(), functionAnalysis.getConnectorTableFunctionHandle(), functionAnalysis.getTransactionHandle()));
        return new RelationPlan(root, this.analysis.getScope((Node)node), (List<Symbol>)outputSymbols.build(), this.outerContext);
    }

    protected RelationPlan visitAliasedRelation(AliasedRelation node, Void context) {
        RelationPlan subPlan = (RelationPlan)this.process((Node)node.getRelation(), context);
        PlanNode root = subPlan.getRoot();
        ImmutableList mappings = subPlan.getFieldMappings();
        if (node.getColumnNames() != null) {
            ImmutableList.Builder newMappings = ImmutableList.builder();
            for (int i = 0; i < subPlan.getDescriptor().getAllFieldCount(); ++i) {
                if (subPlan.getDescriptor().getFieldByIndex(i).isHidden()) continue;
                newMappings.add((Object)subPlan.getFieldMappings().get(i));
            }
            mappings = newMappings.build();
        }
        return new RelationPlan(root, this.analysis.getScope((Node)node), (List<Symbol>)mappings, this.outerContext);
    }

    protected RelationPlan visitPatternRecognitionRelation(PatternRecognitionRelation node, Void context) {
        RelationPlan subPlan = (RelationPlan)this.process((Node)node.getInput(), context);
        ImmutableList inputs = ImmutableList.builder().addAll((Iterable)node.getPartitionBy()).addAll((Iterable)NodeUtils.getSortItemsFromOrderBy(node.getOrderBy()).stream().map(SortItem::getSortKey).collect(ImmutableList.toImmutableList())).build();
        PlanBuilder planBuilder = PlanBuilder.newPlanBuilder(subPlan, this.analysis, this.lambdaDeclarationToSymbolMap, this.session, this.plannerContext);
        planBuilder = planBuilder.appendProjections((Iterable<io.trino.sql.tree.Expression>)inputs, this.symbolAllocator, this.idAllocator);
        ImmutableList.Builder outputLayout = ImmutableList.builder();
        RowsPerMatch rowsPerMatch = this.mapRowsPerMatch(node.getRowsPerMatch().orElse(PatternRecognitionRelation.RowsPerMatch.ONE));
        boolean oneRowOutput = rowsPerMatch.isOneRow();
        DataOrganizationSpecification specification = QueryPlanner.planWindowSpecification(node.getPartitionBy(), node.getOrderBy(), planBuilder::translate);
        outputLayout.addAll(specification.partitionBy());
        if (!oneRowOutput) {
            NodeUtils.getSortItemsFromOrderBy(node.getOrderBy()).stream().map(SortItem::getSortKey).map(planBuilder::translate).forEach(arg_0 -> ((ImmutableList.Builder)outputLayout).add(arg_0));
        }
        planBuilder = this.subqueryPlanner.handleSubqueries(planBuilder, QueryPlanner.extractPatternRecognitionExpressions(node.getVariableDefinitions(), node.getMeasures()), this.analysis.getSubqueries((Node)node));
        PatternRecognitionComponents components = this.planPatternRecognitionComponents(planBuilder.getTranslations(), node.getSubsets(), node.getMeasures(), node.getAfterMatchSkipTo(), node.getPatternSearchMode(), node.getPattern(), node.getVariableDefinitions());
        outputLayout.addAll(components.getMeasureOutputs());
        if (!oneRowOutput) {
            ImmutableSet inputSymbolsOnOutput = ImmutableSet.copyOf((Collection)outputLayout.build());
            subPlan.getFieldMappings().stream().filter(arg_0 -> RelationPlanner.lambda$visitPatternRecognitionRelation$3((Set)inputSymbolsOnOutput, arg_0)).forEach(arg_0 -> ((ImmutableList.Builder)outputLayout).add(arg_0));
        }
        PatternRecognitionNode planNode = new PatternRecognitionNode(this.idAllocator.getNextId(), planBuilder.getRoot(), specification, Optional.empty(), (Set<Symbol>)ImmutableSet.of(), 0, (Map<Symbol, WindowNode.Function>)ImmutableMap.of(), components.getMeasures(), Optional.empty(), rowsPerMatch, components.getSkipToLabels(), components.getSkipToPosition(), components.isInitial(), components.getPattern(), components.getVariableDefinitions());
        return new RelationPlan(planNode, this.analysis.getScope((Node)node), (List<Symbol>)outputLayout.build(), this.outerContext);
    }

    private RowsPerMatch mapRowsPerMatch(PatternRecognitionRelation.RowsPerMatch rowsPerMatch) {
        return switch (rowsPerMatch) {
            default -> throw new MatchException(null, null);
            case PatternRecognitionRelation.RowsPerMatch.ONE -> RowsPerMatch.ONE;
            case PatternRecognitionRelation.RowsPerMatch.ALL_SHOW_EMPTY -> RowsPerMatch.ALL_SHOW_EMPTY;
            case PatternRecognitionRelation.RowsPerMatch.ALL_OMIT_EMPTY -> RowsPerMatch.ALL_OMIT_EMPTY;
            case PatternRecognitionRelation.RowsPerMatch.ALL_WITH_UNMATCHED -> RowsPerMatch.ALL_WITH_UNMATCHED;
            case PatternRecognitionRelation.RowsPerMatch.WINDOW -> RowsPerMatch.WINDOW;
        };
    }

    public PatternRecognitionComponents planPatternRecognitionComponents(TranslationMap translations, List<SubsetDefinition> subsets, List<MeasureDefinition> measures, Optional<SkipTo> skipTo, Optional<PatternSearchMode> searchMode, RowPattern pattern, List<VariableDefinition> variableDefinitions) {
        ImmutableMap.Builder rewrittenSubsetsBuilder = ImmutableMap.builder();
        for (SubsetDefinition subsetDefinition : subsets) {
            String label = this.analysis.getResolvedLabel(subsetDefinition.getName());
            Set elements = (Set)this.analysis.getLabels(subsetDefinition).stream().map(IrLabel::new).collect(ImmutableSet.toImmutableSet());
            rewrittenSubsetsBuilder.put((Object)new IrLabel(label), (Object)elements);
        }
        ImmutableMap rewrittenSubsets = rewrittenSubsetsBuilder.buildOrThrow();
        ImmutableMap.Builder rewrittenMeasures = ImmutableMap.builder();
        ImmutableList.Builder measureOutputs = ImmutableList.builder();
        for (MeasureDefinition measureDefinition : measures) {
            Type type = this.analysis.getType(measureDefinition.getExpression());
            Symbol symbol = this.symbolAllocator.newSymbol(measureDefinition.getName().getValue(), type);
            ExpressionAndValuePointers measure = this.planPatternRecognitionExpression(translations, (Map<IrLabel, Set<IrLabel>>)rewrittenSubsets, measureDefinition.getName().getValue(), measureDefinition.getExpression());
            rewrittenMeasures.put((Object)symbol, (Object)new PatternRecognitionNode.Measure(measure, type));
            measureOutputs.add((Object)symbol);
        }
        ImmutableMap.Builder rewrittenVariableDefinitions = ImmutableMap.builder();
        for (VariableDefinition definition : variableDefinitions) {
            String label = this.analysis.getResolvedLabel(definition.getName());
            ExpressionAndValuePointers variable = this.planPatternRecognitionExpression(translations, (Map<IrLabel, Set<IrLabel>>)rewrittenSubsets, definition.getName().getValue(), definition.getExpression());
            rewrittenVariableDefinitions.put((Object)new IrLabel(label), (Object)variable);
        }
        for (String label : this.analysis.getUndefinedLabels(pattern)) {
            rewrittenVariableDefinitions.put((Object)RelationPlanner.irLabel(label), (Object)ExpressionAndValuePointers.TRUE);
        }
        Set set = skipTo.flatMap(SkipTo::getIdentifier).map(Identifier::getValue).map(arg_0 -> RelationPlanner.lambda$planPatternRecognitionComponents$4((Map)rewrittenSubsets, arg_0)).orElse((Set)ImmutableSet.of());
        return new PatternRecognitionComponents((Map<Symbol, PatternRecognitionNode.Measure>)rewrittenMeasures.buildOrThrow(), (List<Symbol>)measureOutputs.build(), set, this.mapSkipToPosition(skipTo.map(SkipTo::getPosition).orElse(SkipTo.Position.PAST_LAST)), searchMode.map(mode -> mode.getMode() == PatternSearchMode.Mode.INITIAL).orElse(Boolean.TRUE), RowPatternToIrRewriter.rewrite(pattern, this.analysis), (Map<IrLabel, ExpressionAndValuePointers>)rewrittenVariableDefinitions.buildOrThrow());
    }

    private ExpressionAndValuePointers planPatternRecognitionExpression(TranslationMap translations, Map<IrLabel, Set<IrLabel>> subsets, String name, io.trino.sql.tree.Expression expression) {
        HashMap<NodeRef<io.trino.sql.tree.Expression>, Symbol> patternVariableTranslations = new HashMap<NodeRef<io.trino.sql.tree.Expression>, Symbol>();
        ImmutableList.Builder assignments = ImmutableList.builder();
        for (PatternRecognitionAnalysis.PatternInputAnalysis accessor : this.analysis.getPatternInputsAnalysis(expression)) {
            PatternRecognitionAnalysis.Descriptor descriptor;
            Objects.requireNonNull(accessor.descriptor());
            int n = 0;
            ValuePointer pointer = switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{PatternRecognitionAnalysis.MatchNumberDescriptor.class, PatternRecognitionAnalysis.ClassifierDescriptor.class, PatternRecognitionAnalysis.ScalarInputDescriptor.class, PatternRecognitionAnalysis.AggregationDescriptor.class}, (Object)descriptor, n)) {
                default -> throw new MatchException(null, null);
                case 0 -> {
                    PatternRecognitionAnalysis.MatchNumberDescriptor descriptor = (PatternRecognitionAnalysis.MatchNumberDescriptor)descriptor;
                    yield new MatchNumberValuePointer();
                }
                case 1 -> {
                    PatternRecognitionAnalysis.ClassifierDescriptor descriptor = (PatternRecognitionAnalysis.ClassifierDescriptor)descriptor;
                    yield new ClassifierValuePointer(this.planValuePointer(descriptor.label(), descriptor.navigation(), subsets));
                }
                case 2 -> {
                    PatternRecognitionAnalysis.ScalarInputDescriptor descriptor = (PatternRecognitionAnalysis.ScalarInputDescriptor)descriptor;
                    yield new ScalarValuePointer(this.planValuePointer(descriptor.label(), descriptor.navigation(), subsets), Symbol.from(translations.rewrite(accessor.expression())));
                }
                case 3 -> {
                    PatternRecognitionAnalysis.AggregationDescriptor descriptor = (PatternRecognitionAnalysis.AggregationDescriptor)descriptor;
                    HashMap<NodeRef<io.trino.sql.tree.Expression>, Symbol> mappings = new HashMap<NodeRef<io.trino.sql.tree.Expression>, Symbol>();
                    Optional<Symbol> matchNumberSymbol = Optional.empty();
                    if (!descriptor.matchNumberCalls().isEmpty()) {
                        Symbol symbol = this.symbolAllocator.newSymbol("match_number", (Type)BigintType.BIGINT);
                        for (io.trino.sql.tree.Expression var20_22 : descriptor.matchNumberCalls()) {
                            mappings.put((NodeRef<io.trino.sql.tree.Expression>)NodeRef.of((Node)var20_22), symbol);
                        }
                        matchNumberSymbol = Optional.of(symbol);
                    }
                    Optional<Symbol> classifierSymbol = Optional.empty();
                    if (!descriptor.classifierCalls().isEmpty()) {
                        Symbol symbol = this.symbolAllocator.newSymbol("classifier", (Type)VarcharType.VARCHAR);
                        for (io.trino.sql.tree.Expression call : descriptor.classifierCalls()) {
                            mappings.put((NodeRef<io.trino.sql.tree.Expression>)NodeRef.of((Node)call), symbol);
                        }
                        classifierSymbol = Optional.of(symbol);
                    }
                    TranslationMap argumentTranslation = translations.withAdditionalIdentityMappings(mappings);
                    Set<IrLabel> var20_20 = descriptor.labels().stream().flatMap(label -> this.planLabels(Optional.of(label), subsets).stream()).collect(Collectors.toSet());
                    yield new AggregationValuePointer(descriptor.function(), new AggregatedSetDescriptor(var20_20, descriptor.mode() == PatternRecognitionAnalysis.NavigationMode.RUNNING), descriptor.arguments().stream().filter(argument -> !DereferenceExpression.isQualifiedAllFieldsReference((io.trino.sql.tree.Expression)argument)).map(argument -> QueryPlanner.coerceIfNecessary(this.analysis, argument, argumentTranslation.rewrite((io.trino.sql.tree.Expression)argument))).toList(), classifierSymbol, matchNumberSymbol);
                }
            };
            Symbol symbol = this.symbolAllocator.newSymbol(name, this.analysis.getType(accessor.expression()));
            assignments.add((Object)new ExpressionAndValuePointers.Assignment(symbol, pointer));
            patternVariableTranslations.put((NodeRef<io.trino.sql.tree.Expression>)NodeRef.of((Node)accessor.expression()), symbol);
        }
        Expression rewritten = translations.withAdditionalIdentityMappings(patternVariableTranslations).rewrite(expression);
        return new ExpressionAndValuePointers(rewritten, (List<ExpressionAndValuePointers.Assignment>)assignments.build());
    }

    private Set<IrLabel> planLabels(Optional<String> label, Map<IrLabel, Set<IrLabel>> subsets) {
        return label.map(IrLabel::new).map(value -> (Set)subsets.getOrDefault(value, (Set<IrLabel>)ImmutableSet.of((Object)value))).orElse((Set)ImmutableSet.of());
    }

    private LogicalIndexPointer planValuePointer(Optional<String> label, PatternRecognitionAnalysis.Navigation navigation, Map<IrLabel, Set<IrLabel>> subsets) {
        return new LogicalIndexPointer(this.planLabels(label, subsets), navigation.anchor() == PatternRecognitionAnalysis.NavigationAnchor.LAST, navigation.mode() == PatternRecognitionAnalysis.NavigationMode.RUNNING, navigation.logicalOffset(), navigation.physicalOffset());
    }

    private SkipToPosition mapSkipToPosition(SkipTo.Position position) {
        return switch (position) {
            default -> throw new MatchException(null, null);
            case SkipTo.Position.NEXT -> SkipToPosition.NEXT;
            case SkipTo.Position.PAST_LAST -> SkipToPosition.PAST_LAST;
            case SkipTo.Position.FIRST -> SkipToPosition.FIRST;
            case SkipTo.Position.LAST -> SkipToPosition.LAST;
        };
    }

    private static IrLabel irLabel(String label) {
        return new IrLabel(label);
    }

    protected RelationPlan visitSampledRelation(SampledRelation node, Void context) {
        RelationPlan subPlan = (RelationPlan)this.process((Node)node.getRelation(), context);
        double ratio = this.analysis.getSampleRatio(node);
        SampleNode planNode = new SampleNode(this.idAllocator.getNextId(), subPlan.getRoot(), ratio, RelationPlanner.mapSampleType(node.getType()));
        return new RelationPlan(planNode, this.analysis.getScope((Node)node), subPlan.getFieldMappings(), this.outerContext);
    }

    protected RelationPlan visitLateral(Lateral node, Void context) {
        RelationPlan plan = (RelationPlan)this.process((Node)node.getQuery(), context);
        return new RelationPlan(plan.getRoot(), this.analysis.getScope((Node)node), plan.getFieldMappings(), this.outerContext);
    }

    protected RelationPlan visitJoin(Join node, Void context) {
        RelationPlan leftPlan = (RelationPlan)this.process((Node)node.getLeft(), context);
        Optional<Unnest> unnest = RelationPlanner.getUnnest(node.getRight());
        if (unnest.isPresent()) {
            return this.planJoinUnnest(leftPlan, node, unnest.get());
        }
        Optional<JsonTable> jsonTable = RelationPlanner.getJsonTable(node.getRight());
        if (jsonTable.isPresent()) {
            return this.planJoinJsonTable(PlanBuilder.newPlanBuilder(leftPlan, this.analysis, this.lambdaDeclarationToSymbolMap, this.session, this.plannerContext), leftPlan.getFieldMappings(), node.getType(), jsonTable.get(), this.analysis.getScope((Node)node));
        }
        Optional<Lateral> lateral = RelationPlanner.getLateral(node.getRight());
        if (lateral.isPresent()) {
            return this.planCorrelatedJoin(node, leftPlan, lateral.get());
        }
        RelationPlan rightPlan = (RelationPlan)this.process((Node)node.getRight(), context);
        if (node.getCriteria().isPresent() && node.getCriteria().get() instanceof JoinUsing) {
            return this.planJoinUsing(node, leftPlan, rightPlan);
        }
        return this.planJoin(this.analysis.getJoinCriteria(node), node.getType(), this.analysis.getScope((Node)node), leftPlan, rightPlan, this.analysis.getSubqueries((Node)node));
    }

    public RelationPlan planJoin(io.trino.sql.tree.Expression criteria, Join.Type type, Scope scope, RelationPlan leftPlan, RelationPlan rightPlan, Analysis.SubqueryAnalysis subqueries) {
        RelationType left;
        ArrayList<Expression> postInnerJoinConditions;
        ArrayList<io.trino.sql.tree.Expression> complexJoinExpressions;
        ImmutableList.Builder equiClauses;
        PlanBuilder rightPlanBuilder;
        PlanBuilder leftPlanBuilder;
        ImmutableList outputSymbols;
        block19: {
            outputSymbols = ImmutableList.builder().addAll(leftPlan.getFieldMappings()).addAll(rightPlan.getFieldMappings()).build();
            leftPlanBuilder = PlanBuilder.newPlanBuilder(leftPlan, this.analysis, this.lambdaDeclarationToSymbolMap, this.session, this.plannerContext).withScope(scope, (List<Symbol>)outputSymbols);
            rightPlanBuilder = PlanBuilder.newPlanBuilder(rightPlan, this.analysis, this.lambdaDeclarationToSymbolMap, this.session, this.plannerContext).withScope(scope, (List<Symbol>)outputSymbols);
            equiClauses = ImmutableList.builder();
            complexJoinExpressions = new ArrayList<io.trino.sql.tree.Expression>();
            postInnerJoinConditions = new ArrayList<Expression>();
            left = leftPlan.getDescriptor();
            RelationType right = rightPlan.getDescriptor();
            if (type == Join.Type.CROSS || type == Join.Type.IMPLICIT) break block19;
            ArrayList<io.trino.sql.tree.Expression> leftComparisonExpressions = new ArrayList<io.trino.sql.tree.Expression>();
            ArrayList<io.trino.sql.tree.Expression> rightComparisonExpressions = new ArrayList<io.trino.sql.tree.Expression>();
            ArrayList<ComparisonExpression.Operator> joinConditionComparisonOperators = new ArrayList<ComparisonExpression.Operator>();
            for (io.trino.sql.tree.Expression conjunct : AstUtils.extractConjuncts((io.trino.sql.tree.Expression)criteria)) {
                block21: {
                    block20: {
                        if (!RelationPlanner.isEqualComparisonExpression(conjunct) && type != Join.Type.INNER) {
                            complexJoinExpressions.add(conjunct);
                            continue;
                        }
                        Set<QualifiedName> dependencies = NamesExtractor.extractNames(conjunct, this.analysis.getColumnReferences());
                        if (dependencies.stream().allMatch(left::canResolve)) break block20;
                        if (!dependencies.stream().allMatch(right::canResolve)) break block21;
                    }
                    complexJoinExpressions.add(conjunct);
                    continue;
                }
                if (conjunct instanceof ComparisonExpression) {
                    io.trino.sql.tree.Expression firstExpression = ((ComparisonExpression)conjunct).getLeft();
                    io.trino.sql.tree.Expression secondExpression = ((ComparisonExpression)conjunct).getRight();
                    ComparisonExpression.Operator comparisonOperator = ((ComparisonExpression)conjunct).getOperator();
                    Set<QualifiedName> firstDependencies = NamesExtractor.extractNames(firstExpression, this.analysis.getColumnReferences());
                    Set<QualifiedName> secondDependencies = NamesExtractor.extractNames(secondExpression, this.analysis.getColumnReferences());
                    if (firstDependencies.stream().allMatch(left::canResolve)) {
                        if (secondDependencies.stream().allMatch(right::canResolve)) {
                            leftComparisonExpressions.add(firstExpression);
                            rightComparisonExpressions.add(secondExpression);
                            joinConditionComparisonOperators.add(comparisonOperator);
                            continue;
                        }
                    }
                    if (firstDependencies.stream().allMatch(right::canResolve)) {
                        if (secondDependencies.stream().allMatch(left::canResolve)) {
                            leftComparisonExpressions.add(secondExpression);
                            rightComparisonExpressions.add(firstExpression);
                            joinConditionComparisonOperators.add(comparisonOperator.flip());
                            continue;
                        }
                    }
                    complexJoinExpressions.add(conjunct);
                    continue;
                }
                complexJoinExpressions.add(conjunct);
            }
            leftPlanBuilder = this.subqueryPlanner.handleSubqueries(leftPlanBuilder, leftComparisonExpressions, subqueries);
            rightPlanBuilder = this.subqueryPlanner.handleSubqueries(rightPlanBuilder, rightComparisonExpressions, subqueries);
            leftPlanBuilder = leftPlanBuilder.appendProjections(leftComparisonExpressions, this.symbolAllocator, this.idAllocator);
            rightPlanBuilder = rightPlanBuilder.appendProjections((Iterable<io.trino.sql.tree.Expression>)rightComparisonExpressions, this.symbolAllocator, this.idAllocator);
            QueryPlanner.PlanAndMappings leftCoercions = QueryPlanner.coerce(leftPlanBuilder, leftComparisonExpressions, this.analysis, this.idAllocator, this.symbolAllocator);
            leftPlanBuilder = leftCoercions.getSubPlan();
            QueryPlanner.PlanAndMappings rightCoercions = QueryPlanner.coerce(rightPlanBuilder, (List<io.trino.sql.tree.Expression>)rightComparisonExpressions, this.analysis, this.idAllocator, this.symbolAllocator);
            rightPlanBuilder = rightCoercions.getSubPlan();
            for (int i = 0; i < leftComparisonExpressions.size(); ++i) {
                if (joinConditionComparisonOperators.get(i) == ComparisonExpression.Operator.EQUAL) {
                    Symbol leftSymbol = leftCoercions.get((io.trino.sql.tree.Expression)leftComparisonExpressions.get(i));
                    Symbol rightSymbol = rightCoercions.get((io.trino.sql.tree.Expression)rightComparisonExpressions.get(i));
                    equiClauses.add((Object)new JoinNode.EquiJoinClause(leftSymbol, rightSymbol));
                    continue;
                }
                postInnerJoinConditions.add(RelationPlanner.translateComparison((ComparisonExpression.Operator)joinConditionComparisonOperators.get(i), leftCoercions.get((io.trino.sql.tree.Expression)leftComparisonExpressions.get(i)), rightCoercions.get((io.trino.sql.tree.Expression)rightComparisonExpressions.get(i))));
            }
        }
        PlanNode root = new JoinNode(this.idAllocator.getNextId(), RelationPlanner.mapJoinType(type), leftPlanBuilder.getRoot(), rightPlanBuilder.getRoot(), (List<JoinNode.EquiJoinClause>)equiClauses.build(), leftPlanBuilder.getRoot().getOutputSymbols(), rightPlanBuilder.getRoot().getOutputSymbols(), false, Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), (Map<DynamicFilterId, Symbol>)ImmutableMap.of(), Optional.empty());
        if (type != Join.Type.INNER) {
            for (io.trino.sql.tree.Expression complexExpression : complexJoinExpressions) {
                Set<QualifiedName> dependencies = NamesExtractor.extractNamesNoSubqueries(complexExpression, this.analysis.getColumnReferences());
                if (dependencies.stream().allMatch(left::canResolve)) {
                    leftPlanBuilder = this.subqueryPlanner.handleSubqueries(leftPlanBuilder, complexExpression, subqueries);
                    continue;
                }
                rightPlanBuilder = this.subqueryPlanner.handleSubqueries(rightPlanBuilder, complexExpression, subqueries);
            }
        }
        TranslationMap translationMap = new TranslationMap(this.outerContext, scope, this.analysis, this.lambdaDeclarationToSymbolMap, (List<Symbol>)outputSymbols, this.session, this.plannerContext).withAdditionalMappings(leftPlanBuilder.getTranslations().getMappings()).withAdditionalMappings(rightPlanBuilder.getTranslations().getMappings());
        if (type != Join.Type.INNER && !complexJoinExpressions.isEmpty()) {
            root = new JoinNode(this.idAllocator.getNextId(), RelationPlanner.mapJoinType(type), leftPlanBuilder.getRoot(), rightPlanBuilder.getRoot(), (List<JoinNode.EquiJoinClause>)equiClauses.build(), leftPlanBuilder.getRoot().getOutputSymbols(), rightPlanBuilder.getRoot().getOutputSymbols(), false, Optional.of(IrUtils.and(complexJoinExpressions.stream().map(e -> QueryPlanner.coerceIfNecessary(this.analysis, e, translationMap.rewrite((io.trino.sql.tree.Expression)e))).collect(Collectors.toList()))), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), (Map<DynamicFilterId, Symbol>)ImmutableMap.of(), Optional.empty());
        }
        if (type == Join.Type.INNER) {
            PlanBuilder rootPlanBuilder = new PlanBuilder(translationMap, root);
            rootPlanBuilder = this.subqueryPlanner.handleSubqueries(rootPlanBuilder, complexJoinExpressions, subqueries);
            for (io.trino.sql.tree.Expression expression : complexJoinExpressions) {
                postInnerJoinConditions.add(QueryPlanner.coerceIfNecessary(this.analysis, expression, rootPlanBuilder.rewrite(expression)));
            }
            root = rootPlanBuilder.getRoot();
            if (!postInnerJoinConditions.isEmpty()) {
                Expression postInnerJoinCriteria = IrUtils.and(postInnerJoinConditions);
                root = new FilterNode(this.idAllocator.getNextId(), root, postInnerJoinCriteria);
            }
        }
        return new RelationPlan(root, scope, (List<Symbol>)outputSymbols, this.outerContext);
    }

    private static Expression translateComparison(ComparisonExpression.Operator operator, Symbol left, Symbol right) {
        return switch (operator) {
            default -> throw new MatchException(null, null);
            case ComparisonExpression.Operator.EQUAL -> new Comparison(Comparison.Operator.EQUAL, left.toSymbolReference(), right.toSymbolReference());
            case ComparisonExpression.Operator.NOT_EQUAL -> new Comparison(Comparison.Operator.NOT_EQUAL, left.toSymbolReference(), right.toSymbolReference());
            case ComparisonExpression.Operator.LESS_THAN -> new Comparison(Comparison.Operator.LESS_THAN, left.toSymbolReference(), right.toSymbolReference());
            case ComparisonExpression.Operator.LESS_THAN_OR_EQUAL -> new Comparison(Comparison.Operator.LESS_THAN_OR_EQUAL, left.toSymbolReference(), right.toSymbolReference());
            case ComparisonExpression.Operator.GREATER_THAN -> new Comparison(Comparison.Operator.GREATER_THAN, left.toSymbolReference(), right.toSymbolReference());
            case ComparisonExpression.Operator.GREATER_THAN_OR_EQUAL -> new Comparison(Comparison.Operator.GREATER_THAN_OR_EQUAL, left.toSymbolReference(), right.toSymbolReference());
            case ComparisonExpression.Operator.IS_DISTINCT_FROM -> new Not(new Comparison(Comparison.Operator.IDENTICAL, left.toSymbolReference(), right.toSymbolReference()));
        };
    }

    private RelationPlan planJoinUsing(Join node, RelationPlan left, RelationPlan right) {
        Symbol symbol;
        List joinColumns = ((JoinUsing)node.getCriteria().orElseThrow()).getColumns();
        Analysis.JoinUsingAnalysis joinAnalysis = this.analysis.getJoinUsing(node);
        ImmutableList.Builder clauses = ImmutableList.builder();
        HashMap<Identifier, Symbol> leftJoinColumns = new HashMap<Identifier, Symbol>();
        HashMap<Identifier, Symbol> rightJoinColumns = new HashMap<Identifier, Symbol>();
        Assignments.Builder leftCoercions = Assignments.builder();
        Assignments.Builder rightCoercions = Assignments.builder();
        leftCoercions.putIdentities(left.getRoot().getOutputSymbols());
        rightCoercions.putIdentities(right.getRoot().getOutputSymbols());
        for (int i = 0; i < joinColumns.size(); ++i) {
            Identifier identifier = (Identifier)joinColumns.get(i);
            Type type = this.analysis.getType((io.trino.sql.tree.Expression)identifier);
            Symbol leftOutput = this.symbolAllocator.newSymbol(identifier.getValue(), type);
            int leftField = joinAnalysis.getLeftJoinFields().get(i);
            leftCoercions.put(leftOutput, new Cast(left.getSymbol(leftField).toSymbolReference(), type));
            leftJoinColumns.put(identifier, leftOutput);
            Symbol rightOutput = this.symbolAllocator.newSymbol(identifier.getValue(), type);
            int rightField = joinAnalysis.getRightJoinFields().get(i);
            rightCoercions.put(rightOutput, new Cast(right.getSymbol(rightField).toSymbolReference(), type));
            rightJoinColumns.put(identifier, rightOutput);
            clauses.add((Object)new JoinNode.EquiJoinClause(leftOutput, rightOutput));
        }
        ProjectNode leftCoercion = new ProjectNode(this.idAllocator.getNextId(), left.getRoot(), leftCoercions.build());
        ProjectNode rightCoercion = new ProjectNode(this.idAllocator.getNextId(), right.getRoot(), rightCoercions.build());
        JoinNode join = new JoinNode(this.idAllocator.getNextId(), RelationPlanner.mapJoinType(node.getType()), leftCoercion, rightCoercion, (List<JoinNode.EquiJoinClause>)clauses.build(), leftCoercion.getOutputSymbols(), rightCoercion.getOutputSymbols(), false, Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), (Map<DynamicFilterId, Symbol>)ImmutableMap.of(), Optional.empty());
        Assignments.Builder assignments = Assignments.builder();
        ImmutableList.Builder outputs = ImmutableList.builder();
        for (Identifier column : joinColumns) {
            Symbol output = this.symbolAllocator.newSymbol(column.getValue(), this.analysis.getType((io.trino.sql.tree.Expression)column));
            outputs.add((Object)output);
            assignments.put(output, new Coalesce(((Symbol)leftJoinColumns.get(column)).toSymbolReference(), ((Symbol)rightJoinColumns.get(column)).toSymbolReference(), new Expression[0]));
        }
        Iterator<Object> iterator = joinAnalysis.getOtherLeftFields().iterator();
        while (iterator.hasNext()) {
            int field = (Integer)iterator.next();
            symbol = left.getFieldMappings().get(field);
            outputs.add((Object)symbol);
            assignments.putIdentity(symbol);
        }
        iterator = joinAnalysis.getOtherRightFields().iterator();
        while (iterator.hasNext()) {
            int field = (Integer)iterator.next();
            symbol = right.getFieldMappings().get(field);
            outputs.add((Object)symbol);
            assignments.putIdentity(symbol);
        }
        return new RelationPlan(new ProjectNode(this.idAllocator.getNextId(), join, assignments.build()), this.analysis.getScope((Node)node), (List<Symbol>)outputs.build(), this.outerContext);
    }

    private static Optional<Unnest> getUnnest(Relation relation) {
        if (relation instanceof AliasedRelation) {
            return RelationPlanner.getUnnest(((AliasedRelation)relation).getRelation());
        }
        if (relation instanceof Unnest) {
            return Optional.of((Unnest)relation);
        }
        return Optional.empty();
    }

    private static Optional<JsonTable> getJsonTable(Relation relation) {
        if (relation instanceof AliasedRelation) {
            return RelationPlanner.getJsonTable(((AliasedRelation)relation).getRelation());
        }
        if (relation instanceof JsonTable) {
            return Optional.of((JsonTable)relation);
        }
        return Optional.empty();
    }

    private static Optional<Lateral> getLateral(Relation relation) {
        if (relation instanceof AliasedRelation) {
            return RelationPlanner.getLateral(((AliasedRelation)relation).getRelation());
        }
        if (relation instanceof Lateral) {
            return Optional.of((Lateral)relation);
        }
        return Optional.empty();
    }

    private RelationPlan planCorrelatedJoin(Join join, RelationPlan leftPlan, Lateral lateral) {
        Expression rewrittenFilterCondition;
        PlanBuilder leftPlanBuilder = PlanBuilder.newPlanBuilder(leftPlan, this.analysis, this.lambdaDeclarationToSymbolMap, this.session, this.plannerContext);
        RelationPlan rightPlan = (RelationPlan)new RelationPlanner(this.analysis, this.symbolAllocator, this.idAllocator, this.lambdaDeclarationToSymbolMap, this.plannerContext, Optional.of(leftPlanBuilder.getTranslations()), this.session, this.recursiveSubqueries).process((Node)lateral.getQuery(), null);
        PlanBuilder rightPlanBuilder = PlanBuilder.newPlanBuilder(rightPlan, this.analysis, this.lambdaDeclarationToSymbolMap, this.session, this.plannerContext);
        ImmutableList outputSymbols = ImmutableList.builder().addAll(leftPlan.getFieldMappings()).addAll(rightPlan.getFieldMappings()).build();
        TranslationMap translationMap = new TranslationMap(this.outerContext, this.analysis.getScope((Node)join), this.analysis, this.lambdaDeclarationToSymbolMap, (List<Symbol>)outputSymbols, this.session, this.plannerContext).withAdditionalMappings(leftPlanBuilder.getTranslations().getMappings()).withAdditionalMappings(rightPlanBuilder.getTranslations().getMappings());
        if (join.getCriteria().isEmpty()) {
            rewrittenFilterCondition = Booleans.TRUE;
        } else {
            JoinCriteria criteria = (JoinCriteria)join.getCriteria().get();
            if (criteria instanceof JoinUsing || criteria instanceof NaturalJoin) {
                throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, (Node)join, "Correlated join with criteria other than ON is not supported", new Object[0]);
            }
            io.trino.sql.tree.Expression filterExpression = (io.trino.sql.tree.Expression)Iterables.getOnlyElement((Iterable)criteria.getNodes());
            rewrittenFilterCondition = QueryPlanner.coerceIfNecessary(this.analysis, filterExpression, translationMap.rewrite(filterExpression));
        }
        PlanBuilder planBuilder = this.subqueryPlanner.appendCorrelatedJoin(leftPlanBuilder, rightPlanBuilder.getRoot(), lateral.getQuery(), RelationPlanner.mapJoinType(join.getType()), rewrittenFilterCondition, (Map<ScopeAware<io.trino.sql.tree.Expression>, Symbol>)ImmutableMap.of());
        return new RelationPlan(planBuilder.getRoot(), this.analysis.getScope((Node)join), (List<Symbol>)outputSymbols, this.outerContext);
    }

    private static boolean isEqualComparisonExpression(io.trino.sql.tree.Expression conjunct) {
        ComparisonExpression comparison;
        return conjunct instanceof ComparisonExpression && (comparison = (ComparisonExpression)conjunct).getOperator() == ComparisonExpression.Operator.EQUAL;
    }

    private RelationPlan planJoinUnnest(RelationPlan leftPlan, Join joinNode, Unnest node) {
        if (joinNode.getCriteria().isPresent()) {
            JoinCriteria criteria = (JoinCriteria)joinNode.getCriteria().get();
            if (criteria instanceof NaturalJoin) {
                throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, (Node)joinNode, "Natural join involving UNNEST is not supported", new Object[0]);
            }
            if (criteria instanceof JoinUsing) {
                throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, (Node)joinNode, "USING for join involving UNNEST is not supported", new Object[0]);
            }
            io.trino.sql.tree.Expression filter = (io.trino.sql.tree.Expression)Iterables.getOnlyElement((Iterable)criteria.getNodes());
            if (!filter.equals((Object)BooleanLiteral.TRUE_LITERAL)) {
                throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, (Node)joinNode, "JOIN involving UNNEST on condition other than TRUE is not supported", new Object[0]);
            }
        }
        return this.planUnnest(PlanBuilder.newPlanBuilder(leftPlan, this.analysis, this.lambdaDeclarationToSymbolMap, this.session, this.plannerContext), node, leftPlan.getFieldMappings(), joinNode.getType(), this.analysis.getScope((Node)joinNode));
    }

    private RelationPlan planUnnest(PlanBuilder subPlan, Unnest node, List<Symbol> replicatedColumns, Join.Type type, Scope outputScope) {
        subPlan = this.subqueryPlanner.handleSubqueries(subPlan, node.getExpressions(), this.analysis.getSubqueries((Node)node));
        subPlan = subPlan.appendProjections(node.getExpressions(), this.symbolAllocator, this.idAllocator);
        Map allocations = (Map)this.analysis.getOutputDescriptor((Node)node).getVisibleFields().stream().collect(ImmutableMap.toImmutableMap(Function.identity(), this.symbolAllocator::newSymbol));
        Analysis.UnnestAnalysis unnestAnalysis = this.analysis.getUnnest(node);
        ImmutableList.Builder mappings = ImmutableList.builder();
        for (io.trino.sql.tree.Expression expression : node.getExpressions()) {
            Symbol input = subPlan.translate(expression);
            List outputs = (List)unnestAnalysis.getMappings().get(NodeRef.of((Node)expression)).stream().map(allocations::get).collect(ImmutableList.toImmutableList());
            mappings.add((Object)new UnnestNode.Mapping(input, outputs));
        }
        UnnestNode unnestNode = new UnnestNode(this.idAllocator.getNextId(), subPlan.getRoot(), replicatedColumns, (List<UnnestNode.Mapping>)mappings.build(), unnestAnalysis.getOrdinalityField().map(allocations::get), RelationPlanner.mapJoinType(type));
        return new RelationPlan(unnestNode, outputScope, unnestNode.getOutputSymbols(), this.outerContext);
    }

    private RelationPlan planJoinJsonTable(PlanBuilder leftPlan, List<Symbol> leftFieldMappings, Join.Type joinType, JsonTable jsonTable, Scope outputScope) {
        JsonTablePlanNode executionPlan;
        PlanBuilder planBuilder = leftPlan;
        ImmutableList.Builder builder = ImmutableList.builder();
        io.trino.sql.tree.Expression inputExpression = jsonTable.getJsonPathInvocation().getInputExpression();
        builder.add((Object)inputExpression);
        List pathParameters = jsonTable.getJsonPathInvocation().getPathParameters();
        pathParameters.stream().map(JsonPathParameter::getParameter).forEach(arg_0 -> ((ImmutableList.Builder)builder).add(arg_0));
        List<io.trino.sql.tree.Expression> defaultExpressions = RelationPlanner.getDefaultExpressions(jsonTable.getColumns());
        builder.addAll(defaultExpressions);
        ImmutableList inputExpressions = builder.build();
        planBuilder = this.subqueryPlanner.handleSubqueries(planBuilder, (Collection<io.trino.sql.tree.Expression>)inputExpressions, this.analysis.getSubqueries((Node)jsonTable));
        planBuilder = planBuilder.appendProjections((Iterable<io.trino.sql.tree.Expression>)inputExpressions, this.symbolAllocator, this.idAllocator);
        QueryPlanner.PlanAndMappings coerced = QueryPlanner.coerce(planBuilder, (List<io.trino.sql.tree.Expression>)inputExpressions, this.analysis, this.idAllocator, this.symbolAllocator);
        planBuilder = coerced.getSubPlan();
        Constant failOnError = new Constant((Type)BooleanType.BOOLEAN, jsonTable.getErrorBehavior().orElse(JsonTable.ErrorBehavior.EMPTY) == JsonTable.ErrorBehavior.ERROR);
        ResolvedFunction inputToJson = this.analysis.getJsonInputFunction(inputExpression);
        Call inputJson = new Call(inputToJson, (List<Expression>)ImmutableList.of((Object)coerced.get(inputExpression).toSymbolReference(), (Object)failOnError));
        List coercedParameters = (List)pathParameters.stream().map(parameter -> coerced.get(parameter.getParameter()).toSymbolReference()).collect(ImmutableList.toImmutableList());
        Analysis.JsonTableAnalysis jsonTableAnalysis = this.analysis.getJsonTableAnalysis(jsonTable);
        RowType parametersType = jsonTableAnalysis.parametersType();
        TranslationMap.ParametersRow orderedParameters = planBuilder.getTranslations().getParametersRow(pathParameters, coercedParameters, (Type)parametersType, failOnError);
        Expression parametersRow = orderedParameters.getParametersRow();
        Symbol inputJsonSymbol = this.symbolAllocator.newSymbol("inputJson", (Type)Json2016Type.JSON_2016);
        Symbol parametersRowSymbol = this.symbolAllocator.newSymbol("parametersRow", (Type)parametersType);
        ProjectNode appended = new ProjectNode(this.idAllocator.getNextId(), planBuilder.getRoot(), Assignments.builder().putIdentities(planBuilder.getRoot().getOutputSymbols()).put(inputJsonSymbol, inputJson).put(parametersRowSymbol, parametersRow).build());
        planBuilder = planBuilder.withNewRoot(appended);
        ImmutableList.Builder requiredSymbolsBuilder = ImmutableList.builder().add((Object)inputJsonSymbol).add((Object)parametersRowSymbol);
        defaultExpressions.stream().map(coerced::get).distinct().forEach(arg_0 -> ((ImmutableList.Builder)requiredSymbolsBuilder).add(arg_0));
        ImmutableList requiredSymbols = requiredSymbolsBuilder.build();
        HashMap<io.trino.sql.tree.Expression, Integer> defaultExpressionsMapping = new HashMap<io.trino.sql.tree.Expression, Integer>();
        for (io.trino.sql.tree.Expression defaultExpression : defaultExpressions) {
            defaultExpressionsMapping.put(defaultExpression, requiredSymbols.indexOf(coerced.get(defaultExpression)));
        }
        IrJsonPath rootPath = new JsonPathTranslator(this.session, this.plannerContext).rewriteToIr(this.analysis.getJsonPathAnalysis((Node)jsonTable), orderedParameters.getParametersOrder());
        List<NodeRef<JsonTableColumnDefinition>> orderedColumns = jsonTableAnalysis.orderedOutputColumns();
        Map outputIndexMapping = (Map)IntStream.range(0, orderedColumns.size()).boxed().collect(ImmutableMap.toImmutableMap(orderedColumns::get, Function.identity()));
        boolean defaultErrorOnError = jsonTable.getErrorBehavior().map(errorBehavior -> errorBehavior == JsonTable.ErrorBehavior.ERROR).orElse(false);
        if (jsonTable.getPlan().isEmpty()) {
            executionPlan = this.getPlanFromDefaults(rootPath, jsonTable.getColumns(), JsonTablePlan.ParentChildPlanType.OUTER, JsonTablePlan.SiblingsPlanType.UNION, defaultErrorOnError, outputIndexMapping, defaultExpressionsMapping);
        } else {
            Object t = jsonTable.getPlan().orElseThrow();
            if (t instanceof JsonTableDefaultPlan) {
                JsonTableDefaultPlan defaultPlan = (JsonTableDefaultPlan)t;
                executionPlan = this.getPlanFromDefaults(rootPath, jsonTable.getColumns(), defaultPlan.getParentChild(), defaultPlan.getSiblings(), defaultErrorOnError, outputIndexMapping, defaultExpressionsMapping);
            } else {
                executionPlan = this.getPlanFromSpecification(rootPath, jsonTable.getColumns(), (JsonTableSpecificPlan)jsonTable.getPlan().orElseThrow(), defaultErrorOnError, outputIndexMapping, defaultExpressionsMapping);
            }
        }
        RelationType jsonTableRelationType = this.analysis.getScope((Node)jsonTable).getRelationType();
        List properOutputs = (List)IntStream.range(0, orderedColumns.size()).mapToObj(index -> {
            Node patt0$temp = ((NodeRef)orderedColumns.get(index)).getNode();
            if (patt0$temp instanceof QueryColumn) {
                QueryColumn queryColumn = (QueryColumn)patt0$temp;
                return this.symbolAllocator.newSymbol(queryColumn.getName().getCanonicalValue(), (Type)Json2016Type.JSON_2016);
            }
            return this.symbolAllocator.newSymbol(jsonTableRelationType.getFieldByIndex(index));
        }).collect(ImmutableList.toImmutableList());
        List passThroughColumns = (List)leftFieldMappings.stream().map(symbol -> new TableFunctionNode.PassThroughColumn((Symbol)symbol, false)).collect(ImmutableList.toImmutableList());
        boolean outer = joinType == Join.Type.LEFT || joinType == Join.Type.FULL;
        JsonTable.JsonTableFunctionHandle functionHandle = new JsonTable.JsonTableFunctionHandle(executionPlan, outer, defaultErrorOnError, (Type)parametersType, (Type[])properOutputs.stream().map(Symbol::type).toArray(Type[]::new));
        TableFunctionNode tableFunctionNode = new TableFunctionNode(this.idAllocator.getNextId(), "$json_table", jsonTableAnalysis.catalogHandle(), (Map<String, Argument>)ImmutableMap.of((Object)"$input", (Object)new TableArgument(this.getRowType(planBuilder.getRoot()), (List)ImmutableList.of(), (List)ImmutableList.of())), properOutputs, (List<PlanNode>)ImmutableList.of((Object)planBuilder.getRoot()), (List<TableFunctionNode.TableArgumentProperties>)ImmutableList.of((Object)new TableFunctionNode.TableArgumentProperties("$input", true, true, new TableFunctionNode.PassThroughSpecification(true, passThroughColumns), (List<Symbol>)requiredSymbols, Optional.empty())), (List<List<String>>)ImmutableList.of(), new TableFunctionHandle(jsonTableAnalysis.catalogHandle(), functionHandle, jsonTableAnalysis.transactionHandle()));
        ImmutableList.Builder outputLayout = ImmutableList.builder().addAll(leftFieldMappings);
        Assignments.Builder assignments = Assignments.builder().putIdentities(leftFieldMappings);
        for (int i = 0; i < properOutputs.size(); ++i) {
            Symbol properOutput = (Symbol)properOutputs.get(i);
            Node node = orderedColumns.get(i).getNode();
            if (node instanceof QueryColumn) {
                QueryColumn queryColumn = (QueryColumn)node;
                Constant errorBehavior2 = new Constant((Type)TinyintType.TINYINT, queryColumn.getErrorBehavior().orElse(defaultErrorOnError ? JsonQuery.EmptyOrErrorBehavior.ERROR : JsonQuery.EmptyOrErrorBehavior.NULL).ordinal());
                Constant omitQuotes = new Constant((Type)BooleanType.BOOLEAN, queryColumn.getQuotesBehavior().orElse(JsonQuery.QuotesBehavior.KEEP) == JsonQuery.QuotesBehavior.OMIT);
                ResolvedFunction outputFunction = this.analysis.getJsonOutputFunction((Node)queryColumn);
                Record result = new Call(outputFunction, (List<Expression>)ImmutableList.of((Object)properOutput.toSymbolReference(), (Object)errorBehavior2, (Object)omitQuotes));
                Type expectedType = jsonTableRelationType.getFieldByIndex(i).getType();
                Type resultType = outputFunction.signature().getReturnType();
                if (!resultType.equals((Object)expectedType)) {
                    result = new Cast((Expression)((Object)result), expectedType);
                }
                Symbol output = this.symbolAllocator.newSymbol((Expression)((Object)result));
                outputLayout.add((Object)output);
                assignments.put(output, (Expression)((Object)result));
                continue;
            }
            outputLayout.add((Object)properOutput);
            assignments.putIdentity(properOutput);
        }
        ProjectNode projectNode = new ProjectNode(this.idAllocator.getNextId(), tableFunctionNode, assignments.build());
        return new RelationPlan(projectNode, outputScope, (List<Symbol>)outputLayout.build(), this.outerContext);
    }

    private static List<io.trino.sql.tree.Expression> getDefaultExpressions(List<JsonTableColumnDefinition> columns) {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (JsonTableColumnDefinition column : columns) {
            if (column instanceof ValueColumn) {
                ValueColumn valueColumn = (ValueColumn)column;
                valueColumn.getEmptyDefault().ifPresent(arg_0 -> ((ImmutableList.Builder)builder).add(arg_0));
                valueColumn.getErrorDefault().ifPresent(arg_0 -> ((ImmutableList.Builder)builder).add(arg_0));
                continue;
            }
            if (!(column instanceof NestedColumns)) continue;
            NestedColumns nestedColumns = (NestedColumns)column;
            builder.addAll(RelationPlanner.getDefaultExpressions(nestedColumns.getColumns()));
        }
        return builder.build();
    }

    private JsonTablePlanNode getPlanFromDefaults(IrJsonPath path, List<JsonTableColumnDefinition> columnDefinitions, JsonTablePlan.ParentChildPlanType parentChildPlanType, JsonTablePlan.SiblingsPlanType siblingsPlanType, boolean defaultErrorOnError, Map<NodeRef<JsonTableColumnDefinition>, Integer> outputIndexMapping, Map<io.trino.sql.tree.Expression, Integer> defaultExpressionsMapping) {
        ImmutableList.Builder columns = ImmutableList.builder();
        ImmutableList.Builder childrenBuilder = ImmutableList.builder();
        for (JsonTableColumnDefinition columnDefinition : columnDefinitions) {
            if (columnDefinition instanceof NestedColumns) {
                NestedColumns nestedColumns = (NestedColumns)columnDefinition;
                IrJsonPath nestedPath = new JsonPathTranslator(this.session, this.plannerContext).rewriteToIr(this.analysis.getJsonPathAnalysis((Node)nestedColumns), (List<String>)ImmutableList.of());
                childrenBuilder.add((Object)this.getPlanFromDefaults(nestedPath, nestedColumns.getColumns(), parentChildPlanType, siblingsPlanType, defaultErrorOnError, outputIndexMapping, defaultExpressionsMapping));
                continue;
            }
            columns.add((Object)this.getColumn(columnDefinition, defaultErrorOnError, outputIndexMapping, defaultExpressionsMapping));
        }
        ImmutableList children = childrenBuilder.build();
        if (children.isEmpty()) {
            return new JsonTablePlanLeaf(path, (List<JsonTableColumn>)columns.build());
        }
        Object child = children.size() == 1 ? (JsonTablePlanNode)Iterables.getOnlyElement((Iterable)children) : (siblingsPlanType == JsonTablePlan.SiblingsPlanType.UNION ? new JsonTablePlanUnion((List<JsonTablePlanNode>)children) : new JsonTablePlanCross((List<JsonTablePlanNode>)children));
        return new JsonTablePlanSingle(path, (List<JsonTableColumn>)columns.build(), parentChildPlanType == JsonTablePlan.ParentChildPlanType.OUTER, (JsonTablePlanNode)child);
    }

    private JsonTablePlanNode getPlanFromSpecification(IrJsonPath path, List<JsonTableColumnDefinition> columnDefinitions, JsonTableSpecificPlan specificPlan, boolean defaultErrorOnError, Map<NodeRef<JsonTableColumnDefinition>, Integer> outputIndexMapping, Map<io.trino.sql.tree.Expression, Integer> defaultExpressionsMapping) {
        ImmutableList.Builder columns = ImmutableList.builder();
        ImmutableMap.Builder childrenBuilder = ImmutableMap.builder();
        Object planSiblings = specificPlan instanceof PlanLeaf ? ImmutableMap.of() : this.getSiblings(((PlanParentChild)specificPlan).getChild());
        for (JsonTableColumnDefinition columnDefinition : columnDefinitions) {
            if (columnDefinition instanceof NestedColumns) {
                NestedColumns nestedColumns = (NestedColumns)columnDefinition;
                IrJsonPath nestedPath = new JsonPathTranslator(this.session, this.plannerContext).rewriteToIr(this.analysis.getJsonPathAnalysis((Node)nestedColumns), (List<String>)ImmutableList.of());
                String nestedPathName = ((Identifier)nestedColumns.getPathName().orElseThrow()).getCanonicalValue();
                JsonTablePlanNode child = this.getPlanFromSpecification(nestedPath, nestedColumns.getColumns(), (JsonTableSpecificPlan)planSiblings.get(nestedPathName), defaultErrorOnError, outputIndexMapping, defaultExpressionsMapping);
                childrenBuilder.put((Object)nestedPathName, (Object)child);
                continue;
            }
            columns.add((Object)this.getColumn(columnDefinition, defaultErrorOnError, outputIndexMapping, defaultExpressionsMapping));
        }
        ImmutableMap children = childrenBuilder.buildOrThrow();
        if (children.isEmpty()) {
            return new JsonTablePlanLeaf(path, (List<JsonTableColumn>)columns.build());
        }
        PlanParentChild planParentChild = (PlanParentChild)specificPlan;
        boolean outer = planParentChild.getType() == JsonTablePlan.ParentChildPlanType.OUTER;
        JsonTablePlanNode child = this.combineSiblings((Map<String, JsonTablePlanNode>)children, planParentChild.getChild());
        return new JsonTablePlanSingle(path, (List<JsonTableColumn>)columns.build(), outer, child);
    }

    private Map<String, JsonTableSpecificPlan> getSiblings(JsonTableSpecificPlan plan) {
        if (plan instanceof PlanLeaf) {
            PlanLeaf planLeaf = (PlanLeaf)plan;
            return ImmutableMap.of((Object)planLeaf.getName().getCanonicalValue(), (Object)planLeaf);
        }
        if (plan instanceof PlanParentChild) {
            PlanParentChild planParentChild = (PlanParentChild)plan;
            return ImmutableMap.of((Object)planParentChild.getParent().getName().getCanonicalValue(), (Object)planParentChild);
        }
        PlanSiblings planSiblings = (PlanSiblings)plan;
        ImmutableMap.Builder siblings = ImmutableMap.builder();
        for (JsonTableSpecificPlan sibling : planSiblings.getSiblings()) {
            siblings.putAll(this.getSiblings(sibling));
        }
        return siblings.buildOrThrow();
    }

    private JsonTableColumn getColumn(JsonTableColumnDefinition columnDefinition, boolean defaultErrorOnError, Map<NodeRef<JsonTableColumnDefinition>, Integer> outputIndexMapping, Map<io.trino.sql.tree.Expression, Integer> defaultExpressionsMapping) {
        int index = outputIndexMapping.get(NodeRef.of((Node)columnDefinition));
        if (columnDefinition instanceof OrdinalityColumn) {
            return new JsonTableOrdinalityColumn(index);
        }
        ResolvedFunction columnFunction = this.analysis.getResolvedFunction((Node)columnDefinition);
        IrJsonPath columnPath = new JsonPathTranslator(this.session, this.plannerContext).rewriteToIr(this.analysis.getJsonPathAnalysis((Node)columnDefinition), (List<String>)ImmutableList.of());
        if (columnDefinition instanceof QueryColumn) {
            QueryColumn queryColumn = (QueryColumn)columnDefinition;
            return new JsonTableQueryColumn(index, columnFunction, columnPath, queryColumn.getWrapperBehavior().ordinal(), queryColumn.getEmptyBehavior().ordinal(), queryColumn.getErrorBehavior().orElse(defaultErrorOnError ? JsonQuery.EmptyOrErrorBehavior.ERROR : JsonQuery.EmptyOrErrorBehavior.NULL).ordinal());
        }
        if (columnDefinition instanceof ValueColumn) {
            ValueColumn valueColumn = (ValueColumn)columnDefinition;
            int emptyDefault = valueColumn.getEmptyDefault().map(defaultExpressionsMapping::get).orElse(-1);
            int errorDefault = valueColumn.getErrorDefault().map(defaultExpressionsMapping::get).orElse(-1);
            return new JsonTableValueColumn(index, columnFunction, columnPath, valueColumn.getEmptyBehavior().ordinal(), emptyDefault, valueColumn.getErrorBehavior().orElse(defaultErrorOnError ? JsonValue.EmptyOrErrorBehavior.ERROR : JsonValue.EmptyOrErrorBehavior.NULL).ordinal(), errorDefault);
        }
        throw new IllegalStateException("unexpected column definition: " + columnDefinition.getClass().getSimpleName());
    }

    private JsonTablePlanNode combineSiblings(Map<String, JsonTablePlanNode> siblings, JsonTableSpecificPlan plan) {
        if (plan instanceof PlanLeaf) {
            PlanLeaf planLeaf = (PlanLeaf)plan;
            return siblings.get(planLeaf.getName().getCanonicalValue());
        }
        if (plan instanceof PlanParentChild) {
            PlanParentChild planParentChild = (PlanParentChild)plan;
            return siblings.get(planParentChild.getParent().getName().getCanonicalValue());
        }
        PlanSiblings planSiblings = (PlanSiblings)plan;
        List siblingNodes = (List)planSiblings.getSiblings().stream().map(sibling -> this.combineSiblings(siblings, (JsonTableSpecificPlan)sibling)).collect(ImmutableList.toImmutableList());
        if (planSiblings.getType() == JsonTablePlan.SiblingsPlanType.UNION) {
            return new JsonTablePlanUnion(siblingNodes);
        }
        return new JsonTablePlanCross(siblingNodes);
    }

    private RowType getRowType(PlanNode node) {
        return RowType.from((List)((List)node.getOutputSymbols().stream().map(symbol -> new RowType.Field(Optional.of(symbol.name()), symbol.type())).collect(ImmutableList.toImmutableList())));
    }

    protected RelationPlan visitTableSubquery(TableSubquery node, Void context) {
        RelationPlan plan = (RelationPlan)this.process((Node)node.getQuery(), context);
        return new RelationPlan(plan.getRoot(), this.analysis.getScope((Node)node), plan.getFieldMappings(), this.outerContext);
    }

    protected RelationPlan visitQuery(Query node, Void context) {
        return new QueryPlanner(this.analysis, this.symbolAllocator, this.idAllocator, this.lambdaDeclarationToSymbolMap, this.plannerContext, this.outerContext, this.session, this.recursiveSubqueries).plan(node);
    }

    protected RelationPlan visitQuerySpecification(QuerySpecification node, Void context) {
        return new QueryPlanner(this.analysis, this.symbolAllocator, this.idAllocator, this.lambdaDeclarationToSymbolMap, this.plannerContext, this.outerContext, this.session, this.recursiveSubqueries).plan(node);
    }

    protected RelationPlan visitSubqueryExpression(SubqueryExpression node, Void context) {
        return (RelationPlan)this.process((Node)node.getQuery(), context);
    }

    protected RelationPlan visitValues(Values node, Void context) {
        Scope scope = this.analysis.getScope((Node)node);
        ImmutableList.Builder outputSymbolsBuilder = ImmutableList.builder();
        for (Field field : scope.getRelationType().getVisibleFields()) {
            Symbol symbol = this.symbolAllocator.newSymbol(field);
            outputSymbolsBuilder.add((Object)symbol);
        }
        ImmutableList outputSymbols = outputSymbolsBuilder.build();
        TranslationMap translationMap = new TranslationMap(this.outerContext, this.analysis.getScope((Node)node), this.analysis, this.lambdaDeclarationToSymbolMap, (List<Symbol>)outputSymbols, this.session, this.plannerContext);
        ImmutableList.Builder rows = ImmutableList.builder();
        for (io.trino.sql.tree.Expression row : node.getRows()) {
            if (row instanceof Row) {
                rows.add((Object)new io.trino.sql.ir.Row((List)((Row)row).getItems().stream().map(item -> QueryPlanner.coerceIfNecessary(this.analysis, item, translationMap.rewrite((io.trino.sql.tree.Expression)item))).collect(ImmutableList.toImmutableList())));
                continue;
            }
            if (this.analysis.getType(row) instanceof RowType) {
                rows.add((Object)QueryPlanner.coerceIfNecessary(this.analysis, row, translationMap.rewrite(row)));
                continue;
            }
            rows.add((Object)new io.trino.sql.ir.Row((List<Expression>)ImmutableList.of((Object)QueryPlanner.coerceIfNecessary(this.analysis, row, translationMap.rewrite(row)))));
        }
        ValuesNode valuesNode = new ValuesNode(this.idAllocator.getNextId(), (List<Symbol>)outputSymbols, (List<Expression>)rows.build());
        return new RelationPlan(valuesNode, scope, (List<Symbol>)outputSymbols, this.outerContext);
    }

    protected RelationPlan visitUnnest(Unnest node, Void context) {
        Scope scope = this.analysis.getScope((Node)node);
        return this.planUnnest(this.planSingleEmptyRow(scope.getOuterQueryParent()), node, (List<Symbol>)ImmutableList.of(), Join.Type.INNER, scope);
    }

    private PlanBuilder planSingleEmptyRow(Optional<Scope> parent) {
        Scope.Builder scope = Scope.builder();
        parent.ifPresent(scope::withOuterQueryParent);
        ValuesNode values = new ValuesNode(this.idAllocator.getNextId(), 1);
        TranslationMap translations = new TranslationMap(this.outerContext, scope.build(), this.analysis, this.lambdaDeclarationToSymbolMap, (List<Symbol>)ImmutableList.of(), this.session, this.plannerContext);
        return new PlanBuilder(translations, values);
    }

    protected RelationPlan visitJsonTable(JsonTable node, Void context) {
        return this.planJoinJsonTable(this.planSingleEmptyRow(this.analysis.getScope((Node)node).getOuterQueryParent()), (List<Symbol>)ImmutableList.of(), Join.Type.INNER, node, this.analysis.getScope((Node)node));
    }

    protected RelationPlan visitUnion(Union node, Void context) {
        Preconditions.checkArgument((!node.getRelations().isEmpty() ? 1 : 0) != 0, (Object)"No relations specified for UNION");
        SetOperationPlan setOperationPlan = this.process((SetOperation)node);
        PlanNode planNode = new UnionNode(this.idAllocator.getNextId(), setOperationPlan.getSources(), setOperationPlan.getSymbolMapping(), (List<Symbol>)ImmutableList.copyOf((Collection)setOperationPlan.getSymbolMapping().keySet()));
        if (node.isDistinct()) {
            planNode = this.distinct(planNode);
        }
        return new RelationPlan(planNode, this.analysis.getScope((Node)node), planNode.getOutputSymbols(), this.outerContext);
    }

    protected RelationPlan visitIntersect(Intersect node, Void context) {
        Preconditions.checkArgument((!node.getRelations().isEmpty() ? 1 : 0) != 0, (Object)"No relations specified for INTERSECT");
        SetOperationPlan setOperationPlan = this.process((SetOperation)node);
        IntersectNode planNode = new IntersectNode(this.idAllocator.getNextId(), setOperationPlan.getSources(), setOperationPlan.getSymbolMapping(), (List<Symbol>)ImmutableList.copyOf((Collection)setOperationPlan.getSymbolMapping().keySet()), node.isDistinct());
        return new RelationPlan(planNode, this.analysis.getScope((Node)node), ((PlanNode)planNode).getOutputSymbols(), this.outerContext);
    }

    protected RelationPlan visitExcept(Except node, Void context) {
        Preconditions.checkArgument((!node.getRelations().isEmpty() ? 1 : 0) != 0, (Object)"No relations specified for EXCEPT");
        SetOperationPlan setOperationPlan = this.process((SetOperation)node);
        ExceptNode planNode = new ExceptNode(this.idAllocator.getNextId(), setOperationPlan.getSources(), setOperationPlan.getSymbolMapping(), (List<Symbol>)ImmutableList.copyOf((Collection)setOperationPlan.getSymbolMapping().keySet()), node.isDistinct());
        return new RelationPlan(planNode, this.analysis.getScope((Node)node), ((PlanNode)planNode).getOutputSymbols(), this.outerContext);
    }

    private SetOperationPlan process(SetOperation node) {
        RelationType outputFields = this.analysis.getOutputDescriptor((Node)node);
        List outputs = (List)outputFields.getAllFields().stream().map(this.symbolAllocator::newSymbol).collect(ImmutableList.toImmutableList());
        ImmutableListMultimap.Builder symbolMapping = ImmutableListMultimap.builder();
        ImmutableList.Builder sources = ImmutableList.builder();
        for (Relation child : node.getRelations()) {
            RelationPlan plan = (RelationPlan)this.process((Node)child, null);
            List<Type> types = this.analysis.getRelationCoercion(child);
            NodeAndMappings planAndMappings = types == null ? QueryPlanner.pruneInvisibleFields(plan, this.idAllocator) : QueryPlanner.coerce(plan, types, this.symbolAllocator, this.idAllocator);
            for (int i = 0; i < outputFields.getAllFields().size(); ++i) {
                symbolMapping.put((Object)((Symbol)outputs.get(i)), (Object)planAndMappings.getFields().get(i));
            }
            sources.add((Object)planAndMappings.getNode());
        }
        return new SetOperationPlan((List<PlanNode>)sources.build(), (ListMultimap<Symbol, Symbol>)symbolMapping.build());
    }

    private PlanNode distinct(PlanNode node) {
        return AggregationNode.singleAggregation(this.idAllocator.getNextId(), node, (Map<Symbol, AggregationNode.Aggregation>)ImmutableMap.of(), AggregationNode.singleGroupingSet(node.getOutputSymbols()));
    }

    private static /* synthetic */ Set lambda$planPatternRecognitionComponents$4(Map rewrittenSubsets, String label) {
        return (Set)rewrittenSubsets.getOrDefault(new IrLabel(label), ImmutableSet.of((Object)new IrLabel(label)));
    }

    private static /* synthetic */ boolean lambda$visitPatternRecognitionRelation$3(Set inputSymbolsOnOutput, Symbol symbol) {
        return !inputSymbolsOnOutput.contains(symbol);
    }

    public static class PatternRecognitionComponents {
        private final Map<Symbol, PatternRecognitionNode.Measure> measures;
        private final List<Symbol> measureOutputs;
        private final Set<IrLabel> skipToLabels;
        private final SkipToPosition skipToPosition;
        private final boolean initial;
        private final IrRowPattern pattern;
        private final Map<IrLabel, ExpressionAndValuePointers> variableDefinitions;

        public PatternRecognitionComponents(Map<Symbol, PatternRecognitionNode.Measure> measures, List<Symbol> measureOutputs, Set<IrLabel> skipToLabels, SkipToPosition skipToPosition, boolean initial, IrRowPattern pattern, Map<IrLabel, ExpressionAndValuePointers> variableDefinitions) {
            this.measures = Objects.requireNonNull(measures, "measures is null");
            this.measureOutputs = Objects.requireNonNull(measureOutputs, "measureOutputs is null");
            this.skipToLabels = ImmutableSet.copyOf(skipToLabels);
            this.skipToPosition = Objects.requireNonNull(skipToPosition, "skipToPosition is null");
            this.initial = initial;
            this.pattern = Objects.requireNonNull(pattern, "pattern is null");
            this.variableDefinitions = Objects.requireNonNull(variableDefinitions, "variableDefinitions is null");
        }

        public Map<Symbol, PatternRecognitionNode.Measure> getMeasures() {
            return this.measures;
        }

        public List<Symbol> getMeasureOutputs() {
            return this.measureOutputs;
        }

        public Set<IrLabel> getSkipToLabels() {
            return this.skipToLabels;
        }

        public SkipToPosition getSkipToPosition() {
            return this.skipToPosition;
        }

        public boolean isInitial() {
            return this.initial;
        }

        public IrRowPattern getPattern() {
            return this.pattern;
        }

        public Map<IrLabel, ExpressionAndValuePointers> getVariableDefinitions() {
            return this.variableDefinitions;
        }
    }

    private static final class SetOperationPlan {
        private final List<PlanNode> sources;
        private final ListMultimap<Symbol, Symbol> symbolMapping;

        private SetOperationPlan(List<PlanNode> sources, ListMultimap<Symbol, Symbol> symbolMapping) {
            this.sources = sources;
            this.symbolMapping = symbolMapping;
        }

        public List<PlanNode> getSources() {
            return this.sources;
        }

        public ListMultimap<Symbol, Symbol> getSymbolMapping() {
            return this.symbolMapping;
        }
    }
}

