/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner;

import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import io.trino.spi.type.Type;
import io.trino.sql.ir.Expression;
import io.trino.sql.ir.Reference;
import io.trino.sql.planner.SymbolKeySerializer;
import java.util.Objects;

@JsonSerialize(keyUsing=SymbolKeySerializer.class)
public record Symbol(Type type, String name) {
    public Symbol {
        Objects.requireNonNull(name, "name is null");
        Objects.requireNonNull(type, "type is null");
    }

    public static Symbol from(Expression expression) {
        if (!(expression instanceof Reference)) {
            throw new IllegalArgumentException("Unexpected expression: " + String.valueOf(expression));
        }
        Reference symbol = (Reference)expression;
        return new Symbol(symbol.type(), symbol.name());
    }

    public Reference toSymbolReference() {
        return new Reference(this.type, this.name);
    }

    @Override
    public String toString() {
        return this.name + "::[" + String.valueOf(this.type) + "]";
    }
}

