/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner;

import com.google.common.base.CharMatcher;
import com.google.common.primitives.Ints;
import io.trino.spi.type.Type;
import io.trino.sql.analyzer.Field;
import io.trino.sql.ir.Call;
import io.trino.sql.ir.Expression;
import io.trino.sql.ir.Reference;
import io.trino.sql.planner.Symbol;
import java.lang.runtime.SwitchBootstraps;
import java.util.Collection;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;

public class SymbolAllocator {
    public static final CharMatcher EXCLUDED_CHARACTERS = CharMatcher.inRange((char)'a', (char)'z').or(CharMatcher.inRange((char)'0', (char)'9')).negate().precomputed();
    private final Map<String, Symbol> symbols;
    private int nextId;

    public SymbolAllocator() {
        this.symbols = new HashMap<String, Symbol>();
    }

    public SymbolAllocator(Collection<Symbol> initial) {
        this.symbols = new HashMap<String, Symbol>(initial.stream().collect(Collectors.toMap(Symbol::name, e -> e)));
    }

    public Symbol newSymbol(Symbol symbolHint) {
        return this.newSymbol(symbolHint.name(), symbolHint.type());
    }

    public Symbol newSymbol(String nameHint, Type type) {
        String tail;
        Objects.requireNonNull(nameHint, "nameHint is null");
        Objects.requireNonNull(type, "type is null");
        nameHint = EXCLUDED_CHARACTERS.trimAndCollapseFrom((CharSequence)nameHint.toLowerCase(Locale.ENGLISH), '_');
        int index = nameHint.lastIndexOf("_");
        if (index > 0 && (Ints.tryParse((String)(tail = nameHint.substring(index + 1))) != null || index == nameHint.length() - 1)) {
            nameHint = nameHint.substring(0, index);
        }
        Symbol symbol = new Symbol(type, nameHint);
        while (this.symbols.putIfAbsent(symbol.name(), symbol) != null) {
            symbol = new Symbol(type, nameHint + "_" + this.nextId());
        }
        return symbol;
    }

    public Symbol newSymbol(Expression expression) {
        Expression expression2 = expression;
        Objects.requireNonNull(expression2);
        Expression expression3 = expression2;
        int n = 0;
        String nameHint = switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Call.class, Reference.class}, (Object)expression3, n)) {
            case 0 -> {
                Call call = (Call)expression3;
                yield call.function().name().getFunctionName();
            }
            case 1 -> {
                Reference reference = (Reference)expression3;
                yield reference.name();
            }
            default -> "expr";
        };
        return this.newSymbol(nameHint, expression.type());
    }

    public Symbol newSymbol(Field field) {
        String nameHint = field.getName().orElse("field");
        return this.newSymbol(nameHint, field.getType());
    }

    public Collection<Symbol> getSymbols() {
        return this.symbols.values();
    }

    private int nextId() {
        return this.nextId++;
    }
}

