/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner.iterative.rule;

import com.google.common.collect.ImmutableBiMap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import io.trino.matching.Captures;
import io.trino.matching.Pattern;
import io.trino.metadata.QualifiedObjectName;
import io.trino.metadata.TableHandle;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.TrinoException;
import io.trino.spi.connector.CatalogSchemaTableName;
import io.trino.spi.connector.ColumnHandle;
import io.trino.spi.connector.TableScanRedirectApplicationResult;
import io.trino.spi.predicate.Domain;
import io.trino.spi.predicate.TupleDomain;
import io.trino.spi.type.Type;
import io.trino.sql.PlannerContext;
import io.trino.sql.ir.Cast;
import io.trino.sql.planner.DomainTranslator;
import io.trino.sql.planner.PlanNodeIdAllocator;
import io.trino.sql.planner.Symbol;
import io.trino.sql.planner.iterative.Rule;
import io.trino.sql.planner.plan.Assignments;
import io.trino.sql.planner.plan.FilterNode;
import io.trino.sql.planner.plan.Patterns;
import io.trino.sql.planner.plan.PlanNode;
import io.trino.sql.planner.plan.ProjectNode;
import io.trino.sql.planner.plan.TableScanNode;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;

public class ApplyTableScanRedirection
implements Rule<TableScanNode> {
    private static final Pattern<TableScanNode> PATTERN = Patterns.tableScan().matching(node -> !node.isUpdateTarget());
    private final PlannerContext plannerContext;

    public ApplyTableScanRedirection(PlannerContext plannerContext) {
        this.plannerContext = Objects.requireNonNull(plannerContext, "plannerContext is null");
    }

    @Override
    public Pattern<TableScanNode> getPattern() {
        return PATTERN;
    }

    @Override
    public Rule.Result apply(TableScanNode scanNode, Captures captures, Rule.Context context) {
        Optional<TableScanRedirectApplicationResult> tableScanRedirectApplicationResult = this.plannerContext.getMetadata().applyTableScanRedirect(context.getSession(), scanNode.getTable());
        if (tableScanRedirectApplicationResult.isEmpty()) {
            return Rule.Result.empty();
        }
        CatalogSchemaTableName destinationTable = tableScanRedirectApplicationResult.get().getDestinationTable();
        QualifiedObjectName destinationObjectName = QualifiedObjectName.convertFromSchemaTableName(destinationTable.getCatalogName()).apply(destinationTable.getSchemaTableName());
        Optional<QualifiedObjectName> redirectedObjectName = this.plannerContext.getMetadata().getRedirectionAwareTableHandle(context.getSession(), destinationObjectName).redirectedTableName();
        redirectedObjectName.ifPresent(name -> {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, String.format("Further redirection of destination table '%s' to '%s' is not supported", destinationObjectName, name));
        });
        CatalogSchemaTableName sourceTable = this.plannerContext.getMetadata().getTableName(context.getSession(), scanNode.getTable());
        if (destinationTable.equals((Object)sourceTable)) {
            return Rule.Result.empty();
        }
        TableHandle destinationTableHandle = this.plannerContext.getMetadata().getTableHandle(context.getSession(), QualifiedObjectName.convertFromSchemaTableName(destinationTable.getCatalogName()).apply(destinationTable.getSchemaTableName())).orElseThrow(() -> new TrinoException((ErrorCodeSupplier)StandardErrorCode.TABLE_NOT_FOUND, String.format("Destination table %s from table scan redirection not found", destinationTable)));
        Map columnMapping = tableScanRedirectApplicationResult.get().getDestinationColumns();
        Map<String, ColumnHandle> destinationColumnHandles = this.plannerContext.getMetadata().getColumnHandles(context.getSession(), destinationTableHandle);
        ImmutableMap.Builder casts = ImmutableMap.builder();
        ImmutableMap.Builder newAssignmentsBuilder = ImmutableMap.builder();
        for (Map.Entry<Symbol, ColumnHandle> assignment : scanNode.getAssignments().entrySet()) {
            Type redirectedType;
            String destinationColumn = (String)columnMapping.get(assignment.getValue());
            if (destinationColumn == null) {
                throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.COLUMN_NOT_FOUND, String.format("Did not find mapping for source column %s in table scan redirection", assignment.getValue()));
            }
            ColumnHandle destinationColumnHandle = destinationColumnHandles.get(destinationColumn);
            if (destinationColumnHandle == null) {
                throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.COLUMN_NOT_FOUND, String.format("Did not find handle for column %s in destination table %s", destinationColumn, destinationTable));
            }
            Type sourceType = assignment.getKey().type();
            if (!sourceType.equals((Object)(redirectedType = this.plannerContext.getMetadata().getColumnMetadata(context.getSession(), destinationTableHandle, destinationColumnHandle).getType()))) {
                Symbol redirectedSymbol = context.getSymbolAllocator().newSymbol(destinationColumn, redirectedType);
                Cast cast = this.getCast(destinationTable, destinationColumn, redirectedType, redirectedSymbol, sourceTable, assignment.getValue(), sourceType);
                casts.put((Object)assignment.getKey(), (Object)cast);
                newAssignmentsBuilder.put((Object)redirectedSymbol, (Object)destinationColumnHandle);
                continue;
            }
            newAssignmentsBuilder.put((Object)assignment.getKey(), (Object)destinationColumnHandle);
        }
        TupleDomain requiredFilter = tableScanRedirectApplicationResult.get().getFilter();
        if (requiredFilter.isAll()) {
            ImmutableMap newAssignments = newAssignmentsBuilder.buildOrThrow();
            return Rule.Result.ofPlanNode(this.applyProjection(context.getIdAllocator(), (Set<Symbol>)ImmutableSet.copyOf(scanNode.getOutputSymbols()), (Map<Symbol, Cast>)casts.buildOrThrow(), new TableScanNode(scanNode.getId(), destinationTableHandle, (List<Symbol>)ImmutableList.copyOf((Collection)newAssignments.keySet()), (Map<Symbol, ColumnHandle>)newAssignments, (TupleDomain<ColumnHandle>)TupleDomain.all(), Optional.empty(), scanNode.isUpdateTarget(), Optional.empty())));
        }
        ImmutableBiMap inverseAssignments = ImmutableBiMap.copyOf(scanNode.getAssignments()).inverse();
        ImmutableBiMap inverseColumnsMapping = ImmutableBiMap.copyOf((Map)columnMapping).inverse();
        TupleDomain transformedConstraint = requiredFilter.transformKeys(arg_0 -> this.lambda$apply$3((Map)inverseColumnsMapping, (Map)inverseAssignments, requiredFilter, context, destinationColumnHandles, destinationTable, destinationTableHandle, sourceTable, casts, newAssignmentsBuilder, arg_0));
        ImmutableMap newAssignments = newAssignmentsBuilder.buildOrThrow();
        TableScanNode newScanNode = new TableScanNode(scanNode.getId(), destinationTableHandle, (List<Symbol>)ImmutableList.copyOf(newAssignments.keySet()), (Map<Symbol, ColumnHandle>)newAssignments, (TupleDomain<ColumnHandle>)TupleDomain.all(), Optional.empty(), scanNode.isUpdateTarget(), Optional.empty());
        FilterNode filterNode = new FilterNode(context.getIdAllocator().getNextId(), this.applyProjection(context.getIdAllocator(), newAssignments.keySet(), (Map<Symbol, Cast>)casts.buildOrThrow(), newScanNode), DomainTranslator.toPredicate((TupleDomain<Symbol>)transformedConstraint));
        return Rule.Result.ofPlanNode(this.applyProjection(context.getIdAllocator(), (Set<Symbol>)ImmutableSet.copyOf(scanNode.getOutputSymbols()), (Map<Symbol, Cast>)ImmutableMap.of(), filterNode));
    }

    private PlanNode applyProjection(PlanNodeIdAllocator idAllocator, Set<Symbol> requiredSymbols, Map<Symbol, Cast> casts, PlanNode source) {
        if (casts.isEmpty() && requiredSymbols.equals(ImmutableSet.copyOf(source.getOutputSymbols()))) {
            return source;
        }
        return new ProjectNode(idAllocator.getNextId(), source, Assignments.builder().putIdentities((Iterable<Symbol>)Sets.difference(requiredSymbols, casts.keySet())).putAll(casts).build());
    }

    private Cast getCast(CatalogSchemaTableName destinationTable, String destinationColumn, Type destinationType, Symbol destinationSymbol, CatalogSchemaTableName sourceTable, ColumnHandle sourceColumnHandle, Type sourceType) {
        try {
            this.plannerContext.getMetadata().getCoercion(destinationType, sourceType);
        }
        catch (TrinoException e) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.FUNCTION_NOT_FOUND, String.format("Cast not possible from redirected column %s.%s with type %s to source column %s.%s with type: %s", destinationTable, destinationColumn, destinationType, sourceTable, sourceColumnHandle, sourceType));
        }
        return new Cast(destinationSymbol.toSymbolReference(), sourceType);
    }

    private /* synthetic */ Symbol lambda$apply$3(Map inverseColumnsMapping, Map inverseAssignments, TupleDomain requiredFilter, Rule.Context context, Map destinationColumnHandles, CatalogSchemaTableName destinationTable, TableHandle destinationTableHandle, CatalogSchemaTableName sourceTable, ImmutableMap.Builder casts, ImmutableMap.Builder newAssignmentsBuilder, String destinationColumn) {
        ColumnHandle sourceColumnHandle = (ColumnHandle)inverseColumnsMapping.get(destinationColumn);
        if (sourceColumnHandle == null) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.COLUMN_NOT_FOUND, String.format("Did not find mapping for destination column %s in table scan redirection", destinationColumn));
        }
        Symbol symbol = (Symbol)inverseAssignments.get(sourceColumnHandle);
        if (symbol != null) {
            return symbol;
        }
        Type domainType = ((Domain)((Map)requiredFilter.getDomains().get()).get(destinationColumn)).getType();
        symbol = context.getSymbolAllocator().newSymbol(destinationColumn, domainType);
        ColumnHandle destinationColumnHandle = (ColumnHandle)destinationColumnHandles.get(destinationColumn);
        if (destinationColumnHandle == null) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.COLUMN_NOT_FOUND, String.format("Did not find handle for column %s in destination table %s", destinationColumn, destinationTable));
        }
        Type redirectedType = this.plannerContext.getMetadata().getColumnMetadata(context.getSession(), destinationTableHandle, destinationColumnHandle).getType();
        if (!domainType.equals((Object)redirectedType)) {
            Symbol redirectedSymbol = context.getSymbolAllocator().newSymbol(destinationColumn, redirectedType);
            Cast cast = this.getCast(destinationTable, destinationColumn, redirectedType, redirectedSymbol, sourceTable, sourceColumnHandle, domainType);
            casts.put((Object)symbol, (Object)cast);
            newAssignmentsBuilder.put((Object)redirectedSymbol, (Object)destinationColumnHandle);
        } else {
            newAssignmentsBuilder.put((Object)symbol, (Object)destinationColumnHandle);
        }
        return symbol;
    }
}

