/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner.iterative.rule;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Splitter;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.errorprone.annotations.FormatMethod;
import io.airlift.concurrent.MoreFutures;
import io.airlift.slice.Slices;
import io.trino.Session;
import io.trino.SystemSessionProperties;
import io.trino.geospatial.KdbTree;
import io.trino.geospatial.KdbTreeUtils;
import io.trino.matching.Capture;
import io.trino.matching.Captures;
import io.trino.matching.Pattern;
import io.trino.metadata.Metadata;
import io.trino.metadata.QualifiedObjectName;
import io.trino.metadata.ResolvedFunction;
import io.trino.metadata.Split;
import io.trino.metadata.TableHandle;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.Page;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.TrinoException;
import io.trino.spi.connector.ColumnHandle;
import io.trino.spi.connector.ConnectorPageSource;
import io.trino.spi.connector.Constraint;
import io.trino.spi.connector.DynamicFilter;
import io.trino.spi.type.DoubleType;
import io.trino.spi.type.IntegerType;
import io.trino.spi.type.Type;
import io.trino.spi.type.TypeSignature;
import io.trino.spi.type.TypeSignatureParameter;
import io.trino.spi.type.VarcharType;
import io.trino.split.PageSourceManager;
import io.trino.split.SplitManager;
import io.trino.split.SplitSource;
import io.trino.sql.PlannerContext;
import io.trino.sql.ir.Call;
import io.trino.sql.ir.Cast;
import io.trino.sql.ir.Comparison;
import io.trino.sql.ir.Constant;
import io.trino.sql.ir.Expression;
import io.trino.sql.ir.Reference;
import io.trino.sql.planner.BuiltinFunctionCallBuilder;
import io.trino.sql.planner.ExpressionNodeInliner;
import io.trino.sql.planner.ResolvedFunctionCallBuilder;
import io.trino.sql.planner.Symbol;
import io.trino.sql.planner.SymbolsExtractor;
import io.trino.sql.planner.iterative.Rule;
import io.trino.sql.planner.plan.Assignments;
import io.trino.sql.planner.plan.FilterNode;
import io.trino.sql.planner.plan.JoinNode;
import io.trino.sql.planner.plan.JoinType;
import io.trino.sql.planner.plan.Patterns;
import io.trino.sql.planner.plan.PlanNode;
import io.trino.sql.planner.plan.PlanNodeId;
import io.trino.sql.planner.plan.ProjectNode;
import io.trino.sql.planner.plan.SpatialJoinNode;
import io.trino.sql.planner.plan.UnnestNode;
import io.trino.util.SpatialJoinUtils;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.Future;

public class ExtractSpatialJoins {
    private static final TypeSignature GEOMETRY_TYPE_SIGNATURE = new TypeSignature("Geometry", new TypeSignatureParameter[0]);
    private static final TypeSignature SPHERICAL_GEOGRAPHY_TYPE_SIGNATURE = new TypeSignature("SphericalGeography", new TypeSignatureParameter[0]);
    private static final String KDB_TREE_TYPENAME = "KdbTree";
    private final PlannerContext plannerContext;
    private final SplitManager splitManager;
    private final PageSourceManager pageSourceManager;

    public ExtractSpatialJoins(PlannerContext plannerContext, SplitManager splitManager, PageSourceManager pageSourceManager) {
        this.plannerContext = Objects.requireNonNull(plannerContext, "plannerContext is null");
        this.splitManager = Objects.requireNonNull(splitManager, "splitManager is null");
        this.pageSourceManager = Objects.requireNonNull(pageSourceManager, "pageSourceManager is null");
    }

    public Set<Rule<?>> rules() {
        return ImmutableSet.of((Object)new ExtractSpatialInnerJoin(this.plannerContext, this.splitManager, this.pageSourceManager), (Object)new ExtractSpatialLeftJoin(this.plannerContext, this.splitManager, this.pageSourceManager));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static Rule.Result tryCreateSpatialJoin(Rule.Context context, JoinNode joinNode, Expression filter, PlanNodeId nodeId, List<Symbol> outputSymbols, Comparison spatialComparison, PlannerContext plannerContext, SplitManager splitManager, PageSourceManager pageSourceManager) {
        Comparison newComparison;
        Optional<Symbol> newRadiusSymbol;
        Expression radius;
        PlanNode leftNode = joinNode.getLeft();
        PlanNode rightNode = joinNode.getRight();
        List<Symbol> leftSymbols = leftNode.getOutputSymbols();
        List<Symbol> rightSymbols = rightNode.getOutputSymbols();
        if (spatialComparison.operator() == Comparison.Operator.LESS_THAN || spatialComparison.operator() == Comparison.Operator.LESS_THAN_OR_EQUAL) {
            radius = spatialComparison.right();
            radiusSymbols = SymbolsExtractor.extractUnique(radius);
            if (!radiusSymbols.isEmpty() && (!rightSymbols.containsAll(radiusSymbols) || !ExtractSpatialJoins.containsNone(leftSymbols, radiusSymbols))) return Rule.Result.empty();
            newRadiusSymbol = ExtractSpatialJoins.newRadiusSymbol(context, radius);
            newComparison = new Comparison(spatialComparison.operator(), spatialComparison.left(), ExtractSpatialJoins.toExpression(newRadiusSymbol, radius));
        } else {
            radius = spatialComparison.left();
            radiusSymbols = SymbolsExtractor.extractUnique(radius);
            if (!radiusSymbols.isEmpty() && (!rightSymbols.containsAll(radiusSymbols) || !ExtractSpatialJoins.containsNone(leftSymbols, radiusSymbols))) return Rule.Result.empty();
            newRadiusSymbol = ExtractSpatialJoins.newRadiusSymbol(context, radius);
            newComparison = new Comparison(spatialComparison.operator().flip(), spatialComparison.right(), ExtractSpatialJoins.toExpression(newRadiusSymbol, radius));
        }
        Expression newFilter = ExpressionNodeInliner.replaceExpression(filter, (Map<? extends Expression, ? extends Expression>)ImmutableMap.of((Object)spatialComparison, (Object)newComparison));
        PlanNode newRightNode = newRadiusSymbol.map(symbol -> ExtractSpatialJoins.addProjection(context, rightNode, symbol, radius)).orElse(rightNode);
        JoinNode newJoinNode = new JoinNode(joinNode.getId(), joinNode.getType(), leftNode, newRightNode, joinNode.getCriteria(), joinNode.getLeftOutputSymbols(), joinNode.getRightOutputSymbols(), joinNode.isMaySkipOutputDuplicates(), Optional.of(newFilter), joinNode.getLeftHashSymbol(), joinNode.getRightHashSymbol(), joinNode.getDistributionType(), joinNode.isSpillable(), joinNode.getDynamicFilters(), joinNode.getReorderJoinStatsAndCost());
        return ExtractSpatialJoins.tryCreateSpatialJoin(context, newJoinNode, newFilter, nodeId, outputSymbols, (Call)newComparison.left(), Optional.of(newComparison.right()), plannerContext, splitManager, pageSourceManager);
    }

    private static Rule.Result tryCreateSpatialJoin(Rule.Context context, JoinNode joinNode, Expression filter, PlanNodeId nodeId, List<Symbol> outputSymbols, Call spatialFunction, Optional<Expression> radius, PlannerContext plannerContext, SplitManager splitManager, PageSourceManager pageSourceManager) {
        PlanNode newRightNode;
        PlanNode newLeftNode;
        Optional<String> spatialPartitioningTableName = joinNode.getType() == JoinType.INNER ? SystemSessionProperties.getSpatialPartitioningTableName(context.getSession()) : Optional.empty();
        Optional<KdbTree> kdbTree = spatialPartitioningTableName.map(tableName -> ExtractSpatialJoins.loadKdbTree(tableName, context.getSession(), plannerContext.getMetadata(), splitManager, pageSourceManager));
        List<Expression> arguments = spatialFunction.arguments();
        Verify.verify((arguments.size() == 2 ? 1 : 0) != 0);
        Expression firstArgument = arguments.get(0);
        Expression secondArgument = arguments.get(1);
        Type sphericalGeographyType = plannerContext.getTypeManager().getType(SPHERICAL_GEOGRAPHY_TYPE_SIGNATURE);
        if (firstArgument.type().equals((Object)sphericalGeographyType) || secondArgument.type().equals((Object)sphericalGeographyType)) {
            return Rule.Result.empty();
        }
        Set<Symbol> firstSymbols = SymbolsExtractor.extractUnique(firstArgument);
        Set<Symbol> secondSymbols = SymbolsExtractor.extractUnique(secondArgument);
        if (firstSymbols.isEmpty() || secondSymbols.isEmpty()) {
            return Rule.Result.empty();
        }
        Optional<Symbol> newFirstSymbol = ExtractSpatialJoins.newGeometrySymbol(context, firstArgument);
        Optional<Symbol> newSecondSymbol = ExtractSpatialJoins.newGeometrySymbol(context, secondArgument);
        PlanNode leftNode = joinNode.getLeft();
        PlanNode rightNode = joinNode.getRight();
        int alignment = ExtractSpatialJoins.checkAlignment(joinNode, firstSymbols, secondSymbols);
        if (alignment > 0) {
            newLeftNode = newFirstSymbol.map(symbol -> ExtractSpatialJoins.addProjection(context, leftNode, symbol, firstArgument)).orElse(leftNode);
            newRightNode = newSecondSymbol.map(symbol -> ExtractSpatialJoins.addProjection(context, rightNode, symbol, secondArgument)).orElse(rightNode);
        } else if (alignment < 0) {
            newLeftNode = newSecondSymbol.map(symbol -> ExtractSpatialJoins.addProjection(context, leftNode, symbol, secondArgument)).orElse(leftNode);
            newRightNode = newFirstSymbol.map(symbol -> ExtractSpatialJoins.addProjection(context, rightNode, symbol, firstArgument)).orElse(rightNode);
        } else {
            return Rule.Result.empty();
        }
        Expression newFirstArgument = ExtractSpatialJoins.toExpression(newFirstSymbol, firstArgument);
        Expression newSecondArgument = ExtractSpatialJoins.toExpression(newSecondSymbol, secondArgument);
        Optional<Object> leftPartitionSymbol = Optional.empty();
        Optional<Symbol> rightPartitionSymbol = Optional.empty();
        if (kdbTree.isPresent()) {
            leftPartitionSymbol = Optional.of(context.getSymbolAllocator().newSymbol("pid", (Type)IntegerType.INTEGER));
            rightPartitionSymbol = Optional.of(context.getSymbolAllocator().newSymbol("pid", (Type)IntegerType.INTEGER));
            if (alignment > 0) {
                newLeftNode = ExtractSpatialJoins.addPartitioningNodes(plannerContext, context, newLeftNode, (Symbol)leftPartitionSymbol.get(), kdbTree.get(), newFirstArgument, Optional.empty());
                newRightNode = ExtractSpatialJoins.addPartitioningNodes(plannerContext, context, newRightNode, rightPartitionSymbol.get(), kdbTree.get(), newSecondArgument, radius);
            } else {
                newLeftNode = ExtractSpatialJoins.addPartitioningNodes(plannerContext, context, newLeftNode, (Symbol)leftPartitionSymbol.get(), kdbTree.get(), newSecondArgument, Optional.empty());
                newRightNode = ExtractSpatialJoins.addPartitioningNodes(plannerContext, context, newRightNode, rightPartitionSymbol.get(), kdbTree.get(), newFirstArgument, radius);
            }
        }
        ResolvedFunction resolvedFunction = spatialFunction.function();
        Call newSpatialFunction = ResolvedFunctionCallBuilder.builder(resolvedFunction).addArgument(newFirstArgument).addArgument(newSecondArgument).build();
        Expression newFilter = ExpressionNodeInliner.replaceExpression(filter, (Map<? extends Expression, ? extends Expression>)ImmutableMap.of((Object)spatialFunction, (Object)newSpatialFunction));
        return Rule.Result.ofPlanNode(new SpatialJoinNode(nodeId, SpatialJoinNode.Type.fromJoinNodeType(joinNode.getType()), newLeftNode, newRightNode, outputSymbols, newFilter, leftPartitionSymbol, rightPartitionSymbol, kdbTree.map(KdbTreeUtils::toJson)));
    }

    private static KdbTree loadKdbTree(String tableName, Session session, Metadata metadata, SplitManager splitManager, PageSourceManager pageSourceManager) {
        QualifiedObjectName name = ExtractSpatialJoins.toQualifiedObjectName(tableName, session.getCatalog().get(), session.getSchema().get());
        TableHandle tableHandle = metadata.getTableHandle(session, name).orElseThrow(() -> new TrinoException((ErrorCodeSupplier)StandardErrorCode.INVALID_SPATIAL_PARTITIONING, String.format("Table not found: %s", name)));
        Map<String, ColumnHandle> columnHandles = metadata.getColumnHandles(session, tableHandle);
        List visibleColumnHandles = (List)columnHandles.values().stream().filter(handle -> !metadata.getColumnMetadata(session, tableHandle, (ColumnHandle)handle).isHidden()).collect(ImmutableList.toImmutableList());
        ExtractSpatialJoins.checkSpatialPartitioningTable(visibleColumnHandles.size() == 1, "Expected single column for table %s, but found %s columns", name, columnHandles.size());
        ColumnHandle kdbTreeColumn = (ColumnHandle)Iterables.getOnlyElement((Iterable)visibleColumnHandles);
        Optional<Object> kdbTree = Optional.empty();
        try (SplitSource splitSource = splitManager.getSplits(session, session.getQuerySpan(), tableHandle, DynamicFilter.EMPTY, Constraint.alwaysTrue());){
            while (!Thread.currentThread().isInterrupted()) {
                SplitSource.SplitBatch splitBatch = (SplitSource.SplitBatch)MoreFutures.getFutureValue(splitSource.getNextBatch(1000));
                List<Split> splits = splitBatch.getSplits();
                for (Split split : splits) {
                    try {
                        ConnectorPageSource pageSource = pageSourceManager.createPageSource(session, split, tableHandle, (List<ColumnHandle>)ImmutableList.of((Object)kdbTreeColumn), DynamicFilter.EMPTY);
                        try {
                            do {
                                MoreFutures.getFutureValue((Future)pageSource.isBlocked());
                                Page page = pageSource.getNextPage();
                                if (page == null || page.getPositionCount() <= 0) continue;
                                ExtractSpatialJoins.checkSpatialPartitioningTable(kdbTree.isEmpty(), "Expected exactly one row for table %s, but found more", name);
                                ExtractSpatialJoins.checkSpatialPartitioningTable(page.getPositionCount() == 1, "Expected exactly one row for table %s, but found %s rows", name, page.getPositionCount());
                                String kdbTreeJson = VarcharType.VARCHAR.getSlice(page.getBlock(0), 0).toStringUtf8();
                                try {
                                    kdbTree = Optional.of(KdbTreeUtils.fromJson((String)kdbTreeJson));
                                }
                                catch (IllegalArgumentException e) {
                                    ExtractSpatialJoins.checkSpatialPartitioningTable(false, "Invalid JSON string for KDB tree: %s", e.getMessage());
                                }
                            } while (!pageSource.isFinished());
                        }
                        finally {
                            if (pageSource == null) continue;
                            pageSource.close();
                        }
                    }
                    catch (IOException e) {
                        throw new UncheckedIOException(e);
                    }
                }
                if (!splitBatch.isLastBatch()) continue;
                break;
            }
        }
        ExtractSpatialJoins.checkSpatialPartitioningTable(kdbTree.isPresent(), "Expected exactly one row for table %s, but got none", name);
        return (KdbTree)kdbTree.get();
    }

    @FormatMethod
    private static void checkSpatialPartitioningTable(boolean condition, String message, Object ... arguments) {
        if (!condition) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.INVALID_SPATIAL_PARTITIONING, String.format(message, arguments));
        }
    }

    private static QualifiedObjectName toQualifiedObjectName(String name, String catalog, String schema) {
        ImmutableList ids = ImmutableList.copyOf((Iterable)Splitter.on((char)'.').split((CharSequence)name));
        if (ids.size() == 3) {
            return new QualifiedObjectName((String)ids.get(0), (String)ids.get(1), (String)ids.get(2));
        }
        if (ids.size() == 2) {
            return new QualifiedObjectName(catalog, (String)ids.get(0), (String)ids.get(1));
        }
        if (ids.size() == 1) {
            return new QualifiedObjectName(catalog, schema, (String)ids.get(0));
        }
        throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.INVALID_SPATIAL_PARTITIONING, String.format("Invalid name: %s", name));
    }

    private static int checkAlignment(JoinNode joinNode, Set<Symbol> maybeLeftSymbols, Set<Symbol> maybeRightSymbols) {
        List<Symbol> leftSymbols = joinNode.getLeft().getOutputSymbols();
        List<Symbol> rightSymbols = joinNode.getRight().getOutputSymbols();
        if (leftSymbols.containsAll(maybeLeftSymbols) && ExtractSpatialJoins.containsNone(leftSymbols, maybeRightSymbols) && rightSymbols.containsAll(maybeRightSymbols) && ExtractSpatialJoins.containsNone(rightSymbols, maybeLeftSymbols)) {
            return 1;
        }
        if (leftSymbols.containsAll(maybeRightSymbols) && ExtractSpatialJoins.containsNone(leftSymbols, maybeLeftSymbols) && rightSymbols.containsAll(maybeLeftSymbols) && ExtractSpatialJoins.containsNone(rightSymbols, maybeRightSymbols)) {
            return -1;
        }
        return 0;
    }

    private static Expression toExpression(Optional<Symbol> optionalSymbol, Expression defaultExpression) {
        return optionalSymbol.map(symbol -> symbol.toSymbolReference()).orElse(defaultExpression);
    }

    private static Optional<Symbol> newGeometrySymbol(Rule.Context context, Expression expression) {
        if (expression instanceof Reference) {
            return Optional.empty();
        }
        return Optional.of(context.getSymbolAllocator().newSymbol(expression));
    }

    private static Optional<Symbol> newRadiusSymbol(Rule.Context context, Expression expression) {
        if (expression instanceof Reference) {
            return Optional.empty();
        }
        return Optional.of(context.getSymbolAllocator().newSymbol(expression));
    }

    private static PlanNode addProjection(Rule.Context context, PlanNode node, Symbol symbol, Expression expression) {
        Assignments.Builder projections = Assignments.builder();
        for (Symbol outputSymbol : node.getOutputSymbols()) {
            projections.putIdentity(outputSymbol);
        }
        projections.put(symbol, expression);
        return new ProjectNode(context.getIdAllocator().getNextId(), node, projections.build());
    }

    private static PlanNode addPartitioningNodes(PlannerContext plannerContext, Rule.Context context, PlanNode node, Symbol partitionSymbol, KdbTree kdbTree, Expression geometry, Optional<Expression> radius) {
        Assignments.Builder projections = Assignments.builder();
        for (Symbol outputSymbol : node.getOutputSymbols()) {
            projections.putIdentity(outputSymbol);
        }
        TypeSignature typeSignature = new TypeSignature(KDB_TREE_TYPENAME, new TypeSignatureParameter[0]);
        BuiltinFunctionCallBuilder spatialPartitionsCall = BuiltinFunctionCallBuilder.resolve(plannerContext.getMetadata()).setName("spatial_partitions").addArgument(typeSignature, (Expression)new Cast(new Constant((Type)VarcharType.VARCHAR, Slices.utf8Slice((String)KdbTreeUtils.toJson((KdbTree)kdbTree))), plannerContext.getTypeManager().getType(typeSignature))).addArgument(GEOMETRY_TYPE_SIGNATURE, geometry);
        radius.ifPresent(value -> spatialPartitionsCall.addArgument((Type)DoubleType.DOUBLE, (Expression)value));
        Call partitioningFunction = spatialPartitionsCall.build();
        Symbol partitionsSymbol = context.getSymbolAllocator().newSymbol(partitioningFunction);
        projections.put(partitionsSymbol, partitioningFunction);
        return new UnnestNode(context.getIdAllocator().getNextId(), new ProjectNode(context.getIdAllocator().getNextId(), node, projections.build()), node.getOutputSymbols(), (List<UnnestNode.Mapping>)ImmutableList.of((Object)new UnnestNode.Mapping(partitionsSymbol, (List<Symbol>)ImmutableList.of((Object)partitionSymbol))), Optional.empty(), JoinType.INNER);
    }

    private static boolean containsNone(Collection<Symbol> values, Collection<Symbol> testValues) {
        return values.stream().noneMatch(arg_0 -> ((ImmutableSet)ImmutableSet.copyOf(testValues)).contains(arg_0));
    }

    @VisibleForTesting
    public static final class ExtractSpatialInnerJoin
    implements Rule<FilterNode> {
        private static final Capture<JoinNode> JOIN = Capture.newCapture();
        private static final Pattern<FilterNode> PATTERN = Patterns.filter().with(Patterns.source().matching(Patterns.join().capturedAs(JOIN).matching(JoinNode::isCrossJoin)));
        private final PlannerContext plannerContext;
        private final SplitManager splitManager;
        private final PageSourceManager pageSourceManager;

        public ExtractSpatialInnerJoin(PlannerContext plannerContext, SplitManager splitManager, PageSourceManager pageSourceManager) {
            this.plannerContext = Objects.requireNonNull(plannerContext, "plannerContext is null");
            this.splitManager = Objects.requireNonNull(splitManager, "splitManager is null");
            this.pageSourceManager = Objects.requireNonNull(pageSourceManager, "pageSourceManager is null");
        }

        @Override
        public boolean isEnabled(Session session) {
            return SystemSessionProperties.isSpatialJoinEnabled(session);
        }

        @Override
        public Pattern<FilterNode> getPattern() {
            return PATTERN;
        }

        @Override
        public Rule.Result apply(FilterNode node, Captures captures, Rule.Context context) {
            JoinNode joinNode = (JoinNode)captures.get(JOIN);
            Expression filter = node.getPredicate();
            List<Call> spatialFunctions = SpatialJoinUtils.extractSupportedSpatialFunctions(filter);
            for (Call spatialFunction : spatialFunctions) {
                Rule.Result result = ExtractSpatialJoins.tryCreateSpatialJoin(context, joinNode, filter, node.getId(), node.getOutputSymbols(), spatialFunction, Optional.empty(), this.plannerContext, this.splitManager, this.pageSourceManager);
                if (result.isEmpty()) continue;
                return result;
            }
            List<Comparison> spatialComparisons = SpatialJoinUtils.extractSupportedSpatialComparisons(filter);
            for (Comparison spatialComparison : spatialComparisons) {
                Rule.Result result = ExtractSpatialJoins.tryCreateSpatialJoin(context, joinNode, filter, node.getId(), node.getOutputSymbols(), spatialComparison, this.plannerContext, this.splitManager, this.pageSourceManager);
                if (result.isEmpty()) continue;
                return result;
            }
            return Rule.Result.empty();
        }
    }

    @VisibleForTesting
    public static final class ExtractSpatialLeftJoin
    implements Rule<JoinNode> {
        private static final Pattern<JoinNode> PATTERN = Patterns.join().matching(node -> node.getCriteria().isEmpty() && node.getFilter().isPresent() && node.getType() == JoinType.LEFT);
        private final PlannerContext plannerContext;
        private final SplitManager splitManager;
        private final PageSourceManager pageSourceManager;

        public ExtractSpatialLeftJoin(PlannerContext plannerContext, SplitManager splitManager, PageSourceManager pageSourceManager) {
            this.plannerContext = Objects.requireNonNull(plannerContext, "plannerContext is null");
            this.splitManager = Objects.requireNonNull(splitManager, "splitManager is null");
            this.pageSourceManager = Objects.requireNonNull(pageSourceManager, "pageSourceManager is null");
        }

        @Override
        public boolean isEnabled(Session session) {
            return SystemSessionProperties.isSpatialJoinEnabled(session);
        }

        @Override
        public Pattern<JoinNode> getPattern() {
            return PATTERN;
        }

        @Override
        public Rule.Result apply(JoinNode joinNode, Captures captures, Rule.Context context) {
            Expression filter = joinNode.getFilter().get();
            List<Call> spatialFunctions = SpatialJoinUtils.extractSupportedSpatialFunctions(filter);
            for (Call spatialFunction : spatialFunctions) {
                Rule.Result result = ExtractSpatialJoins.tryCreateSpatialJoin(context, joinNode, filter, joinNode.getId(), joinNode.getOutputSymbols(), spatialFunction, Optional.empty(), this.plannerContext, this.splitManager, this.pageSourceManager);
                if (result.isEmpty()) continue;
                return result;
            }
            List<Comparison> spatialComparisons = SpatialJoinUtils.extractSupportedSpatialComparisons(filter);
            for (Comparison spatialComparison : spatialComparisons) {
                Rule.Result result = ExtractSpatialJoins.tryCreateSpatialJoin(context, joinNode, filter, joinNode.getId(), joinNode.getOutputSymbols(), spatialComparison, this.plannerContext, this.splitManager, this.pageSourceManager);
                if (result.isEmpty()) continue;
                return result;
            }
            return Rule.Result.empty();
        }
    }
}

