/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner.iterative.rule;

import com.google.common.collect.ImmutableList;
import io.trino.matching.Captures;
import io.trino.matching.Pattern;
import io.trino.sql.ir.Expression;
import io.trino.sql.planner.iterative.Rule;
import io.trino.sql.planner.optimizations.QueryCardinalityUtil;
import io.trino.sql.planner.plan.OffsetNode;
import io.trino.sql.planner.plan.Patterns;
import io.trino.sql.planner.plan.ValuesNode;
import java.util.List;

public class RemoveRedundantOffset
implements Rule<OffsetNode> {
    private static final Pattern<OffsetNode> PATTERN = Patterns.offset();

    @Override
    public Pattern<OffsetNode> getPattern() {
        return PATTERN;
    }

    @Override
    public Rule.Result apply(OffsetNode offset, Captures captures, Rule.Context context) {
        if (QueryCardinalityUtil.isAtMost(offset.getSource(), context.getLookup(), offset.getCount())) {
            return Rule.Result.ofPlanNode(new ValuesNode(offset.getId(), offset.getOutputSymbols(), (List<Expression>)ImmutableList.of()));
        }
        if (offset.getCount() == 0L) {
            return Rule.Result.ofPlanNode(offset.getSource());
        }
        return Rule.Result.empty();
    }
}

