/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner.iterative.rule;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import io.trino.Session;
import io.trino.metadata.GlobalFunctionCatalog;
import io.trino.spi.type.BooleanType;
import io.trino.spi.type.DateType;
import io.trino.spi.type.LongTimestamp;
import io.trino.spi.type.TimestampType;
import io.trino.spi.type.TimestampWithTimeZoneType;
import io.trino.spi.type.Type;
import io.trino.sql.PlannerContext;
import io.trino.sql.ir.Between;
import io.trino.sql.ir.Call;
import io.trino.sql.ir.Comparison;
import io.trino.sql.ir.Constant;
import io.trino.sql.ir.Expression;
import io.trino.sql.ir.ExpressionRewriter;
import io.trino.sql.ir.ExpressionTreeRewriter;
import io.trino.sql.ir.In;
import io.trino.sql.ir.IrUtils;
import io.trino.sql.ir.IsNull;
import io.trino.sql.ir.Logical;
import io.trino.sql.ir.Not;
import io.trino.sql.planner.IrExpressionInterpreter;
import io.trino.sql.planner.iterative.rule.ExpressionRewriteRuleSet;
import io.trino.type.DateTimes;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.time.temporal.TemporalAdjusters;
import java.util.Collection;
import java.util.Objects;

public class UnwrapYearInComparison
extends ExpressionRewriteRuleSet {
    public UnwrapYearInComparison(PlannerContext plannerContext) {
        super(UnwrapYearInComparison.createRewrite(plannerContext));
    }

    private static ExpressionRewriteRuleSet.ExpressionRewriter createRewrite(PlannerContext plannerContext) {
        Objects.requireNonNull(plannerContext, "plannerContext is null");
        return (expression, context) -> UnwrapYearInComparison.unwrapYear(context.getSession(), plannerContext, expression);
    }

    private static Expression unwrapYear(Session session, PlannerContext plannerContext, Expression expression) {
        return ExpressionTreeRewriter.rewriteWith(new Visitor(plannerContext, session), expression);
    }

    private static Object calculateRangeStartInclusive(int year, Type type) {
        if (type == DateType.DATE) {
            LocalDate firstDay = LocalDate.ofYearDay(year, 1);
            return firstDay.toEpochDay();
        }
        if (type instanceof TimestampType) {
            TimestampType timestampType = (TimestampType)type;
            long yearStartEpochSecond = LocalDateTime.of(year, 1, 1, 0, 0).toEpochSecond(ZoneOffset.UTC);
            long yearStartEpochMicros = Math.multiplyExact(yearStartEpochSecond, 1000000);
            if (timestampType.isShort()) {
                return yearStartEpochMicros;
            }
            return new LongTimestamp(yearStartEpochMicros, 0);
        }
        throw new UnsupportedOperationException("Unsupported type: " + String.valueOf(type));
    }

    @VisibleForTesting
    public static Object calculateRangeEndInclusive(int year, Type type) {
        if (type == DateType.DATE) {
            LocalDate lastDay = LocalDate.ofYearDay(year, 1).with(TemporalAdjusters.lastDayOfYear());
            return lastDay.toEpochDay();
        }
        if (type instanceof TimestampType) {
            TimestampType timestampType = (TimestampType)type;
            long nextYearStartEpochSecond = LocalDateTime.of(year + 1, 1, 1, 0, 0).toEpochSecond(ZoneOffset.UTC);
            long nextYearStartEpochMicros = Math.multiplyExact(nextYearStartEpochSecond, 1000000);
            if (timestampType.isShort()) {
                return nextYearStartEpochMicros - DateTimes.scaleFactor(timestampType.getPrecision(), 6);
            }
            int picosOfMicro = Math.toIntExact(1000000L - DateTimes.scaleFactor(timestampType.getPrecision(), 12));
            return new LongTimestamp(nextYearStartEpochMicros - 1L, picosOfMicro);
        }
        throw new UnsupportedOperationException("Unsupported type: " + String.valueOf(type));
    }

    private static class Visitor
    extends ExpressionRewriter<Void> {
        private final PlannerContext plannerContext;
        private final Session session;

        public Visitor(PlannerContext plannerContext, Session session) {
            this.plannerContext = Objects.requireNonNull(plannerContext, "plannerContext is null");
            this.session = Objects.requireNonNull(session, "session is null");
        }

        @Override
        public Expression rewriteComparison(Comparison node, Void context, ExpressionTreeRewriter<Void> treeRewriter) {
            Comparison expression = treeRewriter.defaultRewrite(node, null);
            return this.unwrapYear(expression);
        }

        @Override
        public Expression rewriteIn(In node, Void context, ExpressionTreeRewriter<Void> treeRewriter) {
            Call call;
            In in = treeRewriter.defaultRewrite(node, null);
            Expression value = in.value();
            if (!(value instanceof Call) || !(call = (Call)value).function().name().equals((Object)GlobalFunctionCatalog.builtinFunctionName("year")) || call.arguments().size() != 1) {
                return in;
            }
            ImmutableList.Builder comparisonExpressions = ImmutableList.builderWithExpectedSize((int)node.valueList().size());
            for (Expression rightExpression : node.valueList()) {
                Comparison comparison = new Comparison(Comparison.Operator.EQUAL, value, rightExpression);
                Expression unwrappedExpression = this.unwrapYear(comparison);
                if (unwrappedExpression == comparison) {
                    return in;
                }
                comparisonExpressions.add((Object)unwrappedExpression);
            }
            return IrUtils.or((Collection<Expression>)comparisonExpressions.build());
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private Expression unwrapYear(Comparison expression) {
            Object object;
            Constant constant;
            Call call;
            Expression expression2 = expression.left();
            if (!(expression2 instanceof Call) || !(call = (Call)expression2).function().name().equals((Object)GlobalFunctionCatalog.builtinFunctionName("year")) || call.arguments().size() != 1) {
                return expression;
            }
            Expression argument = (Expression)Iterables.getOnlyElement(call.arguments());
            Type argumentType = argument.type();
            Expression right = new IrExpressionInterpreter(expression.right(), this.plannerContext, this.session).optimize();
            if (right instanceof Constant && (constant = (Constant)right).value() == null) {
                Record record;
                switch (expression.operator()) {
                    default: {
                        throw new MatchException(null, null);
                    }
                    case EQUAL: 
                    case NOT_EQUAL: 
                    case LESS_THAN: 
                    case LESS_THAN_OR_EQUAL: 
                    case GREATER_THAN: 
                    case GREATER_THAN_OR_EQUAL: {
                        record = new Constant((Type)BooleanType.BOOLEAN, null);
                        return record;
                    }
                    case IDENTICAL: {
                        record = new IsNull(argument);
                    }
                }
                return record;
            }
            if (!(right instanceof Constant)) return expression;
            Constant constant2 = (Constant)right;
            try {
                Type rightType = object = constant2.type();
            }
            catch (Throwable throwable) {
                throw new MatchException(throwable.toString(), throwable);
            }
            Object rightValue = object = constant2.value();
            if (argumentType instanceof TimestampWithTimeZoneType) {
                return expression;
            }
            if (argumentType != DateType.DATE && !(argumentType instanceof TimestampType)) {
                return expression;
            }
            int year = Math.toIntExact((Long)rightValue);
            switch (expression.operator()) {
                default: {
                    throw new MatchException(null, null);
                }
                case EQUAL: {
                    Record record = this.between(argument, argumentType, UnwrapYearInComparison.calculateRangeStartInclusive(year, argumentType), UnwrapYearInComparison.calculateRangeEndInclusive(year, argumentType));
                    return record;
                }
                case NOT_EQUAL: {
                    Record record = new Not(this.between(argument, argumentType, UnwrapYearInComparison.calculateRangeStartInclusive(year, argumentType), UnwrapYearInComparison.calculateRangeEndInclusive(year, argumentType)));
                    return record;
                }
                case IDENTICAL: {
                    Record record = Logical.and(new Not(new IsNull(argument)), this.between(argument, argumentType, UnwrapYearInComparison.calculateRangeStartInclusive(year, argumentType), UnwrapYearInComparison.calculateRangeEndInclusive(year, argumentType)));
                    return record;
                }
                case LESS_THAN: {
                    Object value = UnwrapYearInComparison.calculateRangeStartInclusive(year, argumentType);
                    Record record = new Comparison(Comparison.Operator.LESS_THAN, argument, new Constant(argumentType, value));
                    return record;
                }
                case LESS_THAN_OR_EQUAL: {
                    Object value = UnwrapYearInComparison.calculateRangeEndInclusive(year, argumentType);
                    Record record = new Comparison(Comparison.Operator.LESS_THAN_OR_EQUAL, argument, new Constant(argumentType, value));
                    return record;
                }
                case GREATER_THAN: {
                    Object value = UnwrapYearInComparison.calculateRangeEndInclusive(year, argumentType);
                    Record record = new Comparison(Comparison.Operator.GREATER_THAN, argument, new Constant(argumentType, value));
                    return record;
                }
                case GREATER_THAN_OR_EQUAL: {
                    Object value = UnwrapYearInComparison.calculateRangeStartInclusive(year, argumentType);
                    Record record = new Comparison(Comparison.Operator.GREATER_THAN_OR_EQUAL, argument, new Constant(argumentType, value));
                    return record;
                }
            }
        }

        private Between between(Expression argument, Type type, Object minInclusive, Object maxInclusive) {
            return new Between(argument, new Constant(type, minInclusive), new Constant(type, maxInclusive));
        }
    }
}

