/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner.planprinter;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import io.trino.sql.ir.Booleans;
import io.trino.sql.ir.Comparison;
import io.trino.sql.ir.Expression;
import io.trino.sql.ir.Reference;
import io.trino.sql.planner.Partitioning;
import io.trino.sql.planner.PlanFragment;
import io.trino.sql.planner.SubPlan;
import io.trino.sql.planner.Symbol;
import io.trino.sql.planner.plan.AggregationNode;
import io.trino.sql.planner.plan.ApplyNode;
import io.trino.sql.planner.plan.AssignUniqueId;
import io.trino.sql.planner.plan.CorrelatedJoinNode;
import io.trino.sql.planner.plan.DistinctLimitNode;
import io.trino.sql.planner.plan.DynamicFilterSourceNode;
import io.trino.sql.planner.plan.EnforceSingleRowNode;
import io.trino.sql.planner.plan.ExchangeNode;
import io.trino.sql.planner.plan.FilterNode;
import io.trino.sql.planner.plan.GroupIdNode;
import io.trino.sql.planner.plan.IndexJoinNode;
import io.trino.sql.planner.plan.IndexSourceNode;
import io.trino.sql.planner.plan.JoinNode;
import io.trino.sql.planner.plan.LimitNode;
import io.trino.sql.planner.plan.MarkDistinctNode;
import io.trino.sql.planner.plan.OutputNode;
import io.trino.sql.planner.plan.PatternRecognitionNode;
import io.trino.sql.planner.plan.PlanFragmentId;
import io.trino.sql.planner.plan.PlanNode;
import io.trino.sql.planner.plan.PlanVisitor;
import io.trino.sql.planner.plan.ProjectNode;
import io.trino.sql.planner.plan.RemoteSourceNode;
import io.trino.sql.planner.plan.RowNumberNode;
import io.trino.sql.planner.plan.SampleNode;
import io.trino.sql.planner.plan.SemiJoinNode;
import io.trino.sql.planner.plan.SortNode;
import io.trino.sql.planner.plan.SpatialJoinNode;
import io.trino.sql.planner.plan.StatisticsWriterNode;
import io.trino.sql.planner.plan.TableFinishNode;
import io.trino.sql.planner.plan.TableScanNode;
import io.trino.sql.planner.plan.TableWriterNode;
import io.trino.sql.planner.plan.TopNNode;
import io.trino.sql.planner.plan.TopNRankingNode;
import io.trino.sql.planner.plan.UnionNode;
import io.trino.sql.planner.plan.UnnestNode;
import io.trino.sql.planner.plan.ValuesNode;
import io.trino.sql.planner.plan.WindowNode;
import io.trino.sql.planner.planprinter.NoOpAnonymizer;
import io.trino.sql.planner.planprinter.PlanPrinter;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public final class GraphvizPrinter {
    private static final Map<NodeType, String> NODE_COLORS = Maps.immutableEnumMap((Map)ImmutableMap.builder().put((Object)NodeType.EXCHANGE, (Object)"gold").put((Object)NodeType.AGGREGATE, (Object)"chartreuse3").put((Object)NodeType.FILTER, (Object)"yellow").put((Object)NodeType.PROJECT, (Object)"bisque").put((Object)NodeType.TOPN, (Object)"darksalmon").put((Object)NodeType.OUTPUT, (Object)"white").put((Object)NodeType.LIMIT, (Object)"gray83").put((Object)NodeType.TABLESCAN, (Object)"deepskyblue").put((Object)NodeType.VALUES, (Object)"deepskyblue").put((Object)NodeType.JOIN, (Object)"orange").put((Object)NodeType.SORT, (Object)"aliceblue").put((Object)NodeType.SINK, (Object)"indianred1").put((Object)NodeType.WINDOW, (Object)"darkolivegreen4").put((Object)NodeType.UNION, (Object)"turquoise4").put((Object)NodeType.MARK_DISTINCT, (Object)"violet").put((Object)NodeType.TABLE_WRITER, (Object)"cyan").put((Object)NodeType.TABLE_FINISH, (Object)"hotpink").put((Object)NodeType.INDEX_SOURCE, (Object)"dodgerblue3").put((Object)NodeType.UNNEST, (Object)"crimson").put((Object)NodeType.SAMPLE, (Object)"goldenrod4").put((Object)NodeType.ANALYZE_FINISH, (Object)"plum").put((Object)NodeType.DYNAMIC_FILTER_SOURCE, (Object)"magenta").buildOrThrow());

    private GraphvizPrinter() {
    }

    public static String printLogical(List<PlanFragment> fragments) {
        ImmutableMap fragmentsById = Maps.uniqueIndex(fragments, PlanFragment::getId);
        PlanNodeIdGenerator idGenerator = new PlanNodeIdGenerator();
        StringBuilder output = new StringBuilder();
        output.append("digraph logical_plan {\n");
        for (PlanFragment fragment : fragments) {
            GraphvizPrinter.printFragmentNodes(output, fragment, idGenerator);
        }
        for (PlanFragment fragment : fragments) {
            fragment.getRoot().accept(new EdgePrinter(output, (Map<PlanFragmentId, PlanFragment>)fragmentsById, idGenerator), null);
        }
        output.append("}\n");
        return output.toString();
    }

    public static String printDistributed(SubPlan plan) {
        List<PlanFragment> fragments = plan.getAllFragments();
        ImmutableMap fragmentsById = Maps.uniqueIndex(fragments, PlanFragment::getId);
        PlanNodeIdGenerator idGenerator = new PlanNodeIdGenerator();
        StringBuilder output = new StringBuilder();
        output.append("digraph distributed_plan {\n");
        GraphvizPrinter.printSubPlan(plan, (Map<PlanFragmentId, PlanFragment>)fragmentsById, idGenerator, output);
        output.append("}\n");
        return output.toString();
    }

    private static void printSubPlan(SubPlan plan, Map<PlanFragmentId, PlanFragment> fragmentsById, PlanNodeIdGenerator idGenerator, StringBuilder output) {
        PlanFragment fragment = plan.getFragment();
        GraphvizPrinter.printFragmentNodes(output, fragment, idGenerator);
        fragment.getRoot().accept(new EdgePrinter(output, fragmentsById, idGenerator), null);
        for (SubPlan child : plan.getChildren()) {
            GraphvizPrinter.printSubPlan(child, fragmentsById, idGenerator, output);
        }
    }

    private static void printFragmentNodes(StringBuilder output, PlanFragment fragment, PlanNodeIdGenerator idGenerator) {
        String clusterId = "cluster_" + String.valueOf(fragment.getId());
        output.append("subgraph ").append(clusterId).append(" {").append('\n');
        output.append(String.format("label = \"%s\"", fragment.getPartitioning())).append('\n');
        PlanNode plan = fragment.getRoot();
        plan.accept(new NodePrinter(output, idGenerator), null);
        output.append("}").append('\n');
    }

    static {
        Preconditions.checkState((NODE_COLORS.size() == NodeType.values().length ? 1 : 0) != 0);
    }

    private static class PlanNodeIdGenerator {
        private final Map<PlanNode, Integer> planNodeIds = new HashMap<PlanNode, Integer>();
        private int idCount;

        public String getNodeId(PlanNode from) {
            int nodeId;
            if (this.planNodeIds.containsKey(from)) {
                nodeId = this.planNodeIds.get(from);
            } else {
                ++this.idCount;
                this.planNodeIds.put(from, this.idCount);
                nodeId = this.idCount;
            }
            return "plannode_" + nodeId;
        }
    }

    private static class EdgePrinter
    extends PlanVisitor<Void, Void> {
        private final StringBuilder output;
        private final Map<PlanFragmentId, PlanFragment> fragmentsById;
        private final PlanNodeIdGenerator idGenerator;

        public EdgePrinter(StringBuilder output, Map<PlanFragmentId, PlanFragment> fragmentsById, PlanNodeIdGenerator idGenerator) {
            this.output = output;
            this.fragmentsById = ImmutableMap.copyOf(fragmentsById);
            this.idGenerator = idGenerator;
        }

        @Override
        protected Void visitPlan(PlanNode node, Void context) {
            for (PlanNode child : node.getSources()) {
                this.printEdge(node, child);
                child.accept(this, context);
            }
            return null;
        }

        @Override
        public Void visitRemoteSource(RemoteSourceNode node, Void context) {
            for (PlanFragmentId planFragmentId : node.getSourceFragmentIds()) {
                PlanFragment target = this.fragmentsById.get(planFragmentId);
                this.printEdge(node, target.getRoot());
            }
            return null;
        }

        private void printEdge(PlanNode from, PlanNode to) {
            String fromId = this.idGenerator.getNodeId(from);
            String toId = this.idGenerator.getNodeId(to);
            this.output.append(fromId).append(" -> ").append(toId).append(';').append('\n');
        }
    }

    private static class NodePrinter
    extends PlanVisitor<Void, Void> {
        private static final int MAX_NAME_WIDTH = 100;
        private final StringBuilder output;
        private final PlanNodeIdGenerator idGenerator;

        public NodePrinter(StringBuilder output, PlanNodeIdGenerator idGenerator) {
            this.output = output;
            this.idGenerator = idGenerator;
        }

        @Override
        protected Void visitPlan(PlanNode node, Void context) {
            throw new UnsupportedOperationException(String.format("Node %s does not have a Graphviz visitor", node.getClass().getName()));
        }

        @Override
        public Void visitTableWriter(TableWriterNode node, Void context) {
            ArrayList<CallSite> columns = new ArrayList<CallSite>();
            for (int i = 0; i < node.getColumnNames().size(); ++i) {
                columns.add((CallSite)((Object)(node.getColumnNames().get(i) + " := " + String.valueOf(node.getColumns().get(i)))));
            }
            this.printNode(node, String.format("TableWriter[%s]", Joiner.on((String)", ").join(columns)), NODE_COLORS.get((Object)NodeType.TABLE_WRITER));
            return node.getSource().accept(this, context);
        }

        @Override
        public Void visitStatisticsWriterNode(StatisticsWriterNode node, Void context) {
            this.printNode(node, String.format("StatisticsWriterNode[%s]", Joiner.on((String)", ").join(node.getOutputSymbols())), NODE_COLORS.get((Object)NodeType.ANALYZE_FINISH));
            return node.getSource().accept(this, context);
        }

        @Override
        public Void visitTableFinish(TableFinishNode node, Void context) {
            this.printNode(node, String.format("TableFinish[%s]", Joiner.on((String)", ").join(node.getOutputSymbols())), NODE_COLORS.get((Object)NodeType.TABLE_FINISH));
            return node.getSource().accept(this, context);
        }

        @Override
        public Void visitSample(SampleNode node, Void context) {
            this.printNode(node, String.format("Sample[type=%s, ratio=%f]", new Object[]{node.getSampleType(), node.getSampleRatio()}), NODE_COLORS.get((Object)NodeType.SAMPLE));
            return node.getSource().accept(this, context);
        }

        @Override
        public Void visitSort(SortNode node, Void context) {
            this.printNode(node, String.format("Sort[%s]", Joiner.on((String)", ").join(node.getOrderingScheme().orderBy())), NODE_COLORS.get((Object)NodeType.SORT));
            return node.getSource().accept(this, context);
        }

        @Override
        public Void visitMarkDistinct(MarkDistinctNode node, Void context) {
            this.printNode(node, String.format("MarkDistinct[%s]", node.getMarkerSymbol()), String.format("%s => %s", node.getDistinctSymbols(), node.getMarkerSymbol()), NODE_COLORS.get((Object)NodeType.MARK_DISTINCT));
            return node.getSource().accept(this, context);
        }

        @Override
        public Void visitWindow(WindowNode node, Void context) {
            this.printNode(node, "Window", String.format("partition by = %s|order by = %s", Joiner.on((String)", ").join(node.getPartitionBy()), node.getOrderingScheme().map(orderingScheme -> Joiner.on((String)", ").join(orderingScheme.orderBy())).orElse("")), NODE_COLORS.get((Object)NodeType.WINDOW));
            return node.getSource().accept(this, context);
        }

        @Override
        public Void visitPatternRecognition(PatternRecognitionNode node, Void context) {
            this.printNode(node, "PatternRecognition", String.format("partition by = %s|order by = %s", Joiner.on((String)", ").join(node.getPartitionBy()), node.getOrderingScheme().map(orderingScheme -> Joiner.on((String)", ").join(orderingScheme.orderBy())).orElse("")), NODE_COLORS.get((Object)NodeType.WINDOW));
            return node.getSource().accept(this, context);
        }

        @Override
        public Void visitRowNumber(RowNumberNode node, Void context) {
            this.printNode(node, "RowNumber", String.format("partition by = %s", Joiner.on((String)", ").join(node.getPartitionBy())), NODE_COLORS.get((Object)NodeType.WINDOW));
            return node.getSource().accept(this, context);
        }

        @Override
        public Void visitTopNRanking(TopNRankingNode node, Void context) {
            this.printNode(node, "TopNRanking", String.format("type=%s|partition by = %s|order by = %s|n = %s", new Object[]{node.getRankingType(), Joiner.on((String)", ").join(node.getPartitionBy()), Joiner.on((String)", ").join(node.getOrderingScheme().orderBy()), node.getMaxRankingPerPartition()}), NODE_COLORS.get((Object)NodeType.WINDOW));
            return node.getSource().accept(this, context);
        }

        @Override
        public Void visitUnion(UnionNode node, Void context) {
            this.printNode(node, "Union", NODE_COLORS.get((Object)NodeType.UNION));
            for (PlanNode planNode : node.getSources()) {
                planNode.accept(this, context);
            }
            return null;
        }

        @Override
        public Void visitRemoteSource(RemoteSourceNode node, Void context) {
            this.printNode(node, (node.getOrderingScheme().isPresent() ? "Merge" : "Exchange") + " 1:N", NODE_COLORS.get((Object)NodeType.EXCHANGE));
            return null;
        }

        @Override
        public Void visitExchange(ExchangeNode node, Void context) {
            List<Partitioning.ArgumentBinding> symbols = (List<Partitioning.ArgumentBinding>)node.getOutputSymbols().stream().map(Symbol::toSymbolReference).map(Partitioning.ArgumentBinding::expressionBinding).collect(ImmutableList.toImmutableList());
            if (node.getType() == ExchangeNode.Type.REPARTITION) {
                symbols = node.getPartitioningScheme().getPartitioning().getArguments();
            }
            String columns = Joiner.on((String)", ").join((Iterable)symbols);
            this.printNode(node, String.format("ExchangeNode[%s]", new Object[]{node.getType()}), columns, NODE_COLORS.get((Object)NodeType.EXCHANGE));
            for (PlanNode planNode : node.getSources()) {
                planNode.accept(this, context);
            }
            return null;
        }

        @Override
        public Void visitAggregation(AggregationNode node, Void context) {
            StringBuilder builder = new StringBuilder();
            for (Map.Entry<Symbol, AggregationNode.Aggregation> entry : node.getAggregations().entrySet()) {
                builder.append(String.format("%s := %s\\n", entry.getKey(), PlanPrinter.formatAggregation(new NoOpAnonymizer(), entry.getValue())));
            }
            this.printNode(node, String.format("Aggregate[%s]", new Object[]{node.getStep()}), builder.toString(), NODE_COLORS.get((Object)NodeType.AGGREGATE));
            return node.getSource().accept(this, context);
        }

        @Override
        public Void visitGroupId(GroupIdNode node, Void context) {
            List inputGroupingSetSymbols = node.getGroupingSets().stream().map(set -> "(" + Joiner.on((String)", ").join((Iterable)set.stream().map(symbol -> node.getGroupingColumns().get(symbol)).collect(Collectors.toList())) + ")").collect(Collectors.toList());
            this.printNode(node, "GroupId", Joiner.on((String)", ").join(inputGroupingSetSymbols), NODE_COLORS.get((Object)NodeType.AGGREGATE));
            return node.getSource().accept(this, context);
        }

        @Override
        public Void visitFilter(FilterNode node, Void context) {
            String expression = node.getPredicate().toString();
            this.printNode(node, "Filter", expression, NODE_COLORS.get((Object)NodeType.FILTER));
            return node.getSource().accept(this, context);
        }

        @Override
        public Void visitProject(ProjectNode node, Void context) {
            StringBuilder builder = new StringBuilder();
            for (Map.Entry<Symbol, Expression> entry : node.getAssignments().entrySet()) {
                if (entry.getValue() instanceof Reference && ((Reference)entry.getValue()).name().equals(entry.getKey().name())) continue;
                builder.append(String.format("%s := %s\\n", entry.getKey(), entry.getValue()));
            }
            this.printNode(node, "Project", builder.toString(), NODE_COLORS.get((Object)NodeType.PROJECT));
            return node.getSource().accept(this, context);
        }

        @Override
        public Void visitUnnest(UnnestNode node, Void context) {
            StringBuilder label = new StringBuilder();
            if (!node.getReplicateSymbols().isEmpty()) {
                label.append("CrossJoin Unnest");
            } else {
                label.append("Unnest");
            }
            List unnestInputs = (List)node.getMappings().stream().map(UnnestNode.Mapping::getInput).collect(ImmutableList.toImmutableList());
            label.append(String.format(" [%s", unnestInputs)).append(node.getOrdinalitySymbol().isPresent() ? " (ordinality)]" : "]");
            this.printNode(node, label.toString(), "", NODE_COLORS.get((Object)NodeType.UNNEST));
            return node.getSource().accept(this, context);
        }

        @Override
        public Void visitTopN(TopNNode node, Void context) {
            String keys = node.getOrderingScheme().orderBy().stream().map(input -> String.valueOf(input) + " " + String.valueOf(node.getOrderingScheme().ordering((Symbol)input))).collect(Collectors.joining(", "));
            this.printNode(node, String.format("TopN[%s]", node.getCount()), keys, NODE_COLORS.get((Object)NodeType.TOPN));
            return node.getSource().accept(this, context);
        }

        @Override
        public Void visitOutput(OutputNode node, Void context) {
            String columns = NodePrinter.getColumns(node);
            this.printNode(node, String.format("Output[%s]", columns), NODE_COLORS.get((Object)NodeType.OUTPUT));
            return node.getSource().accept(this, context);
        }

        @Override
        public Void visitDistinctLimit(DistinctLimitNode node, Void context) {
            this.printNode(node, String.format("DistinctLimit[%s]", node.getLimit()), NODE_COLORS.get((Object)NodeType.LIMIT));
            return node.getSource().accept(this, context);
        }

        @Override
        public Void visitLimit(LimitNode node, Void context) {
            this.printNode(node, String.format("Limit[%s]", node.getCount()), NODE_COLORS.get((Object)NodeType.LIMIT));
            return node.getSource().accept(this, context);
        }

        @Override
        public Void visitTableScan(TableScanNode node, Void context) {
            this.printNode(node, String.format("TableScan[%s]", node.getTable()), NODE_COLORS.get((Object)NodeType.TABLESCAN));
            return null;
        }

        @Override
        public Void visitValues(ValuesNode node, Void context) {
            this.printNode(node, "Values", NODE_COLORS.get((Object)NodeType.TABLESCAN));
            return null;
        }

        @Override
        public Void visitEnforceSingleRow(EnforceSingleRowNode node, Void context) {
            this.printNode(node, "Scalar", NODE_COLORS.get((Object)NodeType.PROJECT));
            return node.getSource().accept(this, context);
        }

        @Override
        public Void visitJoin(JoinNode node, Void context) {
            ArrayList<Comparison> joinExpressions = new ArrayList<Comparison>();
            for (JoinNode.EquiJoinClause clause : node.getCriteria()) {
                joinExpressions.add(clause.toExpression());
            }
            String criteria = Joiner.on((String)" AND ").join(joinExpressions);
            this.printNode(node, node.getType().getJoinLabel(), criteria, NODE_COLORS.get((Object)NodeType.JOIN));
            node.getLeft().accept(this, context);
            node.getRight().accept(this, context);
            return null;
        }

        @Override
        public Void visitSemiJoin(SemiJoinNode node, Void context) {
            this.printNode(node, "SemiJoin", String.format("%s = %s", node.getSourceJoinSymbol(), node.getFilteringSourceJoinSymbol()), NODE_COLORS.get((Object)NodeType.JOIN));
            node.getSource().accept(this, context);
            node.getFilteringSource().accept(this, context);
            return null;
        }

        @Override
        public Void visitSpatialJoin(SpatialJoinNode node, Void context) {
            this.printNode(node, node.getType().getJoinLabel(), node.getFilter().toString(), NODE_COLORS.get((Object)NodeType.JOIN));
            node.getLeft().accept(this, context);
            node.getRight().accept(this, context);
            return null;
        }

        @Override
        public Void visitApply(ApplyNode node, Void context) {
            String parameters = Joiner.on((String)",").join(node.getCorrelation());
            this.printNode(node, "Apply", parameters, NODE_COLORS.get((Object)NodeType.JOIN));
            node.getInput().accept(this, context);
            node.getSubquery().accept(this, context);
            return null;
        }

        @Override
        public Void visitAssignUniqueId(AssignUniqueId node, Void context) {
            this.printNode(node, "AssignUniqueId", NODE_COLORS.get((Object)NodeType.PROJECT));
            node.getSource().accept(this, context);
            return null;
        }

        @Override
        public Void visitCorrelatedJoin(CorrelatedJoinNode node, Void context) {
            String correlationSymbols = Joiner.on((String)",").join(node.getCorrelation());
            Object filterExpression = "";
            if (!node.getFilter().equals(Booleans.TRUE)) {
                filterExpression = " " + node.getFilter().toString();
            }
            this.printNode(node, "CorrelatedJoin", correlationSymbols + (String)filterExpression, NODE_COLORS.get((Object)NodeType.JOIN));
            node.getInput().accept(this, context);
            node.getSubquery().accept(this, context);
            return null;
        }

        @Override
        public Void visitIndexSource(IndexSourceNode node, Void context) {
            this.printNode(node, String.format("IndexSource[%s]", node.getIndexHandle()), NODE_COLORS.get((Object)NodeType.INDEX_SOURCE));
            return null;
        }

        @Override
        public Void visitIndexJoin(IndexJoinNode node, Void context) {
            ArrayList<Comparison> joinExpressions = new ArrayList<Comparison>();
            for (IndexJoinNode.EquiJoinClause clause : node.getCriteria()) {
                joinExpressions.add(new Comparison(Comparison.Operator.EQUAL, clause.getProbe().toSymbolReference(), clause.getIndex().toSymbolReference()));
            }
            String criteria = Joiner.on((String)" AND ").join(joinExpressions);
            String joinLabel = String.format("%sIndexJoin", node.getType().getJoinLabel());
            this.printNode(node, joinLabel, criteria, NODE_COLORS.get((Object)NodeType.JOIN));
            node.getProbeSource().accept(this, context);
            node.getIndexSource().accept(this, context);
            return null;
        }

        @Override
        public Void visitDynamicFilterSource(DynamicFilterSourceNode node, Void context) {
            this.printNode(node, "DynamicFilterSource", NODE_COLORS.get((Object)NodeType.DYNAMIC_FILTER_SOURCE));
            return node.getSource().accept(this, context);
        }

        private void printNode(PlanNode node, String label, String color) {
            String nodeId = this.idGenerator.getNodeId(node);
            label = NodePrinter.escapeSpecialCharacters(label);
            this.output.append(nodeId).append(String.format("[label=\"{%s}\", style=\"rounded, filled\", shape=record, fillcolor=%s]", label, color)).append(';').append('\n');
        }

        private void printNode(PlanNode node, String label, String details, String color) {
            if (details.isEmpty()) {
                this.printNode(node, label, color);
            } else {
                String nodeId = this.idGenerator.getNodeId(node);
                label = NodePrinter.escapeSpecialCharacters(label);
                details = NodePrinter.escapeSpecialCharacters(details);
                this.output.append(nodeId).append(String.format("[label=\"{%s|%s}\", style=\"rounded, filled\", shape=record, fillcolor=%s]", label, details, color)).append(';').append('\n');
            }
        }

        private static String getColumns(OutputNode node) {
            Iterator<String> columnNames = node.getColumnNames().iterator();
            Object columns = "";
            int nameWidth = 0;
            while (columnNames.hasNext()) {
                String columnName = columnNames.next();
                columns = (String)columns + columnName;
                nameWidth += columnName.length();
                if (columnNames.hasNext()) {
                    columns = (String)columns + ", ";
                }
                if (nameWidth < 100) continue;
                columns = (String)columns + "\\n";
                nameWidth = 0;
            }
            return columns;
        }

        private static String escapeSpecialCharacters(String label) {
            return label.replace("<", "\\<").replace(">", "\\>").replace("\"", "\\\"");
        }
    }

    private static enum NodeType {
        EXCHANGE,
        AGGREGATE,
        FILTER,
        PROJECT,
        TOPN,
        OUTPUT,
        LIMIT,
        TABLESCAN,
        VALUES,
        JOIN,
        SINK,
        WINDOW,
        UNION,
        SORT,
        SAMPLE,
        MARK_DISTINCT,
        TABLE_WRITER,
        TABLE_FINISH,
        INDEX_SOURCE,
        UNNEST,
        ANALYZE_FINISH,
        DYNAMIC_FILTER_SOURCE;

    }
}

