/*
 * Decompiled with CFR 0.152.
 */
package io.trino.block;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.UnmodifiableIterator;
import io.airlift.slice.Slice;
import io.trino.block.AbstractTestBlock;
import io.trino.block.BlockAssertions;
import io.trino.spi.block.Block;
import io.trino.spi.block.BlockBuilder;
import io.trino.spi.block.DictionaryBlock;
import io.trino.spi.block.DictionaryId;
import io.trino.spi.block.IntArrayBlock;
import io.trino.spi.block.ValueBlock;
import io.trino.spi.block.VariableWidthBlock;
import io.trino.spi.block.VariableWidthBlockBuilder;
import io.trino.spi.type.VarbinaryType;
import java.util.Arrays;
import java.util.Optional;
import java.util.stream.IntStream;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestDictionaryBlock
extends AbstractTestBlock {
    @Test
    public void testConstructionNoPositions() {
        Slice[] expectedValues = TestDictionaryBlock.createExpectedValues(10);
        ValueBlock dictionary = BlockAssertions.createSlicesBlock(expectedValues);
        Block block = DictionaryBlock.create((int)0, (Block)dictionary, (int[])new int[]{1, 5, 9});
        Assertions.assertThat((Object)block).isInstanceOf(VariableWidthBlock.class);
        Assertions.assertThat((int)block.getPositionCount()).isEqualTo(0);
    }

    @Test
    public void testConstructionOnePositions() {
        Slice[] expectedValues = TestDictionaryBlock.createExpectedValues(10);
        ValueBlock dictionary = BlockAssertions.createSlicesBlock(expectedValues);
        Block block = DictionaryBlock.create((int)1, (Block)dictionary, (int[])new int[]{1, 5, 9});
        Assertions.assertThat((Object)block).isInstanceOf(VariableWidthBlock.class);
        Assertions.assertThat((int)block.getPositionCount()).isEqualTo(1);
        Assertions.assertThat((Comparable)VarbinaryType.VARBINARY.getSlice(block, 0)).isEqualTo((Object)expectedValues[1]);
    }

    @Test
    public void testConstructionUnnestDictionary() {
        Slice[] expectedValues = TestDictionaryBlock.createExpectedValues(10);
        ValueBlock innerDictionary = BlockAssertions.createSlicesBlock(expectedValues);
        DictionaryBlock dictionary = (DictionaryBlock)DictionaryBlock.create((int)4, (Block)innerDictionary, (int[])new int[]{1, 3, 5, 7});
        Block block = DictionaryBlock.create((int)2, (Block)dictionary, (int[])new int[]{1, 3});
        Assertions.assertThat((Object)block).isInstanceOf(DictionaryBlock.class);
        this.assertBlock(block, new Slice[]{expectedValues[3], expectedValues[7]});
        ValueBlock actualDictionary = ((DictionaryBlock)block).getDictionary();
        Assertions.assertThat((Object)actualDictionary).isSameAs((Object)innerDictionary);
    }

    @Test
    public void testSizeInBytes() {
        Slice[] expectedValues = TestDictionaryBlock.createExpectedValues(10);
        DictionaryBlock dictionaryBlock = TestDictionaryBlock.createDictionaryBlock(expectedValues, 100);
        Assertions.assertThat((long)dictionaryBlock.getSizeInBytes()).isEqualTo(dictionaryBlock.getDictionary().getSizeInBytes() + 400L);
    }

    @Test
    public void testLogicalSizeInBytes() {
        Slice[] expectedValues = TestDictionaryBlock.createExpectedValues(10);
        DictionaryBlock dictionaryBlock = TestDictionaryBlock.createDictionaryBlock(expectedValues, 100);
        Assertions.assertThat((long)dictionaryBlock.getDictionary().getLogicalSizeInBytes()).isEqualTo(95L);
        Assertions.assertThat((long)dictionaryBlock.getLogicalSizeInBytes()).isEqualTo(950L);
        dictionaryBlock = TestDictionaryBlock.createDictionaryBlock(TestDictionaryBlock.alternatingNullValues(expectedValues), 210);
        Assertions.assertThat((int)dictionaryBlock.getDictionary().getPositionCount()).isEqualTo(21);
        Assertions.assertThat((long)dictionaryBlock.getDictionary().getLogicalSizeInBytes()).isEqualTo(150L);
        Assertions.assertThat((long)dictionaryBlock.getLogicalSizeInBytes()).isEqualTo(1500L);
    }

    @Test
    public void testCopyRegionCreatesCompactBlock() {
        Slice[] expectedValues = TestDictionaryBlock.createExpectedValues(10);
        DictionaryBlock dictionaryBlock = TestDictionaryBlock.createDictionaryBlock(expectedValues, 100);
        DictionaryBlock copyRegionDictionaryBlock = (DictionaryBlock)dictionaryBlock.copyRegion(1, 3);
        Assertions.assertThat((boolean)copyRegionDictionaryBlock.isCompact()).isTrue();
    }

    @Test
    public void testCopyPositionsWithCompaction() {
        Slice[] expectedValues = TestDictionaryBlock.createExpectedValues(10);
        Slice firstExpectedValue = expectedValues[0];
        DictionaryBlock dictionaryBlock = TestDictionaryBlock.createDictionaryBlock(expectedValues, 100);
        int[] positionsToCopy = new int[]{0, 10, 20, 30, 40};
        DictionaryBlock copiedBlock = (DictionaryBlock)dictionaryBlock.copyPositions(positionsToCopy, 0, positionsToCopy.length);
        Assertions.assertThat((int)copiedBlock.getDictionary().getPositionCount()).isEqualTo(1);
        Assertions.assertThat((int)copiedBlock.getPositionCount()).isEqualTo(positionsToCopy.length);
        this.assertBlock((Block)copiedBlock.getDictionary(), new Slice[]{firstExpectedValue});
        this.assertBlock((Block)copiedBlock, new Slice[]{firstExpectedValue, firstExpectedValue, firstExpectedValue, firstExpectedValue, firstExpectedValue});
    }

    @Test
    public void testCopyPositionsWithCompactionsAndReorder() {
        Slice[] expectedValues = TestDictionaryBlock.createExpectedValues(10);
        DictionaryBlock dictionaryBlock = TestDictionaryBlock.createDictionaryBlock(expectedValues, 100);
        int[] positionsToCopy = new int[]{50, 55, 40, 45, 60};
        DictionaryBlock copiedBlock = (DictionaryBlock)dictionaryBlock.copyPositions(positionsToCopy, 0, positionsToCopy.length);
        Assertions.assertThat((int)copiedBlock.getDictionary().getPositionCount()).isEqualTo(2);
        Assertions.assertThat((int)copiedBlock.getPositionCount()).isEqualTo(positionsToCopy.length);
        this.assertBlock((Block)copiedBlock.getDictionary(), new Slice[]{expectedValues[0], expectedValues[5]});
        TestDictionaryBlock.assertDictionaryIds(copiedBlock, 0, 1, 0, 1, 0);
    }

    @Test
    public void testCopyPositionsSamePosition() {
        Slice[] expectedValues = TestDictionaryBlock.createExpectedValues(10);
        DictionaryBlock dictionaryBlock = TestDictionaryBlock.createDictionaryBlock(expectedValues, 100);
        int[] positionsToCopy = new int[]{52, 52, 52};
        DictionaryBlock copiedBlock = (DictionaryBlock)dictionaryBlock.copyPositions(positionsToCopy, 0, positionsToCopy.length);
        Assertions.assertThat((int)copiedBlock.getDictionary().getPositionCount()).isEqualTo(1);
        Assertions.assertThat((int)copiedBlock.getPositionCount()).isEqualTo(positionsToCopy.length);
        this.assertBlock((Block)copiedBlock.getDictionary(), new Slice[]{expectedValues[2]});
        TestDictionaryBlock.assertDictionaryIds(copiedBlock, 0, 0, 0);
    }

    @Test
    public void testCopyPositionsNoCompaction() {
        Slice[] expectedValues = TestDictionaryBlock.createExpectedValues(1);
        DictionaryBlock dictionaryBlock = TestDictionaryBlock.createDictionaryBlock(expectedValues, 100);
        int[] positionsToCopy = new int[]{0, 2, 4, 5};
        DictionaryBlock copiedBlock = (DictionaryBlock)dictionaryBlock.copyPositions(positionsToCopy, 0, positionsToCopy.length);
        Assertions.assertThat((int)copiedBlock.getPositionCount()).isEqualTo(positionsToCopy.length);
        this.assertBlock((Block)copiedBlock.getDictionary(), expectedValues);
    }

    @Test
    public void testCompact() {
        Slice[] expectedValues = TestDictionaryBlock.createExpectedValues(5);
        DictionaryBlock dictionaryBlock = TestDictionaryBlock.createDictionaryBlockWithUnreferencedKeys(expectedValues, 10);
        Assertions.assertThat((boolean)dictionaryBlock.isCompact()).isEqualTo(false);
        DictionaryBlock compactBlock = dictionaryBlock.compact();
        Assertions.assertThat((Object)dictionaryBlock.getDictionarySourceId()).isNotEqualTo((Object)compactBlock.getDictionarySourceId());
        Assertions.assertThat((int)compactBlock.getDictionary().getPositionCount()).isEqualTo(expectedValues.length / 2 + 1);
        this.assertBlock((Block)compactBlock.getDictionary(), new Slice[]{expectedValues[0], expectedValues[1], expectedValues[3]});
        TestDictionaryBlock.assertDictionaryIds(compactBlock, 0, 1, 1, 2, 2, 0, 1, 1, 2, 2);
        Assertions.assertThat((boolean)compactBlock.isCompact()).isEqualTo(true);
        DictionaryBlock reCompactedBlock = compactBlock.compact();
        Assertions.assertThat((Object)reCompactedBlock.getDictionarySourceId()).isEqualTo((Object)compactBlock.getDictionarySourceId());
    }

    @Test
    public void testCompactAllKeysReferenced() {
        Slice[] expectedValues = TestDictionaryBlock.createExpectedValues(5);
        DictionaryBlock dictionaryBlock = TestDictionaryBlock.createDictionaryBlock(expectedValues, 10);
        DictionaryBlock compactBlock = dictionaryBlock.compact();
        Assertions.assertThat((Object)compactBlock.getDictionary()).isEqualTo((Object)dictionaryBlock.getDictionary());
        Assertions.assertThat((int)compactBlock.getPositionCount()).isEqualTo(dictionaryBlock.getPositionCount());
        for (int position = 0; position < compactBlock.getPositionCount(); ++position) {
            Assertions.assertThat((int)compactBlock.getId(position)).isEqualTo(dictionaryBlock.getId(position));
        }
        Assertions.assertThat((boolean)compactBlock.isCompact()).isEqualTo(true);
    }

    @Test
    public void testBasicGetPositions() {
        Slice[] expectedValues = TestDictionaryBlock.createExpectedValues(10);
        Block dictionaryBlock = DictionaryBlock.create((int)6, (Block)BlockAssertions.createSlicesBlock(expectedValues), (int[])new int[]{0, 1, 2, 3, 4, 5});
        this.assertBlock(dictionaryBlock, new Slice[]{expectedValues[0], expectedValues[1], expectedValues[2], expectedValues[3], expectedValues[4], expectedValues[5]});
        DictionaryId dictionaryId = ((DictionaryBlock)dictionaryBlock).getDictionarySourceId();
        dictionaryBlock = dictionaryBlock.getPositions(new int[]{0, 8, 1, 2, 4, 5, 7, 9}, 2, 4);
        this.assertBlock(dictionaryBlock, new Slice[]{expectedValues[1], expectedValues[2], expectedValues[4], expectedValues[5]});
        Assertions.assertThat((Object)((DictionaryBlock)dictionaryBlock).getDictionarySourceId()).isEqualTo((Object)dictionaryId);
        dictionaryBlock = dictionaryBlock.getPositions(new int[]{0, 1, 3, 0, 0}, 0, 3);
        this.assertBlock(dictionaryBlock, new Slice[]{expectedValues[1], expectedValues[2], expectedValues[5]});
        Assertions.assertThat((Object)((DictionaryBlock)dictionaryBlock).getDictionarySourceId()).isEqualTo((Object)dictionaryId);
        dictionaryBlock = dictionaryBlock.getPositions(new int[]{-1, -1, 0, 1, 2}, 2, 3);
        this.assertBlock(dictionaryBlock, new Slice[]{expectedValues[1], expectedValues[2], expectedValues[5]});
        Assertions.assertThat((Object)((DictionaryBlock)dictionaryBlock).getDictionarySourceId()).isEqualTo((Object)dictionaryId);
        dictionaryBlock = dictionaryBlock.getPositions(new int[]{0, 2, 2}, 0, 3);
        this.assertBlock(dictionaryBlock, new Slice[]{expectedValues[1], expectedValues[5], expectedValues[5]});
        Assertions.assertThat((Object)((DictionaryBlock)dictionaryBlock).getDictionarySourceId()).isEqualTo((Object)dictionaryId);
        dictionaryBlock = dictionaryBlock.getPositions(new int[]{1, 1, 1, 1, 1}, 0, 5);
        this.assertBlock(dictionaryBlock, new Slice[]{expectedValues[5], expectedValues[5], expectedValues[5], expectedValues[5], expectedValues[5]});
        Assertions.assertThat((Object)((DictionaryBlock)dictionaryBlock).getDictionarySourceId()).isEqualTo((Object)dictionaryId);
        Block finalDictionaryBlock = dictionaryBlock;
        UnmodifiableIterator unmodifiableIterator = ImmutableList.of((Object)-1, (Object)6).iterator();
        while (unmodifiableIterator.hasNext()) {
            int position = (Integer)unmodifiableIterator.next();
            ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> finalDictionaryBlock.getPositions(new int[]{position}, 0, 1)).isInstanceOf(IllegalArgumentException.class)).hasMessage("Invalid position %d in block with %d positions", new Object[]{position, finalDictionaryBlock.getPositionCount()});
        }
        unmodifiableIterator = ImmutableList.of((Object)-1, (Object)6).iterator();
        while (unmodifiableIterator.hasNext()) {
            int offset = (Integer)unmodifiableIterator.next();
            ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> finalDictionaryBlock.getPositions(new int[]{0}, offset, 1)).isInstanceOf(IndexOutOfBoundsException.class)).hasMessage("Invalid offset %d and length 1 in array with 1 elements", new Object[]{offset});
        }
        unmodifiableIterator = ImmutableList.of((Object)-1, (Object)6).iterator();
        while (unmodifiableIterator.hasNext()) {
            int length = (Integer)unmodifiableIterator.next();
            ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> finalDictionaryBlock.getPositions(new int[]{0}, 0, length)).isInstanceOf(IndexOutOfBoundsException.class)).hasMessage("Invalid offset 0 and length %d in array with 1 elements", new Object[]{length});
        }
    }

    @Test
    public void testCompactGetPositions() {
        DictionaryBlock block = (DictionaryBlock)DictionaryBlock.create((int)6, (Block)BlockAssertions.createSlicesBlock(TestDictionaryBlock.createExpectedValues(10)), (int[])new int[]{0, 1, 2, 3, 4, 5});
        block = block.compact();
        block = (DictionaryBlock)block.getPositions(new int[]{3, 3, 4, 5, 2, 0, 1, 1}, 0, 7);
        Assertions.assertThat((boolean)block.isCompact()).isTrue();
        block = (DictionaryBlock)block.getPositions(new int[]{0, 1, 2, 3, 4, 5, 6, 6, 5, 4, 3, 2, 1}, 0, 12);
        Assertions.assertThat((boolean)block.isCompact()).isTrue();
        block = (DictionaryBlock)block.getPositions(new int[]{0, 2, 0, 2, 0}, 0, 5);
        Assertions.assertThat((boolean)block.isCompact()).isFalse();
        block = block.compact();
        block = (DictionaryBlock)block.getPositions(new int[]{0, 1, 1, 1}, 0, 4);
        Assertions.assertThat((boolean)block.isCompact()).isTrue();
        block = (DictionaryBlock)block.getPositions(new int[]{1, 1, 1, 1}, 0, 4);
        Assertions.assertThat((boolean)block.isCompact()).isFalse();
        block = block.compact();
        block = (DictionaryBlock)block.getPositions(new int[]{0}, 0, 1);
        Assertions.assertThat((boolean)block.isCompact()).isTrue();
        block = (DictionaryBlock)block.getPositions(new int[0], 0, 0);
        Assertions.assertThat((boolean)block.isCompact()).isFalse();
        block = block.compact();
        block = (DictionaryBlock)block.getPositions(new int[0], 0, 0);
        Assertions.assertThat((boolean)block.isCompact()).isTrue();
    }

    @Test
    public void testEstimatedDataSizeForStats() {
        int positionCount = 10;
        int dictionaryPositionCount = 100;
        Slice[] expectedValues = TestDictionaryBlock.createExpectedValues(positionCount);
        DictionaryBlock dictionaryBlock = TestDictionaryBlock.createDictionaryBlock(expectedValues, dictionaryPositionCount);
        for (int position = 0; position < dictionaryPositionCount; ++position) {
            Assertions.assertThat((long)dictionaryBlock.getEstimatedDataSizeForStats(position)).isEqualTo((long)expectedValues[position % positionCount].length());
        }
    }

    @Test
    public void testDictionarySizes() {
        TestDictionaryBlock.assertDictionarySizeMethods((Block)new IntArrayBlock(100, Optional.empty(), IntStream.range(0, 100).toArray()));
        TestDictionaryBlock.assertDictionarySizeMethods((Block)BlockAssertions.createSlicesBlock(TestDictionaryBlock.createExpectedValues(100)));
    }

    private static void assertDictionarySizeMethods(Block block) {
        Assertions.assertThat((Object)block).isNotInstanceOf(DictionaryBlock.class);
        int positions = block.getPositionCount();
        Assertions.assertThat((positions > 0 ? 1 : 0) != 0).isTrue();
        int[] allIds = IntStream.range(0, positions).toArray();
        Assertions.assertThat((long)DictionaryBlock.create((int)allIds.length, (Block)block, (int[])allIds).getSizeInBytes()).isEqualTo(block.getSizeInBytes() + 4L * (long)positions);
        int firstHalfLength = positions / 2;
        int secondHalfLength = positions - firstHalfLength;
        int[] firstHalfIds = IntStream.range(0, firstHalfLength).toArray();
        int[] secondHalfIds = IntStream.range(firstHalfLength, positions).toArray();
        boolean[] selectedPositions = new boolean[positions];
        selectedPositions[0] = true;
        Assertions.assertThat((long)DictionaryBlock.create((int)allIds.length, (Block)block, (int[])allIds).getPositionsSizeInBytes(selectedPositions, 1)).isEqualTo(block.getPositionsSizeInBytes(selectedPositions, 1) + 4L);
        Arrays.fill(selectedPositions, true);
        Assertions.assertThat((long)DictionaryBlock.create((int)allIds.length, (Block)block, (int[])allIds).getPositionsSizeInBytes(selectedPositions, positions)).isEqualTo(block.getSizeInBytes() + 4L * (long)positions);
        Assertions.assertThat((long)DictionaryBlock.create((int)firstHalfIds.length, (Block)block, (int[])firstHalfIds).getSizeInBytes()).isEqualTo(block.getRegionSizeInBytes(0, firstHalfLength) + 4L * (long)firstHalfLength);
        Assertions.assertThat((long)DictionaryBlock.create((int)secondHalfIds.length, (Block)block, (int[])secondHalfIds).getSizeInBytes()).isEqualTo(block.getRegionSizeInBytes(firstHalfLength, secondHalfLength) + 4L * (long)secondHalfLength);
        Assertions.assertThat((long)DictionaryBlock.create((int)allIds.length, (Block)block, (int[])allIds).getRegionSizeInBytes(0, firstHalfLength)).isEqualTo(block.getRegionSizeInBytes(0, firstHalfLength) + 4L * (long)firstHalfLength);
        Assertions.assertThat((long)DictionaryBlock.create((int)allIds.length, (Block)block, (int[])allIds).getRegionSizeInBytes(firstHalfLength, secondHalfLength)).isEqualTo(block.getRegionSizeInBytes(firstHalfLength, secondHalfLength) + 4L * (long)secondHalfLength);
    }

    private static DictionaryBlock createDictionaryBlockWithUnreferencedKeys(Slice[] expectedValues, int positionCount) {
        Preconditions.checkArgument((positionCount >= 2 ? 1 : 0) != 0, (Object)"positionCount must be at least 2 for a dictionary block");
        int dictionarySize = expectedValues.length;
        int[] ids = new int[positionCount];
        for (int i = 0; i < positionCount; ++i) {
            int index = i % dictionarySize;
            if (index % 2 != 0 || index != 0) {
                // empty if block
            }
            ids[i] = --index;
        }
        return (DictionaryBlock)DictionaryBlock.create((int)ids.length, (Block)BlockAssertions.createSlicesBlock(expectedValues), (int[])ids);
    }

    private static DictionaryBlock createDictionaryBlock(Slice[] expectedValues, int positionCount) {
        Preconditions.checkArgument((positionCount >= 2 ? 1 : 0) != 0, (Object)"positionCount must be at least 2 for a dictionary block");
        int dictionarySize = expectedValues.length;
        int[] ids = new int[positionCount];
        for (int i = 0; i < positionCount; ++i) {
            ids[i] = i % dictionarySize;
        }
        return (DictionaryBlock)DictionaryBlock.create((int)ids.length, (Block)BlockAssertions.createSlicesBlock(expectedValues), (int[])ids);
    }

    private static BlockBuilder createBlockBuilder() {
        return new VariableWidthBlockBuilder(null, 100, 1);
    }

    private static void assertDictionaryIds(DictionaryBlock dictionaryBlock, int ... expected) {
        Assertions.assertThat((int)dictionaryBlock.getPositionCount()).isEqualTo(expected.length);
        for (int position = 0; position < dictionaryBlock.getPositionCount(); ++position) {
            Assertions.assertThat((int)dictionaryBlock.getId(position)).isEqualTo(expected[position]);
        }
    }

    @Override
    protected <T> void assertPositionValue(Block block, int position, T expectedValue) {
        if (expectedValue == null) {
            Assertions.assertThat((boolean)block.isNull(position)).isTrue();
            return;
        }
        Assertions.assertThat((boolean)block.isNull(position)).isFalse();
        VariableWidthBlock variableWidthBlock = (VariableWidthBlock)block.getUnderlyingValueBlock();
        Assertions.assertThat((Comparable)variableWidthBlock.getSlice(block.getUnderlyingValuePosition(position))).isEqualTo(expectedValue);
    }
}

