/*
 * Decompiled with CFR 0.152.
 */
package io.trino.execution.scheduler.faulttolerant;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import io.airlift.units.DataSize;
import io.trino.Session;
import io.trino.connector.informationschema.InformationSchemaTable;
import io.trino.connector.informationschema.InformationSchemaTableHandle;
import io.trino.connector.system.GlobalSystemConnector;
import io.trino.connector.system.SystemTableHandle;
import io.trino.cost.StatsAndCosts;
import io.trino.execution.scheduler.faulttolerant.NoMemoryAwarePartitionMemoryEstimator;
import io.trino.execution.scheduler.faulttolerant.NoMemoryPartitionMemoryEstimator;
import io.trino.execution.scheduler.faulttolerant.PartitionMemoryEstimator;
import io.trino.execution.scheduler.faulttolerant.PartitionMemoryEstimatorFactory;
import io.trino.metadata.TableHandle;
import io.trino.operator.RetryPolicy;
import io.trino.plugin.tpch.TpchTableHandle;
import io.trino.spi.ErrorCode;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.connector.ConnectorTableHandle;
import io.trino.spi.connector.ConnectorTransactionHandle;
import io.trino.spi.predicate.TupleDomain;
import io.trino.sql.planner.Partitioning;
import io.trino.sql.planner.PartitioningHandle;
import io.trino.sql.planner.PartitioningScheme;
import io.trino.sql.planner.PlanFragment;
import io.trino.sql.planner.SystemPartitioningHandle;
import io.trino.sql.planner.plan.ExchangeNode;
import io.trino.sql.planner.plan.PlanFragmentId;
import io.trino.sql.planner.plan.PlanNode;
import io.trino.sql.planner.plan.PlanNodeId;
import io.trino.sql.planner.plan.RemoteSourceNode;
import io.trino.sql.planner.plan.TableScanNode;
import io.trino.testing.TestingHandles;
import io.trino.testing.TestingSession;
import io.trino.testing.TestingTransactionHandle;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalLong;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Stream;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestNoMemoryAwarePartitionMemoryEstimator {
    @Test
    public void testInformationSchemaScan() {
        PlanFragment planFragment = TestNoMemoryAwarePartitionMemoryEstimator.tableScanPlanFragment("ts", (ConnectorTableHandle)new InformationSchemaTableHandle("test_catalog", InformationSchemaTable.VIEWS, (Set)ImmutableSet.of(), OptionalLong.empty()));
        PartitionMemoryEstimator estimator = this.createEstimator(planFragment, new PlanFragment[0]);
        Assertions.assertThat((Object)estimator).isInstanceOf(NoMemoryPartitionMemoryEstimator.class);
        PartitionMemoryEstimator.MemoryRequirements noMemoryRequirements = new PartitionMemoryEstimator.MemoryRequirements(DataSize.ofBytes((long)0L));
        Assertions.assertThat((Object)estimator.getInitialMemoryRequirements()).isEqualTo((Object)noMemoryRequirements);
        Assertions.assertThat((Object)estimator.getNextRetryMemoryRequirements(new PartitionMemoryEstimator.MemoryRequirements(DataSize.ofBytes((long)1L)), DataSize.of((long)5L, (DataSize.Unit)DataSize.Unit.BYTE), StandardErrorCode.NOT_SUPPORTED.toErrorCode())).isEqualTo((Object)noMemoryRequirements);
        Assertions.assertThat((Object)estimator.getNextRetryMemoryRequirements(new PartitionMemoryEstimator.MemoryRequirements(DataSize.ofBytes((long)1L)), DataSize.of((long)5L, (DataSize.Unit)DataSize.Unit.BYTE), StandardErrorCode.GENERIC_INSUFFICIENT_RESOURCES.toErrorCode())).isEqualTo((Object)noMemoryRequirements);
    }

    @Test
    public void testTpchTableScan() {
        PlanFragment planFragment = TestNoMemoryAwarePartitionMemoryEstimator.tableScanPlanFragment("ts", (ConnectorTableHandle)new TpchTableHandle("test_catalog", "nation", 1.0));
        PartitionMemoryEstimator estimator = this.createEstimator(planFragment, new PlanFragment[0]);
        Assertions.assertThat((Object)estimator).isInstanceOf(MockDelegatePatitionMemoryEstimator.class);
    }

    @Test
    public void testRemoteFromInformationSchemaScan() {
        PlanFragment tableScanPlanFragment = TestNoMemoryAwarePartitionMemoryEstimator.tableScanPlanFragment("ts", (ConnectorTableHandle)new InformationSchemaTableHandle("test_catalog", InformationSchemaTable.VIEWS, (Set)ImmutableSet.of(), OptionalLong.empty()));
        PlanFragment parentFragment = TestNoMemoryAwarePartitionMemoryEstimator.getParentFragment(tableScanPlanFragment);
        PartitionMemoryEstimator estimator = this.createEstimator(parentFragment, tableScanPlanFragment);
        Assertions.assertThat((Object)estimator).isInstanceOf(NoMemoryPartitionMemoryEstimator.class);
    }

    @Test
    public void testRemoteFromTpchScan() {
        PlanFragment tableScanPlanFragment = TestNoMemoryAwarePartitionMemoryEstimator.tableScanPlanFragment("ts", (ConnectorTableHandle)new TpchTableHandle("test_catalog", "nation", 1.0));
        PlanFragment parentFragment = TestNoMemoryAwarePartitionMemoryEstimator.getParentFragment(tableScanPlanFragment);
        PartitionMemoryEstimator estimator = this.createEstimator(parentFragment, tableScanPlanFragment);
        Assertions.assertThat((Object)estimator).isInstanceOf(MockDelegatePatitionMemoryEstimator.class);
    }

    @Test
    public void testRemoteFromTwoInformationSchemaScans() {
        PlanFragment tableScanPlanFragment1 = TestNoMemoryAwarePartitionMemoryEstimator.tableScanPlanFragment("ts1", (ConnectorTableHandle)new InformationSchemaTableHandle("test_catalog", InformationSchemaTable.VIEWS, (Set)ImmutableSet.of(), OptionalLong.empty()));
        PlanFragment tableScanPlanFragment2 = TestNoMemoryAwarePartitionMemoryEstimator.tableScanPlanFragment("ts2", (ConnectorTableHandle)new InformationSchemaTableHandle("test_catalog", InformationSchemaTable.COLUMNS, (Set)ImmutableSet.of(), OptionalLong.empty()));
        PlanFragment parentFragment = TestNoMemoryAwarePartitionMemoryEstimator.getParentFragment(tableScanPlanFragment1, tableScanPlanFragment2);
        PartitionMemoryEstimator estimator = this.createEstimator(parentFragment, tableScanPlanFragment1, tableScanPlanFragment2);
        Assertions.assertThat((Object)estimator).isInstanceOf(NoMemoryPartitionMemoryEstimator.class);
    }

    @Test
    public void testRemoteFromInformationSchemaAndTpchTableScans() {
        PlanFragment tableScanPlanFragment1 = TestNoMemoryAwarePartitionMemoryEstimator.tableScanPlanFragment("ts1", (ConnectorTableHandle)new InformationSchemaTableHandle("test_catalog", InformationSchemaTable.VIEWS, (Set)ImmutableSet.of(), OptionalLong.empty()));
        PlanFragment tableScanPlanFragment2 = TestNoMemoryAwarePartitionMemoryEstimator.tableScanPlanFragment("ts", (ConnectorTableHandle)new TpchTableHandle("test_catalog", "nation", 1.0));
        PlanFragment parentFragment = TestNoMemoryAwarePartitionMemoryEstimator.getParentFragment(tableScanPlanFragment1, tableScanPlanFragment2);
        PartitionMemoryEstimator estimator = this.createEstimator(parentFragment, tableScanPlanFragment1, tableScanPlanFragment2);
        Assertions.assertThat((Object)estimator).isInstanceOf(MockDelegatePatitionMemoryEstimator.class);
    }

    @Test
    public void testSystemJdbcTableScan() {
        PartitionMemoryEstimator estimator = this.createEstimator(TestNoMemoryAwarePartitionMemoryEstimator.tableScanPlanFragment("ts", new TableHandle(GlobalSystemConnector.CATALOG_HANDLE, (ConnectorTableHandle)new SystemTableHandle("jdbc", "tables", TupleDomain.all()), (ConnectorTransactionHandle)TestingTransactionHandle.create())), new PlanFragment[0]);
        Assertions.assertThat((Object)estimator).isInstanceOf(NoMemoryPartitionMemoryEstimator.class);
        PartitionMemoryEstimator.MemoryRequirements noMemoryRequirements = new PartitionMemoryEstimator.MemoryRequirements(DataSize.ofBytes((long)0L));
        Assertions.assertThat((Object)estimator.getInitialMemoryRequirements()).isEqualTo((Object)noMemoryRequirements);
    }

    @Test
    public void testSystemMetadataTableScan() {
        PartitionMemoryEstimator estimator = this.createEstimator(TestNoMemoryAwarePartitionMemoryEstimator.tableScanPlanFragment("ts", new TableHandle(GlobalSystemConnector.CATALOG_HANDLE, (ConnectorTableHandle)new SystemTableHandle("metadata", "blah", TupleDomain.all()), (ConnectorTransactionHandle)TestingTransactionHandle.create())), new PlanFragment[0]);
        Assertions.assertThat((Object)estimator).isInstanceOf(NoMemoryPartitionMemoryEstimator.class);
        PartitionMemoryEstimator.MemoryRequirements noMemoryRequirements = new PartitionMemoryEstimator.MemoryRequirements(DataSize.ofBytes((long)0L));
        Assertions.assertThat((Object)estimator.getInitialMemoryRequirements()).isEqualTo((Object)noMemoryRequirements);
    }

    private static PlanFragment getParentFragment(PlanFragment ... childFragments) {
        ImmutableList childFragmentIds = (ImmutableList)Stream.of(childFragments).map(PlanFragment::getId).collect(ImmutableList.toImmutableList());
        return new PlanFragment(new PlanFragmentId("parent"), (PlanNode)new RemoteSourceNode(new PlanNodeId("rsn"), (List)childFragmentIds, (List)ImmutableList.of(), Optional.empty(), ExchangeNode.Type.GATHER, RetryPolicy.TASK), (Set)ImmutableSet.of(), SystemPartitioningHandle.SOURCE_DISTRIBUTION, Optional.empty(), (List)ImmutableList.of(), new PartitioningScheme(Partitioning.create((PartitioningHandle)SystemPartitioningHandle.SINGLE_DISTRIBUTION, (List)ImmutableList.of()), (List)ImmutableList.of()), StatsAndCosts.empty(), (List)ImmutableList.of(), (Map)ImmutableMap.of(), Optional.empty());
    }

    private PartitionMemoryEstimator createEstimator(PlanFragment planFragment, PlanFragment ... sourceFragments) {
        NoMemoryAwarePartitionMemoryEstimator.Factory noMemoryAwareEstimatorFactory = new NoMemoryAwarePartitionMemoryEstimator.Factory((PartitionMemoryEstimatorFactory)new MockDelgatePartitionMemoryEstimatorFactory());
        Session session = TestingSession.testSessionBuilder().build();
        Function<PlanFragmentId, PlanFragment> sourceFragmentsLookup = arg_0 -> ((ImmutableMap)Maps.uniqueIndex(Arrays.asList(sourceFragments), PlanFragment::getId)).get(arg_0);
        return noMemoryAwareEstimatorFactory.createPartitionMemoryEstimator(session, planFragment, sourceFragmentsLookup);
    }

    private static PlanFragment tableScanPlanFragment(String fragmentId, ConnectorTableHandle tableHandle) {
        return TestNoMemoryAwarePartitionMemoryEstimator.tableScanPlanFragment(fragmentId, new TableHandle(TestingHandles.TEST_CATALOG_HANDLE, tableHandle, (ConnectorTransactionHandle)TestingTransactionHandle.create()));
    }

    private static PlanFragment tableScanPlanFragment(String fragmentId, TableHandle tableHandle) {
        TableScanNode informationSchemaViewsTableScan = new TableScanNode(new PlanNodeId("tableScan"), tableHandle, (List)ImmutableList.of(), (Map)ImmutableMap.of(), TupleDomain.all(), Optional.empty(), false, Optional.empty());
        return new PlanFragment(new PlanFragmentId(fragmentId), (PlanNode)informationSchemaViewsTableScan, (Set)ImmutableSet.of(), SystemPartitioningHandle.SOURCE_DISTRIBUTION, Optional.empty(), (List)ImmutableList.of(), new PartitioningScheme(Partitioning.create((PartitioningHandle)SystemPartitioningHandle.SINGLE_DISTRIBUTION, (List)ImmutableList.of()), (List)ImmutableList.of()), StatsAndCosts.empty(), (List)ImmutableList.of(), (Map)ImmutableMap.of(), Optional.empty());
    }

    private static class MockDelegatePatitionMemoryEstimator
    implements PartitionMemoryEstimator {
        private MockDelegatePatitionMemoryEstimator() {
        }

        public PartitionMemoryEstimator.MemoryRequirements getInitialMemoryRequirements() {
            throw new RuntimeException("not implemented");
        }

        public PartitionMemoryEstimator.MemoryRequirements getNextRetryMemoryRequirements(PartitionMemoryEstimator.MemoryRequirements previousMemoryRequirements, DataSize peakMemoryUsage, ErrorCode errorCode) {
            throw new RuntimeException("not implemented");
        }

        public void registerPartitionFinished(PartitionMemoryEstimator.MemoryRequirements previousMemoryRequirements, DataSize peakMemoryUsage, boolean success, Optional<ErrorCode> errorCode) {
            throw new RuntimeException("not implemented");
        }
    }

    private static class MockDelgatePartitionMemoryEstimatorFactory
    implements PartitionMemoryEstimatorFactory {
        private MockDelgatePartitionMemoryEstimatorFactory() {
        }

        public PartitionMemoryEstimator createPartitionMemoryEstimator(Session session, PlanFragment planFragment, Function<PlanFragmentId, PlanFragment> sourceFragmentLookup) {
            return new MockDelegatePatitionMemoryEstimator();
        }
    }
}

