/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.airlift.concurrent.Threads;
import io.airlift.slice.Slices;
import io.airlift.units.DataSize;
import io.trino.SequencePageBuilder;
import io.trino.Session;
import io.trino.jmh.Benchmarks;
import io.trino.metadata.Metadata;
import io.trino.metadata.ResolvedFunction;
import io.trino.metadata.Split;
import io.trino.metadata.TestingFunctionResolution;
import io.trino.operator.DriverContext;
import io.trino.operator.OperatorFactory;
import io.trino.operator.ScanFilterAndProjectOperator;
import io.trino.operator.SourceOperator;
import io.trino.operator.TaskContext;
import io.trino.operator.project.CursorProcessor;
import io.trino.operator.project.PageProcessor;
import io.trino.spi.Page;
import io.trino.spi.connector.ColumnHandle;
import io.trino.spi.connector.ConnectorSplit;
import io.trino.spi.connector.DynamicFilter;
import io.trino.spi.connector.FixedPageSource;
import io.trino.spi.function.OperatorType;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.IntegerType;
import io.trino.spi.type.Type;
import io.trino.spi.type.TypeManager;
import io.trino.spi.type.VarcharType;
import io.trino.sql.PlannerContext;
import io.trino.sql.analyzer.TypeSignatureProvider;
import io.trino.sql.gen.ExpressionCompiler;
import io.trino.sql.gen.PageFunctionCompiler;
import io.trino.sql.ir.Call;
import io.trino.sql.ir.Cast;
import io.trino.sql.ir.Comparison;
import io.trino.sql.ir.Constant;
import io.trino.sql.ir.Expression;
import io.trino.sql.ir.Reference;
import io.trino.sql.planner.Symbol;
import io.trino.sql.planner.TestingPlannerContext;
import io.trino.sql.planner.plan.PlanNodeId;
import io.trino.sql.relational.RowExpression;
import io.trino.sql.relational.SqlToRowExpressionTranslator;
import io.trino.testing.TestingHandles;
import io.trino.testing.TestingMetadata;
import io.trino.testing.TestingSession;
import io.trino.testing.TestingSplit;
import io.trino.testing.TestingTaskContext;
import io.trino.transaction.TestingTransactionManager;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.junit.jupiter.api.Test;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.BenchmarkMode;
import org.openjdk.jmh.annotations.Fork;
import org.openjdk.jmh.annotations.Measurement;
import org.openjdk.jmh.annotations.Mode;
import org.openjdk.jmh.annotations.OutputTimeUnit;
import org.openjdk.jmh.annotations.Param;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.Setup;
import org.openjdk.jmh.annotations.State;
import org.openjdk.jmh.annotations.TearDown;
import org.openjdk.jmh.annotations.Warmup;
import org.openjdk.jmh.runner.RunnerException;

@State(value=Scope.Thread)
@OutputTimeUnit(value=TimeUnit.MILLISECONDS)
@Fork(value=5)
@Warmup(iterations=10)
@Measurement(iterations=10)
@BenchmarkMode(value={Mode.AverageTime})
public class BenchmarkScanFilterAndProjectOperator {
    private static final TestingTransactionManager TRANSACTION_MANAGER = new TestingTransactionManager();
    private static final PlannerContext PLANNER_CONTEXT = TestingPlannerContext.plannerContextBuilder().withTransactionManager(TRANSACTION_MANAGER).build();
    private static final Map<String, Type> TYPE_MAP = ImmutableMap.of((Object)"bigint", (Object)BigintType.BIGINT, (Object)"varchar", (Object)VarcharType.VARCHAR);
    private static final Session TEST_SESSION = TestingSession.testSessionBuilder().build();
    private static final int TOTAL_POSITIONS = 1000000;
    private static final DataSize FILTER_AND_PROJECT_MIN_OUTPUT_PAGE_SIZE = DataSize.of((long)500L, (DataSize.Unit)DataSize.Unit.KILOBYTE);
    private static final int FILTER_AND_PROJECT_MIN_OUTPUT_PAGE_ROW_COUNT = 256;
    private static final TestingFunctionResolution FUNCTIONS = new TestingFunctionResolution();
    private static final ResolvedFunction CONCAT = FUNCTIONS.resolveFunction("concat", TypeSignatureProvider.fromTypes((Type[])new Type[]{VarcharType.VARCHAR, VarcharType.VARCHAR}));
    private static final ResolvedFunction MODULUS_INTEGER = FUNCTIONS.resolveOperator(OperatorType.MODULUS, (List<? extends Type>)ImmutableList.of((Object)IntegerType.INTEGER, (Object)IntegerType.INTEGER));
    private static final ResolvedFunction MODULUS_BIGINT = FUNCTIONS.resolveOperator(OperatorType.MODULUS, (List<? extends Type>)ImmutableList.of((Object)BigintType.BIGINT, (Object)BigintType.BIGINT));
    private static final ResolvedFunction ADD_BIGINT = FUNCTIONS.resolveOperator(OperatorType.ADD, (List<? extends Type>)ImmutableList.of((Object)BigintType.BIGINT, (Object)BigintType.BIGINT));

    @Benchmark
    public List<Page> benchmarkColumnOriented(Context context) {
        DriverContext driverContext = context.createTaskContext().addPipelineContext(0, true, true, false).addDriverContext();
        SourceOperator operator = (SourceOperator)context.getOperatorFactory().createOperator(driverContext);
        ImmutableList.Builder outputPages = ImmutableList.builder();
        operator.addSplit(new Split(TestingHandles.TEST_CATALOG_HANDLE, (ConnectorSplit)TestingSplit.createLocalSplit()));
        operator.noMoreSplits();
        for (int loops = 0; !operator.isFinished() && loops < 1000000; ++loops) {
            Page outputPage = operator.getOutput();
            if (outputPage == null) continue;
            outputPages.add((Object)outputPage);
        }
        return outputPages.build();
    }

    @Test
    public void testBenchmark() {
        Context context = new Context();
        context.setup();
        this.benchmarkColumnOriented(context);
        context.cleanup();
    }

    public static void main(String[] args) throws RunnerException {
        Benchmarks.benchmark(BenchmarkScanFilterAndProjectOperator.class).run();
    }

    @State(value=Scope.Thread)
    public static class Context {
        private final Map<Symbol, Integer> sourceLayout = new HashMap<Symbol, Integer>();
        private ExecutorService executor;
        private ScheduledExecutorService scheduledExecutor;
        private OperatorFactory operatorFactory;
        @Param(value={"32", "1024"})
        int positionsPerPage = 32;
        @Param(value={"2", "4", "8", "16", "32"})
        int columnCount = 2;
        @Param(value={"varchar", "bigint"})
        String type = "varchar";
        @Param(value={"false", "true"})
        boolean dictionaryBlocks;

        @Setup
        public void setup() {
            this.executor = Executors.newCachedThreadPool(Threads.daemonThreadsNamed((String)(this.getClass().getSimpleName() + "-%s")));
            this.scheduledExecutor = Executors.newScheduledThreadPool(2, Threads.daemonThreadsNamed((String)(this.getClass().getSimpleName() + "-scheduledExecutor-%s")));
            Type type = TYPE_MAP.get(this.type);
            for (int i2 = 0; i2 < this.columnCount; ++i2) {
                Symbol symbol = new Symbol(type, type.getDisplayName().toLowerCase(Locale.ENGLISH) + i2);
                this.sourceLayout.put(symbol, i2);
            }
            List<RowExpression> projections = this.getProjections(type);
            List<Type> types = projections.stream().map(RowExpression::type).collect(Collectors.toList());
            List columnHandles = (List)IntStream.range(0, this.columnCount).mapToObj(i -> new TestingMetadata.TestingColumnHandle(Integer.toString(i))).collect(ImmutableList.toImmutableList());
            PageFunctionCompiler pageFunctionCompiler = new PageFunctionCompiler(PLANNER_CONTEXT.getFunctionManager(), 0);
            PageProcessor pageProcessor = (PageProcessor)new ExpressionCompiler(PLANNER_CONTEXT.getFunctionManager(), pageFunctionCompiler).compilePageProcessor(Optional.of(this.getFilter(type)), projections).get();
            CursorProcessor cursorProcessor = (CursorProcessor)new ExpressionCompiler(PLANNER_CONTEXT.getFunctionManager(), pageFunctionCompiler).compileCursorProcessor(Optional.of(this.getFilter(type)), projections, (Object)"key").get();
            this.createTaskContext();
            this.createScanFilterAndProjectOperatorFactories(this.createInputPages(types), pageProcessor, cursorProcessor, columnHandles, types);
        }

        @TearDown
        public void cleanup() {
            this.executor.shutdownNow();
            this.scheduledExecutor.shutdownNow();
        }

        private void createScanFilterAndProjectOperatorFactories(List<Page> inputPages, PageProcessor pageProcessor, CursorProcessor cursorProcessor, List<ColumnHandle> columnHandles, List<Type> types) {
            this.operatorFactory = new ScanFilterAndProjectOperator.ScanFilterAndProjectOperatorFactory(0, new PlanNodeId("test"), new PlanNodeId("test_source"), catalog -> (session, split, table, columns, dynamicFilter) -> new FixedPageSource(inputPages), () -> cursorProcessor, () -> pageProcessor, TestingHandles.TEST_TABLE_HANDLE, columnHandles, DynamicFilter.EMPTY, types, FILTER_AND_PROJECT_MIN_OUTPUT_PAGE_SIZE, 256);
        }

        public TaskContext createTaskContext() {
            return TestingTaskContext.createTaskContext((Executor)this.executor, (ScheduledExecutorService)this.scheduledExecutor, (Session)TEST_SESSION, (DataSize)DataSize.of((long)2L, (DataSize.Unit)DataSize.Unit.GIGABYTE));
        }

        public OperatorFactory getOperatorFactory() {
            return this.operatorFactory;
        }

        private List<Page> createInputPages(List<Type> types) {
            ImmutableList.Builder inputPagesBuilder = ImmutableList.builder();
            for (int i = 0; i < 1000000 / this.positionsPerPage; ++i) {
                inputPagesBuilder.add((Object)Context.createPage(types, this.positionsPerPage, this.dictionaryBlocks));
            }
            return inputPagesBuilder.build();
        }

        private RowExpression getFilter(Type type) {
            if (type == VarcharType.VARCHAR) {
                return this.rowExpression((Expression)new Comparison(Comparison.Operator.EQUAL, (Expression)new Call(MODULUS_INTEGER, (List)ImmutableList.of((Object)new Cast((Expression)new Reference((Type)VarcharType.VARCHAR, "varchar0"), (Type)IntegerType.INTEGER), (Object)new Constant((Type)IntegerType.INTEGER, (Object)2L))), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)0L)));
            }
            if (type == BigintType.BIGINT) {
                return this.rowExpression((Expression)new Comparison(Comparison.Operator.EQUAL, (Expression)new Call(MODULUS_BIGINT, (List)ImmutableList.of((Object)new Reference((Type)IntegerType.INTEGER, "bigint0"), (Object)new Constant((Type)IntegerType.INTEGER, (Object)2L))), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)0L)));
            }
            throw new IllegalArgumentException("filter not supported for type : " + String.valueOf(type));
        }

        private List<RowExpression> getProjections(Type type) {
            ImmutableList.Builder builder;
            block3: {
                block2: {
                    builder = ImmutableList.builder();
                    if (type != BigintType.BIGINT) break block2;
                    for (int i = 0; i < this.columnCount; ++i) {
                        builder.add((Object)this.rowExpression((Expression)new Call(ADD_BIGINT, (List)ImmutableList.of((Object)new Reference((Type)BigintType.BIGINT, "bigint" + i), (Object)new Constant((Type)BigintType.BIGINT, (Object)5L)))));
                    }
                    break block3;
                }
                if (type != VarcharType.VARCHAR) break block3;
                for (int i = 0; i < this.columnCount; ++i) {
                    builder.add((Object)this.rowExpression((Expression)new Call(CONCAT, (List)ImmutableList.of((Object)new Reference((Type)VarcharType.VARCHAR, "varchar" + i), (Object)new Constant((Type)VarcharType.VARCHAR, (Object)Slices.utf8Slice((String)"foo"))))));
                }
            }
            return builder.build();
        }

        private RowExpression rowExpression(Expression expression) {
            return SqlToRowExpressionTranslator.translate((Expression)expression, this.sourceLayout, (Metadata)PLANNER_CONTEXT.getMetadata(), (TypeManager)PLANNER_CONTEXT.getTypeManager());
        }

        private static Page createPage(List<? extends Type> types, int positions, boolean dictionary) {
            if (dictionary) {
                return SequencePageBuilder.createSequencePageWithDictionaryBlocks(types, positions);
            }
            return SequencePageBuilder.createSequencePage(types, positions);
        }
    }
}

