/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator;

import com.google.common.util.concurrent.Uninterruptibles;
import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import io.airlift.slice.XxHash64;
import io.trino.operator.OperationTimer;
import java.util.Random;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestOperationTimer {
    public static volatile long blackHole;

    @Test
    public void testOverallTiming() {
        this.testOverallTiming(false);
        this.testOverallTiming(true);
    }

    private void testOverallTiming(boolean trackCpuTime) {
        InternalTiming timing = new InternalTiming(trackCpuTime);
        for (int i = 1; i <= 5; ++i) {
            OperationTimer timer = new OperationTimer(trackCpuTime, false);
            TestOperationTimer.doSomething();
            timing.record(arg_0 -> ((OperationTimer)timer).end(arg_0));
        }
    }

    @Test
    public void testOperationTiming() {
        this.testOperationTiming(false);
        this.testOperationTiming(true);
    }

    private void testOperationTiming(boolean trackCpuTime) {
        InternalTiming overallTiming = new InternalTiming(true);
        InternalTiming operationTiming1 = new InternalTiming(trackCpuTime);
        InternalTiming operationTiming2 = new InternalTiming(trackCpuTime);
        InternalTiming operationTiming3 = new InternalTiming(trackCpuTime);
        OperationTimer timer = new OperationTimer(true, trackCpuTime);
        TestOperationTimer.doSomething();
        operationTiming1.record(arg_0 -> ((OperationTimer)timer).recordOperationComplete(arg_0));
        TestOperationTimer.doSomething();
        operationTiming1.record(arg_0 -> ((OperationTimer)timer).recordOperationComplete(arg_0));
        TestOperationTimer.doSomething();
        operationTiming2.record(arg_0 -> ((OperationTimer)timer).recordOperationComplete(arg_0));
        TestOperationTimer.doSomething();
        operationTiming1.record(arg_0 -> ((OperationTimer)timer).recordOperationComplete(arg_0));
        TestOperationTimer.doSomething();
        operationTiming2.record(arg_0 -> ((OperationTimer)timer).recordOperationComplete(arg_0));
        TestOperationTimer.doSomething();
        operationTiming3.record(arg_0 -> ((OperationTimer)timer).recordOperationComplete(arg_0));
        overallTiming.record(arg_0 -> ((OperationTimer)timer).end(arg_0));
        Assertions.assertThat((long)(operationTiming1.getTiming().getWallNanos() + operationTiming2.getTiming().getWallNanos() + operationTiming3.getTiming().getWallNanos())).isLessThanOrEqualTo(overallTiming.getTiming().getWallNanos());
        Assertions.assertThat((long)(operationTiming1.getTiming().getCpuNanos() + operationTiming2.getTiming().getCpuNanos() + operationTiming3.getTiming().getCpuNanos())).isLessThanOrEqualTo(overallTiming.getTiming().getCpuNanos());
    }

    @Test
    public void testOperationAfterEndAreNotAllowed() {
        OperationTimer.OperationTiming timing = new OperationTimer.OperationTiming();
        OperationTimer timer = new OperationTimer(true, false);
        timer.end(timing);
        Assertions.assertThatThrownBy(() -> timer.end(timing)).isInstanceOf(IllegalStateException.class);
        Assertions.assertThatThrownBy(() -> timer.recordOperationComplete(timing)).isInstanceOf(IllegalStateException.class);
    }

    @Test
    public void testInvalidConstructorArguments() {
        Assertions.assertThatThrownBy(() -> new OperationTimer(false, true)).isInstanceOf(IllegalArgumentException.class);
    }

    private static void doSomething() {
        blackHole = XxHash64.hash((Slice)Slices.random((int)10000, (Random)new Random(blackHole)));
        Uninterruptibles.sleepUninterruptibly((long)50L, (TimeUnit)TimeUnit.MILLISECONDS);
    }

    private static class InternalTiming {
        private final boolean trackCpuTime;
        private final OperationTimer.OperationTiming timing = new OperationTimer.OperationTiming();
        private long calls;
        private long previousWallNanos;
        private long previousCpuNanos;

        private InternalTiming(boolean trackCpuTime) {
            this.trackCpuTime = trackCpuTime;
        }

        public OperationTimer.OperationTiming getTiming() {
            return this.timing;
        }

        public void record(Consumer<OperationTimer.OperationTiming> timer) {
            this.previousWallNanos = this.timing.getWallNanos();
            this.previousCpuNanos = this.timing.getCpuNanos();
            Assertions.assertThat((long)this.timing.getCalls()).isEqualTo(this.calls);
            timer.accept(this.timing);
            ++this.calls;
            Assertions.assertThat((long)this.timing.getCalls()).isEqualTo(this.calls);
            Assertions.assertThat((long)this.timing.getWallNanos()).isGreaterThan(this.previousWallNanos);
            if (this.trackCpuTime) {
                Assertions.assertThat((long)this.timing.getCpuNanos()).isGreaterThan(this.previousCpuNanos);
                Assertions.assertThat((long)this.timing.getWallNanos()).isGreaterThan(this.timing.getCpuNanos());
            } else {
                Assertions.assertThat((long)this.timing.getCpuNanos()).isEqualTo(0L);
            }
        }
    }
}

