/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator;

import com.google.common.collect.ImmutableList;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.SettableFuture;
import io.trino.operator.WorkProcessor;
import io.trino.operator.WorkProcessorAssertion;
import io.trino.operator.WorkProcessorUtils;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;

public class TestWorkProcessor {
    @Test
    public void testIterator() {
        WorkProcessor processor = WorkProcessorAssertion.processorFrom(ImmutableList.of((Object)WorkProcessor.ProcessState.ofResult((Object)1), (Object)WorkProcessor.ProcessState.ofResult((Object)2), (Object)WorkProcessor.ProcessState.finished()));
        Iterator iterator = processor.iterator();
        Assertions.assertThat((boolean)iterator.hasNext()).isTrue();
        Assertions.assertThat((Integer)((Integer)iterator.next())).isEqualTo((Object)1);
        Assertions.assertThat((boolean)iterator.hasNext()).isTrue();
        Assertions.assertThat((Integer)((Integer)iterator.next())).isEqualTo((Object)2);
        Assertions.assertThat((boolean)iterator.hasNext()).isFalse();
    }

    @Test
    public void testIteratorFailsWhenWorkProcessorHasYielded() {
        WorkProcessor processor = WorkProcessorAssertion.processorFrom(ImmutableList.of((Object)WorkProcessor.ProcessState.yielded()));
        Iterator iterator = processor.iterator();
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(iterator::hasNext).isInstanceOf(IllegalStateException.class)).hasMessage("Cannot iterate over yielding WorkProcessor");
    }

    @Test
    public void testIteratorFailsWhenWorkProcessorIsBlocked() {
        WorkProcessor processor = WorkProcessorAssertion.processorFrom(ImmutableList.of((Object)WorkProcessor.ProcessState.blocked((ListenableFuture)SettableFuture.create())));
        Iterator iterator = processor.iterator();
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(iterator::hasNext).isInstanceOf(IllegalStateException.class)).hasMessage("Cannot iterate over blocking WorkProcessor");
    }

    @Test
    @Timeout(value=10L)
    public void testMergeSorted() {
        ImmutableList firstStream = ImmutableList.of((Object)WorkProcessor.ProcessState.ofResult((Object)1), (Object)WorkProcessor.ProcessState.ofResult((Object)3), (Object)WorkProcessor.ProcessState.yielded(), (Object)WorkProcessor.ProcessState.ofResult((Object)5), (Object)WorkProcessor.ProcessState.finished());
        SettableFuture secondFuture = SettableFuture.create();
        ImmutableList secondStream = ImmutableList.of((Object)WorkProcessor.ProcessState.ofResult((Object)2), (Object)WorkProcessor.ProcessState.ofResult((Object)4), (Object)WorkProcessor.ProcessState.blocked((ListenableFuture)secondFuture), (Object)WorkProcessor.ProcessState.finished());
        WorkProcessor mergedStream = WorkProcessorUtils.mergeSorted((Iterable)ImmutableList.of(WorkProcessorAssertion.processorFrom(firstStream), WorkProcessorAssertion.processorFrom(secondStream)), Comparator.comparingInt(firstInteger -> firstInteger));
        WorkProcessorAssertion.assertResult(mergedStream, 1);
        WorkProcessorAssertion.assertResult(mergedStream, 2);
        WorkProcessorAssertion.assertResult(mergedStream, 3);
        WorkProcessorAssertion.assertYields(mergedStream);
        WorkProcessorAssertion.assertResult(mergedStream, 4);
        WorkProcessorAssertion.assertBlocks(mergedStream);
        WorkProcessorAssertion.assertUnblocks(mergedStream, secondFuture);
        WorkProcessorAssertion.assertResult(mergedStream, 5);
        WorkProcessorAssertion.assertFinishes(mergedStream);
    }

    @Test
    @Timeout(value=10L)
    public void testMergeSortedEmptyStreams() {
        SettableFuture firstFuture = SettableFuture.create();
        ImmutableList firstStream = ImmutableList.of((Object)WorkProcessor.ProcessState.blocked((ListenableFuture)firstFuture), (Object)WorkProcessor.ProcessState.yielded(), (Object)WorkProcessor.ProcessState.finished());
        SettableFuture secondFuture = SettableFuture.create();
        ImmutableList secondStream = ImmutableList.of((Object)WorkProcessor.ProcessState.blocked((ListenableFuture)secondFuture), (Object)WorkProcessor.ProcessState.finished());
        WorkProcessor mergedStream = WorkProcessorUtils.mergeSorted((Iterable)ImmutableList.of(WorkProcessorAssertion.processorFrom(firstStream), WorkProcessorAssertion.processorFrom(secondStream)), Comparator.comparingInt(firstInteger -> firstInteger));
        Assertions.assertThat((boolean)mergedStream.isBlocked()).isFalse();
        Assertions.assertThat((boolean)mergedStream.isFinished()).isFalse();
        WorkProcessorAssertion.assertBlocks(mergedStream);
        WorkProcessorAssertion.assertUnblocks(mergedStream, firstFuture);
        WorkProcessorAssertion.assertYields(mergedStream);
        WorkProcessorAssertion.assertBlocks(mergedStream);
        WorkProcessorAssertion.assertUnblocks(mergedStream, secondFuture);
        WorkProcessorAssertion.assertFinishes(mergedStream);
    }

    @Test
    @Timeout(value=10L)
    public void testMergeSortedEmptyStreamsWithFinishedOnly() {
        ImmutableList firstStream = ImmutableList.of((Object)WorkProcessor.ProcessState.finished());
        ImmutableList secondStream = ImmutableList.of((Object)WorkProcessor.ProcessState.finished());
        WorkProcessor mergedStream = WorkProcessorUtils.mergeSorted((Iterable)ImmutableList.of(WorkProcessorAssertion.processorFrom(firstStream), WorkProcessorAssertion.processorFrom(secondStream)), Comparator.comparingInt(firstInteger -> firstInteger));
        Assertions.assertThat((boolean)mergedStream.isBlocked()).isFalse();
        Assertions.assertThat((boolean)mergedStream.isFinished()).isFalse();
        WorkProcessorAssertion.assertFinishes(mergedStream);
    }

    @Test
    @Timeout(value=10L)
    public void testYield() {
        SettableFuture future = SettableFuture.create();
        ImmutableList baseScenario = ImmutableList.of((Object)WorkProcessor.ProcessState.ofResult((Object)1), (Object)WorkProcessor.ProcessState.ofResult((Object)2), (Object)WorkProcessor.ProcessState.blocked((ListenableFuture)future), (Object)WorkProcessor.ProcessState.ofResult((Object)3), (Object)WorkProcessor.ProcessState.ofResult((Object)4), (Object)WorkProcessor.ProcessState.finished());
        AtomicBoolean yieldSignal = new AtomicBoolean();
        WorkProcessor processor = WorkProcessorAssertion.processorFrom(baseScenario).yielding(yieldSignal::get);
        WorkProcessorAssertion.assertResult(processor, 1);
        yieldSignal.set(true);
        WorkProcessorAssertion.assertYields(processor);
        WorkProcessorAssertion.assertResult(processor, 2);
        WorkProcessorAssertion.assertYields(processor);
        WorkProcessorAssertion.assertBlocks(processor);
        WorkProcessorAssertion.assertUnblocks(processor, future);
        yieldSignal.set(false);
        WorkProcessorAssertion.assertResult(processor, 3);
        WorkProcessorAssertion.assertResult(processor, 4);
        WorkProcessorAssertion.assertFinishes(processor);
    }

    @Test
    @Timeout(value=10L)
    public void testBlock() {
        SettableFuture phase1 = SettableFuture.create();
        ImmutableList scenario = ImmutableList.of((Object)WorkProcessor.ProcessState.blocked((ListenableFuture)phase1), (Object)WorkProcessor.ProcessState.yielded(), (Object)WorkProcessor.ProcessState.ofResult((Object)1), (Object)WorkProcessor.ProcessState.finished());
        AtomicReference<SettableFuture> phase2 = new AtomicReference<SettableFuture>(SettableFuture.create());
        WorkProcessor processor = WorkProcessorAssertion.processorFrom(scenario).blocking(phase2::get);
        WorkProcessorAssertion.assertBlocks(processor);
        WorkProcessorAssertion.assertUnblocks(processor, phase2.get());
        WorkProcessorAssertion.assertBlocks(processor);
        WorkProcessorAssertion.assertUnblocks(processor, phase1);
        phase2.set(SettableFuture.create());
        WorkProcessorAssertion.assertBlocks(processor);
        WorkProcessorAssertion.assertUnblocks(processor, phase2.get());
        WorkProcessorAssertion.assertResult(processor, 1);
        phase2.set(SettableFuture.create());
        WorkProcessorAssertion.assertBlocks(processor);
        WorkProcessorAssertion.assertUnblocks(processor, phase2.get());
        WorkProcessorAssertion.assertFinishes(processor);
    }

    @Test
    @Timeout(value=10L)
    public void testProcessStateMonitor() {
        SettableFuture future = SettableFuture.create();
        ImmutableList baseScenario = ImmutableList.of((Object)WorkProcessor.ProcessState.ofResult((Object)1), (Object)WorkProcessor.ProcessState.yielded(), (Object)WorkProcessor.ProcessState.blocked((ListenableFuture)future), (Object)WorkProcessor.ProcessState.finished());
        ImmutableList.Builder actions = ImmutableList.builder();
        WorkProcessor processor = WorkProcessorAssertion.processorFrom(baseScenario).withProcessStateMonitor(state -> actions.add((Object)state.getType()));
        WorkProcessorAssertion.assertResult(processor, 1);
        WorkProcessorAssertion.assertYields(processor);
        WorkProcessorAssertion.assertBlocks(processor);
        WorkProcessorAssertion.assertUnblocks(processor, future);
        WorkProcessorAssertion.assertFinishes(processor);
        Assertions.assertThat((List)actions.build()).isEqualTo((Object)ImmutableList.of((Object)WorkProcessor.ProcessState.Type.RESULT, (Object)WorkProcessor.ProcessState.Type.YIELD, (Object)WorkProcessor.ProcessState.Type.BLOCKED, (Object)WorkProcessor.ProcessState.Type.FINISHED));
    }

    @Test
    @Timeout(value=10L)
    public void testFinished() {
        AtomicBoolean finished = new AtomicBoolean();
        SettableFuture future = SettableFuture.create();
        ImmutableList scenario = ImmutableList.of((Object)WorkProcessor.ProcessState.ofResult((Object)1), (Object)WorkProcessor.ProcessState.yielded(), (Object)WorkProcessor.ProcessState.blocked((ListenableFuture)future), (Object)WorkProcessor.ProcessState.ofResult((Object)2));
        WorkProcessor processor = WorkProcessorAssertion.processorFrom(scenario).finishWhen(finished::get);
        WorkProcessorAssertion.assertResult(processor, 1);
        WorkProcessorAssertion.assertYields(processor);
        WorkProcessorAssertion.assertBlocks(processor);
        finished.set(true);
        WorkProcessorAssertion.assertBlocks(processor);
        WorkProcessorAssertion.assertUnblocks(processor, future);
        WorkProcessorAssertion.assertFinishes(processor);
    }

    @Test
    @Timeout(value=10L)
    public void testFlatMap() {
        ImmutableList baseScenario = ImmutableList.of((Object)WorkProcessor.ProcessState.ofResult((Object)1), (Object)WorkProcessor.ProcessState.ofResult((Object)2), (Object)WorkProcessor.ProcessState.finished());
        WorkProcessor processor = WorkProcessorAssertion.processorFrom(baseScenario).flatMap(element -> WorkProcessor.fromIterable((Iterable)ImmutableList.of((Object)(Double.valueOf(2.0) * (double)element.intValue()), (Object)(Double.valueOf(3.0) * (double)element.intValue()))));
        WorkProcessorAssertion.assertResult(processor, 2.0);
        WorkProcessorAssertion.assertResult(processor, 3.0);
        WorkProcessorAssertion.assertResult(processor, 4.0);
        WorkProcessorAssertion.assertResult(processor, 6.0);
        WorkProcessorAssertion.assertFinishes(processor);
    }

    @Test
    @Timeout(value=10L)
    public void testMap() {
        ImmutableList baseScenario = ImmutableList.of((Object)WorkProcessor.ProcessState.ofResult((Object)1), (Object)WorkProcessor.ProcessState.ofResult((Object)2), (Object)WorkProcessor.ProcessState.finished());
        WorkProcessor processor = WorkProcessorAssertion.processorFrom(baseScenario).map(element -> 2.0 * (double)element.intValue());
        WorkProcessorAssertion.assertResult(processor, 2.0);
        WorkProcessorAssertion.assertResult(processor, 4.0);
        WorkProcessorAssertion.assertFinishes(processor);
    }

    @Test
    @Timeout(value=10L)
    public void testFlatTransform() {
        SettableFuture baseFuture = SettableFuture.create();
        ImmutableList baseScenario = ImmutableList.of((Object)WorkProcessor.ProcessState.ofResult((Object)1.0), (Object)WorkProcessor.ProcessState.blocked((ListenableFuture)baseFuture), (Object)WorkProcessor.ProcessState.ofResult((Object)2.0), (Object)WorkProcessor.ProcessState.yielded(), (Object)WorkProcessor.ProcessState.ofResult((Object)3.0), (Object)WorkProcessor.ProcessState.ofResult((Object)4.0), (Object)WorkProcessor.ProcessState.finished());
        SettableFuture mappedFuture1 = SettableFuture.create();
        ImmutableList mappedScenario1 = ImmutableList.of((Object)WorkProcessor.ProcessState.ofResult((Object)1), (Object)WorkProcessor.ProcessState.yielded(), (Object)WorkProcessor.ProcessState.blocked((ListenableFuture)mappedFuture1), (Object)WorkProcessor.ProcessState.ofResult((Object)2), (Object)WorkProcessor.ProcessState.finished());
        ImmutableList mappedScenario2 = ImmutableList.of((Object)WorkProcessor.ProcessState.finished());
        SettableFuture mappedFuture3 = SettableFuture.create();
        ImmutableList mappedScenario3 = ImmutableList.of((Object)WorkProcessor.ProcessState.blocked((ListenableFuture)mappedFuture3), (Object)WorkProcessor.ProcessState.finished());
        ImmutableList mappedScenario4 = ImmutableList.of((Object)WorkProcessor.ProcessState.ofResult((Object)3), (Object)WorkProcessor.ProcessState.finished());
        SettableFuture transformationFuture = SettableFuture.create();
        ImmutableList transformationScenario = ImmutableList.of(WorkProcessorAssertion.Transform.of(Optional.of(1.0), WorkProcessor.TransformationState.ofResult(WorkProcessorAssertion.processorFrom(mappedScenario1), (boolean)false)), WorkProcessorAssertion.Transform.of(Optional.of(1.0), WorkProcessor.TransformationState.ofResult(WorkProcessorAssertion.processorFrom(mappedScenario2), (boolean)false)), WorkProcessorAssertion.Transform.of(Optional.of(1.0), WorkProcessor.TransformationState.ofResult(WorkProcessorAssertion.processorFrom(mappedScenario3))), WorkProcessorAssertion.Transform.of(Optional.of(2.0), WorkProcessor.TransformationState.blocked((ListenableFuture)transformationFuture)), WorkProcessorAssertion.Transform.of(Optional.of(2.0), WorkProcessor.TransformationState.ofResult(WorkProcessorAssertion.processorFrom(mappedScenario4))), WorkProcessorAssertion.Transform.of(Optional.of(3.0), WorkProcessor.TransformationState.finished()));
        WorkProcessor processor = WorkProcessorAssertion.processorFrom(baseScenario).flatTransform(WorkProcessorAssertion.transformationFrom(transformationScenario));
        WorkProcessorAssertion.assertResult(processor, 1);
        WorkProcessorAssertion.assertYields(processor);
        WorkProcessorAssertion.assertBlocks(processor);
        WorkProcessorAssertion.assertUnblocks(processor, mappedFuture1);
        WorkProcessorAssertion.assertResult(processor, 2);
        WorkProcessorAssertion.assertBlocks(processor);
        WorkProcessorAssertion.assertUnblocks(processor, mappedFuture3);
        WorkProcessorAssertion.assertBlocks(processor);
        WorkProcessorAssertion.assertUnblocks(processor, baseFuture);
        WorkProcessorAssertion.assertBlocks(processor);
        WorkProcessorAssertion.assertUnblocks(processor, transformationFuture);
        WorkProcessorAssertion.assertResult(processor, 3);
        WorkProcessorAssertion.assertYields(processor);
        WorkProcessorAssertion.assertFinishes(processor);
    }

    @Test
    @Timeout(value=10L)
    public void testTransform() {
        SettableFuture baseFuture = SettableFuture.create();
        ImmutableList baseScenario = ImmutableList.of((Object)WorkProcessor.ProcessState.ofResult((Object)1), (Object)WorkProcessor.ProcessState.yielded(), (Object)WorkProcessor.ProcessState.blocked((ListenableFuture)baseFuture), (Object)WorkProcessor.ProcessState.ofResult((Object)2), (Object)WorkProcessor.ProcessState.ofResult((Object)3), (Object)WorkProcessor.ProcessState.finished());
        SettableFuture transformationFuture = SettableFuture.create();
        ImmutableList transformationScenario = ImmutableList.of(WorkProcessorAssertion.Transform.of(Optional.of(1), WorkProcessor.TransformationState.needsMoreData()), WorkProcessorAssertion.Transform.of(Optional.of(2), WorkProcessor.TransformationState.ofResult((Object)"foo")), WorkProcessorAssertion.Transform.of(Optional.of(3), WorkProcessor.TransformationState.blocked((ListenableFuture)transformationFuture)), WorkProcessorAssertion.Transform.of(Optional.of(3), WorkProcessor.TransformationState.yielded()), WorkProcessorAssertion.Transform.of(Optional.of(3), WorkProcessor.TransformationState.ofResult((Object)"bar", (boolean)false)), WorkProcessorAssertion.Transform.of(Optional.of(3), WorkProcessor.TransformationState.ofResult((Object)"zoo", (boolean)true)), WorkProcessorAssertion.Transform.of(Optional.empty(), WorkProcessor.TransformationState.ofResult((Object)"car", (boolean)false)), WorkProcessorAssertion.Transform.of(Optional.empty(), WorkProcessor.TransformationState.finished()));
        WorkProcessor processor = WorkProcessorAssertion.processorFrom(baseScenario).transform(WorkProcessorAssertion.transformationFrom(transformationScenario));
        Assertions.assertThat((boolean)processor.isBlocked()).isFalse();
        Assertions.assertThat((boolean)processor.isFinished()).isFalse();
        WorkProcessorAssertion.assertYields(processor);
        WorkProcessorAssertion.assertBlocks(processor);
        WorkProcessorAssertion.assertUnblocks(processor, baseFuture);
        WorkProcessorAssertion.assertResult(processor, "foo");
        WorkProcessorAssertion.assertBlocks(processor);
        WorkProcessorAssertion.assertUnblocks(processor, transformationFuture);
        WorkProcessorAssertion.assertYields(processor);
        WorkProcessorAssertion.assertResult(processor, "bar");
        WorkProcessorAssertion.assertResult(processor, "zoo");
        WorkProcessorAssertion.assertResult(processor, "car");
        WorkProcessorAssertion.assertFinishes(processor);
    }

    @Test
    @Timeout(value=10L)
    public void testCreateFrom() {
        SettableFuture future = SettableFuture.create();
        ImmutableList scenario = ImmutableList.of((Object)WorkProcessor.ProcessState.yielded(), (Object)WorkProcessor.ProcessState.ofResult((Object)1), (Object)WorkProcessor.ProcessState.blocked((ListenableFuture)future), (Object)WorkProcessor.ProcessState.yielded(), (Object)WorkProcessor.ProcessState.ofResult((Object)2), (Object)WorkProcessor.ProcessState.finished());
        WorkProcessor processor = WorkProcessorAssertion.processorFrom(scenario);
        Assertions.assertThat((boolean)processor.isBlocked()).isFalse();
        Assertions.assertThat((boolean)processor.isFinished()).isFalse();
        WorkProcessorAssertion.assertYields(processor);
        WorkProcessorAssertion.assertResult(processor, 1);
        WorkProcessorAssertion.assertBlocks(processor);
        WorkProcessorAssertion.assertUnblocks(processor, future);
        WorkProcessorAssertion.assertYields(processor);
        WorkProcessorAssertion.assertResult(processor, 2);
        WorkProcessorAssertion.assertFinishes(processor);
    }
}

