/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.project;

import io.trino.block.BlockAssertions;
import io.trino.operator.DriverYieldSignal;
import io.trino.operator.project.InputPageProjection;
import io.trino.operator.project.SelectedPositions;
import io.trino.spi.Page;
import io.trino.spi.block.Block;
import io.trino.spi.block.LazyBlock;
import io.trino.spi.block.ValueBlock;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.Type;
import io.trino.testing.TestingConnectorSession;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestInputPageProjection {
    @Test
    public void testLazyInputPage() {
        InputPageProjection projection = new InputPageProjection(0, (Type)BigintType.BIGINT);
        ValueBlock block = BlockAssertions.createLongSequenceBlock(0, 100);
        Block result = (Block)projection.project(TestingConnectorSession.SESSION, new DriverYieldSignal(), new Page(new Block[]{block}), SelectedPositions.positionsRange((int)0, (int)100)).getResult();
        Assertions.assertThat((boolean)(result instanceof LazyBlock)).isFalse();
        block = TestInputPageProjection.lazyWrapper((Block)block);
        result = (Block)projection.project(TestingConnectorSession.SESSION, new DriverYieldSignal(), new Page(new Block[]{block}), SelectedPositions.positionsRange((int)0, (int)100)).getResult();
        Assertions.assertThat((boolean)(result instanceof LazyBlock)).isTrue();
        Assertions.assertThat((boolean)result.isLoaded()).isFalse();
    }

    private static LazyBlock lazyWrapper(Block block) {
        return new LazyBlock(block.getPositionCount(), () -> ((Block)block).getLoadedBlock());
    }
}

