/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner.assertions;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import io.trino.Session;
import io.trino.cost.StatsProvider;
import io.trino.metadata.Metadata;
import io.trino.sql.planner.assertions.MatchResult;
import io.trino.sql.planner.assertions.Matcher;
import io.trino.sql.planner.assertions.SymbolAliases;
import io.trino.sql.planner.plan.ExceptNode;
import io.trino.sql.planner.plan.IntersectNode;
import io.trino.sql.planner.plan.PlanNode;

public class DistinctMatcher
implements Matcher {
    private final boolean distinct;

    DistinctMatcher(boolean distinct) {
        this.distinct = distinct;
    }

    @Override
    public boolean shapeMatches(PlanNode node) {
        return node instanceof IntersectNode || node instanceof ExceptNode;
    }

    @Override
    public MatchResult detailMatches(PlanNode node, StatsProvider stats, Session session, Metadata metadata, SymbolAliases symbolAliases) {
        boolean actualIsDistinct;
        Preconditions.checkState((boolean)this.shapeMatches(node), (String)"Plan testing framework error: shapeMatches returned false in detailMatches in %s", (Object)this.getClass().getName());
        if (node instanceof IntersectNode) {
            actualIsDistinct = ((IntersectNode)node).isDistinct();
        } else if (node instanceof ExceptNode) {
            actualIsDistinct = ((ExceptNode)node).isDistinct();
        } else {
            throw new IllegalStateException("Unexpected plan node: " + String.valueOf(node));
        }
        if (actualIsDistinct != this.distinct) {
            return MatchResult.NO_MATCH;
        }
        return MatchResult.match();
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("distinct", this.distinct).toString();
    }
}

