/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner.iterative.rule;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.trino.metadata.ResolvedFunction;
import io.trino.metadata.TestingFunctionResolution;
import io.trino.spi.Plugin;
import io.trino.spi.function.OperatorType;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.BooleanType;
import io.trino.spi.type.RowType;
import io.trino.spi.type.Type;
import io.trino.sql.ir.Booleans;
import io.trino.sql.ir.Call;
import io.trino.sql.ir.Expression;
import io.trino.sql.ir.FieldReference;
import io.trino.sql.ir.Reference;
import io.trino.sql.planner.Symbol;
import io.trino.sql.planner.assertions.ExpressionMatcher;
import io.trino.sql.planner.assertions.PlanMatchPattern;
import io.trino.sql.planner.iterative.Rule;
import io.trino.sql.planner.iterative.rule.PushLimitThroughProject;
import io.trino.sql.planner.iterative.rule.test.BaseRuleTest;
import io.trino.sql.planner.plan.Assignments;
import io.trino.sql.planner.plan.PlanNode;
import io.trino.sql.tree.SortItem;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.junit.jupiter.api.Test;

public class TestPushLimitThroughProject
extends BaseRuleTest {
    private static final TestingFunctionResolution FUNCTIONS = new TestingFunctionResolution();
    private static final ResolvedFunction ADD_BIGINT = FUNCTIONS.resolveOperator(OperatorType.ADD, (List<? extends Type>)ImmutableList.of((Object)BigintType.BIGINT, (Object)BigintType.BIGINT));

    public TestPushLimitThroughProject() {
        super(new Plugin[0]);
    }

    @Test
    public void testPushdownLimitNonIdentityProjection() {
        this.tester().assertThat((Rule<?>)new PushLimitThroughProject()).on(p -> {
            Symbol a = p.symbol("a", (Type)BooleanType.BOOLEAN);
            return p.limit(1L, (PlanNode)p.project(Assignments.of((Symbol)a, (Expression)Booleans.TRUE), (PlanNode)p.values(new Symbol[0])));
        }).matches(PlanMatchPattern.strictProject((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"b", (Object)PlanMatchPattern.expression((Expression)Booleans.TRUE)), PlanMatchPattern.limit(1L, PlanMatchPattern.values(new String[0]))));
    }

    @Test
    public void testPushdownLimitWithTiesNNonIdentityProjection() {
        this.tester().assertThat((Rule<?>)new PushLimitThroughProject()).on(p -> {
            Symbol projectedA = p.symbol("projectedA");
            Symbol a = p.symbol("a");
            Symbol projectedB = p.symbol("projectedB");
            Symbol b = p.symbol("b");
            return p.limit(1L, (List<Symbol>)ImmutableList.of((Object)projectedA), (PlanNode)p.project(Assignments.of((Symbol)projectedA, (Expression)new Reference((Type)BigintType.BIGINT, "a"), (Symbol)projectedB, (Expression)new Reference((Type)BigintType.BIGINT, "b")), (PlanNode)p.values(a, b)));
        }).matches(PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"projectedA", (Object)PlanMatchPattern.expression((Expression)new Reference((Type)BigintType.BIGINT, "a")), (Object)"projectedB", (Object)PlanMatchPattern.expression((Expression)new Reference((Type)BigintType.BIGINT, "b"))), PlanMatchPattern.limit(1L, (List<PlanMatchPattern.Ordering>)ImmutableList.of((Object)PlanMatchPattern.sort("a", SortItem.Ordering.ASCENDING, SortItem.NullOrdering.FIRST)), PlanMatchPattern.values("a", "b"))));
    }

    @Test
    public void testPushdownLimitWithTiesThroughProjectionWithExpression() {
        this.tester().assertThat((Rule<?>)new PushLimitThroughProject()).on(p -> {
            Symbol projectedA = p.symbol("projectedA");
            Symbol a = p.symbol("a");
            Symbol projectedC = p.symbol("projectedC");
            Symbol b = p.symbol("b");
            return p.limit(1L, (List<Symbol>)ImmutableList.of((Object)projectedA), (PlanNode)p.project(Assignments.of((Symbol)projectedA, (Expression)new Reference((Type)BigintType.BIGINT, "a"), (Symbol)projectedC, (Expression)new Call(ADD_BIGINT, (List)ImmutableList.of((Object)new Reference((Type)BigintType.BIGINT, "a"), (Object)new Reference((Type)BigintType.BIGINT, "b")))), (PlanNode)p.values(a, b)));
        }).matches(PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"projectedA", (Object)PlanMatchPattern.expression((Expression)new Reference((Type)BigintType.BIGINT, "a")), (Object)"projectedC", (Object)PlanMatchPattern.expression((Expression)new Call(ADD_BIGINT, (List)ImmutableList.of((Object)new Reference((Type)BigintType.BIGINT, "a"), (Object)new Reference((Type)BigintType.BIGINT, "b"))))), PlanMatchPattern.limit(1L, (List<PlanMatchPattern.Ordering>)ImmutableList.of((Object)PlanMatchPattern.sort("a", SortItem.Ordering.ASCENDING, SortItem.NullOrdering.FIRST)), PlanMatchPattern.values("a", "b"))));
    }

    @Test
    public void testDoNotPushdownLimitWithTiesThroughProjectionWithExpression() {
        this.tester().assertThat((Rule<?>)new PushLimitThroughProject()).on(p -> {
            Symbol projectedA = p.symbol("projectedA");
            Symbol a = p.symbol("a");
            Symbol projectedC = p.symbol("projectedC");
            Symbol b = p.symbol("b");
            return p.limit(1L, (List<Symbol>)ImmutableList.of((Object)projectedC), (PlanNode)p.project(Assignments.of((Symbol)projectedA, (Expression)new Reference((Type)BigintType.BIGINT, "a"), (Symbol)projectedC, (Expression)new Call(ADD_BIGINT, (List)ImmutableList.of((Object)new Reference((Type)BigintType.BIGINT, "a"), (Object)new Reference((Type)BigintType.BIGINT, "b")))), (PlanNode)p.values(a, b)));
        }).doesNotFire();
    }

    @Test
    public void testDoesntPushdownLimitThroughIdentityProjection() {
        this.tester().assertThat((Rule<?>)new PushLimitThroughProject()).on(p -> {
            Symbol a = p.symbol("a");
            return p.limit(1L, (PlanNode)p.project(Assignments.of((Symbol)a, (Expression)a.toSymbolReference()), (PlanNode)p.values(a)));
        }).doesNotFire();
    }

    @Test
    public void testDoesntPushDownLimitThroughExclusiveDereferences() {
        RowType rowType = RowType.from((List)ImmutableList.of((Object)new RowType.Field(Optional.of("x"), (Type)BigintType.BIGINT), (Object)new RowType.Field(Optional.of("y"), (Type)BigintType.BIGINT)));
        this.tester().assertThat((Rule<?>)new PushLimitThroughProject()).on(p -> {
            Symbol a = p.symbol("a", (Type)rowType);
            return p.limit(1L, (PlanNode)p.project(Assignments.of((Symbol)p.symbol("b"), (Expression)new FieldReference((Expression)a.toSymbolReference(), 0), (Symbol)p.symbol("c"), (Expression)new FieldReference((Expression)a.toSymbolReference(), 1)), (PlanNode)p.values(a)));
        }).doesNotFire();
    }

    @Test
    public void testLimitWithPreSortedInputs() {
        this.tester().assertThat((Rule<?>)new PushLimitThroughProject()).on(p -> {
            Symbol projectedA = p.symbol("projectedA");
            Symbol a = p.symbol("a");
            Symbol projectedC = p.symbol("projectedC");
            Symbol b = p.symbol("b");
            return p.limit(1L, false, (List<Symbol>)ImmutableList.of((Object)projectedC), (PlanNode)p.project(Assignments.of((Symbol)projectedA, (Expression)new Reference((Type)BigintType.BIGINT, "a"), (Symbol)projectedC, (Expression)new Call(ADD_BIGINT, (List)ImmutableList.of((Object)new Reference((Type)BigintType.BIGINT, "a"), (Object)new Reference((Type)BigintType.BIGINT, "b")))), (PlanNode)p.values(a, b)));
        }).doesNotFire();
        this.tester().assertThat((Rule<?>)new PushLimitThroughProject()).on(p -> {
            Symbol projectedA = p.symbol("projectedA");
            Symbol a = p.symbol("a");
            Symbol projectedC = p.symbol("projectedC");
            Symbol b = p.symbol("b");
            return p.limit(1L, (List<Symbol>)ImmutableList.of(), true, (List<Symbol>)ImmutableList.of((Object)projectedA), (PlanNode)p.project(Assignments.of((Symbol)projectedA, (Expression)new Reference((Type)BigintType.BIGINT, "a"), (Symbol)projectedC, (Expression)new Call(ADD_BIGINT, (List)ImmutableList.of((Object)new Reference((Type)BigintType.BIGINT, "a"), (Object)new Reference((Type)BigintType.BIGINT, "b")))), (PlanNode)p.values(a, b)));
        }).matches(PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"projectedA", (Object)PlanMatchPattern.expression((Expression)new Reference((Type)BigintType.BIGINT, "a")), (Object)"projectedC", (Object)PlanMatchPattern.expression((Expression)new Call(ADD_BIGINT, (List)ImmutableList.of((Object)new Reference((Type)BigintType.BIGINT, "a"), (Object)new Reference((Type)BigintType.BIGINT, "b"))))), PlanMatchPattern.limit(1L, (List<PlanMatchPattern.Ordering>)ImmutableList.of(), true, (List<String>)ImmutableList.of((Object)"a"), PlanMatchPattern.values("a", "b"))));
    }

    @Test
    public void testPushDownLimitThroughOverlappingDereferences() {
        RowType rowType = RowType.from((List)ImmutableList.of((Object)new RowType.Field(Optional.of("x"), (Type)BigintType.BIGINT), (Object)new RowType.Field(Optional.of("y"), (Type)BigintType.BIGINT)));
        this.tester().assertThat((Rule<?>)new PushLimitThroughProject()).on(p -> {
            Symbol a = p.symbol("a", (Type)rowType);
            return p.limit(1L, (PlanNode)p.project(Assignments.of((Symbol)p.symbol("b"), (Expression)new FieldReference((Expression)a.toSymbolReference(), 0), (Symbol)p.symbol("c", (Type)rowType), (Expression)a.toSymbolReference()), (PlanNode)p.values(a)));
        }).matches(PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"b", (Object)PlanMatchPattern.expression((Expression)new FieldReference((Expression)new Reference((Type)rowType, "a"), 0)), (Object)"c", (Object)PlanMatchPattern.expression((Expression)new Reference((Type)rowType, "a"))), PlanMatchPattern.limit(1L, PlanMatchPattern.values("a"))));
    }
}

