/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.query;

import io.trino.sql.query.QueryAssertions;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInstance;
import org.junit.jupiter.api.parallel.Execution;
import org.junit.jupiter.api.parallel.ExecutionMode;

@TestInstance(value=TestInstance.Lifecycle.PER_CLASS)
@Execution(value=ExecutionMode.CONCURRENT)
public class TestPredicatePushdown {
    private final QueryAssertions assertions = new QueryAssertions();

    @AfterAll
    public void teardown() {
        this.assertions.close();
    }

    @Test
    public void testConditionalExpressionWithFailingExpression() {
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("WITH t (k, a) AS (     VALUES         (1, 1),         (2, 0) ),u (k, v) AS (     VALUES        (1, 'x'),         (2, 'y') ) SELECT * FROM (     SELECT v, if(v = 'x', 1 / a) AS r    FROM t JOIN u ON t.k = u.k ) WHERE v = 'x' AND r IS NOT NULL"))).matches("VALUES ('x', 1)");
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("WITH t (k, v) AS (     VALUES         (1, 1),         (2, 0) ), u (k) AS (     VALUES 1, 2 ) SELECT * FROM (     SELECT t.k, if(t.k = 1, 1 / t.v) AS r     FROM t JOIN u ON t.k = u.k ) WHERE k = 1 AND r <> 0"))).matches("VALUES (1, 1)");
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("WITH t (k, v) AS (     VALUES         (1, 1),         (2, 0) ), u (k) AS (     VALUES 1, 2 ) SELECT * FROM (     SELECT t.k, if(t.k = 1, 1 / t.v) AS r     FROM t LEFT JOIN u ON t.k = u.k ) WHERE k = 1 AND r <> 0"))).matches("VALUES (1, 1)");
    }
}

