/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.query;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.trino.connector.MockConnectorFactory;
import io.trino.connector.MockConnectorPlugin;
import io.trino.connector.MockConnectorTableHandle;
import io.trino.spi.Plugin;
import io.trino.spi.connector.ColumnMetadata;
import io.trino.spi.connector.ConnectorViewDefinition;
import io.trino.spi.connector.SchemaTableName;
import io.trino.spi.session.PropertyMetadata;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.Type;
import io.trino.sql.query.QueryAssertions;
import io.trino.testing.QueryRunner;
import io.trino.testing.StandaloneQueryRunner;
import io.trino.testing.TestingSession;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInstance;
import org.junit.jupiter.api.parallel.Execution;
import org.junit.jupiter.api.parallel.ExecutionMode;

@TestInstance(value=TestInstance.Lifecycle.PER_CLASS)
@Execution(value=ExecutionMode.CONCURRENT)
public class TestShowQueries {
    private final QueryAssertions assertions;

    public TestShowQueries() {
        StandaloneQueryRunner queryRunner = new StandaloneQueryRunner(TestingSession.testSessionBuilder().setCatalog("local").setSchema("default").build());
        queryRunner.installPlugin((Plugin)new MockConnectorPlugin(MockConnectorFactory.builder().withGetColumns(schemaTableName -> ImmutableList.of((Object)ColumnMetadata.builder().setName("colaa").setType((Type)BigintType.BIGINT).build(), (Object)ColumnMetadata.builder().setName("cola_").setType((Type)BigintType.BIGINT).build(), (Object)ColumnMetadata.builder().setName("colabc").setType((Type)BigintType.BIGINT).build())).withListSchemaNames(session -> ImmutableList.of((Object)"mockschema")).withListTables((session, schemaName) -> ImmutableList.of((Object)"mockTable")).withGetTableHandle((session, schemaTableName) -> {
            if (schemaTableName.getTableName().equals("mockview")) {
                return null;
            }
            return new MockConnectorTableHandle((SchemaTableName)schemaTableName);
        }).withGetViews((session, schemaTablePrefix) -> ImmutableMap.of((Object)new SchemaTableName("mockschema", "mockview"), (Object)new ConnectorViewDefinition("SELECT cola_ AS test_column FROM mock_table", Optional.empty(), Optional.empty(), (List)ImmutableList.of((Object)new ConnectorViewDefinition.ViewColumn("test_column", BigintType.BIGINT.getTypeId(), Optional.empty())), Optional.empty(), Optional.empty(), true, (List)ImmutableList.of()))).withGetViewProperties(() -> ImmutableList.of((Object)PropertyMetadata.booleanProperty((String)"boolean_property", (String)"sample_property", (Boolean)true, (boolean)false))).build()));
        queryRunner.createCatalog("mock", "mock", (Map)ImmutableMap.of());
        queryRunner.createCatalog("testing_catalog", "mock", (Map)ImmutableMap.of());
        this.assertions = new QueryAssertions((QueryRunner)queryRunner);
    }

    @AfterAll
    public void teardown() {
        this.assertions.close();
    }

    @Test
    public void testShowCatalogsLikeWithEscape() {
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("SHOW CATALOGS LIKE 't$_%' ESCAPE ''"))).failure().hasMessage("Escape string must be a single character");
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("SHOW CATALOGS LIKE 't$_%' ESCAPE '$$'"))).failure().hasMessage("Escape string must be a single character");
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("SHOW CATALOGS LIKE '%$_%' ESCAPE '$'"))).matches("VALUES('testing_catalog')");
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("SHOW CATALOGS LIKE '$_%' ESCAPE '$'"))).matches("SELECT 'testing_catalog' WHERE FALSE");
    }

    @Test
    public void testShowFunctionLike() {
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("SHOW FUNCTIONS LIKE 'split%'"))).skippingTypesCheck().matches("VALUES ('split', 'array(varchar(x))', 'varchar(x), varchar(y)', 'scalar', true, ''),('split', 'array(varchar(x))', 'varchar(x), varchar(y), bigint', 'scalar', true, ''),('split_part', 'varchar(x)', 'varchar(x), varchar(y), bigint', 'scalar', true, 'Splits a string by a delimiter and returns the specified field (counting from one)'),('split_to_map', 'map(varchar,varchar)', 'varchar, varchar, varchar', 'scalar', true, 'Creates a map using entryDelimiter and keyValueDelimiter'),('split_to_multimap', 'map(varchar,array(varchar))', 'varchar, varchar, varchar', 'scalar', true, 'Creates a multimap by splitting a string into key/value pairs')");
    }

    @Test
    public void testShowFunctionsLikeWithEscape() {
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("SHOW FUNCTIONS LIKE 'split$_to$_%' ESCAPE '$'"))).skippingTypesCheck().matches("VALUES ('split_to_map', 'map(varchar,varchar)', 'varchar, varchar, varchar', 'scalar', true, 'Creates a map using entryDelimiter and keyValueDelimiter'),('split_to_multimap', 'map(varchar,array(varchar))', 'varchar, varchar, varchar', 'scalar', true, 'Creates a multimap by splitting a string into key/value pairs')");
    }

    @Test
    public void testShowSessionLike() {
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("SHOW SESSION LIKE '%page_row_c%'"))).skippingTypesCheck().matches("VALUES ('filter_and_project_min_output_page_row_count', '256', '256', 'integer', 'Experimental: Minimum output page row count for filter and project operators')");
    }

    @Test
    public void testShowSessionLikeWithEscape() {
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("SHOW SESSION LIKE 't$_%' ESCAPE ''"))).failure().hasMessage("Escape string must be a single character");
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("SHOW SESSION LIKE 't$_%' ESCAPE '$$'"))).failure().hasMessage("Escape string must be a single character");
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("SHOW SESSION LIKE '%page$_row$_c%' ESCAPE '$'"))).skippingTypesCheck().matches("VALUES ('filter_and_project_min_output_page_row_count', '256', '256', 'integer', 'Experimental: Minimum output page row count for filter and project operators')");
    }

    @Test
    public void testListingEmptyCatalogs() {
        this.assertions.executeExclusively(() -> {
            this.assertions.getQueryRunner().getAccessControl().denyCatalogs(catalog -> false);
            this.assertions.assertQueryReturnsEmptyResult("SHOW CATALOGS");
            this.assertions.getQueryRunner().getAccessControl().reset();
        });
    }

    @Test
    public void testShowColumns() {
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("SHOW COLUMNS FROM mock.mockSchema.mockTable"))).matches("VALUES (VARCHAR 'colaa', VARCHAR 'bigint' , VARCHAR '', VARCHAR ''),(VARCHAR 'cola_', VARCHAR 'bigint' , VARCHAR '', VARCHAR ''),(VARCHAR 'colabc', VARCHAR 'bigint' , VARCHAR '', VARCHAR '')");
    }

    @Test
    public void testShowColumnsLike() {
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("SHOW COLUMNS FROM mock.mockSchema.mockTable like 'colabc'"))).matches("VALUES (VARCHAR 'colabc', VARCHAR 'bigint' , VARCHAR '', VARCHAR '')");
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("SHOW COLUMNS FROM mock.mockSchema.mockTable like 'cola%'"))).matches("VALUES (VARCHAR 'colaa', VARCHAR 'bigint' , VARCHAR '', VARCHAR ''),(VARCHAR 'cola_', VARCHAR 'bigint' , VARCHAR '', VARCHAR ''),(VARCHAR 'colabc', VARCHAR 'bigint' , VARCHAR '', VARCHAR '')");
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("SHOW COLUMNS FROM mock.mockSchema.mockTable like 'cola_'"))).matches("VALUES (VARCHAR 'colaa', VARCHAR 'bigint' , VARCHAR '', VARCHAR ''),(VARCHAR 'cola_', VARCHAR 'bigint' , VARCHAR '', VARCHAR '')");
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("SHOW COLUMNS FROM system.runtime.nodes LIKE 'node%'"))).matches("VALUES (VARCHAR 'node_id', VARCHAR 'varchar' , VARCHAR '', VARCHAR ''),(VARCHAR 'node_version', VARCHAR 'varchar' , VARCHAR '', VARCHAR '')");
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("SHOW COLUMNS FROM system.runtime.nodes LIKE 'node_id'"))).matches("VALUES (VARCHAR 'node_id', VARCHAR 'varchar' , VARCHAR '', VARCHAR '')");
        org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)this.assertions.execute("SHOW COLUMNS FROM system.runtime.nodes LIKE ''").getRowCount());
    }

    @Test
    public void testShowColumnsWithLikeWithEscape() {
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("SHOW COLUMNS FROM system.runtime.nodes LIKE 't$_%' ESCAPE ''"))).failure().hasMessage("Escape string must be a single character");
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("SHOW COLUMNS FROM system.runtime.nodes LIKE 't$_%' ESCAPE '$$'"))).failure().hasMessage("Escape string must be a single character");
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("SHOW COLUMNS FROM mock.mockSchema.mockTable LIKE 'cola$_' ESCAPE '$'"))).matches("VALUES (VARCHAR 'cola_', VARCHAR 'bigint' , VARCHAR '', VARCHAR '')");
    }

    @Test
    public void testShowCreateViewWithProperties() {
        Assertions.assertThat((Object)this.assertions.getQueryRunner().execute("SHOW CREATE VIEW mock.mockschema.mockview").getOnlyValue()).isEqualTo((Object)"CREATE VIEW mock.mockschema.mockview SECURITY INVOKER\nWITH (\n   boolean_property = true\n) AS\nSELECT cola_ test_column\nFROM\n  mock_table");
    }
}

