/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Verify;
import com.google.common.primitives.Shorts;
import io.airlift.slice.SizeOf;
import io.trino.operator.CompletedWork;
import io.trino.operator.FlatHash;
import io.trino.operator.FlatHashStrategyCompiler;
import io.trino.operator.GroupByHash;
import io.trino.operator.UpdateMemory;
import io.trino.operator.Work;
import io.trino.spi.Page;
import io.trino.spi.PageBuilder;
import io.trino.spi.block.Block;
import io.trino.spi.block.BlockBuilder;
import io.trino.spi.block.DictionaryBlock;
import io.trino.spi.block.RunLengthEncodedBlock;
import io.trino.spi.type.Type;
import java.util.Arrays;
import java.util.List;

public class FlatGroupByHash
implements GroupByHash {
    private static final int INSTANCE_SIZE = SizeOf.instanceSize(FlatGroupByHash.class);
    private static final int BATCH_SIZE = 1024;
    private static final double SMALL_DICTIONARIES_MAX_CARDINALITY_RATIO = 0.25;
    private final FlatHash flatHash;
    private final int groupByChannelCount;
    private final boolean hasPrecomputedHash;
    private final boolean processDictionary;
    private DictionaryLookBack dictionaryLookBack;
    private long currentPageSizeInBytes;
    private final Block[] currentBlocks;
    private final BlockBuilder[] currentBlockBuilders;
    private long[] currentHashes;

    public FlatGroupByHash(List<Type> hashTypes, boolean hasPrecomputedHash, int expectedSize, boolean processDictionary, FlatHashStrategyCompiler hashStrategyCompiler, UpdateMemory checkMemoryReservation) {
        this.flatHash = new FlatHash(hashStrategyCompiler.getFlatHashStrategy(hashTypes), hasPrecomputedHash, expectedSize, checkMemoryReservation);
        this.groupByChannelCount = hashTypes.size();
        this.hasPrecomputedHash = hasPrecomputedHash;
        Preconditions.checkArgument((expectedSize > 0 ? 1 : 0) != 0, (Object)"expectedSize must be greater than zero");
        int totalChannels = hashTypes.size() + (hasPrecomputedHash ? 1 : 0);
        this.currentBlocks = new Block[totalChannels];
        this.currentBlockBuilders = new BlockBuilder[totalChannels];
        this.processDictionary = processDictionary && hashTypes.size() == 1;
    }

    public int getPhysicalPosition(int groupId) {
        return this.flatHash.getPhysicalPosition(groupId);
    }

    @Override
    public long getRawHash(int groupId) {
        return this.flatHash.hashPosition(groupId);
    }

    @Override
    public long getEstimatedSize() {
        return FlatHash.sumExact(INSTANCE_SIZE, this.flatHash.getEstimatedSize(), this.currentPageSizeInBytes, SizeOf.sizeOf((long[])this.currentHashes), this.dictionaryLookBack != null ? this.dictionaryLookBack.getRetainedSizeInBytes() : 0L);
    }

    @Override
    public int getGroupCount() {
        return this.flatHash.size();
    }

    @Override
    public void appendValuesTo(int groupId, PageBuilder pageBuilder) {
        BlockBuilder[] blockBuilders = this.currentBlockBuilders;
        for (int i = 0; i < blockBuilders.length; ++i) {
            blockBuilders[i] = pageBuilder.getBlockBuilder(i);
        }
        this.flatHash.appendTo(groupId, blockBuilders);
    }

    @Override
    public Work<?> addPage(Page page) {
        if (page.getPositionCount() == 0) {
            return new CompletedWork<int[]>(new int[0]);
        }
        this.currentPageSizeInBytes = page.getRetainedSizeInBytes();
        Block[] blocks = this.getBlocksFromPage(page);
        if (this.isRunLengthEncoded(blocks)) {
            return new AddRunLengthEncodedPageWork(blocks);
        }
        if (this.canProcessDictionary(blocks)) {
            return new AddDictionaryPageWork(blocks);
        }
        if (this.canProcessLowCardinalityDictionary(blocks)) {
            return new AddLowCardinalityDictionaryPageWork(blocks);
        }
        return new AddNonDictionaryPageWork(blocks);
    }

    @Override
    public Work<int[]> getGroupIds(Page page) {
        if (page.getPositionCount() == 0) {
            return new CompletedWork<int[]>(new int[0]);
        }
        this.currentPageSizeInBytes = page.getRetainedSizeInBytes();
        Block[] blocks = this.getBlocksFromPage(page);
        if (this.isRunLengthEncoded(blocks)) {
            return new GetRunLengthEncodedGroupIdsWork(blocks);
        }
        if (this.canProcessDictionary(blocks)) {
            return new GetDictionaryGroupIdsWork(blocks);
        }
        if (this.canProcessLowCardinalityDictionary(blocks)) {
            return new GetLowCardinalityDictionaryGroupIdsWork(blocks);
        }
        return new GetNonDictionaryGroupIdsWork(blocks);
    }

    @Override
    @VisibleForTesting
    public int getCapacity() {
        return this.flatHash.getCapacity();
    }

    private int putIfAbsent(Block[] blocks, int position) {
        return this.flatHash.putIfAbsent(blocks, position);
    }

    private long[] getHashesBufferArray() {
        if (this.currentHashes == null) {
            this.currentHashes = new long[1024];
        }
        return this.currentHashes;
    }

    private Block[] getBlocksFromPage(Page page) {
        Block[] blocks = this.currentBlocks;
        Preconditions.checkArgument((page.getChannelCount() == blocks.length ? 1 : 0) != 0);
        for (int i = 0; i < blocks.length; ++i) {
            blocks[i] = page.getBlock(i);
        }
        return blocks;
    }

    private void updateDictionaryLookBack(Block dictionary) {
        if (this.dictionaryLookBack == null || this.dictionaryLookBack.getDictionary() != dictionary) {
            this.dictionaryLookBack = new DictionaryLookBack(dictionary);
        }
    }

    private boolean canProcessDictionary(Block[] blocks) {
        DictionaryBlock hashDictionary;
        Block block;
        if (!this.processDictionary || !((block = blocks[0]) instanceof DictionaryBlock)) {
            return false;
        }
        DictionaryBlock inputDictionary = (DictionaryBlock)block;
        if (!this.hasPrecomputedHash) {
            return true;
        }
        Block block2 = blocks[1];
        return block2 instanceof DictionaryBlock && (hashDictionary = (DictionaryBlock)block2).getDictionarySourceId().equals((Object)inputDictionary.getDictionarySourceId());
    }

    private boolean canProcessLowCardinalityDictionary(Block[] blocks) {
        int positionCount = blocks[0].getPositionCount();
        long cardinality = 1L;
        for (int channel = 0; channel < this.groupByChannelCount; ++channel) {
            Block block = blocks[channel];
            if (!(block instanceof DictionaryBlock)) {
                return false;
            }
            DictionaryBlock dictionaryBlock = (DictionaryBlock)block;
            cardinality = Math.multiplyExact(cardinality, dictionaryBlock.getDictionary().getPositionCount());
            if (!((double)cardinality > (double)positionCount * 0.25) && cardinality <= 32767L) continue;
            return false;
        }
        return true;
    }

    private boolean isRunLengthEncoded(Block[] blocks) {
        for (int channel = 0; channel < this.groupByChannelCount; ++channel) {
            if (blocks[channel] instanceof RunLengthEncodedBlock) continue;
            return false;
        }
        return true;
    }

    private int registerGroupId(Block[] dictionaries, int positionInDictionary) {
        if (this.dictionaryLookBack.isProcessed(positionInDictionary)) {
            return this.dictionaryLookBack.getGroupId(positionInDictionary);
        }
        int groupId = this.putIfAbsent(dictionaries, positionInDictionary);
        this.dictionaryLookBack.setProcessed(positionInDictionary, groupId);
        return groupId;
    }

    private int[] calculateCombinationIdToPositionMapping(Block[] blocks) {
        short[] positionToCombinationId = new short[blocks[0].getPositionCount()];
        int maxCardinality = this.calculatePositionToCombinationIdMapping(blocks, positionToCombinationId);
        int[] combinationIdToPosition = new int[maxCardinality];
        Arrays.fill(combinationIdToPosition, -1);
        for (int position = 0; position < positionToCombinationId.length; ++position) {
            combinationIdToPosition[positionToCombinationId[position]] = position;
        }
        return combinationIdToPosition;
    }

    private int calculatePositionToCombinationIdMapping(Block[] blocks, short[] positionToCombinationIds) {
        Preconditions.checkArgument((positionToCombinationIds.length == blocks[0].getPositionCount() ? 1 : 0) != 0);
        int maxCardinality = 1;
        for (int channel = 0; channel < this.groupByChannelCount; ++channel) {
            int position;
            Block block = blocks[channel];
            Verify.verify((boolean)(block instanceof DictionaryBlock), (String)"Only dictionary blocks are supported", (Object[])new Object[0]);
            DictionaryBlock dictionaryBlock = (DictionaryBlock)block;
            int dictionarySize = dictionaryBlock.getDictionary().getPositionCount();
            maxCardinality *= dictionarySize;
            if (channel == 0) {
                for (position = 0; position < positionToCombinationIds.length; ++position) {
                    positionToCombinationIds[position] = (short)dictionaryBlock.getId(position);
                }
                continue;
            }
            for (position = 0; position < positionToCombinationIds.length; ++position) {
                int combinationId = positionToCombinationIds[position];
                combinationId *= dictionarySize;
                positionToCombinationIds[position] = Shorts.checkedCast((long)(combinationId += dictionaryBlock.getId(position)));
            }
        }
        return maxCardinality;
    }

    private static final class DictionaryLookBack {
        private static final int INSTANCE_SIZE = SizeOf.instanceSize(DictionaryLookBack.class);
        private final Block dictionary;
        private final int[] processed;

        public DictionaryLookBack(Block dictionary) {
            this.dictionary = dictionary;
            this.processed = new int[dictionary.getPositionCount()];
            Arrays.fill(this.processed, -1);
        }

        public Block getDictionary() {
            return this.dictionary;
        }

        public int getGroupId(int position) {
            return this.processed[position];
        }

        public boolean isProcessed(int position) {
            return this.processed[position] != -1;
        }

        public void setProcessed(int position, int groupId) {
            this.processed[position] = groupId;
        }

        public long getRetainedSizeInBytes() {
            return FlatHash.sumExact(INSTANCE_SIZE, SizeOf.sizeOf((int[])this.processed), this.dictionary.getRetainedSizeInBytes());
        }
    }

    @VisibleForTesting
    class AddRunLengthEncodedPageWork
    implements Work<Void> {
        private final Block[] blocks;
        private boolean finished;

        public AddRunLengthEncodedPageWork(Block[] blocks) {
            for (int i = 0; i < blocks.length; ++i) {
                blocks[i] = blocks[i].getSingleValueBlock(0);
            }
            this.blocks = blocks;
        }

        @Override
        public boolean process() {
            Preconditions.checkState((!this.finished ? 1 : 0) != 0);
            if (!FlatGroupByHash.this.flatHash.ensureAvailableCapacity(1)) {
                return false;
            }
            FlatGroupByHash.this.putIfAbsent(this.blocks, 0);
            this.finished = true;
            return true;
        }

        @Override
        public Void getResult() {
            throw new UnsupportedOperationException();
        }
    }

    @VisibleForTesting
    class AddDictionaryPageWork
    implements Work<Void> {
        private final DictionaryBlock dictionaryBlock;
        private final Block[] dictionaries;
        private int lastPosition;

        public AddDictionaryPageWork(Block[] blocks) {
            Verify.verify((boolean)FlatGroupByHash.this.canProcessDictionary(blocks), (String)"invalid call to addDictionaryPage", (Object[])new Object[0]);
            this.dictionaryBlock = (DictionaryBlock)blocks[0];
            this.dictionaries = (Block[])Arrays.stream(blocks).map(block -> (DictionaryBlock)block).map(DictionaryBlock::getDictionary).toArray(Block[]::new);
            FlatGroupByHash.this.updateDictionaryLookBack(this.dictionaries[0]);
        }

        @Override
        public boolean process() {
            int positionCount = this.dictionaryBlock.getPositionCount();
            Preconditions.checkState((this.lastPosition <= positionCount ? 1 : 0) != 0, (Object)"position count out of bound");
            while (this.lastPosition < positionCount && FlatGroupByHash.this.flatHash.ensureAvailableCapacity(1)) {
                FlatGroupByHash.this.registerGroupId(this.dictionaries, this.dictionaryBlock.getId(this.lastPosition));
                ++this.lastPosition;
            }
            return this.lastPosition == positionCount;
        }

        @Override
        public Void getResult() {
            throw new UnsupportedOperationException();
        }
    }

    class AddLowCardinalityDictionaryPageWork
    implements Work<Void> {
        private final Block[] blocks;
        private final int[] combinationIdToPosition;
        private int nextCombinationId;

        public AddLowCardinalityDictionaryPageWork(Block[] blocks) {
            this.blocks = blocks;
            this.combinationIdToPosition = FlatGroupByHash.this.calculateCombinationIdToPositionMapping(blocks);
        }

        @Override
        public boolean process() {
            for (int combinationId = this.nextCombinationId; combinationId < this.combinationIdToPosition.length; ++combinationId) {
                int position = this.combinationIdToPosition[combinationId];
                if (position == -1) continue;
                if (!FlatGroupByHash.this.flatHash.ensureAvailableCapacity(1)) {
                    this.nextCombinationId = combinationId;
                    return false;
                }
                FlatGroupByHash.this.putIfAbsent(this.blocks, position);
            }
            return true;
        }

        @Override
        public Void getResult() {
            throw new UnsupportedOperationException();
        }
    }

    @VisibleForTesting
    class AddNonDictionaryPageWork
    implements Work<Void> {
        private final Block[] blocks;
        private int lastPosition;

        public AddNonDictionaryPageWork(Block[] blocks) {
            this.blocks = blocks;
        }

        @Override
        public boolean process() {
            int batchSize;
            int positionCount = this.blocks[0].getPositionCount();
            Preconditions.checkState((this.lastPosition <= positionCount ? 1 : 0) != 0, (Object)"position count out of bound");
            long[] hashes = FlatGroupByHash.this.getHashesBufferArray();
            for (int remainingPositions = positionCount - this.lastPosition; remainingPositions != 0; remainingPositions -= batchSize) {
                batchSize = Math.min(remainingPositions, hashes.length);
                if (!FlatGroupByHash.this.flatHash.ensureAvailableCapacity(batchSize)) {
                    return false;
                }
                FlatGroupByHash.this.flatHash.computeHashes(this.blocks, hashes, this.lastPosition, batchSize);
                for (int i = 0; i < batchSize; ++i) {
                    FlatGroupByHash.this.flatHash.putIfAbsent(this.blocks, this.lastPosition + i, hashes[i]);
                }
                this.lastPosition += batchSize;
            }
            Verify.verify((this.lastPosition == positionCount ? 1 : 0) != 0);
            return true;
        }

        @Override
        public Void getResult() {
            throw new UnsupportedOperationException();
        }
    }

    @VisibleForTesting
    class GetRunLengthEncodedGroupIdsWork
    implements Work<int[]> {
        private final int positionCount;
        private final Block[] blocks;
        private int groupId = -1;
        private boolean processFinished;
        private boolean resultProduced;

        public GetRunLengthEncodedGroupIdsWork(Block[] blocks) {
            this.positionCount = blocks[0].getPositionCount();
            for (int i = 0; i < blocks.length; ++i) {
                blocks[i] = blocks[i].getSingleValueBlock(0);
            }
            this.blocks = blocks;
        }

        @Override
        public boolean process() {
            Preconditions.checkState((!this.processFinished ? 1 : 0) != 0);
            if (!FlatGroupByHash.this.flatHash.ensureAvailableCapacity(1)) {
                return false;
            }
            this.groupId = FlatGroupByHash.this.putIfAbsent(this.blocks, 0);
            this.processFinished = true;
            return true;
        }

        @Override
        public int[] getResult() {
            Preconditions.checkState((boolean)this.processFinished);
            Preconditions.checkState((!this.resultProduced ? 1 : 0) != 0);
            this.resultProduced = true;
            int[] groupIds = new int[this.positionCount];
            Arrays.fill(groupIds, this.groupId);
            return groupIds;
        }
    }

    @VisibleForTesting
    class GetDictionaryGroupIdsWork
    implements Work<int[]> {
        private final int[] groupIds;
        private final DictionaryBlock dictionaryBlock;
        private final Block[] dictionaries;
        private boolean finished;
        private int lastPosition;

        public GetDictionaryGroupIdsWork(Block[] blocks) {
            Verify.verify((boolean)FlatGroupByHash.this.canProcessDictionary(blocks), (String)"invalid call to processDictionary", (Object[])new Object[0]);
            this.dictionaryBlock = (DictionaryBlock)blocks[0];
            this.groupIds = new int[this.dictionaryBlock.getPositionCount()];
            this.dictionaries = (Block[])Arrays.stream(blocks).map(block -> (DictionaryBlock)block).map(DictionaryBlock::getDictionary).toArray(Block[]::new);
            FlatGroupByHash.this.updateDictionaryLookBack(this.dictionaries[0]);
        }

        @Override
        public boolean process() {
            Preconditions.checkState((this.lastPosition <= this.groupIds.length ? 1 : 0) != 0, (Object)"position count out of bound");
            Preconditions.checkState((!this.finished ? 1 : 0) != 0);
            while (this.lastPosition < this.groupIds.length && FlatGroupByHash.this.flatHash.ensureAvailableCapacity(1)) {
                this.groupIds[this.lastPosition] = FlatGroupByHash.this.registerGroupId(this.dictionaries, this.dictionaryBlock.getId(this.lastPosition));
                ++this.lastPosition;
            }
            return this.lastPosition == this.groupIds.length;
        }

        @Override
        public int[] getResult() {
            Preconditions.checkState((this.lastPosition == this.groupIds.length ? 1 : 0) != 0, (Object)"process has not yet finished");
            Preconditions.checkState((!this.finished ? 1 : 0) != 0, (Object)"result has produced");
            this.finished = true;
            return this.groupIds;
        }
    }

    @VisibleForTesting
    class GetLowCardinalityDictionaryGroupIdsWork
    implements Work<int[]> {
        private final Block[] blocks;
        private final short[] positionToCombinationId;
        private final int[] combinationIdToGroupId;
        private final int[] groupIds;
        private int nextPosition;
        private boolean finished;

        public GetLowCardinalityDictionaryGroupIdsWork(Block[] blocks) {
            this.blocks = blocks;
            int positionCount = blocks[0].getPositionCount();
            this.positionToCombinationId = new short[positionCount];
            int maxCardinality = FlatGroupByHash.this.calculatePositionToCombinationIdMapping(blocks, this.positionToCombinationId);
            this.combinationIdToGroupId = new int[maxCardinality];
            Arrays.fill(this.combinationIdToGroupId, -1);
            this.groupIds = new int[positionCount];
        }

        @Override
        public boolean process() {
            for (int position = this.nextPosition; position < this.positionToCombinationId.length; ++position) {
                short combinationId = this.positionToCombinationId[position];
                int groupId = this.combinationIdToGroupId[combinationId];
                if (groupId == -1) {
                    if (!FlatGroupByHash.this.flatHash.ensureAvailableCapacity(1)) {
                        this.nextPosition = position;
                        return false;
                    }
                    this.combinationIdToGroupId[combinationId] = groupId = FlatGroupByHash.this.putIfAbsent(this.blocks, position);
                }
                this.groupIds[position] = groupId;
            }
            return true;
        }

        @Override
        public int[] getResult() {
            Preconditions.checkState((!this.finished ? 1 : 0) != 0, (Object)"result has produced");
            this.finished = true;
            return this.groupIds;
        }
    }

    @VisibleForTesting
    class GetNonDictionaryGroupIdsWork
    implements Work<int[]> {
        private final Block[] blocks;
        private final int[] groupIds;
        private boolean finished;
        private int lastPosition;

        public GetNonDictionaryGroupIdsWork(Block[] blocks) {
            this.blocks = blocks;
            this.groupIds = new int[FlatGroupByHash.this.currentBlocks[0].getPositionCount()];
        }

        @Override
        public boolean process() {
            int batchSize;
            int positionCount = this.groupIds.length;
            Preconditions.checkState((this.lastPosition <= positionCount ? 1 : 0) != 0, (Object)"position count out of bound");
            Preconditions.checkState((!this.finished ? 1 : 0) != 0);
            long[] hashes = FlatGroupByHash.this.getHashesBufferArray();
            for (int remainingPositions = positionCount - this.lastPosition; remainingPositions != 0; remainingPositions -= batchSize) {
                batchSize = Math.min(remainingPositions, hashes.length);
                if (!FlatGroupByHash.this.flatHash.ensureAvailableCapacity(batchSize)) {
                    return false;
                }
                FlatGroupByHash.this.flatHash.computeHashes(this.blocks, hashes, this.lastPosition, batchSize);
                int i = 0;
                int position = this.lastPosition;
                while (i < batchSize) {
                    this.groupIds[position] = FlatGroupByHash.this.flatHash.putIfAbsent(this.blocks, position, hashes[i]);
                    ++i;
                    ++position;
                }
                this.lastPosition += batchSize;
            }
            Verify.verify((this.lastPosition == positionCount ? 1 : 0) != 0);
            return true;
        }

        @Override
        public int[] getResult() {
            Preconditions.checkState((this.lastPosition == FlatGroupByHash.this.currentBlocks[0].getPositionCount() ? 1 : 0) != 0, (Object)"process has not yet finished");
            Preconditions.checkState((!this.finished ? 1 : 0) != 0, (Object)"result has produced");
            this.finished = true;
            return this.groupIds;
        }
    }
}

