/*
 * Decompiled with CFR 0.152.
 */
package io.trino.server;

import com.google.inject.Inject;
import io.trino.execution.executor.timesharing.TimeSharingTaskExecutor;
import io.trino.server.security.ResourceSecurity;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import java.util.Objects;

@Path(value="/v1/maxActiveSplits")
public class TaskExecutorResource {
    private final TimeSharingTaskExecutor taskExecutor;

    @Inject
    public TaskExecutorResource(TimeSharingTaskExecutor taskExecutor) {
        this.taskExecutor = Objects.requireNonNull(taskExecutor, "taskExecutor is null");
    }

    @ResourceSecurity(value=ResourceSecurity.AccessType.MANAGEMENT_READ)
    @GET
    @Produces(value={"text/plain"})
    public String getMaxActiveSplit() {
        return this.taskExecutor.getMaxActiveSplitsInfo();
    }
}

