/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner;

import com.google.common.base.Verify;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import io.trino.Session;
import io.trino.metadata.GlobalFunctionCatalog;
import io.trino.metadata.Metadata;
import io.trino.metadata.OperatorNameUtil;
import io.trino.metadata.ResolvedFunction;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.TrinoException;
import io.trino.spi.block.Block;
import io.trino.spi.block.BlockBuilder;
import io.trino.spi.block.RowValueBuilder;
import io.trino.spi.block.SqlRow;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.function.CatalogSchemaFunctionName;
import io.trino.spi.function.FunctionNullability;
import io.trino.spi.function.InvocationConvention;
import io.trino.spi.function.OperatorType;
import io.trino.spi.type.ArrayType;
import io.trino.spi.type.BooleanType;
import io.trino.spi.type.MapType;
import io.trino.spi.type.RowType;
import io.trino.spi.type.Type;
import io.trino.spi.type.TypeManager;
import io.trino.spi.type.TypeUtils;
import io.trino.sql.DynamicFilters;
import io.trino.sql.InterpretedFunctionInvoker;
import io.trino.sql.PlannerContext;
import io.trino.sql.ir.Array;
import io.trino.sql.ir.Between;
import io.trino.sql.ir.Bind;
import io.trino.sql.ir.Booleans;
import io.trino.sql.ir.Call;
import io.trino.sql.ir.Case;
import io.trino.sql.ir.Cast;
import io.trino.sql.ir.Coalesce;
import io.trino.sql.ir.Comparison;
import io.trino.sql.ir.Constant;
import io.trino.sql.ir.Expression;
import io.trino.sql.ir.FieldReference;
import io.trino.sql.ir.In;
import io.trino.sql.ir.IrExpressions;
import io.trino.sql.ir.IrVisitor;
import io.trino.sql.ir.IsNull;
import io.trino.sql.ir.Lambda;
import io.trino.sql.ir.Logical;
import io.trino.sql.ir.NullIf;
import io.trino.sql.ir.Reference;
import io.trino.sql.ir.Row;
import io.trino.sql.ir.Switch;
import io.trino.sql.ir.WhenClause;
import io.trino.sql.planner.DeterminismEvaluator;
import io.trino.sql.planner.NoOpSymbolResolver;
import io.trino.sql.planner.Symbol;
import io.trino.sql.planner.SymbolResolver;
import io.trino.type.TypeCoercion;
import io.trino.util.FastutilSetHelper;
import java.lang.invoke.LambdaMetafactory;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.runtime.SwitchBootstraps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public class IrExpressionInterpreter {
    private static final CatalogSchemaFunctionName FAIL_NAME = GlobalFunctionCatalog.builtinFunctionName("fail");
    private static final MethodHandle LAMBDA_EVALUATOR;
    private final Expression expression;
    private final PlannerContext plannerContext;
    private final Metadata metadata;
    private final ConnectorSession connectorSession;
    private final InterpretedFunctionInvoker functionInvoker;
    private final TypeCoercion typeCoercion;
    private final IdentityHashMap<List<Expression>, Set<?>> inListCache = new IdentityHashMap();

    public IrExpressionInterpreter(Expression expression, PlannerContext plannerContext, Session session) {
        this.expression = Objects.requireNonNull(expression, "expression is null");
        this.plannerContext = Objects.requireNonNull(plannerContext, "plannerContext is null");
        this.metadata = plannerContext.getMetadata();
        this.connectorSession = session.toConnectorSession();
        this.functionInvoker = new InterpretedFunctionInvoker(plannerContext.getFunctionManager());
        this.typeCoercion = new TypeCoercion(arg_0 -> ((TypeManager)plannerContext.getTypeManager()).getType(arg_0));
    }

    public Object evaluate() {
        Expression result = new Visitor(true).processWithExceptionHandling(this.expression, NoOpSymbolResolver.INSTANCE);
        Verify.verify((boolean)(result instanceof Constant), (String)("Expected constant, but got: " + String.valueOf(result)), (Object[])new Object[0]);
        return ((Constant)result).value();
    }

    public Expression optimize(SymbolResolver inputs) {
        return new Visitor(false).processWithExceptionHandling(this.expression, inputs);
    }

    public Expression optimize() {
        return this.optimize(NoOpSymbolResolver.INSTANCE);
    }

    private static boolean isConstantNull(Expression operand) {
        Constant constant;
        return operand instanceof Constant && (constant = (Constant)operand).value() == null;
    }

    static {
        try {
            LAMBDA_EVALUATOR = MethodHandles.lookup().findVirtual(Visitor.class, "evaluate", MethodType.methodType(Object.class, Expression.class, Map.class, new Object[0].getClass()));
        }
        catch (ReflectiveOperationException e) {
            throw new AssertionError((Object)e);
        }
    }

    private class Visitor
    extends IrVisitor<Expression, SymbolResolver> {
        private final boolean evaluate;

        private Visitor(boolean evaluate) {
            this.evaluate = evaluate;
        }

        private Expression processWithExceptionHandling(Expression expression, SymbolResolver context) {
            try {
                return (Expression)this.process(expression, context);
            }
            catch (TrinoException e) {
                if (!this.evaluate) {
                    return expression;
                }
                throw e;
            }
        }

        @Override
        protected Expression visitReference(Reference node, SymbolResolver context) {
            Optional<Constant> binding = context.getValue(Symbol.from(node));
            if (binding.isPresent()) {
                return binding.get();
            }
            return node;
        }

        @Override
        protected Expression visitConstant(Constant node, SymbolResolver context) {
            return node;
        }

        @Override
        protected Expression visitIsNull(IsNull node, SymbolResolver context) {
            Expression value = this.processWithExceptionHandling(node.value(), context);
            if (value instanceof Constant) {
                Constant constant = (Constant)value;
                return new Constant((Type)BooleanType.BOOLEAN, constant.value() == null);
            }
            return new IsNull(value);
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        protected Expression visitCase(Case node, SymbolResolver context) {
            List<Expression> operands = node.whenClauses().stream().map(WhenClause::getOperand).map(operand -> this.processWithExceptionHandling((Expression)operand, context)).toList();
            ArrayList<WhenClause> newClauses = new ArrayList<WhenClause>();
            Expression newDefault = null;
            for (int i = 0; i < node.whenClauses().size() && newDefault == null; ++i) {
                Expression operand2 = operands.get(i);
                if (operand2 instanceof Constant) {
                    Boolean value;
                    Object object;
                    Constant constant = (Constant)operand2;
                    try {
                        Type type = object = constant.type();
                        object = constant.value();
                    }
                    catch (Throwable throwable) {
                        throw new MatchException(throwable.toString(), throwable);
                    }
                    if (object instanceof Boolean && (value = (Boolean)object).booleanValue()) {
                        newDefault = this.processWithExceptionHandling(node.whenClauses().get(i).getResult(), context);
                        continue;
                    }
                }
                if (operand2 instanceof Constant) continue;
                newClauses.add(new WhenClause(operand2, this.processWithExceptionHandling(node.whenClauses().get(i).getResult(), context)));
            }
            if (newDefault == null) {
                newDefault = this.processWithExceptionHandling(node.defaultValue(), context);
            }
            if (!newClauses.isEmpty()) {
                return new Case(newClauses, newDefault);
            }
            return newDefault;
        }

        @Override
        protected Expression visitSwitch(Switch node, SymbolResolver context) {
            ResolvedFunction equals = IrExpressionInterpreter.this.metadata.resolveOperator(OperatorType.EQUAL, (List<? extends Type>)ImmutableList.of((Object)node.operand().type(), (Object)node.operand().type()));
            Expression operand = this.processWithExceptionHandling(node.operand(), context);
            List<Expression> candidates = node.whenClauses().stream().map(WhenClause::getOperand).map(candidate -> this.processWithExceptionHandling((Expression)candidate, context)).toList();
            ArrayList<WhenClause> newClauses = new ArrayList<WhenClause>();
            Expression newDefault = null;
            for (int i = 0; i < node.whenClauses().size() && newDefault == null; ++i) {
                Constant candidateConstant;
                Expression expression;
                Constant operandConstant;
                if (operand instanceof Constant && (operandConstant = (Constant)operand).value() != null && (expression = candidates.get(i)) instanceof Constant && (candidateConstant = (Constant)expression).value() != null) {
                    if (!Boolean.TRUE.equals(IrExpressionInterpreter.this.functionInvoker.invoke(equals, IrExpressionInterpreter.this.connectorSession, (List<Object>)ImmutableList.of((Object)operandConstant.value(), (Object)candidateConstant.value())))) continue;
                    newDefault = this.processWithExceptionHandling(node.whenClauses().get(i).getResult(), context);
                    continue;
                }
                if (IrExpressionInterpreter.isConstantNull(operand) || IrExpressionInterpreter.isConstantNull(candidates.get(i))) continue;
                newClauses.add(new WhenClause(candidates.get(i), this.processWithExceptionHandling(node.whenClauses().get(i).getResult(), context)));
            }
            if (newDefault == null) {
                newDefault = this.processWithExceptionHandling(node.defaultValue(), context);
            }
            if (!newClauses.isEmpty()) {
                return new Switch(operand, newClauses, newDefault);
            }
            return newDefault;
        }

        @Override
        protected Expression visitCoalesce(Coalesce node, SymbolResolver context) {
            HashSet<Expression> seen = new HashSet<Expression>();
            List<Expression> newOperands = this.processArguments(node, context, seen);
            if (newOperands.isEmpty()) {
                return new Constant(node.type(), null);
            }
            if (newOperands.size() == 1) {
                return (Expression)Iterables.getOnlyElement(newOperands);
            }
            return new Coalesce(newOperands);
        }

        private List<Expression> processArguments(Coalesce node, SymbolResolver context, Set<Expression> seen) {
            ArrayList<Expression> newOperands = new ArrayList<Expression>();
            for (Expression operand : node.operands()) {
                Expression value = this.processWithExceptionHandling(operand, context);
                if (value instanceof Constant) {
                    Constant constant = (Constant)value;
                    if (constant.value() == null) continue;
                    newOperands.add(value);
                    break;
                }
                if (!(value instanceof Coalesce) && !DeterminismEvaluator.isDeterministic(value) || seen.add(value)) {
                    newOperands.add(value);
                    continue;
                }
                if (!(value instanceof Coalesce)) continue;
                Coalesce inner = (Coalesce)value;
                newOperands.addAll(this.processArguments(inner, context, seen));
            }
            return newOperands;
        }

        /*
         * Unable to fully structure code
         * Could not resolve type clashes
         */
        @Override
        protected Expression visitIn(In node, SymbolResolver context) {
            block18: {
                block19: {
                    value = this.processWithExceptionHandling(node.value(), context);
                    if (IrExpressionInterpreter.isConstantNull(value)) {
                        return node.valueList().isEmpty() != false ? Booleans.FALSE : Booleans.NULL_BOOLEAN;
                    }
                    valueList = node.valueList();
                    if (!(value instanceof Constant)) break block18;
                    var5_5 = (Constant)value;
                    type = var8_6 /* !! */  = var5_5.type();
                    try {
                        constantValue /* !! */  = var8_6 /* !! */  = var5_5.value();
                    }
                    catch (Throwable var11_12) {
                        throw new MatchException(var11_12.toString(), var11_12);
                    }
                    if (type instanceof ArrayType || type instanceof MapType || type instanceof RowType) break block18;
                    set = IrExpressionInterpreter.this.inListCache.get(valueList);
                    if (IrExpressionInterpreter.this.inListCache.containsKey(valueList)) break block19;
                    if (!valueList.stream().allMatch((Predicate<Expression>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, isInstance(java.lang.Object ), (Lio/trino/sql/ir/Expression;)Z)(Constant.class))) ** GOTO lbl-1000
                    if (valueList.stream().map((Function<Expression, Constant>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, cast(java.lang.Object ), (Lio/trino/sql/ir/Expression;)Lio/trino/sql/ir/Constant;)(Constant.class)).map((Function<Constant, Object>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, value(), (Lio/trino/sql/ir/Constant;)Ljava/lang/Object;)()).noneMatch((Predicate<Object>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, isNull(java.lang.Object ), (Ljava/lang/Object;)Z)())) {
                        v0 = true;
                    } else lbl-1000:
                    // 2 sources

                    {
                        v0 = nonNullConstants = false;
                    }
                    if (nonNullConstants) {
                        values = valueList.stream().map((Function<Expression, Object>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$visitIn$2(io.trino.sql.planner.SymbolResolver io.trino.sql.ir.Expression ), (Lio/trino/sql/ir/Expression;)Ljava/lang/Object;)((Visitor)this, (SymbolResolver)context)).collect(Collectors.toSet());
                        set = FastutilSetHelper.toFastutilHashSet(values, type, IrExpressionInterpreter.this.plannerContext.getFunctionManager().getScalarFunctionImplementation(IrExpressionInterpreter.this.metadata.resolveOperator(OperatorType.HASH_CODE, (List<? extends Type>)ImmutableList.of((Object)type)), InvocationConvention.simpleConvention((InvocationConvention.InvocationReturnConvention)InvocationConvention.InvocationReturnConvention.FAIL_ON_NULL, (InvocationConvention.InvocationArgumentConvention[])new InvocationConvention.InvocationArgumentConvention[]{InvocationConvention.InvocationArgumentConvention.NEVER_NULL})).getMethodHandle(), IrExpressionInterpreter.this.plannerContext.getFunctionManager().getScalarFunctionImplementation(IrExpressionInterpreter.this.metadata.resolveOperator(OperatorType.EQUAL, (List<? extends Type>)ImmutableList.of((Object)type, (Object)type)), InvocationConvention.simpleConvention((InvocationConvention.InvocationReturnConvention)InvocationConvention.InvocationReturnConvention.NULLABLE_RETURN, (InvocationConvention.InvocationArgumentConvention[])new InvocationConvention.InvocationArgumentConvention[]{InvocationConvention.InvocationArgumentConvention.NEVER_NULL, InvocationConvention.InvocationArgumentConvention.NEVER_NULL})).getMethodHandle());
                    }
                    IrExpressionInterpreter.this.inListCache.put(valueList, set);
                }
                if (set != null) {
                    return new Constant((Type)BooleanType.BOOLEAN, set.contains(constantValue /* !! */ ));
                }
            }
            equalsOperator = IrExpressionInterpreter.this.metadata.resolveOperator(OperatorType.EQUAL, (List<? extends Type>)ImmutableList.of((Object)node.value().type(), (Object)node.value().type()));
            seen = new HashSet<Expression>();
            values = node.valueList().stream().map((Function<Expression, Expression>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$visitIn$3(io.trino.sql.planner.SymbolResolver io.trino.sql.ir.Expression ), (Lio/trino/sql/ir/Expression;)Lio/trino/sql/ir/Expression;)((Visitor)this, (SymbolResolver)context)).toList();
            match = null;
            hasNullMatch = false;
            newList = new ArrayList<Expression>();
            for (Expression item : values) {
                if (value instanceof Constant) {
                    constantValue = (Constant)value;
                    if (item instanceof Constant) {
                        constantItem = (Constant)item;
                        equal = (Boolean)IrExpressionInterpreter.this.functionInvoker.invoke(equalsOperator, IrExpressionInterpreter.this.connectorSession, new Object[]{constantValue.value(), constantItem.value()});
                        if (Boolean.TRUE.equals(equal)) {
                            if (this.evaluate) {
                                return Booleans.TRUE;
                            }
                            match = constantItem;
                            continue;
                        }
                        if (equal != null) continue;
                        hasNullMatch = true;
                        continue;
                    }
                }
                if (!seen.contains(item)) {
                    newList.add(item);
                }
                if (!DeterminismEvaluator.isDeterministic(item)) continue;
                seen.add(item);
            }
            if (match != null) {
                if (newList.isEmpty()) {
                    return Booleans.TRUE;
                }
                newList.add(match);
            }
            if (newList.isEmpty()) {
                return hasNullMatch != false ? Booleans.NULL_BOOLEAN : Booleans.FALSE;
            }
            if (newList.size() == 1) {
                return hasNullMatch != false ? Booleans.NULL_BOOLEAN : new Comparison(Comparison.Operator.EQUAL, value, (Expression)newList.getFirst());
            }
            return new In(value, newList);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        protected Expression visitComparison(Comparison node, SymbolResolver context) {
            Object leftValue;
            Type leftType;
            Object object;
            Constant constant;
            Comparison.Operator operator = node.operator();
            Expression left = this.processWithExceptionHandling(node.left(), context);
            Expression right = this.processWithExceptionHandling(node.right(), context);
            if (operator == Comparison.Operator.IDENTICAL) {
                if (left instanceof Constant) {
                    constant = (Constant)left;
                    leftType = object = constant.type();
                    leftValue = object = constant.value();
                    if (right instanceof Constant) {
                        Constant constant2 = (Constant)right;
                        Object rightType = object = constant2.type();
                        Object rightValue = object = constant2.value();
                        return new Constant((Type)BooleanType.BOOLEAN, this.invokeOperator(OperatorType.IDENTICAL, (List<? extends Type>)ImmutableList.of((Object)leftType, (Object)rightType), Arrays.asList(leftValue, rightValue)));
                    }
                }
                if (IrExpressionInterpreter.isConstantNull(left)) {
                    return new IsNull(right);
                }
                if (IrExpressionInterpreter.isConstantNull(right)) {
                    return new IsNull(left);
                }
            }
            if (!(left instanceof Constant)) return new Comparison(operator, left, right);
            constant = (Constant)left;
            try {
                leftType = object = constant.type();
            }
            catch (Throwable throwable) {
                throw new MatchException(throwable.toString(), throwable);
            }
            leftValue = object = constant.value();
            if (!(right instanceof Constant)) return new Comparison(operator, left, right);
            Constant constant3 = (Constant)right;
            Object rightType = object = constant3.type();
            Object rightValue = object = constant3.value();
            ImmutableList types = ImmutableList.of((Object)leftType, (Object)rightType);
            switch (operator) {
                case EQUAL: {
                    Object object2 = this.invokeOperator(OperatorType.EQUAL, (List<? extends Type>)types, Arrays.asList(leftValue, rightValue));
                    return new Constant((Type)BooleanType.BOOLEAN, object2);
                }
                case NOT_EQUAL: {
                    Object object2;
                    Object object3 = this.invokeOperator(OperatorType.EQUAL, (List<? extends Type>)types, Arrays.asList(leftValue, rightValue));
                    int n = 0;
                    switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Boolean.class}, (Object)object3, n)) {
                        case -1: {
                            object2 = null;
                            return new Constant((Type)BooleanType.BOOLEAN, object2);
                        }
                        case 0: {
                            Boolean result = (Boolean)object3;
                            object2 = result == false;
                            return new Constant((Type)BooleanType.BOOLEAN, object2);
                        }
                    }
                    throw new IllegalStateException("Unexpected value for boolean expression");
                }
                case LESS_THAN: {
                    Object object2 = this.invokeOperator(OperatorType.LESS_THAN, (List<? extends Type>)types, Arrays.asList(leftValue, rightValue));
                    return new Constant((Type)BooleanType.BOOLEAN, object2);
                }
                case LESS_THAN_OR_EQUAL: {
                    Object object2 = this.invokeOperator(OperatorType.LESS_THAN_OR_EQUAL, (List<? extends Type>)types, Arrays.asList(leftValue, rightValue));
                    return new Constant((Type)BooleanType.BOOLEAN, object2);
                }
                case GREATER_THAN: {
                    Object object2 = this.invokeOperator(OperatorType.LESS_THAN, (List<? extends Type>)types, Arrays.asList(rightValue, leftValue));
                    return new Constant((Type)BooleanType.BOOLEAN, object2);
                }
                case GREATER_THAN_OR_EQUAL: {
                    Object object2 = this.invokeOperator(OperatorType.LESS_THAN_OR_EQUAL, (List<? extends Type>)types, Arrays.asList(rightValue, leftValue));
                    return new Constant((Type)BooleanType.BOOLEAN, object2);
                }
                default: {
                    throw new IllegalStateException("Unexpected operator: " + String.valueOf((Object)operator));
                }
            }
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        protected Expression visitBetween(Between node, SymbolResolver context) {
            Expression value = this.processWithExceptionHandling(node.value(), context);
            Expression min = this.processWithExceptionHandling(node.min(), context);
            Expression max = this.processWithExceptionHandling(node.max(), context);
            ResolvedFunction lessThanOrEqual = IrExpressionInterpreter.this.metadata.resolveOperator(OperatorType.LESS_THAN_OR_EQUAL, (List<? extends Type>)ImmutableList.of((Object)value.type(), (Object)value.type()));
            if (min instanceof Constant) {
                Constant minConstant = (Constant)min;
                if (max instanceof Constant) {
                    Constant maxConstant = (Constant)max;
                    if (!(IrExpressionInterpreter.isConstantNull(minConstant) || IrExpressionInterpreter.isConstantNull(maxConstant) || Boolean.TRUE.equals(IrExpressionInterpreter.this.functionInvoker.invoke(lessThanOrEqual, IrExpressionInterpreter.this.connectorSession, minConstant.value(), maxConstant.value())))) {
                        return IrExpressions.ifExpression(new IsNull(value), Booleans.NULL_BOOLEAN, Booleans.FALSE);
                    }
                    if (!(value instanceof Constant)) return new Between(value, min, max);
                    Constant valueConstant = (Constant)value;
                    Boolean minComparison = (Boolean)IrExpressionInterpreter.this.functionInvoker.invoke(lessThanOrEqual, IrExpressionInterpreter.this.connectorSession, minConstant.value(), valueConstant.value());
                    Boolean maxComparison = (Boolean)IrExpressionInterpreter.this.functionInvoker.invoke(lessThanOrEqual, IrExpressionInterpreter.this.connectorSession, valueConstant.value(), maxConstant.value());
                    if (Boolean.TRUE.equals(minComparison) && Boolean.TRUE.equals(maxComparison)) {
                        return Booleans.TRUE;
                    }
                    if (!Boolean.FALSE.equals(minComparison) && !Boolean.FALSE.equals(maxComparison)) return Booleans.NULL_BOOLEAN;
                    return Booleans.FALSE;
                }
            }
            if (min instanceof Constant) {
                Constant minConstant = (Constant)min;
                if (value instanceof Constant) {
                    Constant valueConstant = (Constant)value;
                    Boolean comparison = (Boolean)IrExpressionInterpreter.this.functionInvoker.invoke(lessThanOrEqual, IrExpressionInterpreter.this.connectorSession, minConstant.value(), valueConstant.value());
                    return Boolean.FALSE.equals(comparison) ? Booleans.FALSE : new Comparison(Comparison.Operator.LESS_THAN, value, max);
                }
            }
            if (!(max instanceof Constant)) return new Between(value, min, max);
            Constant maxConstant = (Constant)max;
            if (!(value instanceof Constant)) return new Between(value, min, max);
            Constant valueConstant = (Constant)value;
            Boolean comparison = (Boolean)IrExpressionInterpreter.this.functionInvoker.invoke(lessThanOrEqual, IrExpressionInterpreter.this.connectorSession, valueConstant.value(), maxConstant.value());
            return Boolean.FALSE.equals(comparison) ? Booleans.FALSE : new Comparison(Comparison.Operator.LESS_THAN, min, value);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        protected Expression visitNullIf(NullIf node, SymbolResolver context) {
            Type firstType;
            Object object;
            Expression first = this.processWithExceptionHandling(node.first(), context);
            if (IrExpressionInterpreter.isConstantNull(first)) {
                return new Constant(first.type(), null);
            }
            Expression second = this.processWithExceptionHandling(node.second(), context);
            if (IrExpressionInterpreter.isConstantNull(second)) {
                return first;
            }
            if (!(first instanceof Constant)) return new NullIf(first, second);
            Constant constant = (Constant)first;
            try {
                firstType = object = constant.type();
            }
            catch (Throwable throwable) {
                throw new MatchException(throwable.toString(), throwable);
            }
            Object firstValue = object = constant.value();
            if (!(second instanceof Constant)) return new NullIf(first, second);
            Constant constant2 = (Constant)second;
            Object secondType = object = constant2.type();
            Object secondValue = object = constant2.value();
            Type commonType = IrExpressionInterpreter.this.typeCoercion.getCommonSuperType(firstType, (Type)secondType).get();
            ResolvedFunction firstCast = IrExpressionInterpreter.this.metadata.getCoercion(firstType, commonType);
            ResolvedFunction secondCast = IrExpressionInterpreter.this.metadata.getCoercion((Type)secondType, commonType);
            boolean equal = Boolean.TRUE.equals(this.invokeOperator(OperatorType.EQUAL, (List<? extends Type>)ImmutableList.of((Object)commonType, (Object)commonType), (List<Object>)ImmutableList.of((Object)IrExpressionInterpreter.this.functionInvoker.invoke(firstCast, IrExpressionInterpreter.this.connectorSession, (List<Object>)ImmutableList.of((Object)firstValue)), (Object)IrExpressionInterpreter.this.functionInvoker.invoke(secondCast, IrExpressionInterpreter.this.connectorSession, (List<Object>)ImmutableList.of((Object)secondValue)))));
            return equal ? new Constant(firstType, null) : first;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        protected Expression visitLogical(Logical node, SymbolResolver context) {
            Constant constant;
            List<Expression> terms = node.terms().stream().map(term -> this.processWithExceptionHandling((Expression)term, context)).toList();
            HashSet<Expression> seen = new HashSet<Expression>();
            ArrayList<Expression> newTerms = new ArrayList<Expression>();
            for (Expression term2 : terms) {
                if (term2 instanceof Constant) {
                    Object object;
                    Constant constant2 = (Constant)term2;
                    try {
                        Type type = object = constant2.type();
                        object = constant2.value();
                    }
                    catch (Throwable throwable) {
                        throw new MatchException(throwable.toString(), throwable);
                    }
                    if (object instanceof Boolean) {
                        Boolean value = (Boolean)object;
                        if (node.operator() == Logical.Operator.AND && !value.booleanValue()) {
                            return Booleans.FALSE;
                        }
                        if (node.operator() != Logical.Operator.OR || !value.booleanValue()) continue;
                        return Booleans.TRUE;
                    }
                }
                if (seen.contains(term2)) continue;
                newTerms.add(term2);
                if (!DeterminismEvaluator.isDeterministic(term2)) continue;
                seen.add(term2);
            }
            if (!newTerms.isEmpty()) {
                if (newTerms.size() != 1) return new Logical(node.operator(), newTerms);
                return (Expression)newTerms.getFirst();
            }
            switch (node.operator()) {
                default: {
                    throw new MatchException(null, null);
                }
                case AND: {
                    constant = Booleans.TRUE;
                    return constant;
                }
                case OR: 
            }
            constant = Booleans.FALSE;
            return constant;
        }

        @Override
        protected Expression visitCall(Call node, SymbolResolver context) {
            ResolvedFunction function = node.function();
            if (function.name().getFunctionName().equals(OperatorNameUtil.mangleOperatorName(OperatorType.NEGATION))) {
                return this.processNegation(node, context);
            }
            List<Expression> arguments = node.arguments().stream().map(argument -> this.processWithExceptionHandling((Expression)argument, context)).toList();
            FunctionNullability nullability = function.functionNullability();
            for (int i = 0; i < arguments.size(); ++i) {
                Expression argument2 = arguments.get(i);
                if (!IrExpressionInterpreter.isConstantNull(argument2) || nullability.isArgumentNullable(i)) continue;
                return new Constant(node.type(), null);
            }
            if (this.evaluate || function.deterministic() && !DynamicFilters.isDynamicFilter(node) && !function.name().equals((Object)FAIL_NAME) && arguments.stream().allMatch(e -> e instanceof Constant || e instanceof Lambda && DeterminismEvaluator.isDeterministic(e))) {
                List<Object> argumentValues = arguments.stream().map(argument -> {
                    Expression expression = argument;
                    Objects.requireNonNull(expression);
                    Expression selector0$temp = expression;
                    int index$1 = 0;
                    return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Constant.class, Lambda.class}, (Object)selector0$temp, index$1)) {
                        case 0 -> {
                            Constant constant = (Constant)selector0$temp;
                            yield constant.value();
                        }
                        case 1 -> {
                            Lambda lambda = (Lambda)selector0$temp;
                            yield this.makeLambdaInvoker(lambda);
                        }
                        default -> throw new IllegalArgumentException("Expected lambda or constant, found: " + String.valueOf(argument));
                    };
                }).collect(Collectors.toList());
                try {
                    return new Constant(node.type(), IrExpressionInterpreter.this.functionInvoker.invoke(function, IrExpressionInterpreter.this.connectorSession, argumentValues));
                }
                catch (TrinoException e2) {
                    if (this.evaluate) {
                        throw e2;
                    }
                    return new Call(node.function(), node.arguments().stream().map(argument -> this.processWithExceptionHandling((Expression)argument, context)).toList());
                }
            }
            return new Call(function, arguments);
        }

        private Object evaluate(Expression body, Map<Symbol, Integer> mappings, Object ... arguments) {
            Constant result = (Constant)new Visitor(true).process(body, symbol -> {
                Integer index = (Integer)mappings.get(symbol);
                if (index == null) {
                    return Optional.empty();
                }
                return Optional.of(new Constant(symbol.type(), arguments[index]));
            });
            return result.value();
        }

        private MethodHandle makeLambdaInvoker(Lambda lambda) {
            HashMap<Symbol, Integer> mappings = new HashMap<Symbol, Integer>();
            for (int i = 0; i < lambda.arguments().size(); ++i) {
                mappings.put(lambda.arguments().get(i), i);
            }
            return LAMBDA_EVALUATOR.bindTo(this).bindTo(lambda.body()).bindTo(mappings).asVarargsCollector(new Object[0].getClass());
        }

        private Expression processNegation(Call negation, SymbolResolver context) {
            Expression expression;
            Expression value;
            Expression expression2 = value = this.processWithExceptionHandling(negation.arguments().getFirst(), context);
            Objects.requireNonNull(expression2);
            Expression expression3 = expression2;
            int n = 0;
            block4: while (true) {
                switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Constant.class, Call.class, Expression.class}, (Object)expression3, n)) {
                    case 0: {
                        Constant constant = (Constant)expression3;
                        expression = new Constant(negation.type(), IrExpressionInterpreter.this.functionInvoker.invoke(negation.function(), IrExpressionInterpreter.this.connectorSession, (List<Object>)ImmutableList.of((Object)constant.value())));
                        break block4;
                    }
                    case 1: {
                        Call inner = (Call)expression3;
                        if (!inner.function().name().equals((Object)GlobalFunctionCatalog.builtinFunctionName(OperatorType.NEGATION))) {
                            n = 2;
                            continue block4;
                        }
                        expression = inner.arguments().getFirst();
                        break block4;
                    }
                    default: {
                        Expression inner = expression3;
                        expression = new Call(negation.function(), (List<Expression>)ImmutableList.of((Object)inner));
                        break block4;
                    }
                }
                break;
            }
            return expression;
        }

        @Override
        protected Expression visitLambda(Lambda node, SymbolResolver context) {
            if (this.evaluate) {
                return node;
            }
            return new Lambda(node.arguments(), this.processWithExceptionHandling(node.body(), context));
        }

        @Override
        protected Expression visitBind(Bind node, SymbolResolver context) {
            int i;
            List<Expression> values = node.values().stream().map(value -> this.processWithExceptionHandling((Expression)value, context)).toList();
            HashMap<Symbol, Constant> bindings = new HashMap<Symbol, Constant>();
            ArrayList<Symbol> newArguments = new ArrayList<Symbol>();
            ArrayList<Expression> newBindings = new ArrayList<Expression>();
            for (i = 0; i < values.size(); ++i) {
                Symbol argument = node.function().arguments().get(i);
                Expression value2 = values.get(i);
                if (value2 instanceof Constant) {
                    Constant constant = (Constant)value2;
                    bindings.put(argument, constant);
                    continue;
                }
                newArguments.add(argument);
                newBindings.add(value2);
            }
            for (i = values.size(); i < node.function().arguments().size(); ++i) {
                newArguments.add(node.function().arguments().get(i));
            }
            Expression body = (Expression)new Visitor(false).process(node.function().body(), symbol -> {
                Constant result = (Constant)bindings.get(symbol);
                if (result != null) {
                    return Optional.of(result);
                }
                return context.getValue(symbol);
            });
            if (newBindings.isEmpty()) {
                return new Lambda(newArguments, body);
            }
            return new Bind(newBindings, new Lambda(newArguments, body));
        }

        @Override
        public Expression visitCast(Cast node, SymbolResolver context) {
            Expression expression;
            Expression value;
            Expression expression2 = value = this.processWithExceptionHandling(node.expression(), context);
            Objects.requireNonNull(expression2);
            Expression expression3 = expression2;
            int n = 0;
            block8: while (true) {
                switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Call.class, Expression.class, Constant.class, Constant.class}, (Object)expression3, n)) {
                    case 0: {
                        Call call = (Call)expression3;
                        if (!call.function().name().equals((Object)GlobalFunctionCatalog.builtinFunctionName("json_parse"))) {
                            n = 1;
                            continue block8;
                        }
                        Expression expression4 = this.processJsonParseWithinCast(node, call);
                        expression = expression4;
                        break block8;
                    }
                    case 1: {
                        Expression expression5 = expression3;
                        if (!expression5.type().equals((Object)node.type())) {
                            n = 2;
                            continue block8;
                        }
                        Expression expression6 = expression5;
                        expression = expression6;
                        break block8;
                    }
                    case 2: {
                        Constant constant = (Constant)expression3;
                        if (constant.value() != null) {
                            n = 3;
                            continue block8;
                        }
                        Constant constant2 = new Constant(node.type(), null);
                        expression = constant2;
                        break block8;
                    }
                    case 3: {
                        Constant constant = (Constant)expression3;
                        try {
                            Constant constant3 = new Constant(node.type(), IrExpressionInterpreter.this.functionInvoker.invoke(IrExpressionInterpreter.this.metadata.getCoercion(constant.type(), node.type()), IrExpressionInterpreter.this.connectorSession, (List<Object>)ImmutableList.of((Object)constant.value())));
                            expression = constant3;
                        }
                        catch (TrinoException e) {
                            Cast cast;
                            if (this.evaluate) {
                                throw e;
                            }
                            expression = cast = new Cast(constant, node.type());
                        }
                        break block8;
                    }
                    default: {
                        Cast cast;
                        expression = cast = new Cast(value, node.type());
                        break block8;
                    }
                }
                break;
            }
            return expression;
        }

        private Expression processJsonParseWithinCast(Cast cast, Call jsonParse) {
            Expression string = jsonParse.arguments().getFirst();
            Type type = cast.type();
            Objects.requireNonNull(type);
            Type type2 = type;
            int n = 0;
            return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{ArrayType.class, MapType.class, RowType.class}, (Object)type2, n)) {
                case 0 -> {
                    ArrayType arrayType = (ArrayType)type2;
                    yield new Call(IrExpressionInterpreter.this.metadata.getCoercion(GlobalFunctionCatalog.builtinFunctionName("$internal$json_string_to_array_cast"), string.type(), (Type)arrayType), jsonParse.arguments());
                }
                case 1 -> {
                    MapType mapType = (MapType)type2;
                    yield new Call(IrExpressionInterpreter.this.metadata.getCoercion(GlobalFunctionCatalog.builtinFunctionName("$internal$json_string_to_map_cast"), string.type(), (Type)mapType), jsonParse.arguments());
                }
                case 2 -> {
                    RowType rowType = (RowType)type2;
                    yield new Call(IrExpressionInterpreter.this.metadata.getCoercion(GlobalFunctionCatalog.builtinFunctionName("$internal$json_string_to_row_cast"), string.type(), (Type)rowType), jsonParse.arguments());
                }
                default -> cast;
            };
        }

        @Override
        protected Expression visitArray(Array node, SymbolResolver context) {
            List<Expression> elements = node.elements().stream().map(field -> this.processWithExceptionHandling((Expression)field, context)).toList();
            if (elements.stream().allMatch(Constant.class::isInstance)) {
                BlockBuilder builder = node.elementType().createBlockBuilder(null, node.elements().size());
                for (Expression element : elements) {
                    TypeUtils.writeNativeValue((Type)node.elementType(), (BlockBuilder)builder, (Object)((Constant)element).value());
                }
                return new Constant(node.type(), builder.build());
            }
            return new Array(node.elementType(), elements);
        }

        @Override
        protected Expression visitRow(Row node, SymbolResolver context) {
            List<Expression> fields = node.items().stream().map(field -> this.processWithExceptionHandling((Expression)field, context)).toList();
            if (fields.stream().allMatch(Constant.class::isInstance)) {
                RowType rowType = (RowType)node.type();
                return new Constant((Type)rowType, RowValueBuilder.buildRowValue((RowType)rowType, builders -> {
                    for (int i = 0; i < fields.size(); ++i) {
                        TypeUtils.writeNativeValue((Type)((Expression)fields.get(i)).type(), (BlockBuilder)((BlockBuilder)builders.get(i)), (Object)((Constant)fields.get(i)).value());
                    }
                }));
            }
            return new Row(fields);
        }

        /*
         * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        protected Expression visitFieldReference(FieldReference node, SymbolResolver context) {
            Expression expression;
            Expression base;
            Expression expression2 = base = this.processWithExceptionHandling(node.base(), context);
            Objects.requireNonNull(expression2);
            Expression expression3 = expression2;
            int n = 0;
            block14: while (true) {
                switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Constant.class, Row.class}, (Object)expression3, n)) {
                    case 0: {
                        int n2;
                        Type type;
                        Constant constant = (Constant)expression3;
                        try {
                            type = constant.type();
                            n2 = 0;
                        }
                        catch (Throwable throwable) {
                            throw new MatchException(throwable.toString(), throwable);
                        }
                        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{RowType.class}, (Object)type, n2)) {
                            case 0: {
                                int n3;
                                Object object;
                                RowType type2 = (RowType)type;
                                {
                                    object = constant.value();
                                    n3 = 0;
                                }
                                switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{SqlRow.class, Object.class}, (Object)object, n3)) {
                                    default: {
                                        throw new MatchException(null, null);
                                    }
                                    case 0: {
                                        SqlRow row = (SqlRow)object;
                                        Type fieldType = ((RowType.Field)type2.getFields().get(node.field())).getType();
                                        expression = new Constant(fieldType, TypeUtils.readNativeValue((Type)fieldType, (Block)row.getRawFieldBlock(node.field()), (int)row.getRawIndex()));
                                        return expression;
                                    }
                                    case -1: 
                                    case 1: 
                                }
                                Object value = object;
                                expression = new Constant(((RowType.Field)type2.getFields().get(node.field())).getType(), null);
                                return expression;
                            }
                        }
                        n = 1;
                        continue block14;
                    }
                    case 1: {
                        Row row = (Row)expression3;
                        expression = row.items().get(node.field());
                        return expression;
                    }
                }
                break;
            }
            expression = new FieldReference(base, node.field());
            return expression;
        }

        @Override
        protected Expression visitExpression(Expression node, SymbolResolver context) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "not yet implemented: " + node.getClass().getName());
        }

        private Object invokeOperator(OperatorType operatorType, List<? extends Type> argumentTypes, List<Object> argumentValues) {
            ResolvedFunction operator = IrExpressionInterpreter.this.metadata.resolveOperator(operatorType, argumentTypes);
            return IrExpressionInterpreter.this.functionInvoker.invoke(operator, IrExpressionInterpreter.this.connectorSession, argumentValues);
        }

        private /* synthetic */ Expression lambda$visitIn$3(SymbolResolver context, Expression item) {
            return this.processWithExceptionHandling(item, context);
        }

        private /* synthetic */ Object lambda$visitIn$2(SymbolResolver context, Expression expression) {
            return ((Constant)this.processWithExceptionHandling(expression, context)).value();
        }
    }
}

