/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner;

import com.google.common.base.Functions;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.base.Verify;
import com.google.common.base.VerifyException;
import com.google.common.cache.CacheBuilder;
import com.google.common.collect.ContiguousSet;
import com.google.common.collect.DiscreteDomain;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableBiMap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSetMultimap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import com.google.common.collect.Range;
import com.google.common.collect.SetMultimap;
import com.google.common.collect.Sets;
import com.google.common.primitives.Ints;
import com.google.inject.Inject;
import io.airlift.log.Logger;
import io.airlift.units.DataSize;
import io.trino.Session;
import io.trino.SystemSessionProperties;
import io.trino.cache.CacheUtils;
import io.trino.cache.NonEvictableCache;
import io.trino.cache.SafeCaches;
import io.trino.client.NodeVersion;
import io.trino.exchange.ExchangeManagerRegistry;
import io.trino.execution.DynamicFilterConfig;
import io.trino.execution.ExplainAnalyzeContext;
import io.trino.execution.StageId;
import io.trino.execution.TableExecuteContextManager;
import io.trino.execution.TaskId;
import io.trino.execution.TaskManagerConfig;
import io.trino.execution.buffer.OutputBuffer;
import io.trino.execution.buffer.PagesSerdeFactory;
import io.trino.metadata.GlobalFunctionCatalog;
import io.trino.metadata.MergeHandle;
import io.trino.metadata.Metadata;
import io.trino.metadata.ResolvedFunction;
import io.trino.metadata.TableExecuteHandle;
import io.trino.metadata.TableHandle;
import io.trino.operator.AggregationOperator;
import io.trino.operator.AssignUniqueIdOperator;
import io.trino.operator.DevNullOperator;
import io.trino.operator.DirectExchangeClientSupplier;
import io.trino.operator.DistinctLimitOperator;
import io.trino.operator.DriverFactory;
import io.trino.operator.DynamicFilterSourceOperator;
import io.trino.operator.EnforceSingleRowOperator;
import io.trino.operator.ExchangeOperator;
import io.trino.operator.ExplainAnalyzeOperator;
import io.trino.operator.FilterAndProjectOperator;
import io.trino.operator.FlatHashStrategyCompiler;
import io.trino.operator.GroupIdOperator;
import io.trino.operator.HashAggregationOperator;
import io.trino.operator.HashArraySizeSupplier;
import io.trino.operator.HashSemiJoinOperator;
import io.trino.operator.JoinOperatorType;
import io.trino.operator.LeafTableFunctionOperator;
import io.trino.operator.LimitOperator;
import io.trino.operator.LocalPlannerAware;
import io.trino.operator.MarkDistinctOperator;
import io.trino.operator.MergeOperator;
import io.trino.operator.MergeProcessorOperator;
import io.trino.operator.MergeWriterOperator;
import io.trino.operator.OperatorFactories;
import io.trino.operator.OperatorFactory;
import io.trino.operator.OrderByOperator;
import io.trino.operator.OutputFactory;
import io.trino.operator.PagesIndex;
import io.trino.operator.PagesSpatialIndexFactory;
import io.trino.operator.PartitionFunction;
import io.trino.operator.RefreshMaterializedViewOperator;
import io.trino.operator.RetryPolicy;
import io.trino.operator.RowNumberOperator;
import io.trino.operator.ScanFilterAndProjectOperator;
import io.trino.operator.SetBuilderOperator;
import io.trino.operator.SimpleTableExecuteOperator;
import io.trino.operator.SpatialIndexBuilderOperator;
import io.trino.operator.SpatialJoinOperator;
import io.trino.operator.StatisticsWriterOperator;
import io.trino.operator.StreamingAggregationOperator;
import io.trino.operator.TableFinishOperator;
import io.trino.operator.TableMutationOperator;
import io.trino.operator.TableScanOperator;
import io.trino.operator.TableWriterOperator;
import io.trino.operator.TaskContext;
import io.trino.operator.TopNOperator;
import io.trino.operator.TopNRankingOperator;
import io.trino.operator.ValuesOperator;
import io.trino.operator.WindowFunctionDefinition;
import io.trino.operator.WindowOperator;
import io.trino.operator.aggregation.AccumulatorCompiler;
import io.trino.operator.aggregation.AccumulatorFactory;
import io.trino.operator.aggregation.AggregatorFactory;
import io.trino.operator.aggregation.DistinctAccumulatorFactory;
import io.trino.operator.aggregation.OrderedAccumulatorFactory;
import io.trino.operator.aggregation.partial.PartialAggregationController;
import io.trino.operator.exchange.LocalExchange;
import io.trino.operator.exchange.LocalExchangeSinkOperator;
import io.trino.operator.exchange.LocalExchangeSourceOperator;
import io.trino.operator.exchange.LocalMergeSourceOperator;
import io.trino.operator.exchange.PageChannelSelector;
import io.trino.operator.function.RegularTableFunctionPartition;
import io.trino.operator.function.TableFunctionOperator;
import io.trino.operator.index.DynamicTupleFilterFactory;
import io.trino.operator.index.FieldSetFilteringRecordSet;
import io.trino.operator.index.IndexBuildDriverFactoryProvider;
import io.trino.operator.index.IndexJoinLookupStats;
import io.trino.operator.index.IndexLookupSourceFactory;
import io.trino.operator.index.IndexManager;
import io.trino.operator.index.IndexSourceOperator;
import io.trino.operator.join.HashBuilderOperator;
import io.trino.operator.join.JoinBridgeManager;
import io.trino.operator.join.JoinOperatorFactory;
import io.trino.operator.join.JoinUtils;
import io.trino.operator.join.NestedLoopBuildOperator;
import io.trino.operator.join.NestedLoopJoinBridge;
import io.trino.operator.join.NestedLoopJoinOperator;
import io.trino.operator.join.NestedLoopJoinPagesSupplier;
import io.trino.operator.join.unspilled.HashBuilderOperator;
import io.trino.operator.join.unspilled.PartitionedLookupSourceFactory;
import io.trino.operator.output.PartitionedOutputOperator;
import io.trino.operator.output.PositionsAppenderFactory;
import io.trino.operator.output.SkewedPartitionRebalancer;
import io.trino.operator.output.TaskOutputOperator;
import io.trino.operator.project.CursorProcessor;
import io.trino.operator.project.PageProcessor;
import io.trino.operator.project.PageProjection;
import io.trino.operator.unnest.UnnestOperator;
import io.trino.operator.window.AggregationWindowFunctionSupplier;
import io.trino.operator.window.FrameInfo;
import io.trino.operator.window.PatternRecognitionPartitionerSupplier;
import io.trino.operator.window.RegularPartitionerSupplier;
import io.trino.operator.window.matcher.IrRowPatternToProgramRewriter;
import io.trino.operator.window.matcher.Matcher;
import io.trino.operator.window.matcher.Program;
import io.trino.operator.window.pattern.ArgumentComputation;
import io.trino.operator.window.pattern.LabelEvaluator;
import io.trino.operator.window.pattern.LogicalIndexNavigation;
import io.trino.operator.window.pattern.MatchAggregation;
import io.trino.operator.window.pattern.MatchAggregationPointer;
import io.trino.operator.window.pattern.MeasureComputation;
import io.trino.operator.window.pattern.PhysicalValueAccessor;
import io.trino.operator.window.pattern.PhysicalValuePointer;
import io.trino.operator.window.pattern.SetEvaluator;
import io.trino.plugin.base.MappedRecordSet;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.Page;
import io.trino.spi.PageBuilder;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.TrinoException;
import io.trino.spi.block.Block;
import io.trino.spi.block.BlockBuilder;
import io.trino.spi.block.SqlRow;
import io.trino.spi.connector.ColumnHandle;
import io.trino.spi.connector.ConnectorIndex;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.connector.DynamicFilter;
import io.trino.spi.connector.RecordSet;
import io.trino.spi.connector.SortOrder;
import io.trino.spi.connector.WriterScalingOptions;
import io.trino.spi.function.AggregationImplementation;
import io.trino.spi.function.BoundSignature;
import io.trino.spi.function.CatalogSchemaFunctionName;
import io.trino.spi.function.FunctionId;
import io.trino.spi.function.FunctionKind;
import io.trino.spi.function.WindowFunctionSupplier;
import io.trino.spi.function.table.TableFunctionProcessorProvider;
import io.trino.spi.predicate.Domain;
import io.trino.spi.predicate.NullableValue;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.RowType;
import io.trino.spi.type.Type;
import io.trino.spi.type.TypeOperators;
import io.trino.spi.type.TypeUtils;
import io.trino.spi.type.VarcharType;
import io.trino.spiller.PartitioningSpillerFactory;
import io.trino.spiller.SingleStreamSpillerFactory;
import io.trino.spiller.SpillerFactory;
import io.trino.split.PageSinkManager;
import io.trino.split.PageSourceManager;
import io.trino.sql.DynamicFilters;
import io.trino.sql.PlannerContext;
import io.trino.sql.gen.ExpressionCompiler;
import io.trino.sql.gen.JoinCompiler;
import io.trino.sql.gen.JoinFilterFunctionCompiler;
import io.trino.sql.gen.LambdaBytecodeGenerator;
import io.trino.sql.gen.OrderingCompiler;
import io.trino.sql.gen.PageFunctionCompiler;
import io.trino.sql.ir.Booleans;
import io.trino.sql.ir.Call;
import io.trino.sql.ir.Comparison;
import io.trino.sql.ir.Constant;
import io.trino.sql.ir.Expression;
import io.trino.sql.ir.IrUtils;
import io.trino.sql.ir.Lambda;
import io.trino.sql.ir.Reference;
import io.trino.sql.planner.CompilerConfig;
import io.trino.sql.planner.ExpressionExtractor;
import io.trino.sql.planner.ExpressionNodeInliner;
import io.trino.sql.planner.IrExpressionInterpreter;
import io.trino.sql.planner.LocalDynamicFilterConsumer;
import io.trino.sql.planner.LocalDynamicFiltersCollector;
import io.trino.sql.planner.NodePartitioningManager;
import io.trino.sql.planner.OrderingScheme;
import io.trino.sql.planner.PartitioningScheme;
import io.trino.sql.planner.SortExpressionContext;
import io.trino.sql.planner.SortExpressionExtractor;
import io.trino.sql.planner.Symbol;
import io.trino.sql.planner.SymbolsExtractor;
import io.trino.sql.planner.SystemPartitioningHandle;
import io.trino.sql.planner.optimizations.IndexJoinOptimizer;
import io.trino.sql.planner.optimizations.PlanNodeSearcher;
import io.trino.sql.planner.plan.AdaptivePlanNode;
import io.trino.sql.planner.plan.AggregationNode;
import io.trino.sql.planner.plan.AssignUniqueId;
import io.trino.sql.planner.plan.Assignments;
import io.trino.sql.planner.plan.DataOrganizationSpecification;
import io.trino.sql.planner.plan.DistinctLimitNode;
import io.trino.sql.planner.plan.DynamicFilterId;
import io.trino.sql.planner.plan.DynamicFilterSourceNode;
import io.trino.sql.planner.plan.EnforceSingleRowNode;
import io.trino.sql.planner.plan.ExchangeNode;
import io.trino.sql.planner.plan.ExplainAnalyzeNode;
import io.trino.sql.planner.plan.FilterNode;
import io.trino.sql.planner.plan.FrameBoundType;
import io.trino.sql.planner.plan.GroupIdNode;
import io.trino.sql.planner.plan.IndexJoinNode;
import io.trino.sql.planner.plan.IndexSourceNode;
import io.trino.sql.planner.plan.JoinNode;
import io.trino.sql.planner.plan.JoinType;
import io.trino.sql.planner.plan.LimitNode;
import io.trino.sql.planner.plan.MarkDistinctNode;
import io.trino.sql.planner.plan.MergeProcessorNode;
import io.trino.sql.planner.plan.MergeWriterNode;
import io.trino.sql.planner.plan.OutputNode;
import io.trino.sql.planner.plan.PatternRecognitionNode;
import io.trino.sql.planner.plan.PlanNode;
import io.trino.sql.planner.plan.PlanNodeId;
import io.trino.sql.planner.plan.PlanVisitor;
import io.trino.sql.planner.plan.ProjectNode;
import io.trino.sql.planner.plan.RefreshMaterializedViewNode;
import io.trino.sql.planner.plan.RemoteSourceNode;
import io.trino.sql.planner.plan.RowNumberNode;
import io.trino.sql.planner.plan.RowsPerMatch;
import io.trino.sql.planner.plan.SampleNode;
import io.trino.sql.planner.plan.SemiJoinNode;
import io.trino.sql.planner.plan.SimpleTableExecuteNode;
import io.trino.sql.planner.plan.SkipToPosition;
import io.trino.sql.planner.plan.SortNode;
import io.trino.sql.planner.plan.SpatialJoinNode;
import io.trino.sql.planner.plan.StatisticAggregationsDescriptor;
import io.trino.sql.planner.plan.StatisticsWriterNode;
import io.trino.sql.planner.plan.TableDeleteNode;
import io.trino.sql.planner.plan.TableExecuteNode;
import io.trino.sql.planner.plan.TableFinishNode;
import io.trino.sql.planner.plan.TableFunctionNode;
import io.trino.sql.planner.plan.TableFunctionProcessorNode;
import io.trino.sql.planner.plan.TableScanNode;
import io.trino.sql.planner.plan.TableUpdateNode;
import io.trino.sql.planner.plan.TableWriterNode;
import io.trino.sql.planner.plan.TopNNode;
import io.trino.sql.planner.plan.TopNRankingNode;
import io.trino.sql.planner.plan.UnionNode;
import io.trino.sql.planner.plan.UnnestNode;
import io.trino.sql.planner.plan.ValuesNode;
import io.trino.sql.planner.plan.WindowFrameType;
import io.trino.sql.planner.plan.WindowNode;
import io.trino.sql.planner.rowpattern.AggregationValuePointer;
import io.trino.sql.planner.rowpattern.ClassifierValuePointer;
import io.trino.sql.planner.rowpattern.ExpressionAndValuePointers;
import io.trino.sql.planner.rowpattern.LogicalIndexPointer;
import io.trino.sql.planner.rowpattern.MatchNumberValuePointer;
import io.trino.sql.planner.rowpattern.ScalarValuePointer;
import io.trino.sql.planner.rowpattern.ValuePointer;
import io.trino.sql.planner.rowpattern.ir.IrLabel;
import io.trino.sql.relational.LambdaDefinitionExpression;
import io.trino.sql.relational.RowExpression;
import io.trino.sql.relational.SqlToRowExpressionTranslator;
import io.trino.type.BlockTypeOperators;
import io.trino.type.FunctionType;
import io.trino.util.MoreMath;
import io.trino.util.SpatialJoinUtils;
import java.lang.runtime.SwitchBootstraps;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalDouble;
import java.util.OptionalInt;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.IntStream;

public class LocalExecutionPlanner {
    private static final Logger log = Logger.get(LocalExecutionPlanner.class);
    private final PlannerContext plannerContext;
    private final Metadata metadata;
    private final Optional<ExplainAnalyzeContext> explainAnalyzeContext;
    private final PageSourceManager pageSourceProvider;
    private final IndexManager indexManager;
    private final NodePartitioningManager nodePartitioningManager;
    private final PageSinkManager pageSinkManager;
    private final DirectExchangeClientSupplier directExchangeClientSupplier;
    private final ExpressionCompiler expressionCompiler;
    private final PageFunctionCompiler pageFunctionCompiler;
    private final JoinFilterFunctionCompiler joinFilterFunctionCompiler;
    private final DataSize maxIndexMemorySize;
    private final IndexJoinLookupStats indexJoinLookupStats;
    private final DataSize maxPartialAggregationMemorySize;
    private final DataSize maxPagePartitioningBufferSize;
    private final DataSize maxLocalExchangeBufferSize;
    private final SpillerFactory spillerFactory;
    private final SingleStreamSpillerFactory singleStreamSpillerFactory;
    private final PartitioningSpillerFactory partitioningSpillerFactory;
    private final PagesIndex.Factory pagesIndexFactory;
    private final JoinCompiler joinCompiler;
    private final FlatHashStrategyCompiler hashStrategyCompiler;
    private final OrderingCompiler orderingCompiler;
    private final int largeMaxDistinctValuesPerDriver;
    private final int largePartitionedMaxDistinctValuesPerDriver;
    private final int smallMaxDistinctValuesPerDriver;
    private final int smallPartitionedMaxDistinctValuesPerDriver;
    private final DataSize largeMaxSizePerDriver;
    private final DataSize largePartitionedMaxSizePerDriver;
    private final DataSize smallMaxSizePerDriver;
    private final DataSize smallPartitionedMaxSizePerDriver;
    private final int largeRangeRowLimitPerDriver;
    private final int largePartitionedRangeRowLimitPerDriver;
    private final int smallRangeRowLimitPerDriver;
    private final int smallPartitionedRangeRowLimitPerDriver;
    private final DataSize largeMaxSizePerOperator;
    private final DataSize largePartitionedMaxSizePerOperator;
    private final DataSize smallMaxSizePerOperator;
    private final DataSize smallPartitionedMaxSizePerOperator;
    private final BlockTypeOperators blockTypeOperators;
    private final TypeOperators typeOperators;
    private final TableExecuteContextManager tableExecuteContextManager;
    private final ExchangeManagerRegistry exchangeManagerRegistry;
    private final PositionsAppenderFactory positionsAppenderFactory;
    private final NodeVersion version;
    private final boolean specializeAggregationLoops;
    private final NonEvictableCache<FunctionKey, AccumulatorFactory> accumulatorFactoryCache = SafeCaches.buildNonEvictableCache((CacheBuilder)CacheBuilder.newBuilder().maximumSize(1000L).expireAfterAccess(1L, TimeUnit.HOURS));
    private final NonEvictableCache<FunctionKey, AggregationWindowFunctionSupplier> aggregationWindowFunctionSupplierCache = SafeCaches.buildNonEvictableCache((CacheBuilder)CacheBuilder.newBuilder().maximumSize(1000L).expireAfterAccess(1L, TimeUnit.HOURS));

    @Inject
    public LocalExecutionPlanner(PlannerContext plannerContext, Optional<ExplainAnalyzeContext> explainAnalyzeContext, PageSourceManager pageSourceProvider, IndexManager indexManager, NodePartitioningManager nodePartitioningManager, PageSinkManager pageSinkManager, DirectExchangeClientSupplier directExchangeClientSupplier, ExpressionCompiler expressionCompiler, PageFunctionCompiler pageFunctionCompiler, JoinFilterFunctionCompiler joinFilterFunctionCompiler, IndexJoinLookupStats indexJoinLookupStats, TaskManagerConfig taskManagerConfig, SpillerFactory spillerFactory, SingleStreamSpillerFactory singleStreamSpillerFactory, PartitioningSpillerFactory partitioningSpillerFactory, PagesIndex.Factory pagesIndexFactory, JoinCompiler joinCompiler, FlatHashStrategyCompiler hashStrategyCompiler, OrderingCompiler orderingCompiler, DynamicFilterConfig dynamicFilterConfig, BlockTypeOperators blockTypeOperators, TypeOperators typeOperators, TableExecuteContextManager tableExecuteContextManager, ExchangeManagerRegistry exchangeManagerRegistry, NodeVersion version, CompilerConfig compilerConfig) {
        this.plannerContext = Objects.requireNonNull(plannerContext, "plannerContext is null");
        this.metadata = plannerContext.getMetadata();
        this.explainAnalyzeContext = Objects.requireNonNull(explainAnalyzeContext, "explainAnalyzeContext is null");
        this.pageSourceProvider = Objects.requireNonNull(pageSourceProvider, "pageSourceProvider is null");
        this.indexManager = Objects.requireNonNull(indexManager, "indexManager is null");
        this.nodePartitioningManager = Objects.requireNonNull(nodePartitioningManager, "nodePartitioningManager is null");
        this.directExchangeClientSupplier = directExchangeClientSupplier;
        this.pageSinkManager = Objects.requireNonNull(pageSinkManager, "pageSinkManager is null");
        this.expressionCompiler = Objects.requireNonNull(expressionCompiler, "expressionCompiler is null");
        this.pageFunctionCompiler = Objects.requireNonNull(pageFunctionCompiler, "pageFunctionCompiler is null");
        this.joinFilterFunctionCompiler = Objects.requireNonNull(joinFilterFunctionCompiler, "joinFilterFunctionCompiler is null");
        this.indexJoinLookupStats = Objects.requireNonNull(indexJoinLookupStats, "indexJoinLookupStats is null");
        this.maxIndexMemorySize = taskManagerConfig.getMaxIndexMemoryUsage();
        this.spillerFactory = Objects.requireNonNull(spillerFactory, "spillerFactory is null");
        this.singleStreamSpillerFactory = Objects.requireNonNull(singleStreamSpillerFactory, "singleStreamSpillerFactory is null");
        this.partitioningSpillerFactory = Objects.requireNonNull(partitioningSpillerFactory, "partitioningSpillerFactory is null");
        this.maxPartialAggregationMemorySize = taskManagerConfig.getMaxPartialAggregationMemoryUsage();
        this.maxPagePartitioningBufferSize = taskManagerConfig.getMaxPagePartitioningBufferSize();
        this.maxLocalExchangeBufferSize = taskManagerConfig.getMaxLocalExchangeBufferSize();
        this.pagesIndexFactory = Objects.requireNonNull(pagesIndexFactory, "pagesIndexFactory is null");
        this.joinCompiler = Objects.requireNonNull(joinCompiler, "joinCompiler is null");
        this.hashStrategyCompiler = Objects.requireNonNull(hashStrategyCompiler, "hashStrategyCompiler is null");
        this.orderingCompiler = Objects.requireNonNull(orderingCompiler, "orderingCompiler is null");
        this.largeMaxDistinctValuesPerDriver = dynamicFilterConfig.getLargeMaxDistinctValuesPerDriver();
        this.smallMaxDistinctValuesPerDriver = dynamicFilterConfig.getSmallMaxDistinctValuesPerDriver();
        this.smallPartitionedMaxDistinctValuesPerDriver = dynamicFilterConfig.getSmallPartitionedMaxDistinctValuesPerDriver();
        this.largeMaxSizePerDriver = dynamicFilterConfig.getLargeMaxSizePerDriver();
        this.largePartitionedMaxSizePerDriver = dynamicFilterConfig.getLargePartitionedMaxSizePerDriver();
        this.smallMaxSizePerDriver = dynamicFilterConfig.getSmallMaxSizePerDriver();
        this.smallPartitionedMaxSizePerDriver = dynamicFilterConfig.getSmallPartitionedMaxSizePerDriver();
        this.largeRangeRowLimitPerDriver = dynamicFilterConfig.getLargeRangeRowLimitPerDriver();
        this.largePartitionedRangeRowLimitPerDriver = dynamicFilterConfig.getLargePartitionedRangeRowLimitPerDriver();
        this.smallRangeRowLimitPerDriver = dynamicFilterConfig.getSmallRangeRowLimitPerDriver();
        this.smallPartitionedRangeRowLimitPerDriver = dynamicFilterConfig.getSmallPartitionedRangeRowLimitPerDriver();
        this.largeMaxSizePerOperator = dynamicFilterConfig.getLargeMaxSizePerOperator();
        this.largePartitionedMaxSizePerOperator = dynamicFilterConfig.getLargePartitionedMaxSizePerOperator();
        this.smallMaxSizePerOperator = dynamicFilterConfig.getSmallMaxSizePerOperator();
        this.smallPartitionedMaxSizePerOperator = dynamicFilterConfig.getSmallPartitionedMaxSizePerOperator();
        this.largePartitionedMaxDistinctValuesPerDriver = dynamicFilterConfig.getLargePartitionedMaxDistinctValuesPerDriver();
        this.blockTypeOperators = Objects.requireNonNull(blockTypeOperators, "blockTypeOperators is null");
        this.typeOperators = Objects.requireNonNull(typeOperators, "typeOperators is null");
        this.tableExecuteContextManager = Objects.requireNonNull(tableExecuteContextManager, "tableExecuteContextManager is null");
        this.exchangeManagerRegistry = Objects.requireNonNull(exchangeManagerRegistry, "exchangeManagerRegistry is null");
        this.positionsAppenderFactory = new PositionsAppenderFactory(blockTypeOperators);
        this.version = Objects.requireNonNull(version, "version is null");
        this.specializeAggregationLoops = compilerConfig.isSpecializeAggregationLoops();
    }

    public LocalExecutionPlan plan(TaskContext taskContext, PlanNode plan, PartitioningScheme partitioningScheme, List<PlanNodeId> partitionedSourceOrder, OutputBuffer outputBuffer) {
        PartitionFunction partitionFunction;
        Object partitionChannelTypes;
        Object partitionConstants;
        Object partitionChannels;
        List<Symbol> outputLayout = partitioningScheme.getOutputLayout();
        if (partitioningScheme.getPartitioning().getHandle().equals(SystemPartitioningHandle.FIXED_BROADCAST_DISTRIBUTION) || partitioningScheme.getPartitioning().getHandle().equals(SystemPartitioningHandle.FIXED_ARBITRARY_DISTRIBUTION) || partitioningScheme.getPartitioning().getHandle().equals(SystemPartitioningHandle.SCALED_WRITER_ROUND_ROBIN_DISTRIBUTION) || partitioningScheme.getPartitioning().getHandle().equals(SystemPartitioningHandle.SINGLE_DISTRIBUTION) || partitioningScheme.getPartitioning().getHandle().equals(SystemPartitioningHandle.COORDINATOR_DISTRIBUTION)) {
            return this.plan(taskContext, plan, outputLayout, partitionedSourceOrder, new TaskOutputOperator.TaskOutputFactory(outputBuffer));
        }
        if (partitioningScheme.getHashColumn().isPresent()) {
            partitionChannels = ImmutableList.of((Object)outputLayout.indexOf(partitioningScheme.getHashColumn().get()));
            partitionConstants = ImmutableList.of(Optional.empty());
            partitionChannelTypes = ImmutableList.of((Object)BigintType.BIGINT);
        } else {
            partitionChannels = (List)partitioningScheme.getPartitioning().getArguments().stream().map(argument -> {
                if (argument.isConstant()) {
                    return -1;
                }
                return outputLayout.indexOf(argument.getColumn());
            }).collect(ImmutableList.toImmutableList());
            partitionConstants = (List)partitioningScheme.getPartitioning().getArguments().stream().map(argument -> {
                if (argument.isConstant()) {
                    return Optional.of(argument.getConstant());
                }
                return Optional.empty();
            }).collect(ImmutableList.toImmutableList());
            partitionChannelTypes = (List)partitioningScheme.getPartitioning().getArguments().stream().map(argument -> {
                if (argument.isConstant()) {
                    return argument.getConstant().getType();
                }
                return argument.getColumn().type();
            }).collect(ImmutableList.toImmutableList());
        }
        Optional<SkewedPartitionRebalancer> skewedPartitionRebalancer = Optional.empty();
        int taskCount = SkewedPartitionRebalancer.getTaskCount(partitioningScheme);
        if (SkewedPartitionRebalancer.checkCanScalePartitionsRemotely(taskContext.getSession(), taskCount, partitioningScheme.getPartitioning().getHandle(), this.nodePartitioningManager)) {
            partitionFunction = SkewedPartitionRebalancer.createPartitionFunction(taskContext.getSession(), this.nodePartitioningManager, partitioningScheme, (List<Type>)partitionChannelTypes);
            int partitionedWriterCount = this.getPartitionedWriterCountBasedOnMemory(taskContext.getSession());
            int taskBucketCount = (int)Math.ceil(0.5 * (double)partitionedWriterCount);
            skewedPartitionRebalancer = Optional.of(new SkewedPartitionRebalancer(partitionFunction.partitionCount(), taskCount, taskBucketCount, SystemSessionProperties.getWriterScalingMinDataProcessed(taskContext.getSession()).toBytes(), SystemSessionProperties.getSkewedPartitionMinDataProcessedRebalanceThreshold(taskContext.getSession()).toBytes()));
        } else {
            partitionFunction = this.nodePartitioningManager.getPartitionFunction(taskContext.getSession(), partitioningScheme, (List<Type>)partitionChannelTypes);
        }
        OptionalInt nullChannel = OptionalInt.empty();
        Set<Symbol> partitioningColumns = partitioningScheme.getPartitioning().getColumns();
        Preconditions.checkArgument((!partitioningScheme.isReplicateNullsAndAny() || partitioningColumns.size() <= 1 ? 1 : 0) != 0);
        if (partitioningScheme.isReplicateNullsAndAny() && partitioningColumns.size() == 1) {
            nullChannel = OptionalInt.of(outputLayout.indexOf(Iterables.getOnlyElement(partitioningColumns)));
        }
        return this.plan(taskContext, plan, outputLayout, partitionedSourceOrder, new PartitionedOutputOperator.PartitionedOutputFactory(partitionFunction, (List<Integer>)partitionChannels, (List<Optional<NullableValue>>)partitionConstants, partitioningScheme.isReplicateNullsAndAny(), nullChannel, outputBuffer, this.maxPagePartitioningBufferSize, this.positionsAppenderFactory, taskContext.getSession().getExchangeEncryptionKey(), taskContext.newAggregateMemoryContext(), SystemSessionProperties.getPagePartitioningBufferPoolSize(taskContext.getSession()), skewedPartitionRebalancer));
    }

    public LocalExecutionPlan plan(TaskContext taskContext, PlanNode plan, List<Symbol> outputLayout, List<PlanNodeId> partitionedSourceOrder, OutputFactory outputOperatorFactory) {
        Session session = taskContext.getSession();
        LocalExecutionPlanContext context = new LocalExecutionPlanContext(taskContext);
        PhysicalOperation physicalOperation = plan.accept(new Visitor(session), context);
        Function<Page, Page> pagePreprocessor = LocalExecutionPlanner.enforceLoadedLayoutProcessor(outputLayout, physicalOperation.getLayout());
        List outputTypes = (List)outputLayout.stream().map(Symbol::type).collect(ImmutableList.toImmutableList());
        context.addDriverFactory(true, new PhysicalOperation(outputOperatorFactory.createOutputOperator(context.getNextOperatorId(), plan.getId(), outputTypes, pagePreprocessor, new PagesSerdeFactory(this.plannerContext.getBlockEncodingSerde(), SystemSessionProperties.getExchangeCompressionCodec(session))), physicalOperation), context);
        context.getDriverFactories().stream().map(DriverFactory::getOperatorFactories).flatMap(Collection::stream).filter(LocalPlannerAware.class::isInstance).map(LocalPlannerAware.class::cast).forEach(LocalPlannerAware::localPlannerComplete);
        return new LocalExecutionPlan(context.getDriverFactories(), partitionedSourceOrder);
    }

    private int getPartitionedWriterCountBasedOnMemory(Session session) {
        return this.getPartitionedWriterCountBasedOnMemory(SystemSessionProperties.getTaskMaxWriterCount(session), session);
    }

    private int getPartitionedWriterCountBasedOnMemory(int partitionedWriterCount, Session session) {
        return Math.min(partitionedWriterCount, MoreMath.previousPowerOfTwo(SkewedPartitionRebalancer.getMaxWritersBasedOnMemory(session)));
    }

    private static Optional<PartialAggregationController> createPartialAggregationController(Optional<DataSize> maxPartialAggregationMemorySize, AggregationNode.Step step, Session session) {
        return maxPartialAggregationMemorySize.isPresent() && step.isOutputPartial() && SystemSessionProperties.isAdaptivePartialAggregationEnabled(session) ? Optional.of(new PartialAggregationController(maxPartialAggregationMemorySize.get(), SystemSessionProperties.getAdaptivePartialAggregationUniqueRowsRatioThreshold(session))) : Optional.empty();
    }

    private int getDynamicFilteringMaxDistinctValuesPerDriver(Session session, boolean partitioned) {
        if (SystemSessionProperties.isEnableLargeDynamicFilters(session)) {
            if (partitioned) {
                return this.largePartitionedMaxDistinctValuesPerDriver;
            }
            return this.largeMaxDistinctValuesPerDriver;
        }
        if (partitioned) {
            return this.smallPartitionedMaxDistinctValuesPerDriver;
        }
        return this.smallMaxDistinctValuesPerDriver;
    }

    private DataSize getDynamicFilteringMaxSizePerDriver(Session session, boolean partitioned) {
        if (SystemSessionProperties.isEnableLargeDynamicFilters(session)) {
            if (partitioned) {
                return this.largePartitionedMaxSizePerDriver;
            }
            return this.largeMaxSizePerDriver;
        }
        if (partitioned) {
            return this.smallPartitionedMaxSizePerDriver;
        }
        return this.smallMaxSizePerDriver;
    }

    private int getDynamicFilteringRangeRowLimitPerDriver(Session session, boolean partitioned) {
        if (SystemSessionProperties.isEnableLargeDynamicFilters(session)) {
            if (partitioned) {
                return this.largePartitionedRangeRowLimitPerDriver;
            }
            return this.largeRangeRowLimitPerDriver;
        }
        if (partitioned) {
            return this.smallPartitionedRangeRowLimitPerDriver;
        }
        return this.smallRangeRowLimitPerDriver;
    }

    private DataSize getDynamicFilteringMaxSizePerOperator(Session session, boolean partitioned) {
        if (SystemSessionProperties.isEnableLargeDynamicFilters(session)) {
            if (partitioned) {
                return this.largePartitionedMaxSizePerOperator;
            }
            return this.largeMaxSizePerOperator;
        }
        if (partitioned) {
            return this.smallPartitionedMaxSizePerOperator;
        }
        return this.smallMaxSizePerOperator;
    }

    private static List<Type> getTypes(List<Expression> expressions) {
        return (List)expressions.stream().map(Expression::type).collect(ImmutableList.toImmutableList());
    }

    private static TableFinishOperator.TableFinisher createTableFinisher(Session session, TableFinishNode node, Metadata metadata) {
        TableWriterNode.WriterTarget target = node.getTarget();
        return (fragments, statistics, tableExecuteContext) -> {
            if (target instanceof TableWriterNode.CreateTarget) {
                return metadata.finishCreateTable(session, ((TableWriterNode.CreateTarget)target).getHandle(), fragments, statistics);
            }
            if (target instanceof TableWriterNode.InsertTarget) {
                TableWriterNode.InsertTarget insertTarget = (TableWriterNode.InsertTarget)target;
                return metadata.finishInsert(session, insertTarget.getHandle(), insertTarget.getSourceTableHandles(), fragments, statistics);
            }
            if (target instanceof TableWriterNode.RefreshMaterializedViewTarget) {
                TableWriterNode.RefreshMaterializedViewTarget refreshTarget = (TableWriterNode.RefreshMaterializedViewTarget)target;
                return metadata.finishRefreshMaterializedView(session, refreshTarget.getTableHandle(), refreshTarget.getInsertHandle(), fragments, statistics, refreshTarget.getSourceTableHandles(), refreshTarget.getSourceTableFunctions());
            }
            if (target instanceof TableWriterNode.TableExecuteTarget) {
                TableExecuteHandle tableExecuteHandle = ((TableWriterNode.TableExecuteTarget)target).getExecuteHandle();
                metadata.finishTableExecute(session, tableExecuteHandle, fragments, tableExecuteContext.getSplitsInfo());
                return Optional.empty();
            }
            if (target instanceof TableWriterNode.MergeTarget) {
                TableWriterNode.MergeTarget mergeTarget = (TableWriterNode.MergeTarget)target;
                MergeHandle mergeHandle = mergeTarget.getMergeHandle().orElseThrow(() -> new IllegalArgumentException("mergeHandle not present"));
                metadata.finishMerge(session, mergeHandle, fragments, statistics);
                return Optional.empty();
            }
            throw new AssertionError((Object)("Unhandled target type: " + target.getClass().getName()));
        };
    }

    private static boolean shouldOutputRowCount(TableFinishNode node) {
        TableWriterNode.WriterTarget target = node.getTarget();
        return !(target instanceof TableWriterNode.TableExecuteTarget);
    }

    private static Function<Page, Page> enforceLoadedLayoutProcessor(List<Symbol> expectedLayout, Map<Symbol, Integer> inputLayout) {
        int[] channels = expectedLayout.stream().peek(symbol -> Preconditions.checkArgument((boolean)inputLayout.containsKey(symbol), (String)"channel not found for symbol: %s", (Object)symbol)).mapToInt(inputLayout::get).toArray();
        if (Arrays.equals(channels, IntStream.range(0, inputLayout.size()).toArray())) {
            return PageChannelSelector.identitySelection();
        }
        return new PageChannelSelector(channels);
    }

    private static List<Integer> getChannelsForSymbols(List<Symbol> symbols, Map<Symbol, Integer> layout) {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (Symbol symbol : symbols) {
            builder.add((Object)layout.get(symbol));
        }
        return builder.build();
    }

    private static Function<Symbol, Integer> channelGetter(PhysicalOperation source) {
        return input -> {
            Preconditions.checkArgument((boolean)source.getLayout().containsKey(input));
            return source.getLayout().get(input);
        };
    }

    private static Set<DynamicFilterId> getConsumedDynamicFilterIds(PlanNode node) {
        return (Set)ExpressionExtractor.extractExpressions(node).stream().flatMap(expression -> DynamicFilters.extractDynamicFilters(expression).getDynamicConjuncts().stream()).map(DynamicFilters.Descriptor::getId).collect(ImmutableSet.toImmutableSet());
    }

    private boolean useSpillingJoinOperator(boolean spillEnabled, Session session) {
        return spillEnabled || SystemSessionProperties.isForceSpillingOperator(session);
    }

    public static class LocalExecutionPlan {
        private final List<DriverFactory> driverFactories;
        private final List<PlanNodeId> partitionedSourceOrder;

        public LocalExecutionPlan(List<DriverFactory> driverFactories, List<PlanNodeId> partitionedSourceOrder) {
            this.driverFactories = ImmutableList.copyOf((Collection)Objects.requireNonNull(driverFactories, "driverFactories is null"));
            this.partitionedSourceOrder = ImmutableList.copyOf((Collection)Objects.requireNonNull(partitionedSourceOrder, "partitionedSourceOrder is null"));
        }

        public List<DriverFactory> getDriverFactories() {
            return this.driverFactories;
        }

        public List<PlanNodeId> getPartitionedSourceOrder() {
            return this.partitionedSourceOrder;
        }
    }

    private static class LocalExecutionPlanContext {
        private final TaskContext taskContext;
        private final List<DriverFactory> driverFactories;
        private final Optional<IndexSourceContext> indexSourceContext;
        private final AtomicInteger nextPipelineId;
        private int nextOperatorId;
        private boolean inputDriver = true;
        private OptionalInt driverInstanceCount = OptionalInt.empty();

        public LocalExecutionPlanContext(TaskContext taskContext) {
            this(taskContext, new ArrayList<DriverFactory>(), Optional.empty(), new AtomicInteger(0));
        }

        private LocalExecutionPlanContext(TaskContext taskContext, List<DriverFactory> driverFactories, Optional<IndexSourceContext> indexSourceContext, AtomicInteger nextPipelineId) {
            this.taskContext = taskContext;
            this.driverFactories = driverFactories;
            this.indexSourceContext = indexSourceContext;
            this.nextPipelineId = nextPipelineId;
        }

        public void addDriverFactory(boolean outputDriver, PhysicalOperation physicalOperation, LocalExecutionPlanContext context) {
            boolean inputDriver = context.isInputDriver();
            OptionalInt driverInstances = context.getDriverInstanceCount();
            List<OperatorFactory> operatorFactories = physicalOperation.getOperatorFactories();
            this.addLookupOuterDrivers(outputDriver, operatorFactories);
            this.addDriverFactory(inputDriver, outputDriver, operatorFactories, driverInstances);
        }

        private void addLookupOuterDrivers(boolean isOutputDriver, List<OperatorFactory> operatorFactories) {
            for (int i = 0; i < operatorFactories.size(); ++i) {
                JoinOperatorFactory lookupJoin;
                Optional<OperatorFactory> outerOperatorFactoryResult;
                OperatorFactory operatorFactory = operatorFactories.get(i);
                if (!(operatorFactory instanceof JoinOperatorFactory) || !(outerOperatorFactoryResult = (lookupJoin = (JoinOperatorFactory)operatorFactory).createOuterOperatorFactory()).isPresent()) continue;
                ImmutableList.Builder newOperators = ImmutableList.builder();
                newOperators.add((Object)outerOperatorFactoryResult.get());
                operatorFactories.subList(i + 1, operatorFactories.size()).stream().map(OperatorFactory::duplicate).forEach(arg_0 -> ((ImmutableList.Builder)newOperators).add(arg_0));
                this.addDriverFactory(false, isOutputDriver, (List<OperatorFactory>)newOperators.build(), OptionalInt.of(1));
            }
        }

        private void addDriverFactory(boolean inputDriver, boolean outputDriver, List<OperatorFactory> operatorFactories, OptionalInt driverInstances) {
            this.driverFactories.add(new DriverFactory(this.getNextPipelineId(), inputDriver, outputDriver, operatorFactories, driverInstances));
        }

        private List<DriverFactory> getDriverFactories() {
            return ImmutableList.copyOf(this.driverFactories);
        }

        public StageId getStageId() {
            return this.taskContext.getTaskId().getStageId();
        }

        public TaskId getTaskId() {
            return this.taskContext.getTaskId();
        }

        public LocalDynamicFiltersCollector getDynamicFiltersCollector() {
            return this.taskContext.getLocalDynamicFiltersCollector();
        }

        private void registerCoordinatorDynamicFilters(List<DynamicFilters.Descriptor> dynamicFilters) {
            if (!SystemSessionProperties.isEnableCoordinatorDynamicFiltersDistribution(this.taskContext.getSession())) {
                return;
            }
            Set consumedFilterIds = (Set)dynamicFilters.stream().map(DynamicFilters.Descriptor::getId).collect(ImmutableSet.toImmutableSet());
            LocalDynamicFiltersCollector dynamicFiltersCollector = this.getDynamicFiltersCollector();
            dynamicFiltersCollector.register((Set<DynamicFilterId>)Sets.difference((Set)consumedFilterIds, dynamicFiltersCollector.getRegisteredDynamicFilterIds()));
        }

        private TaskContext getTaskContext() {
            return this.taskContext;
        }

        public Optional<IndexSourceContext> getIndexSourceContext() {
            return this.indexSourceContext;
        }

        private int getNextPipelineId() {
            return this.nextPipelineId.getAndIncrement();
        }

        private int getNextOperatorId() {
            return this.nextOperatorId++;
        }

        private boolean isInputDriver() {
            return this.inputDriver;
        }

        private void setInputDriver(boolean inputDriver) {
            this.inputDriver = inputDriver;
        }

        public LocalExecutionPlanContext createSubContext() {
            Preconditions.checkState((boolean)this.indexSourceContext.isEmpty(), (Object)"index build plan cannot have sub-contexts");
            return new LocalExecutionPlanContext(this.taskContext, this.driverFactories, this.indexSourceContext, this.nextPipelineId);
        }

        public LocalExecutionPlanContext createIndexSourceSubContext(IndexSourceContext indexSourceContext) {
            return new LocalExecutionPlanContext(this.taskContext, this.driverFactories, Optional.of(indexSourceContext), this.nextPipelineId);
        }

        public OptionalInt getDriverInstanceCount() {
            return this.driverInstanceCount;
        }

        public void setDriverInstanceCount(int driverInstanceCount) {
            Preconditions.checkArgument((driverInstanceCount > 0 ? 1 : 0) != 0, (Object)"driverInstanceCount must be > 0");
            if (this.driverInstanceCount.isPresent()) {
                Preconditions.checkState((this.driverInstanceCount.getAsInt() == driverInstanceCount ? 1 : 0) != 0, (Object)("driverInstance count already set to " + this.driverInstanceCount.getAsInt()));
            }
            this.driverInstanceCount = OptionalInt.of(driverInstanceCount);
        }
    }

    private class Visitor
    extends PlanVisitor<PhysicalOperation, LocalExecutionPlanContext> {
        private final Session session;

        private Visitor(Session session) {
            this.session = session;
        }

        @Override
        public PhysicalOperation visitRemoteSource(RemoteSourceNode node, LocalExecutionPlanContext context) {
            if (node.getOrderingScheme().isPresent()) {
                return this.createMergeSource(node, context);
            }
            return this.createRemoteSource(node, context);
        }

        private PhysicalOperation createMergeSource(RemoteSourceNode node, LocalExecutionPlanContext context) {
            Preconditions.checkArgument((boolean)node.getOrderingScheme().isPresent(), (Object)"orderingScheme is absent");
            Preconditions.checkArgument((node.getRetryPolicy() == RetryPolicy.NONE ? 1 : 0) != 0, (String)"unexpected retry policy: %s", (Object)((Object)node.getRetryPolicy()));
            context.setDriverInstanceCount(1);
            OrderingScheme orderingScheme = node.getOrderingScheme().get();
            ImmutableMap<Symbol, Integer> layout = this.makeLayout(node);
            List<Integer> sortChannels = LocalExecutionPlanner.getChannelsForSymbols(orderingScheme.orderBy(), layout);
            List<SortOrder> sortOrder = orderingScheme.orderingList();
            List<Type> types = this.getSourceOperatorTypes(node);
            ImmutableList outputChannels = (ImmutableList)IntStream.range(0, types.size()).boxed().collect(ImmutableList.toImmutableList());
            MergeOperator.MergeOperatorFactory operatorFactory = new MergeOperator.MergeOperatorFactory(context.getNextOperatorId(), node.getId(), LocalExecutionPlanner.this.directExchangeClientSupplier, new PagesSerdeFactory(LocalExecutionPlanner.this.plannerContext.getBlockEncodingSerde(), SystemSessionProperties.getExchangeCompressionCodec(this.session)), LocalExecutionPlanner.this.orderingCompiler, types, (List<Integer>)outputChannels, sortChannels, sortOrder);
            return new PhysicalOperation((OperatorFactory)operatorFactory, (Map<Symbol, Integer>)this.makeLayout(node));
        }

        private PhysicalOperation createRemoteSource(RemoteSourceNode node, LocalExecutionPlanContext context) {
            if (context.getDriverInstanceCount().isEmpty()) {
                context.setDriverInstanceCount(SystemSessionProperties.getTaskConcurrency(this.session));
            }
            ExchangeOperator.ExchangeOperatorFactory operatorFactory = new ExchangeOperator.ExchangeOperatorFactory(context.getNextOperatorId(), node.getId(), LocalExecutionPlanner.this.directExchangeClientSupplier, new PagesSerdeFactory(LocalExecutionPlanner.this.plannerContext.getBlockEncodingSerde(), SystemSessionProperties.getExchangeCompressionCodec(this.session)), node.getRetryPolicy(), LocalExecutionPlanner.this.exchangeManagerRegistry);
            return new PhysicalOperation((OperatorFactory)operatorFactory, (Map<Symbol, Integer>)this.makeLayout(node));
        }

        @Override
        public PhysicalOperation visitExplainAnalyze(ExplainAnalyzeNode node, LocalExecutionPlanContext context) {
            ExplainAnalyzeContext analyzeContext = LocalExecutionPlanner.this.explainAnalyzeContext.orElseThrow(() -> new IllegalStateException("ExplainAnalyze can only run on coordinator"));
            PhysicalOperation source = node.getSource().accept(this, context);
            ExplainAnalyzeOperator.ExplainAnalyzeOperatorFactory operatorFactory = new ExplainAnalyzeOperator.ExplainAnalyzeOperatorFactory(context.getNextOperatorId(), node.getId(), analyzeContext.getQueryPerformanceFetcher(), LocalExecutionPlanner.this.metadata, LocalExecutionPlanner.this.plannerContext.getFunctionManager(), node.isVerbose(), LocalExecutionPlanner.this.version);
            return new PhysicalOperation((OperatorFactory)operatorFactory, (Map<Symbol, Integer>)this.makeLayout(node), source);
        }

        @Override
        public PhysicalOperation visitOutput(OutputNode node, LocalExecutionPlanContext context) {
            return node.getSource().accept(this, context);
        }

        @Override
        public PhysicalOperation visitRowNumber(RowNumberNode node, LocalExecutionPlanContext context) {
            PhysicalOperation source = node.getSource().accept(this, context);
            List<Symbol> partitionBySymbols = node.getPartitionBy();
            List<Integer> partitionChannels = LocalExecutionPlanner.getChannelsForSymbols(partitionBySymbols, source.getLayout());
            List partitionTypes = (List)partitionChannels.stream().map(channel -> source.getTypes().get((int)channel)).collect(ImmutableList.toImmutableList());
            ImmutableList.Builder outputChannels = ImmutableList.builder();
            for (int i = 0; i < source.getTypes().size(); ++i) {
                outputChannels.add((Object)i);
            }
            ImmutableMap.Builder outputMappings = ImmutableMap.builder();
            outputMappings.putAll(source.getLayout());
            int channel2 = source.getTypes().size();
            outputMappings.put((Object)node.getRowNumberSymbol(), (Object)channel2);
            Optional<Integer> hashChannel = node.getHashSymbol().map(LocalExecutionPlanner.channelGetter(source));
            RowNumberOperator.RowNumberOperatorFactory operatorFactory = new RowNumberOperator.RowNumberOperatorFactory(context.getNextOperatorId(), node.getId(), source.getTypes(), (List<Integer>)outputChannels.build(), partitionChannels, partitionTypes, node.getMaxRowCountPerPartition(), hashChannel, 10000, LocalExecutionPlanner.this.hashStrategyCompiler);
            return new PhysicalOperation((OperatorFactory)operatorFactory, (Map<Symbol, Integer>)outputMappings.buildOrThrow(), source);
        }

        @Override
        public PhysicalOperation visitTopNRanking(TopNRankingNode node, LocalExecutionPlanContext context) {
            PhysicalOperation source = node.getSource().accept(this, context);
            List<Symbol> partitionBySymbols = node.getPartitionBy();
            List<Integer> partitionChannels = LocalExecutionPlanner.getChannelsForSymbols(partitionBySymbols, source.getLayout());
            List partitionTypes = (List)partitionChannels.stream().map(channel -> source.getTypes().get((int)channel)).collect(ImmutableList.toImmutableList());
            List<Symbol> orderBySymbols = node.getOrderingScheme().orderBy();
            List<Integer> sortChannels = LocalExecutionPlanner.getChannelsForSymbols(orderBySymbols, source.getLayout());
            List sortOrder = (List)orderBySymbols.stream().map(symbol -> node.getOrderingScheme().ordering((Symbol)symbol)).collect(ImmutableList.toImmutableList());
            ImmutableList.Builder outputChannels = ImmutableList.builder();
            for (int i = 0; i < source.getTypes().size(); ++i) {
                outputChannels.add((Object)i);
            }
            ImmutableMap.Builder outputMappings = ImmutableMap.builder();
            outputMappings.putAll(source.getLayout());
            if (!node.isPartial() || !partitionChannels.isEmpty()) {
                int channel2 = source.getTypes().size();
                outputMappings.put((Object)node.getRankingSymbol(), (Object)channel2);
            }
            Optional<Integer> hashChannel = node.getHashSymbol().map(LocalExecutionPlanner.channelGetter(source));
            boolean isPartial = node.isPartial();
            Optional<DataSize> maxPartialTopNMemorySize = isPartial ? Optional.of(SystemSessionProperties.getMaxPartialTopNMemory(this.session)).filter(maxSize -> maxSize.compareTo(DataSize.ofBytes((long)0L)) > 0) : Optional.empty();
            TopNRankingOperator.TopNRankingOperatorFactory operatorFactory = new TopNRankingOperator.TopNRankingOperatorFactory(context.getNextOperatorId(), node.getId(), node.getRankingType(), source.getTypes(), (List<Integer>)outputChannels.build(), partitionChannels, partitionTypes, sortChannels, sortOrder, node.getMaxRankingPerPartition(), isPartial, hashChannel, 1000, maxPartialTopNMemorySize, LocalExecutionPlanner.this.hashStrategyCompiler, LocalExecutionPlanner.this.plannerContext.getTypeOperators(), LocalExecutionPlanner.this.blockTypeOperators);
            return new PhysicalOperation((OperatorFactory)operatorFactory, (Map<Symbol, Integer>)this.makeLayout(node), source);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public PhysicalOperation visitWindow(WindowNode node, LocalExecutionPlanContext context) {
            PhysicalOperation source = node.getSource().accept(this, context);
            List<Symbol> partitionBySymbols = node.getPartitionBy();
            ImmutableList partitionChannels = ImmutableList.copyOf(LocalExecutionPlanner.getChannelsForSymbols(partitionBySymbols, source.getLayout()));
            ImmutableList preGroupedChannels = ImmutableList.copyOf(LocalExecutionPlanner.getChannelsForSymbols((List<Symbol>)ImmutableList.copyOf(node.getPrePartitionedInputs()), source.getLayout()));
            Object sortChannels = ImmutableList.of();
            Object sortOrder = ImmutableList.of();
            if (node.getOrderingScheme().isPresent()) {
                OrderingScheme orderingScheme = node.getOrderingScheme().get();
                sortChannels = LocalExecutionPlanner.getChannelsForSymbols(orderingScheme.orderBy(), source.getLayout());
                sortOrder = orderingScheme.orderingList();
            }
            ImmutableList.Builder outputChannels = ImmutableList.builder();
            for (int i = 0; i < source.getTypes().size(); ++i) {
                outputChannels.add((Object)i);
            }
            ImmutableList.Builder windowFunctionsBuilder = ImmutableList.builder();
            ImmutableList.Builder windowFunctionOutputSymbolsBuilder = ImmutableList.builder();
            for (Map.Entry<Symbol, WindowNode.Function> entry : node.getWindowFunctions().entrySet()) {
                void var15_17;
                Optional<Integer> frameStartChannel = Optional.empty();
                Optional optional = Optional.empty();
                Optional<Integer> frameEndChannel = Optional.empty();
                Optional<Integer> sortKeyChannelForEndComparison = Optional.empty();
                Optional<Integer> sortKeyChannel = Optional.empty();
                Optional<FrameInfo.Ordering> ordering = Optional.empty();
                WindowNode.Frame frame = entry.getValue().getFrame();
                if (frame.getStartValue().isPresent()) {
                    frameStartChannel = Optional.of(source.getLayout().get(frame.getStartValue().get()));
                }
                if (frame.getSortKeyCoercedForFrameStartComparison().isPresent()) {
                    Optional<Integer> optional2 = Optional.of(source.getLayout().get(frame.getSortKeyCoercedForFrameStartComparison().get()));
                }
                if (frame.getEndValue().isPresent()) {
                    frameEndChannel = Optional.of(source.getLayout().get(frame.getEndValue().get()));
                }
                if (frame.getSortKeyCoercedForFrameEndComparison().isPresent()) {
                    sortKeyChannelForEndComparison = Optional.of(source.getLayout().get(frame.getSortKeyCoercedForFrameEndComparison().get()));
                }
                if (node.getOrderingScheme().isPresent()) {
                    sortKeyChannel = Optional.of((Integer)sortChannels.get(0));
                    ordering = Optional.of(((SortOrder)sortOrder.get(0)).isAscending() ? FrameInfo.Ordering.ASCENDING : FrameInfo.Ordering.DESCENDING);
                }
                FrameInfo frameInfo = new FrameInfo(frame.getType(), frame.getStartType(), frameStartChannel, (Optional<Integer>)var15_17, frame.getEndType(), frameEndChannel, sortKeyChannelForEndComparison, sortKeyChannel, ordering);
                WindowNode.Function function = entry.getValue();
                ResolvedFunction resolvedFunction = function.getResolvedFunction();
                ImmutableList.Builder arguments = ImmutableList.builder();
                for (Expression argument : function.getArguments()) {
                    if (argument instanceof Lambda) continue;
                    Symbol argumentSymbol = Symbol.from(argument);
                    arguments.add((Object)source.getLayout().get(argumentSymbol));
                }
                Symbol symbol = entry.getKey();
                WindowFunctionSupplier windowFunctionSupplier = this.getWindowFunctionImplementation(resolvedFunction);
                Type type = resolvedFunction.signature().getReturnType();
                List lambdas = (List)function.getArguments().stream().filter(Lambda.class::isInstance).map(Lambda.class::cast).collect(ImmutableList.toImmutableList());
                List functionTypes = (List)resolvedFunction.signature().getArgumentTypes().stream().filter(FunctionType.class::isInstance).map(FunctionType.class::cast).collect(ImmutableList.toImmutableList());
                List<Supplier<Object>> lambdaProviders = this.makeLambdaProviders(lambdas, windowFunctionSupplier.getLambdaInterfaces(), functionTypes);
                windowFunctionsBuilder.add((Object)WindowFunctionDefinition.window(windowFunctionSupplier, type, frameInfo, function.isIgnoreNulls(), lambdaProviders, (List<Integer>)arguments.build()));
                windowFunctionOutputSymbolsBuilder.add((Object)symbol);
            }
            ImmutableList windowFunctionOutputSymbols = windowFunctionOutputSymbolsBuilder.build();
            ImmutableMap.Builder outputMappings = ImmutableMap.builder();
            for (Symbol symbol : node.getSource().getOutputSymbols()) {
                outputMappings.put((Object)symbol, (Object)source.getLayout().get(symbol));
            }
            int channel = source.getTypes().size();
            for (Symbol symbol : windowFunctionOutputSymbols) {
                outputMappings.put((Object)symbol, (Object)channel);
                ++channel;
            }
            WindowOperator.WindowOperatorFactory windowOperatorFactory = new WindowOperator.WindowOperatorFactory(context.getNextOperatorId(), node.getId(), source.getTypes(), (List<Integer>)outputChannels.build(), (List<WindowFunctionDefinition>)windowFunctionsBuilder.build(), (List<Integer>)partitionChannels, (List<Integer>)preGroupedChannels, (List<Integer>)sortChannels, (List<SortOrder>)sortOrder, node.getPreSortedOrderPrefix(), 10000, LocalExecutionPlanner.this.pagesIndexFactory, SystemSessionProperties.isSpillEnabled(this.session), LocalExecutionPlanner.this.spillerFactory, LocalExecutionPlanner.this.orderingCompiler, (List<Type>)ImmutableList.of(), new RegularPartitionerSupplier());
            return new PhysicalOperation((OperatorFactory)windowOperatorFactory, (Map<Symbol, Integer>)outputMappings.buildOrThrow(), source);
        }

        private WindowFunctionSupplier getWindowFunctionImplementation(ResolvedFunction resolvedFunction) {
            if (resolvedFunction.functionKind() == FunctionKind.AGGREGATE) {
                return (WindowFunctionSupplier)CacheUtils.uncheckedCacheGet(LocalExecutionPlanner.this.aggregationWindowFunctionSupplierCache, (Object)new FunctionKey(resolvedFunction.functionId(), resolvedFunction.signature()), () -> {
                    AggregationImplementation aggregationImplementation = LocalExecutionPlanner.this.plannerContext.getFunctionManager().getAggregationImplementation(resolvedFunction);
                    return new AggregationWindowFunctionSupplier(resolvedFunction.signature(), aggregationImplementation, resolvedFunction.functionNullability());
                });
            }
            return LocalExecutionPlanner.this.plannerContext.getFunctionManager().getWindowFunctionSupplier(resolvedFunction);
        }

        @Override
        public PhysicalOperation visitPatternRecognition(PatternRecognitionNode node, LocalExecutionPlanContext context) {
            int nextOutputChannel;
            PhysicalOperation source = node.getSource().accept(this, context);
            List<Symbol> partitionBySymbols = node.getPartitionBy();
            ImmutableList partitionChannels = ImmutableList.copyOf(LocalExecutionPlanner.getChannelsForSymbols(partitionBySymbols, source.getLayout()));
            ImmutableList preGroupedChannels = ImmutableList.copyOf(LocalExecutionPlanner.getChannelsForSymbols((List<Symbol>)ImmutableList.copyOf(node.getPrePartitionedInputs()), source.getLayout()));
            Object sortChannels = ImmutableList.of();
            Object sortOrder = ImmutableList.of();
            if (node.getOrderingScheme().isPresent()) {
                OrderingScheme orderingScheme = node.getOrderingScheme().get();
                sortChannels = LocalExecutionPlanner.getChannelsForSymbols(orderingScheme.orderBy(), source.getLayout());
                sortOrder = orderingScheme.orderingList();
            }
            ImmutableList.Builder outputChannels = ImmutableList.builder();
            ImmutableMap.Builder outputMappings = ImmutableMap.builder();
            if (node.getRowsPerMatch() == RowsPerMatch.ONE) {
                outputChannels.addAll((Iterable)partitionChannels);
                nextOutputChannel = partitionBySymbols.size();
                for (int i = 0; i < partitionBySymbols.size(); ++i) {
                    outputMappings.put((Object)partitionBySymbols.get(i), (Object)i);
                }
            } else {
                outputChannels.addAll((Iterable)IntStream.range(0, source.getTypes().size()).boxed().collect(ImmutableList.toImmutableList()));
                nextOutputChannel = source.getTypes().size();
                outputMappings.putAll(source.getLayout());
            }
            for (Map.Entry<Symbol, PatternRecognitionNode.Measure> entry : node.getMeasures().entrySet()) {
                outputMappings.put((Object)entry.getKey(), (Object)nextOutputChannel);
                ++nextOutputChannel;
            }
            ImmutableList.Builder windowFunctionsBuilder = ImmutableList.builder();
            for (Map.Entry<Symbol, WindowNode.Function> entry : node.getWindowFunctions().entrySet()) {
                outputMappings.put((Object)entry.getKey(), (Object)nextOutputChannel);
                ++nextOutputChannel;
                WindowNode.Function function = entry.getValue();
                ResolvedFunction resolvedFunction = function.getResolvedFunction();
                ImmutableList.Builder arguments = ImmutableList.builder();
                for (Expression argument : function.getArguments()) {
                    if (argument instanceof Lambda) continue;
                    Symbol argumentSymbol = Symbol.from(argument);
                    arguments.add((Object)source.getLayout().get(argumentSymbol));
                }
                WindowFunctionSupplier windowFunctionSupplier = this.getWindowFunctionImplementation(resolvedFunction);
                Type type = resolvedFunction.signature().getReturnType();
                List lambdas = (List)function.getArguments().stream().filter(Lambda.class::isInstance).map(Lambda.class::cast).collect(ImmutableList.toImmutableList());
                List functionTypes = (List)resolvedFunction.signature().getArgumentTypes().stream().filter(FunctionType.class::isInstance).map(FunctionType.class::cast).collect(ImmutableList.toImmutableList());
                List<Supplier<Object>> lambdaProviders = this.makeLambdaProviders(lambdas, windowFunctionSupplier.getLambdaInterfaces(), functionTypes);
                windowFunctionsBuilder.add((Object)WindowFunctionDefinition.window(windowFunctionSupplier, type, function.isIgnoreNulls(), lambdaProviders, (List<Integer>)arguments.build()));
            }
            ImmutableList immutableList = ImmutableList.copyOf(node.getVariableDefinitions().keySet());
            ImmutableList.Builder builder = ImmutableList.builder();
            ImmutableMap.Builder mappingBuilder = ImmutableMap.builder();
            for (int i = 0; i < immutableList.size(); ++i) {
                IrLabel label = (IrLabel)immutableList.get(i);
                builder.add((Object)label.getName());
                mappingBuilder.put((Object)label, (Object)i);
            }
            ImmutableMap mapping = mappingBuilder.buildOrThrow();
            ImmutableList labelNames = builder.build();
            Program program = IrRowPatternToProgramRewriter.rewrite(node.getPattern(), (Map<IrLabel, Integer>)mapping);
            Optional<FrameInfo> frame = node.getCommonBaseFrame().map(baseFrame -> {
                Preconditions.checkArgument((baseFrame.getType() == WindowFrameType.ROWS && baseFrame.getStartType() == FrameBoundType.CURRENT_ROW ? 1 : 0) != 0, (Object)"invalid base frame");
                return new FrameInfo(baseFrame.getType(), baseFrame.getStartType(), Optional.empty(), Optional.empty(), baseFrame.getEndType(), baseFrame.getEndValue().map(source.getLayout()::get), Optional.empty(), Optional.empty(), Optional.empty());
            });
            ConnectorSession connectorSession = this.session.toConnectorSession();
            int matchAggregationIndex = 0;
            ImmutableList.Builder labelEvaluationsAggregations = ImmutableList.builder();
            int firstUnusedChannel = source.getLayout().values().stream().mapToInt(Integer::intValue).max().orElse(-1) + 1;
            ImmutableList.Builder labelEvaluationsAggregationArguments = ImmutableList.builder();
            ImmutableList.Builder evaluationsValuePointers = ImmutableList.builder();
            ImmutableList.Builder aggregationsLabelDependencies = ImmutableList.builder();
            ImmutableList.Builder evaluationsBuilder = ImmutableList.builder();
            for (ExpressionAndValuePointers expressionAndValuePointers : node.getVariableDefinitions().values()) {
                Supplier<PageProjection> pageProjectionSupplier = this.prepareProjection(expressionAndValuePointers);
                ValueAccessors valueAccessors = this.preparePhysicalValuePointers(expressionAndValuePointers, (Map<IrLabel, Integer>)mapping, source, connectorSession, firstUnusedChannel, matchAggregationIndex);
                firstUnusedChannel = valueAccessors.getFirstUnusedChannel();
                matchAggregationIndex = valueAccessors.getAggregationIndex();
                labelEvaluationsAggregations.addAll(valueAccessors.getAggregations());
                labelEvaluationsAggregationArguments.addAll(valueAccessors.getAggregationArguments());
                aggregationsLabelDependencies.addAll(valueAccessors.getLabelDependencies());
                evaluationsValuePointers.add(valueAccessors.getValueAccessors());
                evaluationsBuilder.add((Object)new LabelEvaluator.EvaluationSupplier(pageProjectionSupplier, valueAccessors.getValueAccessors(), (List<String>)labelNames, connectorSession));
            }
            ImmutableList labelEvaluations = evaluationsBuilder.build();
            matchAggregationIndex = 0;
            ImmutableList.Builder measureComputationsAggregations = ImmutableList.builder();
            firstUnusedChannel = source.getLayout().values().stream().mapToInt(Integer::intValue).max().orElse(-1) + 1;
            ImmutableList.Builder measureComputationsAggregationArguments = ImmutableList.builder();
            ImmutableList.Builder measuresBuilder = ImmutableList.builder();
            for (PatternRecognitionNode.Measure measure : node.getMeasures().values()) {
                ExpressionAndValuePointers expressionAndValuePointers = measure.getExpressionAndValuePointers();
                Supplier<PageProjection> pageProjectionSupplier = this.prepareProjection(expressionAndValuePointers);
                ValueAccessors valueAccessors = this.preparePhysicalValuePointers(expressionAndValuePointers, (Map<IrLabel, Integer>)mapping, source, connectorSession, firstUnusedChannel, matchAggregationIndex);
                firstUnusedChannel = valueAccessors.getFirstUnusedChannel();
                matchAggregationIndex = valueAccessors.getAggregationIndex();
                measureComputationsAggregations.addAll(valueAccessors.getAggregations());
                measureComputationsAggregationArguments.addAll(valueAccessors.getAggregationArguments());
                measuresBuilder.add((Object)new MeasureComputation.MeasureComputationSupplier(pageProjectionSupplier, valueAccessors.getValueAccessors(), measure.getType(), (List<String>)labelNames, connectorSession));
            }
            ImmutableList measureComputations = measuresBuilder.build();
            Optional<LogicalIndexNavigation> skipToNavigation = Optional.empty();
            if (!node.getSkipToLabels().isEmpty()) {
                boolean last = node.getSkipToPosition().equals((Object)SkipToPosition.LAST);
                skipToNavigation = Optional.of(new LogicalIndexPointer(node.getSkipToLabels(), last, false, 0, 0).toLogicalIndexNavigation((Map<IrLabel, Integer>)mapping));
            }
            PatternRecognitionPartitionerSupplier partitionerSupplier = new PatternRecognitionPartitionerSupplier((List<MeasureComputation.MeasureComputationSupplier>)measureComputations, (List<MatchAggregation.MatchAggregationInstantiator>)measureComputationsAggregations.build(), (List<ArgumentComputation.ArgumentComputationSupplier>)measureComputationsAggregationArguments.build(), frame, node.getRowsPerMatch(), skipToNavigation, node.getSkipToPosition(), node.isInitial(), new Matcher(program, (List<List<PhysicalValueAccessor>>)evaluationsValuePointers.build(), (List<MatchAggregationLabelDependency>)aggregationsLabelDependencies.build(), (List<MatchAggregation.MatchAggregationInstantiator>)labelEvaluationsAggregations.build()), (List<LabelEvaluator.EvaluationSupplier>)labelEvaluations, (List<ArgumentComputation.ArgumentComputationSupplier>)labelEvaluationsAggregationArguments.build(), (List<String>)labelNames);
            WindowOperator.WindowOperatorFactory operatorFactory = new WindowOperator.WindowOperatorFactory(context.getNextOperatorId(), node.getId(), source.getTypes(), (List<Integer>)outputChannels.build(), (List<WindowFunctionDefinition>)windowFunctionsBuilder.build(), (List<Integer>)partitionChannels, (List<Integer>)preGroupedChannels, (List<Integer>)sortChannels, (List<SortOrder>)sortOrder, node.getPreSortedOrderPrefix(), 10000, LocalExecutionPlanner.this.pagesIndexFactory, SystemSessionProperties.isSpillEnabled(this.session), LocalExecutionPlanner.this.spillerFactory, LocalExecutionPlanner.this.orderingCompiler, (List)node.getMeasures().values().stream().map(PatternRecognitionNode.Measure::getType).collect(ImmutableList.toImmutableList()), partitionerSupplier);
            return new PhysicalOperation((OperatorFactory)operatorFactory, (Map<Symbol, Integer>)outputMappings.buildOrThrow(), source);
        }

        private Supplier<PageProjection> prepareProjection(ExpressionAndValuePointers expressionAndValuePointers) {
            Expression rewritten = expressionAndValuePointers.getExpression();
            ImmutableMap.Builder inputTypes = ImmutableMap.builder();
            ImmutableMap.Builder inputLayout = ImmutableMap.builder();
            List<ExpressionAndValuePointers.Assignment> assignments = expressionAndValuePointers.getAssignments();
            for (int i = 0; i < assignments.size(); ++i) {
                ValuePointer valuePointer;
                ExpressionAndValuePointers.Assignment assignment = assignments.get(i);
                inputLayout.put((Object)assignment.symbol(), (Object)i);
                Symbol symbol = assignment.symbol();
                Objects.requireNonNull(assignment.valuePointer());
                int n = 0;
                inputTypes.put((Object)symbol, (Object)(switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{AggregationValuePointer.class, ClassifierValuePointer.class, MatchNumberValuePointer.class, ScalarValuePointer.class}, (Object)valuePointer, n)) {
                    default -> throw new MatchException(null, null);
                    case 0 -> {
                        AggregationValuePointer pointer = (AggregationValuePointer)valuePointer;
                        yield pointer.getFunction().signature().getReturnType();
                    }
                    case 1 -> {
                        ClassifierValuePointer pointer = (ClassifierValuePointer)valuePointer;
                        yield VarcharType.VARCHAR;
                    }
                    case 2 -> {
                        MatchNumberValuePointer pointer = (MatchNumberValuePointer)valuePointer;
                        yield BigintType.BIGINT;
                    }
                    case 3 -> {
                        ScalarValuePointer pointer = (ScalarValuePointer)valuePointer;
                        yield pointer.getInputSymbol().type();
                    }
                }));
            }
            RowExpression rowExpression = this.toRowExpression(rewritten, (Map<Symbol, Integer>)inputLayout.buildOrThrow());
            return LocalExecutionPlanner.this.pageFunctionCompiler.compileProjection(rowExpression, Optional.empty());
        }

        private ValueAccessors preparePhysicalValuePointers(ExpressionAndValuePointers expressionAndValuePointers, Map<IrLabel, Integer> mapping, PhysicalOperation source, ConnectorSession connectorSession, int firstUnusedChannel, int matchAggregationIndex) {
            Map<Symbol, Integer> sourceLayout = source.getLayout();
            ImmutableList.Builder matchAggregations = ImmutableList.builder();
            ImmutableList.Builder aggregationArguments = ImmutableList.builder();
            ImmutableList.Builder labelDependencies = ImmutableList.builder();
            ImmutableList.Builder valueAccessors = ImmutableList.builder();
            block6: for (ExpressionAndValuePointers.Assignment assignment : expressionAndValuePointers.getAssignments()) {
                ValuePointer valuePointer;
                Objects.requireNonNull(assignment.valuePointer());
                int n = 0;
                switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{ClassifierValuePointer.class, MatchNumberValuePointer.class, ScalarValuePointer.class, AggregationValuePointer.class}, (Object)valuePointer, n)) {
                    default: {
                        throw new MatchException(null, null);
                    }
                    case 0: {
                        ClassifierValuePointer pointer = (ClassifierValuePointer)valuePointer;
                        valueAccessors.add((Object)new PhysicalValuePointer(-1, (Type)VarcharType.VARCHAR, pointer.getLogicalIndexPointer().toLogicalIndexNavigation(mapping)));
                        continue block6;
                    }
                    case 1: {
                        MatchNumberValuePointer pointer = (MatchNumberValuePointer)valuePointer;
                        valueAccessors.add((Object)new PhysicalValuePointer(-2, (Type)BigintType.BIGINT, LogicalIndexNavigation.NO_OP));
                        continue block6;
                    }
                    case 2: {
                        ScalarValuePointer pointer = (ScalarValuePointer)valuePointer;
                        valueAccessors.add((Object)new PhysicalValuePointer((Integer)Iterables.getOnlyElement(LocalExecutionPlanner.getChannelsForSymbols((List<Symbol>)ImmutableList.of((Object)pointer.getInputSymbol()), sourceLayout)), pointer.getInputSymbol().type(), pointer.getLogicalIndexPointer().toLogicalIndexNavigation(mapping)));
                        continue block6;
                    }
                    case 3: 
                }
                AggregationValuePointer pointer = (AggregationValuePointer)valuePointer;
                boolean classifierInvolved = false;
                ResolvedFunction resolvedFunction = pointer.getFunction();
                AggregationImplementation aggregationImplementation = LocalExecutionPlanner.this.plannerContext.getFunctionManager().getAggregationImplementation(pointer.getFunction());
                ImmutableList.Builder builder = ImmutableList.builder();
                List signatureTypes = resolvedFunction.signature().getArgumentTypes();
                for (int i = 0; i < pointer.getArguments().size(); ++i) {
                    builder.add(new AbstractMap.SimpleEntry<Expression, Type>(pointer.getArguments().get(i), (Type)signatureTypes.get(i)));
                }
                Map<Boolean, List<Map.Entry>> arguments = builder.build().stream().collect(Collectors.partitioningBy(entry -> entry.getKey() instanceof Lambda));
                List lambdas = (List)arguments.get(true).stream().map(Map.Entry::getKey).map(Lambda.class::cast).collect(ImmutableList.toImmutableList());
                List functionTypes = (List)resolvedFunction.signature().getArgumentTypes().stream().filter(FunctionType.class::isInstance).map(FunctionType.class::cast).collect(ImmutableList.toImmutableList());
                List<Supplier<Object>> lambdaProviders = this.makeLambdaProviders(lambdas, aggregationImplementation.getLambdaInterfaces(), functionTypes);
                ArrayList<Integer> valueChannels = new ArrayList<Integer>();
                Optional<Symbol> classifierArgumentSymbol = pointer.getClassifierSymbol();
                Optional<Symbol> matchNumberArgumentSymbol = pointer.getMatchNumberSymbol();
                Set runtimeEvaluatedSymbols = (Set)ImmutableSet.of(classifierArgumentSymbol, matchNumberArgumentSymbol).stream().flatMap(Optional::stream).collect(ImmutableSet.toImmutableSet());
                for (Map.Entry argumentWithType : arguments.get(false)) {
                    boolean isRuntimeEvaluated;
                    Expression argument = (Expression)argumentWithType.getKey();
                    boolean bl = isRuntimeEvaluated = !(argument instanceof Reference) || runtimeEvaluatedSymbols.contains(Symbol.from(argument));
                    if (isRuntimeEvaluated) {
                        ImmutableList argumentInputSymbols = ImmutableList.copyOf(SymbolsExtractor.extractUnique(argument));
                        Supplier<PageProjection> argumentProjectionSupplier = this.prepareArgumentProjection(argument, (List<Symbol>)argumentInputSymbols);
                        ArrayList<Integer> argumentInputChannels = new ArrayList<Integer>();
                        for (Symbol symbol : argumentInputSymbols) {
                            if (classifierArgumentSymbol.isPresent() && symbol.equals(classifierArgumentSymbol.get())) {
                                classifierInvolved = true;
                                argumentInputChannels.add(-1);
                                continue;
                            }
                            if (matchNumberArgumentSymbol.isPresent() && symbol.equals(matchNumberArgumentSymbol.get())) {
                                argumentInputChannels.add(-2);
                                continue;
                            }
                            argumentInputChannels.add(sourceLayout.get(symbol));
                        }
                        Type argumentType = (Type)argumentWithType.getValue();
                        ArgumentComputation.ArgumentComputationSupplier argumentComputationSupplier = new ArgumentComputation.ArgumentComputationSupplier(argumentProjectionSupplier, argumentType, argumentInputChannels, connectorSession);
                        aggregationArguments.add((Object)argumentComputationSupplier);
                        valueChannels.add(firstUnusedChannel);
                        ++firstUnusedChannel;
                        continue;
                    }
                    valueChannels.add(sourceLayout.get(Symbol.from(argument)));
                }
                AggregationWindowFunctionSupplier aggregationWindowFunctionSupplier = (AggregationWindowFunctionSupplier)CacheUtils.uncheckedCacheGet(LocalExecutionPlanner.this.aggregationWindowFunctionSupplierCache, (Object)new FunctionKey(resolvedFunction.functionId(), resolvedFunction.signature()), () -> new AggregationWindowFunctionSupplier(resolvedFunction.signature(), aggregationImplementation, resolvedFunction.functionNullability()));
                matchAggregations.add((Object)new MatchAggregation.MatchAggregationInstantiator(resolvedFunction.signature(), aggregationWindowFunctionSupplier, valueChannels, lambdaProviders, new SetEvaluator.SetEvaluatorSupplier(pointer.getSetDescriptor(), mapping)));
                labelDependencies.add((Object)new MatchAggregationLabelDependency((Set)pointer.getSetDescriptor().getLabels().stream().map(mapping::get).collect(ImmutableSet.toImmutableSet()), classifierInvolved));
                valueAccessors.add((Object)new MatchAggregationPointer(matchAggregationIndex));
                ++matchAggregationIndex;
            }
            return new ValueAccessors((List<PhysicalValueAccessor>)valueAccessors.build(), (List<MatchAggregation.MatchAggregationInstantiator>)matchAggregations.build(), matchAggregationIndex, (List<ArgumentComputation.ArgumentComputationSupplier>)aggregationArguments.build(), firstUnusedChannel, (List<MatchAggregationLabelDependency>)labelDependencies.build());
        }

        private Supplier<PageProjection> prepareArgumentProjection(Expression argument, List<Symbol> inputSymbols) {
            ImmutableMap.Builder inputLayout = ImmutableMap.builder();
            for (int i = 0; i < inputSymbols.size(); ++i) {
                inputLayout.put((Object)inputSymbols.get(i), (Object)i);
            }
            RowExpression rowExpression = this.toRowExpression(argument, (Map<Symbol, Integer>)inputLayout.buildOrThrow());
            return LocalExecutionPlanner.this.pageFunctionCompiler.compileProjection(rowExpression, Optional.empty());
        }

        @Override
        public PhysicalOperation visitTableFunction(TableFunctionNode node, LocalExecutionPlanContext context) {
            throw new IllegalStateException(String.format("Unexpected node: TableFunctionNode (%s)", node.getName()));
        }

        @Override
        public PhysicalOperation visitTableFunctionProcessor(TableFunctionProcessorNode node, LocalExecutionPlanContext context) {
            TableFunctionProcessorProvider processorProvider = LocalExecutionPlanner.this.plannerContext.getFunctionManager().getTableFunctionProcessorProvider(node.getHandle());
            if (node.getSource().isEmpty()) {
                LeafTableFunctionOperator.LeafTableFunctionOperatorFactory operatorFactory = new LeafTableFunctionOperator.LeafTableFunctionOperatorFactory(context.getNextOperatorId(), node.getId(), node.getHandle().catalogHandle(), processorProvider, node.getHandle().functionHandle());
                return new PhysicalOperation((OperatorFactory)operatorFactory, (Map<Symbol, Integer>)this.makeLayout(node));
            }
            PhysicalOperation source = node.getSource().orElseThrow().accept(this, context);
            int properChannelsCount = node.getProperOutputs().size();
            long passThroughSourcesCount = node.getPassThroughSpecifications().stream().filter(TableFunctionNode.PassThroughSpecification::declaredAsPassThrough).count();
            List requiredChannels = (List)node.getRequiredSymbols().stream().map(list -> LocalExecutionPlanner.getChannelsForSymbols(list, source.getLayout())).collect(ImmutableList.toImmutableList());
            Optional<Map<Integer, Integer>> markerChannels = node.getMarkerSymbols().map(map -> (Map)map.entrySet().stream().collect(ImmutableMap.toImmutableMap(entry -> source.getLayout().get(entry.getKey()), entry -> source.getLayout().get(entry.getValue()))));
            int channel = properChannelsCount;
            ImmutableList.Builder passThroughColumnSpecifications = ImmutableList.builder();
            for (TableFunctionNode.PassThroughSpecification specification : node.getPassThroughSpecifications()) {
                int indexChannel = specification.declaredAsPassThrough() ? channel++ : -1;
                for (TableFunctionNode.PassThroughColumn column : specification.columns()) {
                    passThroughColumnSpecifications.add((Object)new RegularTableFunctionPartition.PassThroughColumnSpecification(column.isPartitioningColumn(), source.getLayout().get(column.symbol()), indexChannel));
                }
            }
            List partitionChannels = node.getSpecification().map(DataOrganizationSpecification::partitionBy).map(list -> LocalExecutionPlanner.getChannelsForSymbols(list, source.getLayout())).orElse((List)ImmutableList.of());
            Object sortChannels = ImmutableList.of();
            Object sortOrders = ImmutableList.of();
            if (node.getSpecification().flatMap(DataOrganizationSpecification::orderingScheme).isPresent()) {
                OrderingScheme orderingScheme = (OrderingScheme)node.getSpecification().flatMap(DataOrganizationSpecification::orderingScheme).orElseThrow();
                sortChannels = LocalExecutionPlanner.getChannelsForSymbols(orderingScheme.orderBy(), source.getLayout());
                sortOrders = orderingScheme.orderingList();
            }
            TableFunctionOperator.TableFunctionOperatorFactory operator = new TableFunctionOperator.TableFunctionOperatorFactory(context.getNextOperatorId(), node.getId(), processorProvider, node.getHandle().catalogHandle(), node.getHandle().functionHandle(), properChannelsCount, Math.toIntExact(passThroughSourcesCount), requiredChannels, markerChannels, (List<RegularTableFunctionPartition.PassThroughColumnSpecification>)passThroughColumnSpecifications.build(), node.isPruneWhenEmpty(), partitionChannels, LocalExecutionPlanner.getChannelsForSymbols((List<Symbol>)ImmutableList.copyOf(node.getPrePartitioned()), source.getLayout()), (List<Integer>)sortChannels, (List<SortOrder>)sortOrders, node.getPreSorted(), source.getTypes(), 10000, LocalExecutionPlanner.this.pagesIndexFactory);
            ImmutableMap.Builder outputMappings = ImmutableMap.builder();
            for (int i = 0; i < node.getProperOutputs().size(); ++i) {
                outputMappings.put((Object)node.getProperOutputs().get(i), (Object)i);
            }
            List passThroughSymbols = (List)node.getPassThroughSpecifications().stream().map(TableFunctionNode.PassThroughSpecification::columns).flatMap(Collection::stream).map(TableFunctionNode.PassThroughColumn::symbol).collect(ImmutableList.toImmutableList());
            int outputChannel = properChannelsCount;
            for (Symbol passThroughSymbol : passThroughSymbols) {
                outputMappings.put((Object)passThroughSymbol, (Object)outputChannel++);
            }
            return new PhysicalOperation((OperatorFactory)operator, (Map<Symbol, Integer>)outputMappings.buildOrThrow(), source);
        }

        @Override
        public PhysicalOperation visitTopN(TopNNode node, LocalExecutionPlanContext context) {
            PhysicalOperation source = node.getSource().accept(this, context);
            List<Symbol> orderBySymbols = node.getOrderingScheme().orderBy();
            ArrayList<Integer> sortChannels = new ArrayList<Integer>();
            ArrayList<SortOrder> sortOrders = new ArrayList<SortOrder>();
            for (Symbol symbol : orderBySymbols) {
                sortChannels.add(source.getLayout().get(symbol));
                sortOrders.add(node.getOrderingScheme().ordering(symbol));
            }
            OperatorFactory operator = TopNOperator.createOperatorFactory(context.getNextOperatorId(), node.getId(), source.getTypes(), (int)node.getCount(), sortChannels, sortOrders, LocalExecutionPlanner.this.plannerContext.getTypeOperators());
            return new PhysicalOperation(operator, source.getLayout(), source);
        }

        @Override
        public PhysicalOperation visitSort(SortNode node, LocalExecutionPlanContext context) {
            PhysicalOperation source = node.getSource().accept(this, context);
            List<Symbol> orderBySymbols = node.getOrderingScheme().orderBy();
            List<Integer> orderByChannels = LocalExecutionPlanner.getChannelsForSymbols(orderBySymbols, source.getLayout());
            ImmutableList.Builder sortOrder = ImmutableList.builder();
            for (Symbol symbol : orderBySymbols) {
                sortOrder.add((Object)node.getOrderingScheme().ordering(symbol));
            }
            ImmutableList.Builder outputChannels = ImmutableList.builder();
            for (int i = 0; i < source.getTypes().size(); ++i) {
                outputChannels.add((Object)i);
            }
            boolean spillEnabled = SystemSessionProperties.isSpillEnabled(this.session);
            OrderByOperator.OrderByOperatorFactory operator = new OrderByOperator.OrderByOperatorFactory(context.getNextOperatorId(), node.getId(), source.getTypes(), (List<Integer>)outputChannels.build(), 10000, orderByChannels, (List<SortOrder>)sortOrder.build(), LocalExecutionPlanner.this.pagesIndexFactory, spillEnabled, Optional.of(LocalExecutionPlanner.this.spillerFactory), LocalExecutionPlanner.this.orderingCompiler);
            return new PhysicalOperation((OperatorFactory)operator, source.getLayout(), source);
        }

        @Override
        public PhysicalOperation visitLimit(LimitNode node, LocalExecutionPlanContext context) {
            Preconditions.checkState((boolean)node.getTiesResolvingScheme().isEmpty(), (Object)"Limit with ties not supported");
            PhysicalOperation source = node.getSource().accept(this, context);
            LimitOperator.LimitOperatorFactory operatorFactory = new LimitOperator.LimitOperatorFactory(context.getNextOperatorId(), node.getId(), node.getCount());
            return new PhysicalOperation((OperatorFactory)operatorFactory, source.getLayout(), source);
        }

        @Override
        public PhysicalOperation visitDistinctLimit(DistinctLimitNode node, LocalExecutionPlanContext context) {
            PhysicalOperation source = node.getSource().accept(this, context);
            Optional<Integer> hashChannel = node.getHashSymbol().map(LocalExecutionPlanner.channelGetter(source));
            List<Integer> distinctChannels = LocalExecutionPlanner.getChannelsForSymbols(node.getDistinctSymbols(), source.getLayout());
            DistinctLimitOperator.DistinctLimitOperatorFactory operatorFactory = new DistinctLimitOperator.DistinctLimitOperatorFactory(context.getNextOperatorId(), node.getId(), source.getTypes(), distinctChannels, node.getLimit(), hashChannel, LocalExecutionPlanner.this.hashStrategyCompiler);
            return new PhysicalOperation((OperatorFactory)operatorFactory, (Map<Symbol, Integer>)this.makeLayout(node), source);
        }

        @Override
        public PhysicalOperation visitGroupId(GroupIdNode node, LocalExecutionPlanContext context) {
            PhysicalOperation source = node.getSource().accept(this, context);
            HashMap<Symbol, Integer> newLayout = new HashMap<Symbol, Integer>();
            ImmutableList.Builder outputTypes = ImmutableList.builder();
            int outputChannel = 0;
            for (Symbol symbol : node.getDistinctGroupingSetSymbols()) {
                newLayout.put(symbol, outputChannel++);
                outputTypes.add((Object)source.getTypes().get(source.getLayout().get(node.getGroupingColumns().get(symbol))));
            }
            HashMap<Symbol, Integer> argumentMappings = new HashMap<Symbol, Integer>();
            for (Symbol symbol : node.getAggregationArguments()) {
                int n = source.getLayout().get(symbol);
                newLayout.put(symbol, outputChannel++);
                outputTypes.add((Object)source.getTypes().get(n));
                argumentMappings.put(symbol, n);
            }
            ImmutableList.Builder builder = ImmutableList.builder();
            for (List<Symbol> list : node.getGroupingSets()) {
                ImmutableMap.Builder setMapping = ImmutableMap.builder();
                for (Symbol output : list) {
                    setMapping.put((Object)((Integer)newLayout.get(output)), (Object)source.getLayout().get(node.getGroupingColumns().get(output)));
                }
                for (Symbol output : argumentMappings.keySet()) {
                    setMapping.put((Object)((Integer)newLayout.get(output)), (Object)((Integer)argumentMappings.get(output)));
                }
                builder.add((Object)setMapping.buildOrThrow());
            }
            newLayout.put(node.getGroupIdSymbol(), outputChannel);
            outputTypes.add((Object)BigintType.BIGINT);
            GroupIdOperator.GroupIdOperatorFactory groupIdOperatorFactory = new GroupIdOperator.GroupIdOperatorFactory(context.getNextOperatorId(), node.getId(), (List<? extends Type>)outputTypes.build(), (List<Map<Integer, Integer>>)builder.build());
            return new PhysicalOperation((OperatorFactory)groupIdOperatorFactory, newLayout, source);
        }

        @Override
        public PhysicalOperation visitAggregation(AggregationNode node, LocalExecutionPlanContext context) {
            PhysicalOperation source = node.getSource().accept(this, context);
            if (node.getGroupingKeys().isEmpty()) {
                return this.planGlobalAggregation(node, source, context);
            }
            boolean spillEnabled = SystemSessionProperties.isSpillEnabled(this.session);
            DataSize unspillMemoryLimit = SystemSessionProperties.getAggregationOperatorUnspillMemoryLimit(this.session);
            return this.planGroupByAggregation(node, source, spillEnabled, unspillMemoryLimit, context);
        }

        @Override
        public PhysicalOperation visitMarkDistinct(MarkDistinctNode node, LocalExecutionPlanContext context) {
            PhysicalOperation source = node.getSource().accept(this, context);
            List<Integer> channels = LocalExecutionPlanner.getChannelsForSymbols(node.getDistinctSymbols(), source.getLayout());
            Optional<Integer> hashChannel = node.getHashSymbol().map(LocalExecutionPlanner.channelGetter(source));
            MarkDistinctOperator.MarkDistinctOperatorFactory operator = new MarkDistinctOperator.MarkDistinctOperatorFactory(context.getNextOperatorId(), node.getId(), source.getTypes(), channels, hashChannel, LocalExecutionPlanner.this.hashStrategyCompiler);
            return new PhysicalOperation((OperatorFactory)operator, (Map<Symbol, Integer>)this.makeLayout(node), source);
        }

        @Override
        public PhysicalOperation visitSample(SampleNode node, LocalExecutionPlanContext context) {
            if (node.getSampleType() == SampleNode.Type.SYSTEM) {
                return node.getSource().accept(this, context);
            }
            throw new UnsupportedOperationException("not yet implemented: " + String.valueOf(node));
        }

        @Override
        public PhysicalOperation visitFilter(FilterNode node, LocalExecutionPlanContext context) {
            PlanNode sourceNode = node.getSource();
            if (node.getSource() instanceof TableScanNode && this.getStaticFilter(node.getPredicate()).isEmpty()) {
                return this.visitTableScan(node.getId(), (TableScanNode)node.getSource(), node.getPredicate(), context);
            }
            Expression filterExpression = node.getPredicate();
            List<Symbol> outputSymbols = node.getOutputSymbols();
            return this.visitScanFilterAndProject(context, node.getId(), sourceNode, Optional.of(filterExpression), Assignments.identity(outputSymbols), outputSymbols);
        }

        @Override
        public PhysicalOperation visitProject(ProjectNode node, LocalExecutionPlanContext context) {
            PlanNode sourceNode;
            Optional<Expression> filterExpression = Optional.empty();
            PlanNode planNode = node.getSource();
            if (planNode instanceof FilterNode) {
                FilterNode filterNode = (FilterNode)planNode;
                sourceNode = filterNode.getSource();
                filterExpression = Optional.of(filterNode.getPredicate());
            } else {
                sourceNode = node.getSource();
            }
            List<Symbol> outputSymbols = node.getOutputSymbols();
            return this.visitScanFilterAndProject(context, node.getId(), sourceNode, filterExpression, node.getAssignments(), outputSymbols);
        }

        private PhysicalOperation visitScanFilterAndProject(LocalExecutionPlanContext context, PlanNodeId planNodeId, PlanNode sourceNode, Optional<Expression> filterExpression, Assignments assignments, List<Symbol> outputSymbols) {
            Map<Object, Object> sourceLayout;
            TableHandle table = null;
            ArrayList<ColumnHandle> columns = null;
            PhysicalOperation source = null;
            if (sourceNode instanceof TableScanNode) {
                TableScanNode tableScanNode = (TableScanNode)sourceNode;
                table = tableScanNode.getTable();
                sourceLayout = new LinkedHashMap();
                columns = new ArrayList<ColumnHandle>();
                int channel = 0;
                for (Symbol symbol : tableScanNode.getOutputSymbols()) {
                    columns.add(tableScanNode.getAssignments().get(symbol));
                    Integer input = channel;
                    sourceLayout.put(symbol, input);
                    ++channel;
                }
            } else {
                if (sourceNode instanceof SampleNode) {
                    SampleNode sampleNode = (SampleNode)sourceNode;
                    Preconditions.checkArgument((sampleNode.getSampleType() == SampleNode.Type.SYSTEM ? 1 : 0) != 0, (String)"%s sampling is not supported", (Object)((Object)sampleNode.getSampleType()));
                    return this.visitScanFilterAndProject(context, planNodeId, sampleNode.getSource(), filterExpression, assignments, outputSymbols);
                }
                source = sourceNode.accept(this, context);
                sourceLayout = source.getLayout();
            }
            ImmutableMap.Builder outputMappingsBuilder = ImmutableMap.builder();
            for (int i = 0; i < outputSymbols.size(); ++i) {
                Symbol symbol = outputSymbols.get(i);
                outputMappingsBuilder.put((Object)symbol, (Object)i);
            }
            ImmutableMap outputMappings = outputMappingsBuilder.buildOrThrow();
            Optional<RowExpression> staticFilters = filterExpression.flatMap(this::getStaticFilter);
            DynamicFilter dynamicFilter = filterExpression.filter(expression -> sourceNode instanceof TableScanNode).map(expression -> this.getDynamicFilter((TableScanNode)sourceNode, (Expression)expression, context)).orElse(DynamicFilter.EMPTY);
            ArrayList<Expression> projections = new ArrayList<Expression>();
            for (Symbol symbol : outputSymbols) {
                projections.add(assignments.get(symbol));
            }
            Optional<RowExpression> translatedFilter = staticFilters.map(filter -> this.toRowExpression((Expression)filter, (Map<Symbol, Integer>)sourceLayout));
            List translatedProjections = (List)projections.stream().map(expression -> this.toRowExpression((Expression)expression, (Map<Symbol, Integer>)sourceLayout)).collect(ImmutableList.toImmutableList());
            try {
                if (columns != null) {
                    Supplier<CursorProcessor> cursorProcessor = LocalExecutionPlanner.this.expressionCompiler.compileCursorProcessor(translatedFilter, translatedProjections, sourceNode.getId());
                    Supplier<PageProcessor> pageProcessor = LocalExecutionPlanner.this.expressionCompiler.compilePageProcessor(translatedFilter, (List<? extends RowExpression>)translatedProjections, Optional.of(String.valueOf(context.getStageId()) + "_" + String.valueOf(planNodeId)));
                    ScanFilterAndProjectOperator.ScanFilterAndProjectOperatorFactory operatorFactory = new ScanFilterAndProjectOperator.ScanFilterAndProjectOperatorFactory(context.getNextOperatorId(), planNodeId, sourceNode.getId(), LocalExecutionPlanner.this.pageSourceProvider, cursorProcessor, pageProcessor, table, columns, dynamicFilter, LocalExecutionPlanner.getTypes(projections), SystemSessionProperties.getFilterAndProjectMinOutputPageSize(this.session), SystemSessionProperties.getFilterAndProjectMinOutputPageRowCount(this.session));
                    return new PhysicalOperation((OperatorFactory)operatorFactory, (Map<Symbol, Integer>)outputMappings);
                }
                Supplier<PageProcessor> pageProcessor = LocalExecutionPlanner.this.expressionCompiler.compilePageProcessor(translatedFilter, (List<? extends RowExpression>)translatedProjections, Optional.of(String.valueOf(context.getStageId()) + "_" + String.valueOf(planNodeId)));
                OperatorFactory operatorFactory = FilterAndProjectOperator.createOperatorFactory(context.getNextOperatorId(), planNodeId, pageProcessor, LocalExecutionPlanner.getTypes(projections), SystemSessionProperties.getFilterAndProjectMinOutputPageSize(this.session), SystemSessionProperties.getFilterAndProjectMinOutputPageRowCount(this.session));
                return new PhysicalOperation(operatorFactory, (Map<Symbol, Integer>)outputMappings, source);
            }
            catch (TrinoException e) {
                throw e;
            }
            catch (RuntimeException e) {
                throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.COMPILER_ERROR, "Compiler failed. Possible reasons include: the query may have too many or too complex expressions, or the underlying tables may have too many columns", (Throwable)e);
            }
        }

        private RowExpression toRowExpression(Expression expression, Map<Symbol, Integer> layout) {
            return SqlToRowExpressionTranslator.translate(expression, layout, LocalExecutionPlanner.this.metadata, LocalExecutionPlanner.this.plannerContext.getTypeManager());
        }

        @Override
        public PhysicalOperation visitTableScan(TableScanNode node, LocalExecutionPlanContext context) {
            return this.visitTableScan(node.getId(), node, Booleans.TRUE, context);
        }

        private PhysicalOperation visitTableScan(PlanNodeId planNodeId, TableScanNode node, Expression filterExpression, LocalExecutionPlanContext context) {
            ArrayList<ColumnHandle> columns = new ArrayList<ColumnHandle>();
            for (Symbol symbol : node.getOutputSymbols()) {
                columns.add(node.getAssignments().get(symbol));
            }
            DynamicFilter dynamicFilter = this.getDynamicFilter(node, filterExpression, context);
            TableScanOperator.TableScanOperatorFactory operatorFactory = new TableScanOperator.TableScanOperatorFactory(context.getNextOperatorId(), planNodeId, node.getId(), LocalExecutionPlanner.this.pageSourceProvider, node.getTable(), columns, dynamicFilter);
            return new PhysicalOperation((OperatorFactory)operatorFactory, (Map<Symbol, Integer>)this.makeLayout(node));
        }

        private Optional<Expression> getStaticFilter(Expression filterExpression) {
            DynamicFilters.ExtractResult extractDynamicFilterResult = DynamicFilters.extractDynamicFilters(filterExpression);
            Expression staticFilter = IrUtils.combineConjuncts(extractDynamicFilterResult.getStaticConjuncts());
            if (staticFilter.equals(Booleans.TRUE)) {
                return Optional.empty();
            }
            return Optional.of(staticFilter);
        }

        private DynamicFilter getDynamicFilter(TableScanNode tableScanNode, Expression filterExpression, LocalExecutionPlanContext context) {
            DynamicFilters.ExtractResult extractDynamicFilterResult = DynamicFilters.extractDynamicFilters(filterExpression);
            List<DynamicFilters.Descriptor> dynamicFilters = extractDynamicFilterResult.getDynamicConjuncts();
            if (dynamicFilters.isEmpty()) {
                return DynamicFilter.EMPTY;
            }
            log.debug("[TableScan] Dynamic filters: %s", new Object[]{dynamicFilters});
            context.registerCoordinatorDynamicFilters(dynamicFilters);
            return context.getDynamicFiltersCollector().createDynamicFilter(dynamicFilters, tableScanNode.getAssignments(), LocalExecutionPlanner.this.plannerContext);
        }

        @Override
        public PhysicalOperation visitValues(ValuesNode node, LocalExecutionPlanContext context) {
            context.setDriverInstanceCount(1);
            if (node.getRowCount() == 0) {
                ValuesOperator.ValuesOperatorFactory operatorFactory = new ValuesOperator.ValuesOperatorFactory(context.getNextOperatorId(), node.getId(), (List<Page>)ImmutableList.of());
                return new PhysicalOperation((OperatorFactory)operatorFactory, (Map<Symbol, Integer>)this.makeLayout(node));
            }
            List<Type> outputTypes = this.getSymbolTypes(node.getOutputSymbols());
            PageBuilder pageBuilder = new PageBuilder(node.getRowCount(), outputTypes);
            for (int i = 0; i < node.getRowCount(); ++i) {
                pageBuilder.declarePosition();
                if (!node.getRows().isPresent()) continue;
                Expression row = node.getRows().get().get(i);
                Preconditions.checkState((boolean)(row.type() instanceof RowType), (String)"unexpected type of Values row: %s", (Object)row.type());
                SqlRow result = (SqlRow)new IrExpressionInterpreter(row, LocalExecutionPlanner.this.plannerContext, this.session).evaluate();
                int rawIndex = result.getRawIndex();
                for (int j = 0; j < outputTypes.size(); ++j) {
                    Block fieldBlock = result.getRawFieldBlock(j);
                    TypeUtils.writeNativeValue((Type)outputTypes.get(j), (BlockBuilder)pageBuilder.getBlockBuilder(j), (Object)TypeUtils.readNativeValue((Type)outputTypes.get(j), (Block)fieldBlock, (int)rawIndex));
                }
            }
            ValuesOperator.ValuesOperatorFactory operatorFactory = new ValuesOperator.ValuesOperatorFactory(context.getNextOperatorId(), node.getId(), (List<Page>)ImmutableList.of((Object)pageBuilder.build()));
            return new PhysicalOperation((OperatorFactory)operatorFactory, (Map<Symbol, Integer>)this.makeLayout(node));
        }

        @Override
        public PhysicalOperation visitUnnest(UnnestNode node, LocalExecutionPlanContext context) {
            PhysicalOperation source = node.getSource().accept(this, context);
            ImmutableList.Builder replicateTypes = ImmutableList.builder();
            for (Symbol symbol : node.getReplicateSymbols()) {
                replicateTypes.add((Object)symbol.type());
            }
            List unnestSymbols = (List)node.getMappings().stream().map(UnnestNode.Mapping::getInput).collect(ImmutableList.toImmutableList());
            ImmutableList.Builder unnestTypes = ImmutableList.builder();
            for (Symbol symbol : unnestSymbols) {
                unnestTypes.add((Object)symbol.type());
            }
            Optional<Symbol> ordinalitySymbol = node.getOrdinalitySymbol();
            Optional<Type> ordinalityType = ordinalitySymbol.map(Symbol::type);
            ordinalityType.ifPresent(type -> Preconditions.checkState((boolean)type.equals((Object)BigintType.BIGINT), (Object)"Type of ordinalitySymbol must always be BIGINT."));
            List<Integer> replicateChannels = LocalExecutionPlanner.getChannelsForSymbols(node.getReplicateSymbols(), source.getLayout());
            List<Integer> unnestChannels = LocalExecutionPlanner.getChannelsForSymbols(unnestSymbols, source.getLayout());
            ImmutableMap.Builder outputMappings = ImmutableMap.builder();
            int channel = 0;
            for (Symbol symbol : node.getReplicateSymbols()) {
                outputMappings.put((Object)symbol, (Object)channel);
                ++channel;
            }
            for (UnnestNode.Mapping mapping : node.getMappings()) {
                for (Symbol unnestedSymbol : mapping.getOutputs()) {
                    outputMappings.put((Object)unnestedSymbol, (Object)channel);
                    ++channel;
                }
            }
            if (ordinalitySymbol.isPresent()) {
                outputMappings.put((Object)ordinalitySymbol.get(), (Object)channel);
                ++channel;
            }
            boolean outer = node.getJoinType() == JoinType.LEFT || node.getJoinType() == JoinType.FULL;
            UnnestOperator.UnnestOperatorFactory operatorFactory = new UnnestOperator.UnnestOperatorFactory(context.getNextOperatorId(), node.getId(), replicateChannels, (List<Type>)replicateTypes.build(), unnestChannels, (List<Type>)unnestTypes.build(), ordinalityType.isPresent(), outer);
            return new PhysicalOperation((OperatorFactory)operatorFactory, (Map<Symbol, Integer>)outputMappings.buildOrThrow(), source);
        }

        private ImmutableMap<Symbol, Integer> makeLayout(PlanNode node) {
            return this.makeLayoutFromOutputSymbols(node.getOutputSymbols());
        }

        private ImmutableMap<Symbol, Integer> makeLayoutFromOutputSymbols(List<Symbol> outputSymbols) {
            ImmutableMap.Builder outputMappings = ImmutableMap.builder();
            int channel = 0;
            for (Symbol symbol : outputSymbols) {
                outputMappings.put((Object)symbol, (Object)channel);
                ++channel;
            }
            return outputMappings.buildOrThrow();
        }

        @Override
        public PhysicalOperation visitIndexSource(IndexSourceNode node, LocalExecutionPlanContext context) {
            Preconditions.checkState((boolean)context.getIndexSourceContext().isPresent(), (Object)"Must be in an index source context");
            IndexSourceContext indexSourceContext = context.getIndexSourceContext().get();
            SetMultimap<Symbol, Integer> indexLookupToProbeInput = indexSourceContext.getIndexLookupToProbeInput();
            Preconditions.checkState((boolean)indexLookupToProbeInput.keySet().equals(node.getLookupSymbols()));
            ImmutableList lookupSymbolSchema = ImmutableList.copyOf(node.getLookupSymbols());
            ImmutableList.Builder remappedProbeKeyChannelsBuilder = ImmutableList.builder();
            ImmutableList.Builder overlappingFieldSetsBuilder = ImmutableList.builder();
            for (Symbol lookupSymbol : lookupSymbolSchema) {
                Set potentialProbeInputs = indexLookupToProbeInput.get((Object)lookupSymbol);
                Preconditions.checkState((!potentialProbeInputs.isEmpty() ? 1 : 0) != 0, (Object)"Must have at least one source from the probe input");
                if (potentialProbeInputs.size() > 1) {
                    overlappingFieldSetsBuilder.add((Object)ImmutableSet.copyOf((Collection)potentialProbeInputs));
                }
                remappedProbeKeyChannelsBuilder.add((Object)((Integer)Iterables.getFirst((Iterable)potentialProbeInputs, null)));
            }
            ImmutableList overlappingFieldSets = overlappingFieldSetsBuilder.build();
            ImmutableList remappedProbeKeyChannels = remappedProbeKeyChannelsBuilder.build();
            Function<RecordSet, RecordSet> probeKeyNormalizer = arg_0 -> this.lambda$visitIndexSource$19((List)overlappingFieldSets, (List)remappedProbeKeyChannels, arg_0);
            List lookupSchema = Lists.transform((List)lookupSymbolSchema, (com.google.common.base.Function)Functions.forMap(node.getAssignments()));
            List outputSchema = Lists.transform(node.getOutputSymbols(), (com.google.common.base.Function)Functions.forMap(node.getAssignments()));
            ConnectorIndex index = LocalExecutionPlanner.this.indexManager.getIndex(this.session, node.getIndexHandle(), lookupSchema, outputSchema);
            IndexSourceOperator.IndexSourceOperatorFactory operatorFactory = new IndexSourceOperator.IndexSourceOperatorFactory(context.getNextOperatorId(), node.getId(), index, probeKeyNormalizer);
            return new PhysicalOperation((OperatorFactory)operatorFactory, (Map<Symbol, Integer>)this.makeLayout(node));
        }

        private SetMultimap<Symbol, Integer> mapIndexSourceLookupSymbolToProbeKeyInput(IndexJoinNode node, Map<Symbol, Integer> probeKeyLayout) {
            Set indexJoinSymbols = (Set)node.getCriteria().stream().map(IndexJoinNode.EquiJoinClause::getIndex).collect(ImmutableSet.toImmutableSet());
            Map<Symbol, Symbol> indexKeyTrace = IndexJoinOptimizer.IndexKeyTracer.trace(node.getIndexSource(), indexJoinSymbols);
            HashMultimap indexToProbeKeyInput = HashMultimap.create();
            for (IndexJoinNode.EquiJoinClause clause : node.getCriteria()) {
                indexToProbeKeyInput.put((Object)clause.getIndex(), (Object)probeKeyLayout.get(clause.getProbe()));
            }
            ImmutableSetMultimap.Builder builder = ImmutableSetMultimap.builder();
            for (Map.Entry<Symbol, Symbol> entry : indexKeyTrace.entrySet()) {
                Symbol indexJoinSymbol = entry.getKey();
                Symbol indexLookupSymbol = entry.getValue();
                builder.putAll((Object)indexLookupSymbol, (Iterable)indexToProbeKeyInput.get((Object)indexJoinSymbol));
            }
            return builder.build();
        }

        @Override
        public PhysicalOperation visitIndexJoin(IndexJoinNode node, LocalExecutionPlanContext context) {
            List<IndexJoinNode.EquiJoinClause> clauses = node.getCriteria();
            List probeSymbols = Lists.transform(clauses, IndexJoinNode.EquiJoinClause::getProbe);
            List indexSymbols = Lists.transform(clauses, IndexJoinNode.EquiJoinClause::getIndex);
            PhysicalOperation probeSource = node.getProbeSource().accept(this, context);
            List<Integer> probeChannels = LocalExecutionPlanner.getChannelsForSymbols(probeSymbols, probeSource.getLayout());
            OptionalInt probeHashChannel = node.getProbeHashSymbol().map(LocalExecutionPlanner.channelGetter(probeSource)).map(OptionalInt::of).orElse(OptionalInt.empty());
            HashMap<Symbol, Integer> probeKeyLayout = new HashMap<Symbol, Integer>();
            for (int i = 0; i < probeSymbols.size(); ++i) {
                probeKeyLayout.put((Symbol)probeSymbols.get(i), i);
            }
            SetMultimap<Symbol, Integer> indexLookupToProbeInput = this.mapIndexSourceLookupSymbolToProbeKeyInput(node, probeKeyLayout);
            LocalExecutionPlanContext indexContext = context.createIndexSourceSubContext(new IndexSourceContext(indexLookupToProbeInput));
            PhysicalOperation indexSource = node.getIndexSource().accept(this, indexContext);
            List<Integer> indexOutputChannels = LocalExecutionPlanner.getChannelsForSymbols(indexSymbols, indexSource.getLayout());
            OptionalInt indexHashChannel = node.getIndexHashSymbol().map(LocalExecutionPlanner.channelGetter(indexSource)).map(OptionalInt::of).orElse(OptionalInt.empty());
            Set<Symbol> indexSymbolsNeededBySource = IndexJoinOptimizer.IndexKeyTracer.trace(node.getIndexSource(), (Set<Symbol>)ImmutableSet.copyOf((Collection)indexSymbols)).keySet();
            Set lookupSourceInputChannels = (Set)node.getCriteria().stream().filter(equiJoinClause -> indexSymbolsNeededBySource.contains(equiJoinClause.getIndex())).map(IndexJoinNode.EquiJoinClause::getProbe).map(probeKeyLayout::get).collect(ImmutableSet.toImmutableSet());
            Optional<DynamicTupleFilterFactory> dynamicTupleFilterFactory = Optional.empty();
            if (lookupSourceInputChannels.size() < probeKeyLayout.values().size()) {
                int[] nonLookupInputChannels = Ints.toArray((Collection)((Collection)node.getCriteria().stream().filter(equiJoinClause -> !indexSymbolsNeededBySource.contains(equiJoinClause.getIndex())).map(IndexJoinNode.EquiJoinClause::getProbe).map(probeKeyLayout::get).collect(ImmutableList.toImmutableList())));
                int[] nonLookupOutputChannels = Ints.toArray((Collection)((Collection)node.getCriteria().stream().filter(equiJoinClause -> !indexSymbolsNeededBySource.contains(equiJoinClause.getIndex())).map(IndexJoinNode.EquiJoinClause::getIndex).map(indexSource.getLayout()::get).collect(ImmutableList.toImmutableList())));
                int filterOperatorId = indexContext.getNextOperatorId();
                dynamicTupleFilterFactory = Optional.of(new DynamicTupleFilterFactory(filterOperatorId, node.getId(), nonLookupInputChannels, nonLookupOutputChannels, indexSource.getTypes(), LocalExecutionPlanner.this.pageFunctionCompiler, LocalExecutionPlanner.this.blockTypeOperators));
            }
            IndexBuildDriverFactoryProvider indexBuildDriverFactoryProvider = new IndexBuildDriverFactoryProvider(indexContext.getNextPipelineId(), indexContext.getNextOperatorId(), node.getId(), indexContext.isInputDriver(), indexSource.getTypes(), indexSource.getOperatorFactories(), dynamicTupleFilterFactory);
            IndexLookupSourceFactory indexLookupSourceFactory = new IndexLookupSourceFactory(lookupSourceInputChannels, indexOutputChannels, indexHashChannel, indexSource.getTypes(), indexBuildDriverFactoryProvider, LocalExecutionPlanner.this.maxIndexMemorySize, LocalExecutionPlanner.this.indexJoinLookupStats, SystemSessionProperties.isShareIndexLoading(this.session), LocalExecutionPlanner.this.pagesIndexFactory, LocalExecutionPlanner.this.hashStrategyCompiler, LocalExecutionPlanner.this.blockTypeOperators);
            indexLookupSourceFactory.setTaskContext(context.taskContext);
            JoinBridgeManager<IndexLookupSourceFactory> lookupSourceFactoryManager = new JoinBridgeManager<IndexLookupSourceFactory>(false, indexLookupSourceFactory, indexLookupSourceFactory.getOutputTypes());
            ImmutableMap.Builder outputMappings = ImmutableMap.builder();
            outputMappings.putAll(probeSource.getLayout());
            int offset = probeSource.getTypes().size();
            for (Map.Entry<Symbol, Integer> entry : indexSource.getLayout().entrySet()) {
                Integer input = entry.getValue();
                outputMappings.put((Object)entry.getKey(), (Object)(offset + input));
            }
            OptionalInt totalOperatorsCount = context.getDriverInstanceCount();
            OperatorFactory lookupJoinOperatorFactory = switch (node.getType()) {
                default -> throw new MatchException(null, null);
                case IndexJoinNode.Type.INNER -> OperatorFactories.spillingJoin(JoinOperatorType.innerJoin(false, false), context.getNextOperatorId(), node.getId(), lookupSourceFactoryManager, false, probeSource.getTypes(), probeChannels, probeHashChannel, Optional.empty(), totalOperatorsCount, PartitioningSpillerFactory.unsupportedPartitioningSpillerFactory(), LocalExecutionPlanner.this.typeOperators);
                case IndexJoinNode.Type.SOURCE_OUTER -> OperatorFactories.spillingJoin(JoinOperatorType.probeOuterJoin(false), context.getNextOperatorId(), node.getId(), lookupSourceFactoryManager, false, probeSource.getTypes(), probeChannels, probeHashChannel, Optional.empty(), totalOperatorsCount, PartitioningSpillerFactory.unsupportedPartitioningSpillerFactory(), LocalExecutionPlanner.this.typeOperators);
            };
            return new PhysicalOperation(lookupJoinOperatorFactory, (Map<Symbol, Integer>)outputMappings.buildOrThrow(), probeSource);
        }

        @Override
        public PhysicalOperation visitJoin(JoinNode node, LocalExecutionPlanContext context) {
            Set localDynamicFilters = (Set)node.getDynamicFilters().keySet().stream().filter(LocalExecutionPlanner.getConsumedDynamicFilterIds(node.getLeft())::contains).collect(ImmutableSet.toImmutableSet());
            context.getDynamicFiltersCollector().register(localDynamicFilters);
            if (node.isCrossJoin()) {
                return this.createNestedLoopJoin(node, localDynamicFilters, context);
            }
            List<JoinNode.EquiJoinClause> clauses = node.getCriteria();
            List leftSymbols = Lists.transform(clauses, JoinNode.EquiJoinClause::getLeft);
            List rightSymbols = Lists.transform(clauses, JoinNode.EquiJoinClause::getRight);
            switch (node.getType()) {
                default: {
                    throw new MatchException(null, null);
                }
                case INNER: 
                case LEFT: 
                case RIGHT: 
                case FULL: 
            }
            return this.createLookupJoin(node, node.getLeft(), leftSymbols, node.getLeftHashSymbol(), node.getRight(), rightSymbols, node.getRightHashSymbol(), localDynamicFilters, context);
        }

        @Override
        public PhysicalOperation visitSpatialJoin(SpatialJoinNode node, LocalExecutionPlanContext context) {
            Expression filterExpression = node.getFilter();
            List<Call> spatialFunctions = SpatialJoinUtils.extractSupportedSpatialFunctions(filterExpression);
            for (Call spatialFunction : spatialFunctions) {
                Optional<PhysicalOperation> operation = this.tryCreateSpatialJoin(context, node, this.removeExpressionFromFilter(filterExpression, spatialFunction), spatialFunction, Optional.empty(), Optional.empty());
                if (!operation.isPresent()) continue;
                return operation.get();
            }
            List<Comparison> spatialComparisons = SpatialJoinUtils.extractSupportedSpatialComparisons(filterExpression);
            for (Comparison spatialComparison : spatialComparisons) {
                Expression radius;
                if (spatialComparison.operator() != Comparison.Operator.LESS_THAN && spatialComparison.operator() != Comparison.Operator.LESS_THAN_OR_EQUAL || (!((radius = spatialComparison.right()) instanceof Reference) || !this.getSymbolReferences(node.getRight().getOutputSymbols()).contains(radius)) && !(radius instanceof Constant)) continue;
                Call spatialFunction = (Call)spatialComparison.left();
                Optional<PhysicalOperation> operation = this.tryCreateSpatialJoin(context, node, this.removeExpressionFromFilter(filterExpression, spatialComparison), spatialFunction, Optional.of(radius), Optional.of(spatialComparison.operator()));
                if (!operation.isPresent()) continue;
                return operation.get();
            }
            throw new VerifyException("No valid spatial relationship found for spatial join");
        }

        private Optional<PhysicalOperation> tryCreateSpatialJoin(LocalExecutionPlanContext context, SpatialJoinNode node, Optional<Expression> filterExpression, Call spatialFunction, Optional<Expression> radius, Optional<Comparison.Operator> comparisonOperator) {
            Reference firstSymbol;
            Expression expression;
            block11: {
                block10: {
                    List<Expression> arguments = spatialFunction.arguments();
                    Verify.verify((arguments.size() == 2 ? 1 : 0) != 0);
                    expression = arguments.get(0);
                    if (!(expression instanceof Reference)) break block10;
                    firstSymbol = (Reference)expression;
                    expression = arguments.get(1);
                    if (expression instanceof Reference) break block11;
                }
                return Optional.empty();
            }
            Reference secondSymbol = (Reference)expression;
            PlanNode probeNode = node.getLeft();
            Set<Reference> probeSymbols = this.getSymbolReferences(probeNode.getOutputSymbols());
            PlanNode buildNode = node.getRight();
            Set<Reference> buildSymbols = this.getSymbolReferences(buildNode.getOutputSymbols());
            Optional<Symbol> radiusSymbol = Optional.empty();
            OptionalDouble constantRadius = OptionalDouble.empty();
            if (radius.isPresent()) {
                Expression expression2 = radius.get();
                if (expression2 instanceof Reference) {
                    Reference reference = (Reference)expression2;
                    radiusSymbol = Optional.of(Symbol.from(reference));
                } else if (expression2 instanceof Constant) {
                    Constant constant = (Constant)expression2;
                    constantRadius = OptionalDouble.of((Double)constant.value());
                } else {
                    throw new IllegalArgumentException("Unexpected expression for radius: " + String.valueOf(expression2));
                }
            }
            if (probeSymbols.contains(firstSymbol) && buildSymbols.contains(secondSymbol)) {
                return Optional.of(this.createSpatialLookupJoin(node, probeNode, Symbol.from(firstSymbol), buildNode, Symbol.from(secondSymbol), radiusSymbol, constantRadius, this.spatialTest(spatialFunction, true, comparisonOperator), filterExpression, context));
            }
            if (probeSymbols.contains(secondSymbol) && buildSymbols.contains(firstSymbol)) {
                return Optional.of(this.createSpatialLookupJoin(node, probeNode, Symbol.from(secondSymbol), buildNode, Symbol.from(firstSymbol), radiusSymbol, constantRadius, this.spatialTest(spatialFunction, false, comparisonOperator), filterExpression, context));
            }
            return Optional.empty();
        }

        private Optional<Expression> removeExpressionFromFilter(Expression filter, Expression expression) {
            Expression updatedJoinFilter = ExpressionNodeInliner.replaceExpression(filter, (Map<? extends Expression, ? extends Expression>)ImmutableMap.of((Object)expression, (Object)Booleans.TRUE));
            return updatedJoinFilter.equals(Booleans.TRUE) ? Optional.empty() : Optional.of(updatedJoinFilter);
        }

        private SpatialIndexBuilderOperator.SpatialPredicate spatialTest(Call call, boolean probeFirst, Optional<Comparison.Operator> comparisonOperator) {
            CatalogSchemaFunctionName functionName = call.function().name();
            if (functionName.equals((Object)GlobalFunctionCatalog.builtinFunctionName("st_contains"))) {
                if (probeFirst) {
                    return (buildGeometry, probeGeometry, radius) -> probeGeometry.contains(buildGeometry);
                }
                return (buildGeometry, probeGeometry, radius) -> buildGeometry.contains(probeGeometry);
            }
            if (functionName.equals((Object)GlobalFunctionCatalog.builtinFunctionName("st_within"))) {
                if (probeFirst) {
                    return (buildGeometry, probeGeometry, radius) -> probeGeometry.within(buildGeometry);
                }
                return (buildGeometry, probeGeometry, radius) -> buildGeometry.within(probeGeometry);
            }
            if (functionName.equals((Object)GlobalFunctionCatalog.builtinFunctionName("st_intersects"))) {
                return (buildGeometry, probeGeometry, radius) -> buildGeometry.intersects(probeGeometry);
            }
            if (functionName.equals((Object)GlobalFunctionCatalog.builtinFunctionName("st_distance"))) {
                if (comparisonOperator.orElseThrow() == Comparison.Operator.LESS_THAN) {
                    return (buildGeometry, probeGeometry, radius) -> buildGeometry.distance(probeGeometry) < radius.getAsDouble();
                }
                if (comparisonOperator.get() == Comparison.Operator.LESS_THAN_OR_EQUAL) {
                    return (buildGeometry, probeGeometry, radius) -> buildGeometry.distance(probeGeometry) <= radius.getAsDouble();
                }
                throw new UnsupportedOperationException("Unsupported comparison operator: " + String.valueOf((Object)comparisonOperator.get()));
            }
            throw new UnsupportedOperationException("Unsupported spatial function: " + String.valueOf(functionName));
        }

        private Set<Reference> getSymbolReferences(Collection<Symbol> symbols) {
            return (Set)symbols.stream().map(Symbol::toSymbolReference).collect(ImmutableSet.toImmutableSet());
        }

        private PhysicalOperation createNestedLoopJoin(JoinNode node, Set<DynamicFilterId> localDynamicFilters, LocalExecutionPlanContext context) {
            PhysicalOperation probeSource = node.getLeft().accept(this, context);
            LocalExecutionPlanContext buildContext = context.createSubContext();
            PhysicalOperation buildSource = node.getRight().accept(this, buildContext);
            Preconditions.checkArgument((node.getType() == JoinType.INNER ? 1 : 0) != 0, (Object)"NestedLoopJoin is only used for inner join");
            JoinBridgeManager<NestedLoopJoinBridge> nestedLoopJoinBridgeManager = new JoinBridgeManager<NestedLoopJoinBridge>(false, new NestedLoopJoinPagesSupplier(), buildSource.getTypes());
            NestedLoopBuildOperator.NestedLoopBuildOperatorFactory nestedLoopBuildOperatorFactory = new NestedLoopBuildOperator.NestedLoopBuildOperatorFactory(buildContext.getNextOperatorId(), node.getId(), nestedLoopJoinBridgeManager);
            int partitionCount = buildContext.getDriverInstanceCount().orElse(1);
            Preconditions.checkArgument((partitionCount == 1 ? 1 : 0) != 0, (Object)"Expected local execution to not be parallel");
            int operatorId = buildContext.getNextOperatorId();
            boolean partitioned = !JoinUtils.isBuildSideReplicated(node);
            Optional<LocalDynamicFilterConsumer> localDynamicFilter = this.createDynamicFilter(buildSource, node, context, localDynamicFilters, partitioned);
            if (localDynamicFilter.isPresent()) {
                buildSource = this.createDynamicFilterSourceOperatorFactory(operatorId, localDynamicFilter.get(), node, partitioned, buildContext.getDriverInstanceCount().orElse(1) == 1, buildSource);
            }
            context.addDriverFactory(false, new PhysicalOperation((OperatorFactory)nestedLoopBuildOperatorFactory, buildSource), buildContext);
            ImmutableMap.Builder outputMappings = ImmutableMap.builder();
            List<Symbol> outputSymbols = node.getOutputSymbols();
            for (int i = 0; i < outputSymbols.size(); ++i) {
                Symbol symbol = outputSymbols.get(i);
                outputMappings.put((Object)symbol, (Object)i);
            }
            List<Integer> probeChannels = LocalExecutionPlanner.getChannelsForSymbols(node.getLeftOutputSymbols(), probeSource.getLayout());
            List<Integer> buildChannels = LocalExecutionPlanner.getChannelsForSymbols(node.getRightOutputSymbols(), buildSource.getLayout());
            NestedLoopJoinOperator.NestedLoopJoinOperatorFactory operatorFactory = new NestedLoopJoinOperator.NestedLoopJoinOperatorFactory(context.getNextOperatorId(), node.getId(), nestedLoopJoinBridgeManager, probeChannels, buildChannels);
            return new PhysicalOperation((OperatorFactory)operatorFactory, (Map<Symbol, Integer>)outputMappings.buildOrThrow(), probeSource);
        }

        private PhysicalOperation createSpatialLookupJoin(SpatialJoinNode node, PlanNode probeNode, Symbol probeSymbol, PlanNode buildNode, Symbol buildSymbol, Optional<Symbol> radiusSymbol, OptionalDouble constantRadius, SpatialIndexBuilderOperator.SpatialPredicate spatialRelationshipTest, Optional<Expression> joinFilter, LocalExecutionPlanContext context) {
            PhysicalOperation probeSource = probeNode.accept(this, context);
            PagesSpatialIndexFactory pagesSpatialIndexFactory = this.createPagesSpatialIndexFactory(node, buildNode, buildSymbol, radiusSymbol, constantRadius, probeSource.getLayout(), spatialRelationshipTest, joinFilter, context);
            OperatorFactory operator = this.createSpatialLookupJoin(node, probeNode, probeSource, probeSymbol, pagesSpatialIndexFactory, context);
            ImmutableMap.Builder outputMappings = ImmutableMap.builder();
            List<Symbol> outputSymbols = node.getOutputSymbols();
            for (int i = 0; i < outputSymbols.size(); ++i) {
                Symbol symbol = outputSymbols.get(i);
                outputMappings.put((Object)symbol, (Object)i);
            }
            return new PhysicalOperation(operator, (Map<Symbol, Integer>)outputMappings.buildOrThrow(), probeSource);
        }

        private OperatorFactory createSpatialLookupJoin(SpatialJoinNode node, PlanNode probeNode, PhysicalOperation probeSource, Symbol probeSymbol, PagesSpatialIndexFactory pagesSpatialIndexFactory, LocalExecutionPlanContext context) {
            List<Type> probeTypes = probeSource.getTypes();
            List probeOutputSymbols = (List)node.getOutputSymbols().stream().filter(symbol -> probeNode.getOutputSymbols().contains(symbol)).collect(ImmutableList.toImmutableList());
            ImmutableList probeOutputChannels = ImmutableList.copyOf(LocalExecutionPlanner.getChannelsForSymbols(probeOutputSymbols, probeSource.getLayout()));
            Function<Symbol, Integer> probeChannelGetter = LocalExecutionPlanner.channelGetter(probeSource);
            int probeChannel = probeChannelGetter.apply(probeSymbol);
            Optional<Integer> partitionChannel = node.getLeftPartitionSymbol().map(probeChannelGetter);
            return new SpatialJoinOperator.SpatialJoinOperatorFactory(context.getNextOperatorId(), node.getId(), node.getType(), probeTypes, (List<Integer>)probeOutputChannels, probeChannel, partitionChannel, pagesSpatialIndexFactory);
        }

        private PagesSpatialIndexFactory createPagesSpatialIndexFactory(SpatialJoinNode node, PlanNode buildNode, Symbol buildSymbol, Optional<Symbol> radiusSymbol, OptionalDouble constantRadius, Map<Symbol, Integer> probeLayout, SpatialIndexBuilderOperator.SpatialPredicate spatialRelationshipTest, Optional<Expression> joinFilter, LocalExecutionPlanContext context) {
            LocalExecutionPlanContext buildContext = context.createSubContext();
            PhysicalOperation buildSource = buildNode.accept(this, buildContext);
            List buildOutputSymbols = (List)node.getOutputSymbols().stream().filter(symbol -> buildNode.getOutputSymbols().contains(symbol)).collect(ImmutableList.toImmutableList());
            Map<Symbol, Integer> buildLayout = buildSource.getLayout();
            ImmutableList buildOutputChannels = ImmutableList.copyOf(LocalExecutionPlanner.getChannelsForSymbols(buildOutputSymbols, buildLayout));
            Function<Symbol, Integer> buildChannelGetter = LocalExecutionPlanner.channelGetter(buildSource);
            Integer buildChannel = buildChannelGetter.apply(buildSymbol);
            Optional<Integer> radiusChannel = radiusSymbol.map(buildChannelGetter);
            Optional<JoinFilterFunctionCompiler.JoinFilterFunctionFactory> filterFunctionFactory = joinFilter.map(filterExpression -> this.compileJoinFilterFunction((Expression)filterExpression, probeLayout, buildLayout));
            Optional<Integer> partitionChannel = node.getRightPartitionSymbol().map(buildChannelGetter);
            SpatialIndexBuilderOperator.SpatialIndexBuilderOperatorFactory builderOperatorFactory = new SpatialIndexBuilderOperator.SpatialIndexBuilderOperatorFactory(buildContext.getNextOperatorId(), node.getId(), buildSource.getTypes(), (List<Integer>)buildOutputChannels, buildChannel, radiusChannel, constantRadius, partitionChannel, spatialRelationshipTest, node.getKdbTree(), filterFunctionFactory, 10000, LocalExecutionPlanner.this.pagesIndexFactory);
            context.addDriverFactory(false, new PhysicalOperation((OperatorFactory)builderOperatorFactory, buildSource), buildContext);
            return builderOperatorFactory.getPagesSpatialIndexFactory();
        }

        private PhysicalOperation createLookupJoin(JoinNode node, PlanNode probeNode, List<Symbol> probeSymbols, Optional<Symbol> probeHashSymbol, PlanNode buildNode, List<Symbol> buildSymbols, Optional<Symbol> buildHashSymbol, Set<DynamicFilterId> localDynamicFilters, LocalExecutionPlanContext context) {
            OperatorFactory operator;
            PhysicalOperation probeSource = probeNode.accept(this, context);
            boolean buildOuter = node.getType() == JoinType.RIGHT || node.getType() == JoinType.FULL;
            boolean spillEnabled = SystemSessionProperties.isSpillEnabled(this.session) && node.isSpillable().orElseThrow(() -> new IllegalArgumentException("spillable not yet set")) != false && !buildOuter;
            boolean consumedLocalDynamicFilters = !localDynamicFilters.isEmpty();
            List<Type> probeTypes = probeSource.getTypes();
            ImmutableList probeOutputChannels = ImmutableList.copyOf(LocalExecutionPlanner.getChannelsForSymbols(node.getLeftOutputSymbols(), probeSource.getLayout()));
            ImmutableList probeJoinChannels = ImmutableList.copyOf(LocalExecutionPlanner.getChannelsForSymbols(probeSymbols, probeSource.getLayout()));
            OptionalInt probeHashChannel = probeHashSymbol.map(LocalExecutionPlanner.channelGetter(probeSource)).map(OptionalInt::of).orElse(OptionalInt.empty());
            OptionalInt totalOperatorsCount = OptionalInt.empty();
            if (spillEnabled) {
                totalOperatorsCount = context.getDriverInstanceCount();
                Preconditions.checkState((boolean)totalOperatorsCount.isPresent(), (Object)"A fixed distribution is required for JOIN when spilling is enabled");
            }
            boolean outputSingleMatch = node.isMaySkipOutputDuplicates() && ((ImmutableSet)node.getCriteria().stream().map(JoinNode.EquiJoinClause::getRight).collect(ImmutableSet.toImmutableSet())).containsAll(node.getRightOutputSymbols());
            LocalExecutionPlanContext buildContext = context.createSubContext();
            PhysicalOperation buildSource = buildNode.accept(this, buildContext);
            ImmutableList buildOutputChannels = ImmutableList.copyOf(LocalExecutionPlanner.getChannelsForSymbols(node.getRightOutputSymbols(), buildSource.getLayout()));
            ImmutableList buildChannels = ImmutableList.copyOf(LocalExecutionPlanner.getChannelsForSymbols(buildSymbols, buildSource.getLayout()));
            OptionalInt buildHashChannel = buildHashSymbol.map(LocalExecutionPlanner.channelGetter(buildSource)).map(OptionalInt::of).orElse(OptionalInt.empty());
            int partitionCount = buildContext.getDriverInstanceCount().orElse(1);
            Map<Symbol, Integer> buildLayout = buildSource.getLayout();
            Optional<JoinFilterFunctionCompiler.JoinFilterFunctionFactory> filterFunctionFactory = node.getFilter().map(filterExpression -> this.compileJoinFilterFunction((Expression)filterExpression, probeSource.getLayout(), buildLayout));
            Optional<Object> sortExpressionContext = node.getFilter().flatMap(filter -> SortExpressionExtractor.extractSortExpression((Set<Symbol>)ImmutableSet.copyOf(node.getRight().getOutputSymbols()), filter));
            Optional<Integer> sortChannel = sortExpressionContext.map(SortExpressionContext::getSortExpression).map(Symbol::from).map(sortSymbol -> this.createJoinSourcesLayout(buildLayout, probeSource.getLayout()).get(sortSymbol));
            List searchFunctionFactories = (List)sortExpressionContext.map(SortExpressionContext::getSearchExpressions).map(searchExpressions -> (ImmutableList)searchExpressions.stream().map(searchExpression -> this.compileJoinFilterFunction((Expression)searchExpression, probeSource.getLayout(), buildLayout)).collect(ImmutableList.toImmutableList())).orElse(ImmutableList.of());
            ImmutableList buildOutputTypes = (ImmutableList)buildOutputChannels.stream().map(buildSource.getTypes()::get).collect(ImmutableList.toImmutableList());
            List<Type> buildTypes = buildSource.getTypes();
            int operatorId = buildContext.getNextOperatorId();
            boolean partitioned = !JoinUtils.isBuildSideReplicated(node);
            Optional<LocalDynamicFilterConsumer> localDynamicFilter = this.createDynamicFilter(buildSource, node, context, localDynamicFilters, partitioned);
            if (localDynamicFilter.isPresent()) {
                buildSource = this.createDynamicFilterSourceOperatorFactory(operatorId, localDynamicFilter.get(), node, partitioned, buildContext.getDriverInstanceCount().orElse(1) == 1, buildSource);
            }
            int taskConcurrency = SystemSessionProperties.getTaskConcurrency(this.session);
            boolean waitForBuild = consumedLocalDynamicFilters;
            if (LocalExecutionPlanner.this.useSpillingJoinOperator(spillEnabled, this.session)) {
                lookupSourceFactory = new JoinBridgeManager<io.trino.operator.join.PartitionedLookupSourceFactory>(buildOuter, new io.trino.operator.join.PartitionedLookupSourceFactory(buildTypes, (List<Type>)buildOutputTypes, (List)buildChannels.stream().map(buildTypes::get).collect(ImmutableList.toImmutableList()), partitionCount, buildOuter, LocalExecutionPlanner.this.typeOperators), (List<Type>)buildOutputTypes);
                hashBuilderOperatorFactory = new HashBuilderOperator.HashBuilderOperatorFactory(buildContext.getNextOperatorId(), node.getId(), lookupSourceFactory, (List<Integer>)buildOutputChannels, (List<Integer>)buildChannels, buildHashChannel, filterFunctionFactory, sortChannel, searchFunctionFactories, 10000, LocalExecutionPlanner.this.pagesIndexFactory, spillEnabled && partitionCount > 1, LocalExecutionPlanner.this.singleStreamSpillerFactory, HashArraySizeSupplier.incrementalLoadFactorHashArraySizeSupplier(this.session, taskConcurrency / partitionCount));
                context.addDriverFactory(false, new PhysicalOperation(hashBuilderOperatorFactory, buildSource), buildContext);
                joinType = JoinOperatorType.ofJoinNodeType(node.getType(), outputSingleMatch, waitForBuild);
                operator = OperatorFactories.spillingJoin(joinType, context.getNextOperatorId(), node.getId(), lookupSourceFactory, node.getFilter().isPresent(), probeTypes, (List<Integer>)probeJoinChannels, probeHashChannel, Optional.of(probeOutputChannels), totalOperatorsCount, LocalExecutionPlanner.this.partitioningSpillerFactory, LocalExecutionPlanner.this.typeOperators);
            } else {
                lookupSourceFactory = new JoinBridgeManager<PartitionedLookupSourceFactory>(buildOuter, new PartitionedLookupSourceFactory(buildTypes, (List<Type>)buildOutputTypes, (List)buildChannels.stream().map(buildTypes::get).collect(ImmutableList.toImmutableList()), partitionCount, buildOuter, LocalExecutionPlanner.this.typeOperators), (List<Type>)buildOutputTypes);
                hashBuilderOperatorFactory = new HashBuilderOperator.HashBuilderOperatorFactory(buildContext.getNextOperatorId(), node.getId(), lookupSourceFactory, (List<Integer>)buildOutputChannels, (List<Integer>)buildChannels, buildHashChannel, filterFunctionFactory, sortChannel, searchFunctionFactories, 10000, LocalExecutionPlanner.this.pagesIndexFactory, HashArraySizeSupplier.incrementalLoadFactorHashArraySizeSupplier(this.session, taskConcurrency / partitionCount));
                context.addDriverFactory(false, new PhysicalOperation(hashBuilderOperatorFactory, buildSource), buildContext);
                joinType = JoinOperatorType.ofJoinNodeType(node.getType(), outputSingleMatch, waitForBuild);
                operator = OperatorFactories.join(joinType, context.getNextOperatorId(), node.getId(), lookupSourceFactory, node.getFilter().isPresent(), probeTypes, (List<Integer>)probeJoinChannels, probeHashChannel, Optional.of(probeOutputChannels), LocalExecutionPlanner.this.typeOperators);
            }
            ImmutableMap.Builder outputMappings = ImmutableMap.builder();
            List<Symbol> outputSymbols = node.getOutputSymbols();
            for (int i = 0; i < outputSymbols.size(); ++i) {
                Symbol symbol = outputSymbols.get(i);
                outputMappings.put((Object)symbol, (Object)i);
            }
            return new PhysicalOperation(operator, (Map<Symbol, Integer>)outputMappings.buildOrThrow(), probeSource);
        }

        @Override
        public PhysicalOperation visitDynamicFilterSource(DynamicFilterSourceNode node, LocalExecutionPlanContext context) {
            Preconditions.checkState((!node.getDynamicFilters().isEmpty() ? 1 : 0) != 0, (Object)"Dynamic filters cannot be empty in DynamicFilterSourceNode");
            log.debug("[DynamicFilterSource] Dynamic filters: %s", new Object[]{node.getDynamicFilters()});
            PhysicalOperation source = node.getSource().accept(this, context);
            Map dynamicFilterChannels = (Map)node.getDynamicFilters().entrySet().stream().collect(ImmutableMap.toImmutableMap(Map.Entry::getKey, entry -> {
                Symbol buildSymbol = (Symbol)entry.getValue();
                int buildChannelIndex = node.getOutputSymbols().indexOf(buildSymbol);
                Verify.verify((buildChannelIndex >= 0 ? 1 : 0) != 0);
                return buildChannelIndex;
            }));
            Map dynamicFilterChannelTypes = (Map)dynamicFilterChannels.entrySet().stream().collect(ImmutableMap.toImmutableMap(Map.Entry::getKey, entry -> source.getTypes().get((Integer)entry.getValue())));
            TaskContext taskContext = context.getTaskContext();
            LocalDynamicFilterConsumer dynamicFilterSourceConsumer = new LocalDynamicFilterConsumer(dynamicFilterChannels, dynamicFilterChannelTypes, (List<Consumer<Map<DynamicFilterId, Domain>>>)ImmutableList.of(taskContext::updateDomains), LocalExecutionPlanner.this.getDynamicFilteringMaxSizePerOperator(this.session, false));
            return this.createDynamicFilterSourceOperatorFactory(context.getNextOperatorId(), dynamicFilterSourceConsumer, node, false, false, source);
        }

        private PhysicalOperation createDynamicFilterSourceOperatorFactory(int operatorId, LocalDynamicFilterConsumer dynamicFilter, PlanNode node, boolean partitioned, boolean isBuildSideSingle, PhysicalOperation buildSource) {
            List filterBuildChannels = (List)dynamicFilter.getBuildChannels().entrySet().stream().map(entry -> {
                DynamicFilterId filterId = (DynamicFilterId)entry.getKey();
                int index = (Integer)entry.getValue();
                Type type = buildSource.getTypes().get(index);
                return new DynamicFilterSourceOperator.Channel(filterId, type, index);
            }).collect(ImmutableList.toImmutableList());
            int taskConcurrency = SystemSessionProperties.getTaskConcurrency(this.session);
            return new PhysicalOperation((OperatorFactory)new DynamicFilterSourceOperator.DynamicFilterSourceOperatorFactory(operatorId, node.getId(), dynamicFilter, filterBuildChannels, this.multipleIf(LocalExecutionPlanner.this.getDynamicFilteringMaxDistinctValuesPerDriver(this.session, partitioned), taskConcurrency, isBuildSideSingle), this.multipleIf(LocalExecutionPlanner.this.getDynamicFilteringMaxSizePerDriver(this.session, partitioned), taskConcurrency, isBuildSideSingle), this.multipleIf(LocalExecutionPlanner.this.getDynamicFilteringRangeRowLimitPerDriver(this.session, partitioned), taskConcurrency, isBuildSideSingle), LocalExecutionPlanner.this.typeOperators), buildSource.getLayout(), buildSource);
        }

        private int multipleIf(int value, int multiplier, boolean shouldMultiply) {
            return shouldMultiply ? value * multiplier : value;
        }

        private DataSize multipleIf(DataSize value, int multiplier, boolean shouldMultiply) {
            return shouldMultiply ? DataSize.ofBytes((long)(value.toBytes() * (long)multiplier)) : value;
        }

        private Optional<LocalDynamicFilterConsumer> createDynamicFilter(PhysicalOperation buildSource, JoinNode node, LocalExecutionPlanContext context, Set<DynamicFilterId> localDynamicFilters, boolean partitioned) {
            Set<DynamicFilterId> coordinatorDynamicFilters = Visitor.getCoordinatorDynamicFilters(node.getDynamicFilters().keySet(), node, context.getTaskId());
            ImmutableSet collectedDynamicFilters = ImmutableSet.builder().addAll(localDynamicFilters).addAll(coordinatorDynamicFilters).build();
            if (collectedDynamicFilters.isEmpty()) {
                return Optional.empty();
            }
            log.debug("[Join] Dynamic filters: %s", new Object[]{node.getDynamicFilters()});
            ImmutableList.Builder collectors = ImmutableList.builder();
            TaskContext taskContext = context.getTaskContext();
            if (!localDynamicFilters.isEmpty()) {
                collectors.add(taskContext::addDynamicFilter);
            }
            if (!coordinatorDynamicFilters.isEmpty()) {
                collectors.add(Visitor.getCoordinatorDynamicFilterDomainsCollector(taskContext, coordinatorDynamicFilters));
            }
            LocalDynamicFilterConsumer filterConsumer = LocalDynamicFilterConsumer.create(node, buildSource.getTypes(), (Set<DynamicFilterId>)collectedDynamicFilters, (List<Consumer<Map<DynamicFilterId, Domain>>>)collectors.build(), LocalExecutionPlanner.this.getDynamicFilteringMaxSizePerOperator(this.session, partitioned));
            return Optional.of(filterConsumer);
        }

        private JoinFilterFunctionCompiler.JoinFilterFunctionFactory compileJoinFilterFunction(Expression filterExpression, Map<Symbol, Integer> probeLayout, Map<Symbol, Integer> buildLayout) {
            Map<Symbol, Integer> joinSourcesLayout = this.createJoinSourcesLayout(buildLayout, probeLayout);
            RowExpression translatedFilter = this.toRowExpression(filterExpression, joinSourcesLayout);
            return LocalExecutionPlanner.this.joinFilterFunctionCompiler.compileJoinFilterFunction(translatedFilter, buildLayout.size());
        }

        private Map<Symbol, Integer> createJoinSourcesLayout(Map<Symbol, Integer> lookupSourceLayout, Map<Symbol, Integer> probeSourceLayout) {
            ImmutableMap.Builder joinSourcesLayout = ImmutableMap.builder();
            joinSourcesLayout.putAll(lookupSourceLayout);
            for (Map.Entry<Symbol, Integer> probeLayoutEntry : probeSourceLayout.entrySet()) {
                joinSourcesLayout.put((Object)probeLayoutEntry.getKey(), (Object)(probeLayoutEntry.getValue() + lookupSourceLayout.size()));
            }
            return joinSourcesLayout.buildOrThrow();
        }

        @Override
        public PhysicalOperation visitSemiJoin(SemiJoinNode node, LocalExecutionPlanContext context) {
            boolean isLocalDynamicFilter = node.getDynamicFilterId().map(filterId -> LocalExecutionPlanner.getConsumedDynamicFilterIds(node.getSource()).contains(filterId)).orElse(false);
            boolean isCoordinatorDynamicFilter = node.getDynamicFilterId().map(filterId -> !Visitor.getCoordinatorDynamicFilters((Set<DynamicFilterId>)ImmutableSet.of((Object)filterId), node, context.getTaskId()).isEmpty()).orElse(false);
            if (isLocalDynamicFilter) {
                context.getDynamicFiltersCollector().register((Set<DynamicFilterId>)ImmutableSet.of((Object)node.getDynamicFilterId().get()));
            }
            PhysicalOperation probeSource = node.getSource().accept(this, context);
            LocalExecutionPlanContext buildContext = context.createSubContext();
            PhysicalOperation buildSource = node.getFilteringSource().accept(this, buildContext);
            int partitionCount = buildContext.getDriverInstanceCount().orElse(1);
            Preconditions.checkArgument((partitionCount == 1 ? 1 : 0) != 0, (Object)"Expected local execution to not be parallel");
            int probeChannel = probeSource.getLayout().get(node.getSourceJoinSymbol());
            int buildChannel = buildSource.getLayout().get(node.getFilteringSourceJoinSymbol());
            int operatorId = buildContext.getNextOperatorId();
            if (isLocalDynamicFilter || isCoordinatorDynamicFilter) {
                DynamicFilterId filterId2 = node.getDynamicFilterId().get();
                log.debug("[Semi-join] Dynamic filter: %s", new Object[]{filterId2});
                ImmutableList.Builder collectors = ImmutableList.builder();
                TaskContext taskContext = context.getTaskContext();
                if (isLocalDynamicFilter) {
                    collectors.add(taskContext::addDynamicFilter);
                }
                if (isCoordinatorDynamicFilter) {
                    collectors.add(Visitor.getCoordinatorDynamicFilterDomainsCollector(taskContext, (Set<DynamicFilterId>)ImmutableSet.of((Object)filterId2)));
                }
                boolean partitioned = !JoinUtils.isBuildSideReplicated(node);
                LocalDynamicFilterConsumer filterConsumer = new LocalDynamicFilterConsumer((Map<DynamicFilterId, Integer>)ImmutableMap.of((Object)filterId2, (Object)buildChannel), (Map<DynamicFilterId, Type>)ImmutableMap.of((Object)filterId2, (Object)buildSource.getTypes().get(buildChannel)), (List<Consumer<Map<DynamicFilterId, Domain>>>)collectors.build(), LocalExecutionPlanner.this.getDynamicFilteringMaxSizePerOperator(this.session, partitioned));
                buildSource = new PhysicalOperation((OperatorFactory)new DynamicFilterSourceOperator.DynamicFilterSourceOperatorFactory(operatorId, node.getId(), filterConsumer, (List<DynamicFilterSourceOperator.Channel>)ImmutableList.of((Object)new DynamicFilterSourceOperator.Channel(filterId2, buildSource.getTypes().get(buildChannel), buildChannel)), LocalExecutionPlanner.this.getDynamicFilteringMaxDistinctValuesPerDriver(this.session, partitioned), LocalExecutionPlanner.this.getDynamicFilteringMaxSizePerDriver(this.session, partitioned), LocalExecutionPlanner.this.getDynamicFilteringRangeRowLimitPerDriver(this.session, partitioned), LocalExecutionPlanner.this.typeOperators), buildSource.getLayout(), buildSource);
            }
            Optional<Integer> buildHashChannel = node.getFilteringSourceHashSymbol().map(LocalExecutionPlanner.channelGetter(buildSource));
            Optional<Integer> probeHashChannel = node.getSourceHashSymbol().map(LocalExecutionPlanner.channelGetter(probeSource));
            SetBuilderOperator.SetBuilderOperatorFactory setBuilderOperatorFactory = new SetBuilderOperator.SetBuilderOperatorFactory(buildContext.getNextOperatorId(), node.getId(), buildSource.getTypes().get(buildChannel), buildChannel, buildHashChannel, 10000, LocalExecutionPlanner.this.joinCompiler, LocalExecutionPlanner.this.typeOperators);
            SetBuilderOperator.SetSupplier setProvider = setBuilderOperatorFactory.getSetProvider();
            context.addDriverFactory(false, new PhysicalOperation((OperatorFactory)setBuilderOperatorFactory, buildSource), buildContext);
            ImmutableMap outputMappings = ImmutableMap.builder().putAll(probeSource.getLayout()).put((Object)node.getSemiJoinOutput(), (Object)probeSource.getLayout().size()).buildOrThrow();
            OperatorFactory operator = HashSemiJoinOperator.createOperatorFactory(context.getNextOperatorId(), node.getId(), setProvider, probeSource.getTypes(), probeChannel, probeHashChannel);
            return new PhysicalOperation(operator, (Map<Symbol, Integer>)outputMappings, probeSource);
        }

        private static Set<DynamicFilterId> getCoordinatorDynamicFilters(Set<DynamicFilterId> dynamicFilters, PlanNode node, TaskId taskId) {
            if (!JoinUtils.isBuildSideReplicated(node) || taskId.getPartitionId() == 0) {
                return dynamicFilters;
            }
            return ImmutableSet.of();
        }

        private static Consumer<Map<DynamicFilterId, Domain>> getCoordinatorDynamicFilterDomainsCollector(TaskContext taskContext, Set<DynamicFilterId> coordinatorDynamicFilters) {
            return domains -> taskContext.updateDomains((Map)domains.entrySet().stream().filter(entry -> coordinatorDynamicFilters.contains(entry.getKey())).collect(ImmutableMap.toImmutableMap(Map.Entry::getKey, Map.Entry::getValue)));
        }

        @Override
        public PhysicalOperation visitRefreshMaterializedView(RefreshMaterializedViewNode node, LocalExecutionPlanContext context) {
            context.setDriverInstanceCount(1);
            RefreshMaterializedViewOperator.RefreshMaterializedViewOperatorFactory operatorFactory = new RefreshMaterializedViewOperator.RefreshMaterializedViewOperatorFactory(context.getNextOperatorId(), node.getId(), LocalExecutionPlanner.this.metadata, node.getViewName());
            return new PhysicalOperation((OperatorFactory)operatorFactory, (Map<Symbol, Integer>)this.makeLayout(node));
        }

        @Override
        public PhysicalOperation visitTableWriter(TableWriterNode node, LocalExecutionPlanContext context) {
            int maxWriterCount = this.getWriterCount(this.session, node.getTarget().getWriterScalingOptions(LocalExecutionPlanner.this.metadata, this.session), node.getPartitioningScheme(), node.getSource());
            context.setDriverInstanceCount(maxWriterCount);
            context.taskContext.setMaxWriterCount(maxWriterCount);
            PhysicalOperation source = node.getSource().accept(this, context);
            ImmutableMap.Builder outputMapping = ImmutableMap.builder();
            outputMapping.put((Object)node.getOutputSymbols().get(0), (Object)0);
            outputMapping.put((Object)node.getOutputSymbols().get(1), (Object)1);
            OperatorFactory statisticsAggregation = node.getStatisticsAggregation().map(aggregation -> {
                List<Symbol> groupingSymbols = aggregation.getGroupingSymbols();
                if (groupingSymbols.isEmpty()) {
                    return this.createAggregationOperatorFactory(node.getId(), aggregation.getAggregations(), AggregationNode.Step.PARTIAL, 2, (ImmutableMap.Builder<Symbol, Integer>)outputMapping, source, context);
                }
                return this.createHashAggregationOperatorFactory(node.getId(), aggregation.getAggregations(), (Set<Integer>)ImmutableSet.of(), groupingSymbols, AggregationNode.Step.PARTIAL, Optional.empty(), Optional.empty(), source, false, false, false, DataSize.ofBytes((long)0L), context, 2, (ImmutableMap.Builder<Symbol, Integer>)outputMapping, 200, Optional.empty());
            }).orElseGet(() -> new DevNullOperator.DevNullOperatorFactory(context.getNextOperatorId(), node.getId()));
            List inputChannels = (List)node.getColumns().stream().map(source::symbolToChannel).collect(ImmutableList.toImmutableList());
            TableWriterOperator.TableWriterOperatorFactory operatorFactory = new TableWriterOperator.TableWriterOperatorFactory(context.getNextOperatorId(), node.getId(), LocalExecutionPlanner.this.pageSinkManager, node.getTarget(), inputChannels, this.session, statisticsAggregation, this.getSymbolTypes(node.getOutputSymbols()));
            return new PhysicalOperation((OperatorFactory)operatorFactory, (Map<Symbol, Integer>)outputMapping.buildOrThrow(), source);
        }

        @Override
        public PhysicalOperation visitStatisticsWriterNode(StatisticsWriterNode node, LocalExecutionPlanContext context) {
            PhysicalOperation source = node.getSource().accept(this, context);
            StatisticAggregationsDescriptor<Integer> descriptor = node.getDescriptor().map(symbol -> source.getLayout().get(symbol));
            StatisticsWriterOperator.StatisticsWriterOperatorFactory operatorFactory = new StatisticsWriterOperator.StatisticsWriterOperatorFactory(context.getNextOperatorId(), node.getId(), computedStatistics -> LocalExecutionPlanner.this.metadata.finishStatisticsCollection(this.session, ((StatisticsWriterNode.WriteStatisticsHandle)node.getTarget()).getHandle(), computedStatistics), node.isRowCountEnabled(), descriptor);
            return new PhysicalOperation((OperatorFactory)operatorFactory, (Map<Symbol, Integer>)this.makeLayout(node), source);
        }

        @Override
        public PhysicalOperation visitTableFinish(TableFinishNode node, LocalExecutionPlanContext context) {
            PhysicalOperation source = node.getSource().accept(this, context);
            ImmutableMap.Builder outputMapping = ImmutableMap.builder();
            OperatorFactory statisticsAggregation = node.getStatisticsAggregation().map(aggregation -> {
                List<Symbol> groupingSymbols = aggregation.getGroupingSymbols();
                if (groupingSymbols.isEmpty()) {
                    return this.createAggregationOperatorFactory(node.getId(), aggregation.getAggregations(), AggregationNode.Step.FINAL, 0, (ImmutableMap.Builder<Symbol, Integer>)outputMapping, source, context);
                }
                return this.createHashAggregationOperatorFactory(node.getId(), aggregation.getAggregations(), (Set<Integer>)ImmutableSet.of(), groupingSymbols, AggregationNode.Step.FINAL, Optional.empty(), Optional.empty(), source, false, false, false, DataSize.ofBytes((long)0L), context, 0, (ImmutableMap.Builder<Symbol, Integer>)outputMapping, 200, Optional.empty());
            }).orElseGet(() -> new DevNullOperator.DevNullOperatorFactory(context.getNextOperatorId(), node.getId()));
            ImmutableMap aggregationOutput = outputMapping.buildOrThrow();
            StatisticAggregationsDescriptor descriptor = node.getStatisticsAggregationDescriptor().map(arg_0 -> Visitor.lambda$visitTableFinish$52((Map)aggregationOutput, arg_0)).orElseGet(StatisticAggregationsDescriptor::empty);
            TableFinishOperator.TableFinishOperatorFactory operatorFactory = new TableFinishOperator.TableFinishOperatorFactory(context.getNextOperatorId(), node.getId(), LocalExecutionPlanner.createTableFinisher(this.session, node, LocalExecutionPlanner.this.metadata), statisticsAggregation, descriptor, LocalExecutionPlanner.this.tableExecuteContextManager, LocalExecutionPlanner.shouldOutputRowCount(node), this.session);
            ImmutableMap layout = ImmutableMap.of((Object)((Symbol)Iterables.getOnlyElement(node.getOutputSymbols())), (Object)0);
            return new PhysicalOperation((OperatorFactory)operatorFactory, (Map<Symbol, Integer>)layout, source);
        }

        @Override
        public PhysicalOperation visitSimpleTableExecuteNode(SimpleTableExecuteNode node, LocalExecutionPlanContext context) {
            context.setDriverInstanceCount(1);
            SimpleTableExecuteOperator.SimpleTableExecuteOperatorOperatorFactory operatorFactory = new SimpleTableExecuteOperator.SimpleTableExecuteOperatorOperatorFactory(context.getNextOperatorId(), node.getId(), LocalExecutionPlanner.this.metadata, this.session, node.getExecuteHandle());
            return new PhysicalOperation((OperatorFactory)operatorFactory, (Map<Symbol, Integer>)this.makeLayout(node));
        }

        @Override
        public PhysicalOperation visitTableExecute(TableExecuteNode node, LocalExecutionPlanContext context) {
            int maxWriterCount = this.getWriterCount(this.session, node.getTarget().getWriterScalingOptions(LocalExecutionPlanner.this.metadata, this.session), node.getPartitioningScheme(), node.getSource());
            context.setDriverInstanceCount(maxWriterCount);
            context.taskContext.setMaxWriterCount(maxWriterCount);
            PhysicalOperation source = node.getSource().accept(this, context);
            ImmutableMap.Builder outputMapping = ImmutableMap.builder();
            outputMapping.put((Object)node.getOutputSymbols().get(0), (Object)0);
            outputMapping.put((Object)node.getOutputSymbols().get(1), (Object)1);
            List inputChannels = (List)node.getColumns().stream().map(source::symbolToChannel).collect(ImmutableList.toImmutableList());
            TableWriterOperator.TableWriterOperatorFactory operatorFactory = new TableWriterOperator.TableWriterOperatorFactory(context.getNextOperatorId(), node.getId(), LocalExecutionPlanner.this.pageSinkManager, node.getTarget(), inputChannels, this.session, new DevNullOperator.DevNullOperatorFactory(context.getNextOperatorId(), node.getId()), this.getSymbolTypes(node.getOutputSymbols()));
            return new PhysicalOperation((OperatorFactory)operatorFactory, (Map<Symbol, Integer>)outputMapping.buildOrThrow(), source);
        }

        private int getWriterCount(Session session, WriterScalingOptions connectorScalingOptions, Optional<PartitioningScheme> partitioningScheme, PlanNode source) {
            if (this.isSingleGatheringExchange(source)) {
                return 1;
            }
            if (partitioningScheme.isPresent()) {
                int partitionedWriterCount = SystemSessionProperties.getTaskMaxWriterCount(session);
                if (this.isLocalScaledWriterExchange(source)) {
                    partitionedWriterCount = connectorScalingOptions.perTaskMaxScaledWriterCount().map(writerCount -> Math.min(writerCount, SystemSessionProperties.getTaskMaxWriterCount(session))).orElse(SystemSessionProperties.getTaskMaxWriterCount(session));
                }
                return LocalExecutionPlanner.this.getPartitionedWriterCountBasedOnMemory(partitionedWriterCount, session);
            }
            int unpartitionedWriterCount = SystemSessionProperties.getTaskMinWriterCount(session);
            if (this.isLocalScaledWriterExchange(source)) {
                unpartitionedWriterCount = connectorScalingOptions.perTaskMaxScaledWriterCount().map(writerCount -> Math.min(writerCount, SystemSessionProperties.getTaskMaxWriterCount(session))).orElse(SystemSessionProperties.getTaskMaxWriterCount(session));
            }
            return Math.min(unpartitionedWriterCount, SkewedPartitionRebalancer.getMaxWritersBasedOnMemory(session));
        }

        private boolean isSingleGatheringExchange(PlanNode node) {
            Optional<PlanNode> result = PlanNodeSearcher.searchFrom(node).where(planNode -> planNode instanceof ExchangeNode).findFirst();
            return result.isPresent() && result.get() instanceof ExchangeNode && ((ExchangeNode)result.get()).getPartitioningScheme().getPartitioning().getHandle().equals(SystemPartitioningHandle.SINGLE_DISTRIBUTION);
        }

        @Override
        public PhysicalOperation visitMergeWriter(MergeWriterNode node, LocalExecutionPlanContext context) {
            int writerCount = node.getPartitioningScheme().map(scheme -> SystemSessionProperties.getTaskMaxWriterCount(this.session)).orElseGet(() -> SystemSessionProperties.getTaskMinWriterCount(this.session));
            context.setDriverInstanceCount(writerCount);
            PhysicalOperation source = node.getSource().accept(this, context);
            Function<Page, Page> pagePreprocessor = LocalExecutionPlanner.enforceLoadedLayoutProcessor(node.getProjectedSymbols(), source.getLayout());
            MergeWriterOperator.MergeWriterOperatorFactory operatorFactory = new MergeWriterOperator.MergeWriterOperatorFactory(context.getNextOperatorId(), node.getId(), LocalExecutionPlanner.this.pageSinkManager, node.getTarget(), this.session, pagePreprocessor);
            return new PhysicalOperation((OperatorFactory)operatorFactory, (Map<Symbol, Integer>)this.makeLayout(node), source);
        }

        @Override
        public PhysicalOperation visitMergeProcessor(MergeProcessorNode node, LocalExecutionPlanContext context) {
            PhysicalOperation source = node.getSource().accept(this, context);
            ImmutableMap<Symbol, Integer> nodeLayout = this.makeLayout(node);
            ImmutableMap<Symbol, Integer> sourceLayout = this.makeLayout(node.getSource());
            int rowIdChannel = (Integer)sourceLayout.get(node.getRowIdSymbol());
            int mergeRowChannel = (Integer)sourceLayout.get(node.getMergeRowSymbol());
            List redistributionColumns = (List)node.getRedistributionColumnSymbols().stream().map(arg_0 -> nodeLayout.get(arg_0)).collect(ImmutableList.toImmutableList());
            List dataColumnChannels = (List)node.getDataColumnSymbols().stream().map(arg_0 -> nodeLayout.get(arg_0)).collect(ImmutableList.toImmutableList());
            List<Symbol> expectedLayout = node.getSource().getOutputSymbols();
            Function<Page, Page> pagePreprocessor = LocalExecutionPlanner.enforceLoadedLayoutProcessor(expectedLayout, source.getLayout());
            OperatorFactory operatorFactory = MergeProcessorOperator.createOperatorFactory(context.getNextOperatorId(), node.getId(), node.getTarget().getMergeParadigmAndTypes(), rowIdChannel, mergeRowChannel, redistributionColumns, dataColumnChannels, pagePreprocessor);
            return new PhysicalOperation(operatorFactory, (Map<Symbol, Integer>)nodeLayout, source);
        }

        @Override
        public PhysicalOperation visitTableDelete(TableDeleteNode node, LocalExecutionPlanContext context) {
            TableMutationOperator.TableMutationOperatorFactory operatorFactory = new TableMutationOperator.TableMutationOperatorFactory(context.getNextOperatorId(), node.getId(), () -> LocalExecutionPlanner.this.metadata.executeDelete(this.session, node.getTarget()));
            return new PhysicalOperation((OperatorFactory)operatorFactory, (Map<Symbol, Integer>)this.makeLayout(node));
        }

        @Override
        public PhysicalOperation visitTableUpdate(TableUpdateNode node, LocalExecutionPlanContext context) {
            TableMutationOperator.TableMutationOperatorFactory operatorFactory = new TableMutationOperator.TableMutationOperatorFactory(context.getNextOperatorId(), node.getId(), () -> LocalExecutionPlanner.this.metadata.executeUpdate(this.session, node.getTarget()));
            return new PhysicalOperation((OperatorFactory)operatorFactory, (Map<Symbol, Integer>)this.makeLayout(node));
        }

        @Override
        public PhysicalOperation visitUnion(UnionNode node, LocalExecutionPlanContext context) {
            throw new UnsupportedOperationException("Union node should not be present in a local execution plan");
        }

        @Override
        public PhysicalOperation visitEnforceSingleRow(EnforceSingleRowNode node, LocalExecutionPlanContext context) {
            PhysicalOperation source = node.getSource().accept(this, context);
            EnforceSingleRowOperator.EnforceSingleRowOperatorFactory operatorFactory = new EnforceSingleRowOperator.EnforceSingleRowOperatorFactory(context.getNextOperatorId(), node.getId(), source.getTypes());
            return new PhysicalOperation((OperatorFactory)operatorFactory, (Map<Symbol, Integer>)this.makeLayout(node), source);
        }

        @Override
        public PhysicalOperation visitAssignUniqueId(AssignUniqueId node, LocalExecutionPlanContext context) {
            PhysicalOperation source = node.getSource().accept(this, context);
            OperatorFactory operatorFactory = AssignUniqueIdOperator.createOperatorFactory(context.getNextOperatorId(), node.getId());
            return new PhysicalOperation(operatorFactory, (Map<Symbol, Integer>)this.makeLayout(node), source);
        }

        @Override
        public PhysicalOperation visitExchange(ExchangeNode node, LocalExecutionPlanContext context) {
            Preconditions.checkArgument((node.getScope() == ExchangeNode.Scope.LOCAL ? 1 : 0) != 0, (Object)"Only local exchanges are supported in the local planner");
            if (node.getOrderingScheme().isPresent()) {
                return this.createLocalMerge(node, context);
            }
            return this.createLocalExchange(node, context);
        }

        private boolean isLocalScaledWriterExchange(PlanNode node) {
            Optional<PlanNode> result = PlanNodeSearcher.searchFrom(node).where(planNode -> planNode instanceof ExchangeNode && ((ExchangeNode)planNode).getScope() == ExchangeNode.Scope.LOCAL).findFirst();
            return result.isPresent() && result.get() instanceof ExchangeNode && ((ExchangeNode)result.get()).getPartitioningScheme().getPartitioning().getHandle().isScaleWriters();
        }

        private PhysicalOperation createLocalMerge(ExchangeNode node, LocalExecutionPlanContext context) {
            Preconditions.checkArgument((boolean)node.getOrderingScheme().isPresent(), (Object)"orderingScheme is absent");
            Preconditions.checkState((node.getSources().size() == 1 ? 1 : 0) != 0, (Object)"single source is expected");
            context.setDriverInstanceCount(1);
            PlanNode sourceNode = (PlanNode)Iterables.getOnlyElement(node.getSources());
            LocalExecutionPlanContext subContext = context.createSubContext();
            PhysicalOperation source = sourceNode.accept(this, subContext);
            int operatorsCount = subContext.getDriverInstanceCount().orElse(1);
            List<Type> types = this.getSourceOperatorTypes(node);
            LocalExchange localExchange = new LocalExchange(LocalExecutionPlanner.this.nodePartitioningManager, this.session, operatorsCount, node.getPartitioningScheme().getPartitioning().getHandle(), (List<Integer>)ImmutableList.of(), (List<Type>)ImmutableList.of(), Optional.empty(), LocalExecutionPlanner.this.maxLocalExchangeBufferSize, LocalExecutionPlanner.this.typeOperators, SystemSessionProperties.getWriterScalingMinDataProcessed(this.session), () -> context.getTaskContext().getQueryMemoryReservation().toBytes());
            List expectedLayout = (List)Iterables.getOnlyElement(node.getInputs());
            Function<Page, Page> pagePreprocessor = LocalExecutionPlanner.enforceLoadedLayoutProcessor(expectedLayout, source.getLayout());
            context.addDriverFactory(false, new PhysicalOperation((OperatorFactory)new LocalExchangeSinkOperator.LocalExchangeSinkOperatorFactory(localExchange.createSinkFactory(), subContext.getNextOperatorId(), node.getId(), pagePreprocessor), source), subContext);
            context.setInputDriver(false);
            OrderingScheme orderingScheme = node.getOrderingScheme().get();
            ImmutableMap<Symbol, Integer> layout = this.makeLayout(node);
            List<Integer> sortChannels = LocalExecutionPlanner.getChannelsForSymbols(orderingScheme.orderBy(), layout);
            List<SortOrder> orderings = orderingScheme.orderingList();
            LocalMergeSourceOperator.LocalMergeSourceOperatorFactory operatorFactory = new LocalMergeSourceOperator.LocalMergeSourceOperatorFactory(context.getNextOperatorId(), node.getId(), localExchange, types, LocalExecutionPlanner.this.orderingCompiler, sortChannels, orderings);
            return new PhysicalOperation((OperatorFactory)operatorFactory, (Map<Symbol, Integer>)layout);
        }

        private PhysicalOperation createLocalExchange(ExchangeNode node, LocalExecutionPlanContext context) {
            PhysicalOperation source;
            int driverInstanceCount;
            if (node.getType() == ExchangeNode.Type.GATHER) {
                driverInstanceCount = 1;
                context.setDriverInstanceCount(1);
            } else if (context.getDriverInstanceCount().isPresent()) {
                driverInstanceCount = context.getDriverInstanceCount().getAsInt();
            } else {
                driverInstanceCount = SystemSessionProperties.getTaskConcurrency(this.session);
                context.setDriverInstanceCount(driverInstanceCount);
            }
            List<Type> types = this.getSourceOperatorTypes(node);
            List partitionChannels = (List)node.getPartitioningScheme().getPartitioning().getArguments().stream().map(argument -> node.getOutputSymbols().indexOf(argument.getColumn())).collect(ImmutableList.toImmutableList());
            Optional<Integer> hashChannel = node.getPartitioningScheme().getHashColumn().map(symbol -> node.getOutputSymbols().indexOf(symbol));
            List partitionChannelTypes = (List)partitionChannels.stream().map(types::get).collect(ImmutableList.toImmutableList());
            ArrayList<DriverFactoryParameters> driverFactoryParametersList = new ArrayList<DriverFactoryParameters>();
            for (int i = 0; i < node.getSources().size(); ++i) {
                PlanNode sourceNode = node.getSources().get(i);
                LocalExecutionPlanContext subContext = context.createSubContext();
                source = sourceNode.accept(this, subContext);
                driverFactoryParametersList.add(new DriverFactoryParameters(subContext, source));
            }
            LocalExchange localExchange = new LocalExchange(LocalExecutionPlanner.this.nodePartitioningManager, this.session, driverInstanceCount, node.getPartitioningScheme().getPartitioning().getHandle(), partitionChannels, partitionChannelTypes, hashChannel, LocalExecutionPlanner.this.maxLocalExchangeBufferSize, LocalExecutionPlanner.this.typeOperators, SystemSessionProperties.getWriterScalingMinDataProcessed(this.session), () -> context.getTaskContext().getQueryMemoryReservation().toBytes());
            for (int i = 0; i < node.getSources().size(); ++i) {
                DriverFactoryParameters driverFactoryParameters = (DriverFactoryParameters)driverFactoryParametersList.get(i);
                source = driverFactoryParameters.getSource();
                LocalExecutionPlanContext subContext = driverFactoryParameters.getSubContext();
                List<Symbol> expectedLayout = node.getInputs().get(i);
                Function<Page, Page> pagePreprocessor = LocalExecutionPlanner.enforceLoadedLayoutProcessor(expectedLayout, source.getLayout());
                context.addDriverFactory(false, new PhysicalOperation((OperatorFactory)new LocalExchangeSinkOperator.LocalExchangeSinkOperatorFactory(localExchange.createSinkFactory(), subContext.getNextOperatorId(), node.getId(), pagePreprocessor), source), subContext);
            }
            context.setInputDriver(false);
            Verify.verify((context.getDriverInstanceCount().getAsInt() == localExchange.getBufferCount() ? 1 : 0) != 0, (String)"driver instance count must match the number of exchange partitions", (Object[])new Object[0]);
            return new PhysicalOperation((OperatorFactory)new LocalExchangeSourceOperator.LocalExchangeSourceOperatorFactory(context.getNextOperatorId(), node.getId(), localExchange), (Map<Symbol, Integer>)this.makeLayout(node));
        }

        @Override
        public PhysicalOperation visitAdaptivePlanNode(AdaptivePlanNode node, LocalExecutionPlanContext context) {
            return node.getCurrentPlan().accept(this, context);
        }

        @Override
        protected PhysicalOperation visitPlan(PlanNode node, LocalExecutionPlanContext context) {
            throw new UnsupportedOperationException("not yet implemented");
        }

        private List<Type> getSourceOperatorTypes(PlanNode node) {
            return this.getSymbolTypes(node.getOutputSymbols());
        }

        private List<Type> getSymbolTypes(List<Symbol> symbols) {
            return (List)symbols.stream().map(Symbol::type).collect(ImmutableList.toImmutableList());
        }

        private AggregatorFactory buildAggregatorFactory(PhysicalOperation source, AggregationNode.Aggregation aggregation, AggregationNode.Step step) {
            ImmutableList intermediateTypes;
            ArrayList<Integer> argumentChannels = new ArrayList<Integer>();
            for (Expression argument : aggregation.getArguments()) {
                if (argument instanceof Lambda) continue;
                Symbol argumentSymbol = Symbol.from(argument);
                argumentChannels.add(source.getLayout().get(argumentSymbol));
            }
            ResolvedFunction resolvedFunction = aggregation.getResolvedFunction();
            AggregationImplementation aggregationImplementation = LocalExecutionPlanner.this.plannerContext.getFunctionManager().getAggregationImplementation(aggregation.getResolvedFunction());
            AccumulatorFactory accumulatorFactory = (AccumulatorFactory)CacheUtils.uncheckedCacheGet(LocalExecutionPlanner.this.accumulatorFactoryCache, (Object)new FunctionKey(resolvedFunction.functionId(), resolvedFunction.signature()), () -> AccumulatorCompiler.generateAccumulatorFactory(resolvedFunction.signature(), aggregationImplementation, resolvedFunction.functionNullability(), LocalExecutionPlanner.this.specializeAggregationLoops));
            if (aggregation.isDistinct()) {
                accumulatorFactory = new DistinctAccumulatorFactory(accumulatorFactory, (List)argumentChannels.stream().map(channel -> source.getTypes().get((int)channel)).collect(ImmutableList.toImmutableList()), LocalExecutionPlanner.this.hashStrategyCompiler, this.session);
            }
            if (aggregation.getOrderingScheme().isPresent()) {
                List inputArgumentChannels = (List)IntStream.range(0, argumentChannels.size()).boxed().collect(ImmutableList.toImmutableList());
                OrderingScheme orderingScheme = aggregation.getOrderingScheme().get();
                List<Symbol> sortKeys = orderingScheme.orderBy();
                List sortOrders = (List)sortKeys.stream().map(orderingScheme::ordering).collect(ImmutableList.toImmutableList());
                ArrayList<Integer> inputOrderByChannels = new ArrayList<Integer>();
                for (int orderByChannel : LocalExecutionPlanner.getChannelsForSymbols(sortKeys, source.getLayout())) {
                    int inputChannel = argumentChannels.indexOf(orderByChannel);
                    if (inputChannel < 0) {
                        inputChannel = argumentChannels.size();
                        argumentChannels.add(orderByChannel);
                    }
                    inputOrderByChannels.add(inputChannel);
                }
                accumulatorFactory = new OrderedAccumulatorFactory(accumulatorFactory, (List)argumentChannels.stream().map(channel -> source.getTypes().get((int)channel)).collect(ImmutableList.toImmutableList()), inputArgumentChannels, inputOrderByChannels, sortOrders, LocalExecutionPlanner.this.pagesIndexFactory);
            }
            RowType intermediateType = (intermediateTypes = (ImmutableList)aggregationImplementation.getAccumulatorStateDescriptors().stream().map(stateDescriptor -> stateDescriptor.getSerializer().getSerializedType()).collect(ImmutableList.toImmutableList())).size() == 1 ? (Type)Iterables.getOnlyElement((Iterable)intermediateTypes) : RowType.anonymous((List)intermediateTypes);
            Type finalType = resolvedFunction.signature().getReturnType();
            OptionalInt maskChannel = aggregation.getMask().stream().mapToInt(value -> source.getLayout().get(value)).findAny();
            List lambdas = (List)aggregation.getArguments().stream().filter(Lambda.class::isInstance).map(Lambda.class::cast).collect(ImmutableList.toImmutableList());
            List functionTypes = (List)resolvedFunction.signature().getArgumentTypes().stream().filter(FunctionType.class::isInstance).map(FunctionType.class::cast).collect(ImmutableList.toImmutableList());
            List<Supplier<Object>> lambdaProviders = this.makeLambdaProviders(lambdas, aggregationImplementation.getLambdaInterfaces(), functionTypes);
            return new AggregatorFactory(accumulatorFactory, step, (Type)intermediateType, finalType, argumentChannels, maskChannel, !aggregation.isDistinct() && aggregation.getOrderingScheme().isEmpty(), lambdaProviders);
        }

        private List<Supplier<Object>> makeLambdaProviders(List<Lambda> lambdas, List<Class<?>> lambdaInterfaces, List<FunctionType> functionTypes) {
            ArrayList<Supplier<Object>> lambdaProviders = new ArrayList<Supplier<Object>>();
            if (!lambdas.isEmpty()) {
                Verify.verify((lambdas.size() == functionTypes.size() ? 1 : 0) != 0);
                Verify.verify((lambdas.size() == lambdaInterfaces.size() ? 1 : 0) != 0);
                for (int i = 0; i < lambdas.size(); ++i) {
                    Lambda lambdaExpression = lambdas.get(i);
                    FunctionType functionType = functionTypes.get(i);
                    Verify.verify((lambdaExpression.arguments().size() == functionType.getArgumentTypes().size() ? 1 : 0) != 0);
                    HashMap<Symbol, Type> lambdaArgumentSymbolTypes = new HashMap<Symbol, Type>();
                    for (int j = 0; j < lambdaExpression.arguments().size(); ++j) {
                        lambdaArgumentSymbolTypes.put(lambdaExpression.arguments().get(j), functionType.getArgumentTypes().get(j));
                    }
                    LambdaDefinitionExpression lambda = (LambdaDefinitionExpression)this.toRowExpression(lambdaExpression, (Map<Symbol, Integer>)ImmutableMap.of());
                    Class<? extends Supplier<Object>> lambdaProviderClass = LambdaBytecodeGenerator.compileLambdaProvider(lambda, LocalExecutionPlanner.this.plannerContext.getFunctionManager(), lambdaInterfaces.get(i));
                    try {
                        lambdaProviders.add(lambdaProviderClass.getConstructor(ConnectorSession.class).newInstance(this.session.toConnectorSession()));
                        continue;
                    }
                    catch (ReflectiveOperationException e) {
                        throw new RuntimeException(e);
                    }
                }
            }
            return lambdaProviders;
        }

        private PhysicalOperation planGlobalAggregation(AggregationNode node, PhysicalOperation source, LocalExecutionPlanContext context) {
            ImmutableMap.Builder outputMappings = ImmutableMap.builder();
            AggregationOperator.AggregationOperatorFactory operatorFactory = this.createAggregationOperatorFactory(node.getId(), node.getAggregations(), node.getStep(), 0, (ImmutableMap.Builder<Symbol, Integer>)outputMappings, source, context);
            return new PhysicalOperation((OperatorFactory)operatorFactory, (Map<Symbol, Integer>)outputMappings.buildOrThrow(), source);
        }

        private AggregationOperator.AggregationOperatorFactory createAggregationOperatorFactory(PlanNodeId planNodeId, Map<Symbol, AggregationNode.Aggregation> aggregations, AggregationNode.Step step, int startOutputChannel, ImmutableMap.Builder<Symbol, Integer> outputMappings, PhysicalOperation source, LocalExecutionPlanContext context) {
            int outputChannel = startOutputChannel;
            ImmutableList.Builder aggregatorFactories = ImmutableList.builder();
            for (Map.Entry<Symbol, AggregationNode.Aggregation> entry : aggregations.entrySet()) {
                Symbol symbol = entry.getKey();
                AggregationNode.Aggregation aggregation = entry.getValue();
                aggregatorFactories.add((Object)this.buildAggregatorFactory(source, aggregation, step));
                outputMappings.put((Object)symbol, (Object)outputChannel);
                ++outputChannel;
            }
            return new AggregationOperator.AggregationOperatorFactory(context.getNextOperatorId(), planNodeId, (List<AggregatorFactory>)aggregatorFactories.build());
        }

        private PhysicalOperation planGroupByAggregation(AggregationNode node, PhysicalOperation source, boolean spillEnabled, DataSize unspillMemoryLimit, LocalExecutionPlanContext context) {
            ImmutableMap.Builder mappings = ImmutableMap.builder();
            OperatorFactory operatorFactory = this.createHashAggregationOperatorFactory(node.getId(), node.getAggregations(), node.getGlobalGroupingSets(), node.getGroupingKeys(), node.getStep(), node.getHashSymbol(), node.getGroupIdSymbol(), source, node.hasDefaultOutput(), spillEnabled, node.isStreamable(), unspillMemoryLimit, context, 0, (ImmutableMap.Builder<Symbol, Integer>)mappings, 10000, Optional.of(LocalExecutionPlanner.this.maxPartialAggregationMemorySize));
            return new PhysicalOperation(operatorFactory, (Map<Symbol, Integer>)mappings.buildOrThrow(), source);
        }

        private OperatorFactory createHashAggregationOperatorFactory(PlanNodeId planNodeId, Map<Symbol, AggregationNode.Aggregation> aggregations, Set<Integer> globalGroupingSets, List<Symbol> groupBySymbols, AggregationNode.Step step, Optional<Symbol> hashSymbol, Optional<Symbol> groupIdSymbol, PhysicalOperation source, boolean hasDefaultOutput, boolean spillEnabled, boolean isStreamable, DataSize unspillMemoryLimit, LocalExecutionPlanContext context, int startOutputChannel, ImmutableMap.Builder<Symbol, Integer> outputMappings, int expectedGroups, Optional<DataSize> maxPartialAggregationMemorySize) {
            ArrayList aggregationOutputSymbols = new ArrayList();
            ArrayList<AggregatorFactory> aggregatorFactories = new ArrayList<AggregatorFactory>();
            for (Map.Entry<Symbol, AggregationNode.Aggregation> entry2 : aggregations.entrySet()) {
                Iterator symbol = entry2.getKey();
                AggregationNode.Aggregation aggregation = entry2.getValue();
                aggregatorFactories.add(this.buildAggregatorFactory(source, aggregation, step));
                aggregationOutputSymbols.add(symbol);
            }
            int channel = startOutputChannel;
            Optional<Integer> groupIdChannel = Optional.empty();
            for (Symbol symbol : groupBySymbols) {
                outputMappings.put((Object)symbol, (Object)channel);
                if (groupIdSymbol.isPresent() && groupIdSymbol.get().equals(symbol)) {
                    groupIdChannel = Optional.of(channel);
                }
                ++channel;
            }
            if (hashSymbol.isPresent()) {
                outputMappings.put((Object)hashSymbol.get(), (Object)channel++);
            }
            for (Symbol symbol : aggregationOutputSymbols) {
                outputMappings.put((Object)symbol, (Object)channel);
                ++channel;
            }
            List<Integer> groupByChannels = LocalExecutionPlanner.getChannelsForSymbols(groupBySymbols, source.getLayout());
            List list = (List)groupByChannels.stream().map(entry -> source.getTypes().get((int)entry)).collect(ImmutableList.toImmutableList());
            if (isStreamable) {
                return StreamingAggregationOperator.createOperatorFactory(context.getNextOperatorId(), planNodeId, source.getTypes(), list, groupByChannels, aggregatorFactories, LocalExecutionPlanner.this.joinCompiler);
            }
            Optional<Integer> hashChannel = hashSymbol.map(LocalExecutionPlanner.channelGetter(source));
            return new HashAggregationOperator.HashAggregationOperatorFactory(context.getNextOperatorId(), planNodeId, list, groupByChannels, (List<Integer>)ImmutableList.copyOf(globalGroupingSets), step, hasDefaultOutput, aggregatorFactories, hashChannel, groupIdChannel, expectedGroups, maxPartialAggregationMemorySize, spillEnabled, unspillMemoryLimit, LocalExecutionPlanner.this.spillerFactory, LocalExecutionPlanner.this.hashStrategyCompiler, LocalExecutionPlanner.this.typeOperators, LocalExecutionPlanner.createPartialAggregationController(maxPartialAggregationMemorySize, step, this.session));
        }

        private static /* synthetic */ StatisticAggregationsDescriptor lambda$visitTableFinish$52(Map aggregationOutput, StatisticAggregationsDescriptor desc) {
            return desc.map(aggregationOutput::get);
        }

        private /* synthetic */ RecordSet lambda$visitIndexSource$19(List overlappingFieldSets, List remappedProbeKeyChannels, RecordSet recordSet) {
            if (!overlappingFieldSets.isEmpty()) {
                recordSet = new FieldSetFilteringRecordSet(LocalExecutionPlanner.this.plannerContext.getTypeOperators(), recordSet, overlappingFieldSets);
            }
            return new MappedRecordSet(recordSet, remappedProbeKeyChannels);
        }
    }

    private static class PhysicalOperation {
        private final List<OperatorFactory> operatorFactories;
        private final Map<Symbol, Integer> layout;
        private final List<Type> types;

        public PhysicalOperation(OperatorFactory operatorFactory, Map<Symbol, Integer> layout) {
            this(operatorFactory, layout, Optional.empty());
        }

        public PhysicalOperation(OperatorFactory operatorFactory, Map<Symbol, Integer> layout, PhysicalOperation source) {
            this(operatorFactory, layout, Optional.of(Objects.requireNonNull(source, "source is null")));
        }

        public PhysicalOperation(OperatorFactory outputOperatorFactory, PhysicalOperation source) {
            this(outputOperatorFactory, (Map<Symbol, Integer>)ImmutableMap.of(), Optional.of(Objects.requireNonNull(source, "source is null")));
        }

        private PhysicalOperation(OperatorFactory operatorFactory, Map<Symbol, Integer> layout, Optional<PhysicalOperation> source) {
            Objects.requireNonNull(operatorFactory, "operatorFactory is null");
            Objects.requireNonNull(layout, "layout is null");
            Objects.requireNonNull(source, "source is null");
            this.types = PhysicalOperation.toTypes(layout);
            this.operatorFactories = ImmutableList.builder().addAll((Iterable)source.map(PhysicalOperation::getOperatorFactories).orElse((List)ImmutableList.of())).add((Object)operatorFactory).build();
            this.layout = ImmutableMap.copyOf(layout);
        }

        private static List<Type> toTypes(Map<Symbol, Integer> layout) {
            int channelCount = layout.values().stream().mapToInt(Integer::intValue).max().orElse(-1) + 1;
            Preconditions.checkArgument((layout.size() == channelCount && ImmutableSet.copyOf(layout.values()).containsAll((Collection)ContiguousSet.create((Range)Range.closedOpen((Comparable)Integer.valueOf(0), (Comparable)Integer.valueOf(channelCount)), (DiscreteDomain)DiscreteDomain.integers())) ? 1 : 0) != 0, (String)"Layout does not have a symbol for every output channel: %s", layout);
            ImmutableBiMap channelLayout = ImmutableBiMap.copyOf(layout).inverse();
            return (List)IntStream.range(0, channelCount).mapToObj(((Map)channelLayout)::get).map(symbol -> symbol.type()).collect(ImmutableList.toImmutableList());
        }

        public int symbolToChannel(Symbol input) {
            Preconditions.checkArgument((boolean)this.layout.containsKey(input));
            return this.layout.get(input);
        }

        public List<Type> getTypes() {
            return this.types;
        }

        public Map<Symbol, Integer> getLayout() {
            return this.layout;
        }

        private List<OperatorFactory> getOperatorFactories() {
            return this.operatorFactories;
        }
    }

    private static class FunctionKey {
        private final FunctionId functionId;
        private final BoundSignature boundSignature;

        public FunctionKey(FunctionId functionId, BoundSignature boundSignature) {
            this.functionId = Objects.requireNonNull(functionId, "functionId is null");
            this.boundSignature = Objects.requireNonNull(boundSignature, "boundSignature is null");
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            FunctionKey that = (FunctionKey)o;
            return this.functionId.equals((Object)that.functionId) && this.boundSignature.equals((Object)that.boundSignature);
        }

        public int hashCode() {
            return Objects.hash(this.functionId, this.boundSignature);
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("functionId", (Object)this.functionId).add("boundSignature", (Object)this.boundSignature).toString();
        }
    }

    public static class MatchAggregationLabelDependency {
        private final Set<Integer> labels;
        private final boolean classifierInvolved;

        public MatchAggregationLabelDependency(Set<Integer> labels, boolean classifierInvolved) {
            this.labels = labels;
            this.classifierInvolved = classifierInvolved;
        }

        public Set<Integer> getLabels() {
            return this.labels;
        }

        public boolean isClassifierInvolved() {
            return this.classifierInvolved;
        }
    }

    private static class ValueAccessors {
        private final List<PhysicalValueAccessor> valueAccessors;
        private final List<MatchAggregation.MatchAggregationInstantiator> aggregations;
        private final int aggregationIndex;
        private final List<ArgumentComputation.ArgumentComputationSupplier> aggregationArguments;
        private final int firstUnusedChannel;
        private final List<MatchAggregationLabelDependency> labelDependencies;

        public ValueAccessors(List<PhysicalValueAccessor> valueAccessors, List<MatchAggregation.MatchAggregationInstantiator> aggregations, int aggregationIndex, List<ArgumentComputation.ArgumentComputationSupplier> aggregationArguments, int firstUnusedChannel, List<MatchAggregationLabelDependency> labelDependencies) {
            this.valueAccessors = valueAccessors;
            this.aggregations = aggregations;
            this.aggregationIndex = aggregationIndex;
            this.aggregationArguments = aggregationArguments;
            this.firstUnusedChannel = firstUnusedChannel;
            this.labelDependencies = labelDependencies;
        }

        public List<PhysicalValueAccessor> getValueAccessors() {
            return this.valueAccessors;
        }

        public List<MatchAggregation.MatchAggregationInstantiator> getAggregations() {
            return this.aggregations;
        }

        public int getAggregationIndex() {
            return this.aggregationIndex;
        }

        public List<ArgumentComputation.ArgumentComputationSupplier> getAggregationArguments() {
            return this.aggregationArguments;
        }

        public int getFirstUnusedChannel() {
            return this.firstUnusedChannel;
        }

        public List<MatchAggregationLabelDependency> getLabelDependencies() {
            return this.labelDependencies;
        }
    }

    private static class DriverFactoryParameters {
        private final LocalExecutionPlanContext subContext;
        private final PhysicalOperation source;

        public DriverFactoryParameters(LocalExecutionPlanContext subContext, PhysicalOperation source) {
            this.subContext = subContext;
            this.source = source;
        }

        public LocalExecutionPlanContext getSubContext() {
            return this.subContext;
        }

        public PhysicalOperation getSource() {
            return this.source;
        }
    }

    private static class IndexSourceContext {
        private final SetMultimap<Symbol, Integer> indexLookupToProbeInput;

        public IndexSourceContext(SetMultimap<Symbol, Integer> indexLookupToProbeInput) {
            this.indexLookupToProbeInput = ImmutableSetMultimap.copyOf((Multimap)((Multimap)Objects.requireNonNull(indexLookupToProbeInput, "indexLookupToProbeInput is null")));
        }

        private SetMultimap<Symbol, Integer> getIndexLookupToProbeInput() {
            return this.indexLookupToProbeInput;
        }
    }
}

