/*
 * Decompiled with CFR 0.152.
 */
package io.trino.type;

import com.fasterxml.jackson.annotation.JsonValue;
import io.trino.client.IntervalDayTime;
import java.util.Objects;

public class SqlIntervalDayTime {
    private final long milliSeconds;

    public SqlIntervalDayTime(long milliSeconds) {
        this.milliSeconds = milliSeconds;
    }

    public SqlIntervalDayTime(int day, int hour, int minute, int second, int millis) {
        this.milliSeconds = IntervalDayTime.toMillis((long)day, (long)hour, (long)minute, (long)second, (long)millis);
    }

    public int hashCode() {
        return Objects.hash(this.milliSeconds);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        SqlIntervalDayTime other = (SqlIntervalDayTime)obj;
        return this.milliSeconds == other.milliSeconds;
    }

    @JsonValue
    public String toString() {
        return IntervalDayTime.formatMillis((long)this.milliSeconds);
    }

    public long getMillis() {
        return this.milliSeconds;
    }
}

