/*
 * Decompiled with CFR 0.152.
 */
package io.trino.connector;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.airlift.configuration.testing.ConfigAssertions;
import io.trino.connector.FileCatalogStoreConfig;
import java.io.File;
import java.util.List;
import java.util.Map;
import org.junit.jupiter.api.Test;

public class TestFileCatalogStoreConfig {
    @Test
    public void testDefaults() {
        ConfigAssertions.assertRecordedDefaults((Object)((FileCatalogStoreConfig)ConfigAssertions.recordDefaults(FileCatalogStoreConfig.class)).setCatalogConfigurationDir(new File("etc/catalog")).setDisabledCatalogs((String)null).setReadOnly(false));
    }

    @Test
    public void testExplicitPropertyMappings() {
        ImmutableMap properties = ImmutableMap.builder().put((Object)"catalog.config-dir", (Object)"/foo").put((Object)"catalog.disabled-catalogs", (Object)"abc,xyz").put((Object)"catalog.read-only", (Object)"true").buildOrThrow();
        FileCatalogStoreConfig expected = new FileCatalogStoreConfig().setCatalogConfigurationDir(new File("/foo")).setDisabledCatalogs((List)ImmutableList.of((Object)"abc", (Object)"xyz")).setReadOnly(true);
        ConfigAssertions.assertFullMapping((Map)properties, (Object)expected);
    }
}

