/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator;

import io.trino.operator.IncrementalLoadFactorHashArraySizeSupplier;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestIncrementalLoadFactorHashArraySizeSupplier {
    @Test
    public void testSizeIncreasesMonotonically() {
        IncrementalLoadFactorHashArraySizeSupplier sizeSupplier = new IncrementalLoadFactorHashArraySizeSupplier(1);
        IncrementalLoadFactorHashArraySizeSupplier sizeSupplierWithMultiplier = new IncrementalLoadFactorHashArraySizeSupplier(4);
        int previousSize = sizeSupplier.getHashArraySize(65535);
        previousSize = this.assertHashArraySizeIncreases(65536, previousSize, sizeSupplier, sizeSupplierWithMultiplier);
        previousSize = this.assertHashArraySizeIncreases(65537, previousSize, sizeSupplier, sizeSupplierWithMultiplier);
        previousSize = this.assertHashArraySizeIncreases(1048575, previousSize, sizeSupplier, sizeSupplierWithMultiplier);
        previousSize = this.assertHashArraySizeIncreases(0x100000, previousSize, sizeSupplier, sizeSupplierWithMultiplier);
        this.assertHashArraySizeIncreases(0x100001, previousSize, sizeSupplier, sizeSupplierWithMultiplier);
    }

    private int assertHashArraySizeIncreases(int expectedCount, int previousSize, IncrementalLoadFactorHashArraySizeSupplier sizeSupplier, IncrementalLoadFactorHashArraySizeSupplier sizeSupplierWithMultiplier) {
        int size = sizeSupplier.getHashArraySize(expectedCount);
        io.airlift.testing.Assertions.assertGreaterThanOrEqual((Comparable)Integer.valueOf(size), (Comparable)Integer.valueOf(previousSize));
        Assertions.assertThat((int)(sizeSupplier.getHashArraySize(expectedCount) * 4)).isEqualTo(sizeSupplierWithMultiplier.getHashArraySize(expectedCount * 4));
        return size;
    }
}

