/*
 * Decompiled with CFR 0.152.
 */
package io.trino.spiller;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterators;
import com.google.common.io.MoreFiles;
import com.google.common.io.RecursiveDeleteOption;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.common.util.concurrent.MoreExecutors;
import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import io.trino.execution.buffer.CompressionCodec;
import io.trino.execution.buffer.PagesSerdeUtil;
import io.trino.memory.context.AggregatedMemoryContext;
import io.trino.memory.context.LocalMemoryContext;
import io.trino.operator.PageAssertions;
import io.trino.spi.Page;
import io.trino.spi.block.Block;
import io.trino.spi.block.BlockBuilder;
import io.trino.spi.block.BlockEncodingSerde;
import io.trino.spi.block.TestingBlockEncodingSerde;
import io.trino.spi.block.VariableWidthBlockBuilder;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.DoubleType;
import io.trino.spi.type.Type;
import io.trino.spi.type.VarbinaryType;
import io.trino.spiller.FileSingleStreamSpiller;
import io.trino.spiller.FileSingleStreamSpillerFactory;
import io.trino.spiller.SingleStreamSpiller;
import io.trino.spiller.SpillerStats;
import java.io.File;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInstance;
import org.junit.jupiter.api.parallel.Execution;
import org.junit.jupiter.api.parallel.ExecutionMode;

@TestInstance(value=TestInstance.Lifecycle.PER_CLASS)
@Execution(value=ExecutionMode.CONCURRENT)
public class TestFileSingleStreamSpiller {
    private static final List<Type> TYPES = ImmutableList.of((Object)BigintType.BIGINT, (Object)DoubleType.DOUBLE, (Object)VarbinaryType.VARBINARY);
    private final ListeningExecutorService executor = MoreExecutors.listeningDecorator((ExecutorService)Executors.newCachedThreadPool());

    @AfterAll
    public void tearDown() throws Exception {
        this.executor.shutdown();
    }

    @Test
    public void testSpill() throws Exception {
        this.assertSpill(CompressionCodec.NONE, false);
    }

    @Test
    public void testSpillCompression() throws Exception {
        this.assertSpill(CompressionCodec.LZ4, false);
    }

    @Test
    public void testSpillEncryption() throws Exception {
        this.assertSpill(CompressionCodec.NONE, true);
    }

    @Test
    public void testSpillEncryptionWithCompression() throws Exception {
        this.assertSpill(CompressionCodec.LZ4, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void assertSpill(CompressionCodec compressionCodec, boolean encryption) throws Exception {
        File spillPath = Files.createTempDirectory("tmp", new FileAttribute[0]).toFile();
        try {
            FileSingleStreamSpillerFactory spillerFactory = new FileSingleStreamSpillerFactory(this.executor, (BlockEncodingSerde)new TestingBlockEncodingSerde(), new SpillerStats(), (List)ImmutableList.of((Object)spillPath.toPath()), 1.0, compressionCodec, encryption);
            LocalMemoryContext memoryContext = AggregatedMemoryContext.newSimpleAggregatedMemoryContext().newLocalMemoryContext("test");
            SingleStreamSpiller singleStreamSpiller = spillerFactory.create(TYPES, bytes -> {}, memoryContext);
            Assertions.assertThat((boolean)(singleStreamSpiller instanceof FileSingleStreamSpiller)).isTrue();
            FileSingleStreamSpiller spiller = (FileSingleStreamSpiller)singleStreamSpiller;
            Page page = this.buildPage();
            Assertions.assertThat((long)memoryContext.getBytes()).isEqualTo(4096L);
            spiller.spill(page).get();
            spiller.spill((Iterator)Iterators.forArray((Object[])new Page[]{page, page, page})).get();
            Assertions.assertThat((int)MoreFiles.listFiles((Path)spillPath.toPath()).size()).isEqualTo(1);
            try (InputStream is = Files.newInputStream((Path)MoreFiles.listFiles((Path)spillPath.toPath()).get(0), new OpenOption[0]);){
                Iterator serializedPages = PagesSerdeUtil.readSerializedPages((InputStream)is);
                ((AbstractBooleanAssert)Assertions.assertThat((boolean)serializedPages.hasNext()).describedAs("at least one page should be successfully read back", new Object[0])).isTrue();
                Slice serializedPage = (Slice)serializedPages.next();
                Assertions.assertThat((boolean)PagesSerdeUtil.isSerializedPageCompressed((Slice)serializedPage)).isEqualTo(compressionCodec == CompressionCodec.LZ4);
                Assertions.assertThat((boolean)PagesSerdeUtil.isSerializedPageEncrypted((Slice)serializedPage)).isEqualTo(encryption);
            }
            Iterator spilledPagesIterator = spiller.getSpilledPages();
            Assertions.assertThat((long)memoryContext.getBytes()).isEqualTo(4096L);
            ImmutableList spilledPages = ImmutableList.copyOf((Iterator)spilledPagesIterator);
            Assertions.assertThat((int)4).isEqualTo(spilledPages.size());
            for (int i = 0; i < 4; ++i) {
                PageAssertions.assertPageEquals(TYPES, page, (Page)spilledPages.get(i));
            }
            ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> ((FileSingleStreamSpiller)spiller).getSpilledPages()).isInstanceOf(IllegalStateException.class)).hasMessage("Repeated reads are disallowed to prevent potential resource leaks");
            spiller.close();
            Assertions.assertThat((int)MoreFiles.listFiles((Path)spillPath.toPath()).size()).isEqualTo(0);
            Assertions.assertThat((long)memoryContext.getBytes()).isEqualTo(0L);
        }
        catch (Throwable throwable) {
            MoreFiles.deleteRecursively((Path)spillPath.toPath(), (RecursiveDeleteOption[])new RecursiveDeleteOption[]{RecursiveDeleteOption.ALLOW_INSECURE});
            throw throwable;
        }
        MoreFiles.deleteRecursively((Path)spillPath.toPath(), (RecursiveDeleteOption[])new RecursiveDeleteOption[]{RecursiveDeleteOption.ALLOW_INSECURE});
    }

    private Page buildPage() {
        BlockBuilder col1 = BigintType.BIGINT.createBlockBuilder(null, 1);
        BlockBuilder col2 = DoubleType.DOUBLE.createBlockBuilder(null, 1);
        VariableWidthBlockBuilder col3 = VarbinaryType.VARBINARY.createBlockBuilder(null, 1);
        BigintType.BIGINT.writeLong(col1, 42L);
        DoubleType.DOUBLE.writeDouble(col2, 43.0);
        VarbinaryType.VARBINARY.writeSlice((BlockBuilder)col3, Slices.allocate((int)16).getOutput().appendDouble(43.0).appendLong(1L).slice());
        return new Page(new Block[]{col1.build(), col2.build(), col3.build()});
    }
}

