/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.ir.optimizer;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.trino.spi.type.BooleanType;
import io.trino.spi.type.Type;
import io.trino.sql.ir.Booleans;
import io.trino.sql.ir.Constant;
import io.trino.sql.ir.Expression;
import io.trino.sql.ir.Logical;
import io.trino.sql.ir.Reference;
import io.trino.sql.ir.optimizer.rule.EvaluateLogical;
import io.trino.testing.TestingSession;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class TestEvaluateLogical {
    TestEvaluateLogical() {
    }

    @Test
    void testOr() {
        Assertions.assertThat(this.optimize((Expression)new Logical(Logical.Operator.OR, (List)ImmutableList.of((Object)Booleans.TRUE, (Object)Booleans.FALSE, (Object)new Reference((Type)BooleanType.BOOLEAN, "a"))))).isEqualTo(Optional.of(Booleans.TRUE));
        Assertions.assertThat(this.optimize((Expression)new Logical(Logical.Operator.OR, (List)ImmutableList.of((Object)Booleans.FALSE, (Object)new Reference((Type)BooleanType.BOOLEAN, "a"))))).isEmpty();
        Assertions.assertThat(this.optimize((Expression)new Logical(Logical.Operator.OR, (List)ImmutableList.of((Object)new Constant((Type)BooleanType.BOOLEAN, null), (Object)Booleans.FALSE)))).isEqualTo(Optional.of(new Constant((Type)BooleanType.BOOLEAN, null)));
        Assertions.assertThat(this.optimize((Expression)new Logical(Logical.Operator.OR, (List)ImmutableList.of((Object)Booleans.TRUE, (Object)Booleans.TRUE)))).isEqualTo(Optional.of(Booleans.TRUE));
        Assertions.assertThat(this.optimize((Expression)new Logical(Logical.Operator.OR, (List)ImmutableList.of((Object)Booleans.TRUE, (Object)Booleans.FALSE)))).isEqualTo(Optional.of(Booleans.TRUE));
        Assertions.assertThat(this.optimize((Expression)new Logical(Logical.Operator.OR, (List)ImmutableList.of((Object)Booleans.FALSE, (Object)Booleans.TRUE)))).isEqualTo(Optional.of(Booleans.TRUE));
        Assertions.assertThat(this.optimize((Expression)new Logical(Logical.Operator.OR, (List)ImmutableList.of((Object)Booleans.FALSE, (Object)Booleans.FALSE)))).isEqualTo(Optional.of(Booleans.FALSE));
    }

    @Test
    void testAnd() {
        Assertions.assertThat(this.optimize((Expression)new Logical(Logical.Operator.AND, (List)ImmutableList.of((Object)Booleans.TRUE, (Object)Booleans.FALSE, (Object)new Reference((Type)BooleanType.BOOLEAN, "a"))))).isEqualTo(Optional.of(Booleans.FALSE));
        Assertions.assertThat(this.optimize((Expression)new Logical(Logical.Operator.AND, (List)ImmutableList.of((Object)Booleans.TRUE, (Object)new Reference((Type)BooleanType.BOOLEAN, "a"))))).isEmpty();
        Assertions.assertThat(this.optimize((Expression)new Logical(Logical.Operator.AND, (List)ImmutableList.of((Object)new Constant((Type)BooleanType.BOOLEAN, null), (Object)Booleans.TRUE)))).isEqualTo(Optional.of(new Constant((Type)BooleanType.BOOLEAN, null)));
        Assertions.assertThat(this.optimize((Expression)new Logical(Logical.Operator.AND, (List)ImmutableList.of((Object)Booleans.TRUE, (Object)Booleans.TRUE)))).isEqualTo(Optional.of(Booleans.TRUE));
        Assertions.assertThat(this.optimize((Expression)new Logical(Logical.Operator.AND, (List)ImmutableList.of((Object)Booleans.TRUE, (Object)Booleans.FALSE)))).isEqualTo(Optional.of(Booleans.FALSE));
        Assertions.assertThat(this.optimize((Expression)new Logical(Logical.Operator.AND, (List)ImmutableList.of((Object)Booleans.FALSE, (Object)Booleans.TRUE)))).isEqualTo(Optional.of(Booleans.FALSE));
        Assertions.assertThat(this.optimize((Expression)new Logical(Logical.Operator.AND, (List)ImmutableList.of((Object)Booleans.FALSE, (Object)Booleans.FALSE)))).isEqualTo(Optional.of(Booleans.FALSE));
    }

    private Optional<Expression> optimize(Expression expression) {
        return new EvaluateLogical().apply(expression, TestingSession.testSession(), (Map)ImmutableMap.of());
    }
}

