/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.ir.optimizer;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.Type;
import io.trino.spi.type.VarcharType;
import io.trino.sql.ir.Constant;
import io.trino.sql.ir.Expression;
import io.trino.sql.ir.Reference;
import io.trino.sql.ir.Switch;
import io.trino.sql.ir.WhenClause;
import io.trino.sql.ir.optimizer.rule.EvaluateSwitch;
import io.trino.sql.planner.TestingPlannerContext;
import io.trino.testing.TestingSession;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.OptionalAssert;
import org.junit.jupiter.api.Test;

public class TestEvaluateSwitch {
    @Test
    void test() {
        Assertions.assertThat(this.optimize((Expression)new Switch((Expression)new Reference((Type)BigintType.BIGINT, "x"), (List)ImmutableList.of((Object)new WhenClause((Expression)new Constant((Type)BigintType.BIGINT, (Object)1L), (Expression)new Reference((Type)VarcharType.VARCHAR, "a"))), (Expression)new Reference((Type)VarcharType.VARCHAR, "b")))).isEqualTo(Optional.empty());
        ((OptionalAssert)Assertions.assertThat(this.optimize((Expression)new Switch((Expression)new Constant((Type)BigintType.BIGINT, (Object)1L), (List)ImmutableList.of((Object)new WhenClause((Expression)new Constant((Type)BigintType.BIGINT, (Object)1L), (Expression)new Reference((Type)VarcharType.VARCHAR, "a"))), (Expression)new Reference((Type)VarcharType.VARCHAR, "b")))).describedAs("match", new Object[0])).isEqualTo(Optional.of(new Reference((Type)VarcharType.VARCHAR, "a")));
        ((OptionalAssert)Assertions.assertThat(this.optimize((Expression)new Switch((Expression)new Constant((Type)BigintType.BIGINT, (Object)1L), (List)ImmutableList.of((Object)new WhenClause((Expression)new Constant((Type)BigintType.BIGINT, (Object)2L), (Expression)new Reference((Type)VarcharType.VARCHAR, "a"))), (Expression)new Reference((Type)VarcharType.VARCHAR, "b")))).describedAs("no match", new Object[0])).isEqualTo(Optional.of(new Reference((Type)VarcharType.VARCHAR, "b")));
    }

    private Optional<Expression> optimize(Expression expression) {
        return new EvaluateSwitch(TestingPlannerContext.PLANNER_CONTEXT).apply(expression, TestingSession.testSession(), (Map)ImmutableMap.of());
    }
}

