/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.ir.optimizer;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.trino.metadata.Metadata;
import io.trino.spi.type.BooleanType;
import io.trino.spi.type.Type;
import io.trino.sql.ir.Booleans;
import io.trino.sql.ir.Case;
import io.trino.sql.ir.Expression;
import io.trino.sql.ir.IrExpressions;
import io.trino.sql.ir.Reference;
import io.trino.sql.ir.WhenClause;
import io.trino.sql.ir.optimizer.rule.SimplifyRedundantCase;
import io.trino.sql.planner.TestingPlannerContext;
import io.trino.testing.TestingSession;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestSimplifyRedundantCase {
    @Test
    void test() {
        Assertions.assertThat(this.optimize((Expression)new Case((List)ImmutableList.of((Object)new WhenClause((Expression)new Reference((Type)BooleanType.BOOLEAN, "x"), (Expression)Booleans.TRUE)), (Expression)Booleans.FALSE))).isEqualTo(Optional.of(new Reference((Type)BooleanType.BOOLEAN, "x")));
        Assertions.assertThat(this.optimize((Expression)new Case((List)ImmutableList.of((Object)new WhenClause((Expression)new Reference((Type)BooleanType.BOOLEAN, "x"), (Expression)Booleans.FALSE)), (Expression)Booleans.TRUE))).isEqualTo(Optional.of(IrExpressions.not((Metadata)TestingPlannerContext.PLANNER_CONTEXT.getMetadata(), (Expression)new Reference((Type)BooleanType.BOOLEAN, "x"))));
    }

    private Optional<Expression> optimize(Expression expression) {
        return new SimplifyRedundantCase(TestingPlannerContext.PLANNER_CONTEXT).apply(expression, TestingSession.testSession(), (Map)ImmutableMap.of());
    }
}

