/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.airlift.slice.Slices;
import io.trino.Session;
import io.trino.metadata.ResolvedFunction;
import io.trino.metadata.TestingFunctionResolution;
import io.trino.spi.function.OperatorType;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.DoubleType;
import io.trino.spi.type.IntegerType;
import io.trino.spi.type.Type;
import io.trino.spi.type.VarcharType;
import io.trino.sql.analyzer.TypeSignatureProvider;
import io.trino.sql.ir.Booleans;
import io.trino.sql.ir.Call;
import io.trino.sql.ir.Cast;
import io.trino.sql.ir.Comparison;
import io.trino.sql.ir.Constant;
import io.trino.sql.ir.Expression;
import io.trino.sql.ir.In;
import io.trino.sql.ir.Logical;
import io.trino.sql.ir.Reference;
import io.trino.sql.planner.assertions.BasePlanTest;
import io.trino.sql.planner.assertions.ExpectedValueProvider;
import io.trino.sql.planner.assertions.ExpressionMatcher;
import io.trino.sql.planner.assertions.PlanMatchPattern;
import io.trino.sql.planner.plan.ExchangeNode;
import io.trino.sql.planner.plan.JoinNode;
import io.trino.sql.planner.plan.JoinType;
import io.trino.sql.planner.plan.ProjectNode;
import io.trino.sql.planner.plan.WindowNode;
import java.util.List;
import java.util.Map;
import org.junit.jupiter.api.Test;

public abstract class AbstractPredicatePushdownTest
extends BasePlanTest {
    private static final TestingFunctionResolution FUNCTIONS = new TestingFunctionResolution();
    private static final ResolvedFunction RANDOM = FUNCTIONS.resolveFunction("random", TypeSignatureProvider.fromTypes((Type[])new Type[0]));
    private static final ResolvedFunction RANDOM_INTEGER = FUNCTIONS.resolveFunction("random", TypeSignatureProvider.fromTypes((Type[])new Type[]{IntegerType.INTEGER}));
    private static final ResolvedFunction ROUND = FUNCTIONS.resolveFunction("round", TypeSignatureProvider.fromTypes((Type[])new Type[]{DoubleType.DOUBLE}));
    private static final ResolvedFunction LENGTH = FUNCTIONS.resolveFunction("length", TypeSignatureProvider.fromTypes((Type[])new Type[]{VarcharType.createVarcharType((int)1)}));
    private static final ResolvedFunction ADD_BIGINT = FUNCTIONS.resolveOperator(OperatorType.ADD, (List<? extends Type>)ImmutableList.of((Object)BigintType.BIGINT, (Object)BigintType.BIGINT));
    private static final ResolvedFunction MULTIPLY_BIGINT = FUNCTIONS.resolveOperator(OperatorType.MULTIPLY, (List<? extends Type>)ImmutableList.of((Object)BigintType.BIGINT, (Object)BigintType.BIGINT));
    private static final ResolvedFunction DIVIDE_INTEGER = FUNCTIONS.resolveOperator(OperatorType.DIVIDE, (List<? extends Type>)ImmutableList.of((Object)IntegerType.INTEGER, (Object)IntegerType.INTEGER));
    private static final ResolvedFunction SUBTRACT_INTEGER = FUNCTIONS.resolveOperator(OperatorType.SUBTRACT, (List<? extends Type>)ImmutableList.of((Object)IntegerType.INTEGER, (Object)IntegerType.INTEGER));
    private static final ResolvedFunction MULTIPLY_DOUBLE = FUNCTIONS.resolveOperator(OperatorType.MULTIPLY, (List<? extends Type>)ImmutableList.of((Object)DoubleType.DOUBLE, (Object)DoubleType.DOUBLE));
    private final boolean enableDynamicFiltering;

    protected AbstractPredicatePushdownTest(boolean enableDynamicFiltering) {
        super((Map<String, String>)ImmutableMap.of((Object)"enable_dynamic_filtering", (Object)Boolean.toString(enableDynamicFiltering)));
        this.enableDynamicFiltering = enableDynamicFiltering;
    }

    @Test
    public abstract void testCoercions();

    @Test
    public void testPushDownToLhsOfSemiJoin() {
        this.assertPlan("SELECT quantity FROM (SELECT * FROM lineitem WHERE orderkey IN (SELECT orderkey FROM orders)) WHERE linenumber = 2", this.noSemiJoinRewrite(), PlanMatchPattern.anyTree(PlanMatchPattern.semiJoin("LINE_ORDER_KEY", "ORDERS_ORDER_KEY", "SEMI_JOIN_RESULT", this.enableDynamicFiltering, PlanMatchPattern.anyTree(PlanMatchPattern.filter((Expression)new Comparison(Comparison.Operator.EQUAL, (Expression)new Reference((Type)IntegerType.INTEGER, "LINE_NUMBER"), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)2L)), PlanMatchPattern.tableScan("lineitem", (Map<String, String>)ImmutableMap.of((Object)"LINE_ORDER_KEY", (Object)"orderkey", (Object)"LINE_NUMBER", (Object)"linenumber", (Object)"LINE_QUANTITY", (Object)"quantity")))), PlanMatchPattern.anyTree(PlanMatchPattern.tableScan("orders", (Map<String, String>)ImmutableMap.of((Object)"ORDERS_ORDER_KEY", (Object)"orderkey"))))));
    }

    @Test
    public void testNonDeterministicPredicatePropagatesOnlyToSourceSideOfSemiJoin() {
        this.assertPlan("SELECT * FROM lineitem WHERE orderkey IN (SELECT orderkey FROM orders) AND orderkey = random(5)", this.noSemiJoinRewrite(), PlanMatchPattern.anyTree(PlanMatchPattern.semiJoin("LINE_ORDER_KEY", "ORDERS_ORDER_KEY", "SEMI_JOIN_RESULT", this.enableDynamicFiltering, PlanMatchPattern.filter((Expression)new Comparison(Comparison.Operator.EQUAL, (Expression)new Reference((Type)BigintType.BIGINT, "LINE_ORDER_KEY"), (Expression)new Cast((Expression)new Call(RANDOM_INTEGER, (List)ImmutableList.of((Object)new Constant((Type)IntegerType.INTEGER, (Object)5L))), (Type)BigintType.BIGINT)), PlanMatchPattern.tableScan("lineitem", (Map<String, String>)ImmutableMap.of((Object)"LINE_ORDER_KEY", (Object)"orderkey"))), PlanMatchPattern.node(ExchangeNode.class, PlanMatchPattern.tableScan("orders", (Map<String, String>)ImmutableMap.of((Object)"ORDERS_ORDER_KEY", (Object)"orderkey"))))));
        this.assertPlan("SELECT * FROM lineitem WHERE orderkey NOT IN (SELECT orderkey FROM orders) AND orderkey = random(5)", PlanMatchPattern.anyTree(PlanMatchPattern.semiJoin("LINE_ORDER_KEY", "ORDERS_ORDER_KEY", "SEMI_JOIN_RESULT", PlanMatchPattern.filter((Expression)new Comparison(Comparison.Operator.EQUAL, (Expression)new Reference((Type)BigintType.BIGINT, "LINE_ORDER_KEY"), (Expression)new Cast((Expression)new Call(RANDOM_INTEGER, (List)ImmutableList.of((Object)new Constant((Type)IntegerType.INTEGER, (Object)5L))), (Type)BigintType.BIGINT)), PlanMatchPattern.tableScan("lineitem", (Map<String, String>)ImmutableMap.of((Object)"LINE_ORDER_KEY", (Object)"orderkey"))), PlanMatchPattern.anyTree(PlanMatchPattern.tableScan("orders", (Map<String, String>)ImmutableMap.of((Object)"ORDERS_ORDER_KEY", (Object)"orderkey"))))));
    }

    @Test
    public void testGreaterPredicateFromFilterSidePropagatesToSourceSideOfSemiJoin() {
        this.assertPlan("SELECT quantity FROM (SELECT * FROM lineitem WHERE orderkey IN (SELECT orderkey FROM orders WHERE orderkey > 2))", this.noSemiJoinRewrite(), PlanMatchPattern.anyTree(PlanMatchPattern.semiJoin("LINE_ORDER_KEY", "ORDERS_ORDER_KEY", "SEMI_JOIN_RESULT", this.enableDynamicFiltering, PlanMatchPattern.filter((Expression)new Comparison(Comparison.Operator.GREATER_THAN, (Expression)new Reference((Type)BigintType.BIGINT, "LINE_ORDER_KEY"), (Expression)new Constant((Type)BigintType.BIGINT, (Object)2L)), PlanMatchPattern.tableScan("lineitem", (Map<String, String>)ImmutableMap.of((Object)"LINE_ORDER_KEY", (Object)"orderkey", (Object)"LINE_QUANTITY", (Object)"quantity"))), PlanMatchPattern.anyTree(PlanMatchPattern.filter((Expression)new Comparison(Comparison.Operator.GREATER_THAN, (Expression)new Reference((Type)BigintType.BIGINT, "ORDERS_ORDER_KEY"), (Expression)new Constant((Type)BigintType.BIGINT, (Object)2L)), PlanMatchPattern.tableScan("orders", (Map<String, String>)ImmutableMap.of((Object)"ORDERS_ORDER_KEY", (Object)"orderkey")))))));
    }

    @Test
    public void testEqualsPredicateFromFilterSidePropagatesToSourceSideOfSemiJoin() {
        this.assertPlan("SELECT quantity FROM (SELECT * FROM lineitem WHERE orderkey IN (SELECT orderkey FROM orders WHERE orderkey = 2))", this.noSemiJoinRewrite(), PlanMatchPattern.anyTree(PlanMatchPattern.semiJoin("LINE_ORDER_KEY", "ORDERS_ORDER_KEY", "SEMI_JOIN_RESULT", this.enableDynamicFiltering, PlanMatchPattern.filter((Expression)new Comparison(Comparison.Operator.EQUAL, (Expression)new Reference((Type)BigintType.BIGINT, "LINE_ORDER_KEY"), (Expression)new Constant((Type)BigintType.BIGINT, (Object)2L)), PlanMatchPattern.tableScan("lineitem", (Map<String, String>)ImmutableMap.of((Object)"LINE_ORDER_KEY", (Object)"orderkey", (Object)"LINE_QUANTITY", (Object)"quantity"))), PlanMatchPattern.anyTree(PlanMatchPattern.filter((Expression)new Comparison(Comparison.Operator.EQUAL, (Expression)new Reference((Type)BigintType.BIGINT, "ORDERS_ORDER_KEY"), (Expression)new Constant((Type)BigintType.BIGINT, (Object)2L)), PlanMatchPattern.tableScan("orders", (Map<String, String>)ImmutableMap.of((Object)"ORDERS_ORDER_KEY", (Object)"orderkey")))))));
    }

    @Test
    public void testPredicateFromFilterSideNotPropagatesToSourceSideOfSemiJoinIfNotIn() {
        this.assertPlan("SELECT quantity FROM (SELECT * FROM lineitem WHERE orderkey NOT IN (SELECT orderkey FROM orders WHERE orderkey > 2))", PlanMatchPattern.anyTree(PlanMatchPattern.semiJoin("LINE_ORDER_KEY", "ORDERS_ORDER_KEY", "SEMI_JOIN_RESULT", PlanMatchPattern.tableScan("lineitem", (Map<String, String>)ImmutableMap.of((Object)"LINE_ORDER_KEY", (Object)"orderkey", (Object)"LINE_QUANTITY", (Object)"quantity")), PlanMatchPattern.anyTree(PlanMatchPattern.filter((Expression)new Comparison(Comparison.Operator.GREATER_THAN, (Expression)new Reference((Type)BigintType.BIGINT, "ORDERS_ORDER_KEY"), (Expression)new Constant((Type)BigintType.BIGINT, (Object)2L)), PlanMatchPattern.tableScan("orders", (Map<String, String>)ImmutableMap.of((Object)"ORDERS_ORDER_KEY", (Object)"orderkey")))))));
    }

    @Test
    public void testGreaterPredicateFromSourceSidePropagatesToFilterSideOfSemiJoin() {
        this.assertPlan("SELECT quantity FROM (SELECT * FROM lineitem WHERE orderkey IN (SELECT orderkey FROM orders) AND orderkey > 2)", this.noSemiJoinRewrite(), PlanMatchPattern.anyTree(PlanMatchPattern.semiJoin("LINE_ORDER_KEY", "ORDERS_ORDER_KEY", "SEMI_JOIN_RESULT", this.enableDynamicFiltering, PlanMatchPattern.filter((Expression)new Comparison(Comparison.Operator.GREATER_THAN, (Expression)new Reference((Type)BigintType.BIGINT, "LINE_ORDER_KEY"), (Expression)new Constant((Type)BigintType.BIGINT, (Object)2L)), PlanMatchPattern.tableScan("lineitem", (Map<String, String>)ImmutableMap.of((Object)"LINE_ORDER_KEY", (Object)"orderkey", (Object)"LINE_QUANTITY", (Object)"quantity"))), PlanMatchPattern.anyTree(PlanMatchPattern.filter((Expression)new Comparison(Comparison.Operator.GREATER_THAN, (Expression)new Reference((Type)BigintType.BIGINT, "ORDERS_ORDER_KEY"), (Expression)new Constant((Type)BigintType.BIGINT, (Object)2L)), PlanMatchPattern.tableScan("orders", (Map<String, String>)ImmutableMap.of((Object)"ORDERS_ORDER_KEY", (Object)"orderkey")))))));
    }

    @Test
    public void testEqualPredicateFromSourceSidePropagatesToFilterSideOfSemiJoin() {
        this.assertPlan("SELECT quantity FROM (SELECT * FROM lineitem WHERE orderkey IN (SELECT orderkey FROM orders) AND orderkey = 2)", this.noSemiJoinRewrite(), PlanMatchPattern.anyTree(PlanMatchPattern.semiJoin("LINE_ORDER_KEY", "ORDERS_ORDER_KEY", "SEMI_JOIN_RESULT", this.enableDynamicFiltering, PlanMatchPattern.filter((Expression)new Comparison(Comparison.Operator.EQUAL, (Expression)new Reference((Type)BigintType.BIGINT, "LINE_ORDER_KEY"), (Expression)new Constant((Type)BigintType.BIGINT, (Object)2L)), PlanMatchPattern.tableScan("lineitem", (Map<String, String>)ImmutableMap.of((Object)"LINE_ORDER_KEY", (Object)"orderkey", (Object)"LINE_QUANTITY", (Object)"quantity"))), PlanMatchPattern.anyTree(PlanMatchPattern.filter((Expression)new Comparison(Comparison.Operator.EQUAL, (Expression)new Reference((Type)BigintType.BIGINT, "ORDERS_ORDER_KEY"), (Expression)new Constant((Type)BigintType.BIGINT, (Object)2L)), PlanMatchPattern.tableScan("orders", (Map<String, String>)ImmutableMap.of((Object)"ORDERS_ORDER_KEY", (Object)"orderkey")))))));
    }

    @Test
    public void testPredicateFromSourceSideNotPropagatesToFilterSideOfSemiJoinIfNotIn() {
        this.assertPlan("SELECT quantity FROM (SELECT * FROM lineitem WHERE orderkey NOT IN (SELECT orderkey FROM orders) AND orderkey > 2)", PlanMatchPattern.anyTree(PlanMatchPattern.semiJoin("LINE_ORDER_KEY", "ORDERS_ORDER_KEY", "SEMI_JOIN_RESULT", PlanMatchPattern.filter((Expression)new Comparison(Comparison.Operator.GREATER_THAN, (Expression)new Reference((Type)BigintType.BIGINT, "LINE_ORDER_KEY"), (Expression)new Constant((Type)BigintType.BIGINT, (Object)2L)), PlanMatchPattern.tableScan("lineitem", (Map<String, String>)ImmutableMap.of((Object)"LINE_ORDER_KEY", (Object)"orderkey", (Object)"LINE_QUANTITY", (Object)"quantity"))), PlanMatchPattern.node(ExchangeNode.class, PlanMatchPattern.tableScan("orders", (Map<String, String>)ImmutableMap.of((Object)"ORDERS_ORDER_KEY", (Object)"orderkey"))))));
    }

    @Test
    public void testPredicateFromFilterSideNotPropagatesToSourceSideOfSemiJoinUsedInProjection() {
        this.assertPlan("SELECT orderkey IN (SELECT orderkey FROM orders WHERE orderkey > 2) FROM lineitem", PlanMatchPattern.anyTree(PlanMatchPattern.semiJoin("LINE_ORDER_KEY", "ORDERS_ORDER_KEY", "SEMI_JOIN_RESULT", PlanMatchPattern.tableScan("lineitem", (Map<String, String>)ImmutableMap.of((Object)"LINE_ORDER_KEY", (Object)"orderkey")), PlanMatchPattern.anyTree(PlanMatchPattern.filter((Expression)new Comparison(Comparison.Operator.GREATER_THAN, (Expression)new Reference((Type)BigintType.BIGINT, "ORDERS_ORDER_KEY"), (Expression)new Constant((Type)BigintType.BIGINT, (Object)2L)), PlanMatchPattern.tableScan("orders", (Map<String, String>)ImmutableMap.of((Object)"ORDERS_ORDER_KEY", (Object)"orderkey")))))));
    }

    @Test
    public void testFilteredSelectFromPartitionedTable() {
        List allOptimizers = this.getPlanTester().getPlanOptimizers(false);
        this.assertPlan("SELECT DISTINCT orderstatus FROM orders", PlanMatchPattern.anyTree(PlanMatchPattern.tableScan("orders")), allOptimizers);
        this.assertPlan("SELECT orderstatus FROM orders WHERE orderstatus = 'O'", PlanMatchPattern.output(PlanMatchPattern.tableScan("orders")), allOptimizers);
        this.assertPlan("SELECT orderstatus FROM orders WHERE orderstatus = 'no_such_partition_value'", PlanMatchPattern.output(PlanMatchPattern.values("orderstatus")), allOptimizers);
    }

    @Test
    public void testPredicatePushDownThroughMarkDistinct() {
        this.assertPlan("SELECT (SELECT a FROM (VALUES 1, 2, 3) t(a) WHERE a = b) FROM (VALUES 0, 1) p(b) WHERE b = 1", PlanMatchPattern.anyTree(PlanMatchPattern.join(JoinType.LEFT, builder -> builder.equiCriteria("A", "B").left(PlanMatchPattern.assignUniqueId("unique", PlanMatchPattern.values("A"))).right(PlanMatchPattern.values("B")))));
    }

    @Test
    public void testPredicatePushDownOverProjection() {
        this.assertPlan("WITH t AS (SELECT orderkey * 2 x FROM orders) SELECT * FROM t WHERE x + x > 1", PlanMatchPattern.anyTree(PlanMatchPattern.filter((Expression)new Comparison(Comparison.Operator.GREATER_THAN, (Expression)new Call(ADD_BIGINT, (List)ImmutableList.of((Object)new Reference((Type)BigintType.BIGINT, "expr"), (Object)new Reference((Type)BigintType.BIGINT, "expr"))), (Expression)new Constant((Type)BigintType.BIGINT, (Object)1L)), PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"expr", (Object)PlanMatchPattern.expression((Expression)new Call(MULTIPLY_BIGINT, (List)ImmutableList.of((Object)new Reference((Type)BigintType.BIGINT, "orderkey"), (Object)new Constant((Type)BigintType.BIGINT, (Object)2L))))), PlanMatchPattern.tableScan("orders", (Map<String, String>)ImmutableMap.of((Object)"orderkey", (Object)"orderkey"))))));
        this.assertPlan("with t AS (SELECT orderkey * 2 x, 1 y FROM orders) SELECT * FROM t WHERE x + y + y >1", PlanMatchPattern.anyTree(PlanMatchPattern.project(PlanMatchPattern.filter((Expression)new Comparison(Comparison.Operator.GREATER_THAN, (Expression)new Call(ADD_BIGINT, (List)ImmutableList.of((Object)new Call(ADD_BIGINT, (List)ImmutableList.of((Object)new Call(MULTIPLY_BIGINT, (List)ImmutableList.of((Object)new Reference((Type)BigintType.BIGINT, "orderkey"), (Object)new Constant((Type)BigintType.BIGINT, (Object)2L))), (Object)new Constant((Type)BigintType.BIGINT, (Object)1L))), (Object)new Constant((Type)BigintType.BIGINT, (Object)1L))), (Expression)new Constant((Type)BigintType.BIGINT, (Object)1L)), PlanMatchPattern.tableScan("orders", (Map<String, String>)ImmutableMap.of((Object)"orderkey", (Object)"orderkey"))))));
        this.assertPlan("WITH t AS (SELECT orderkey * 2 x FROM orders) SELECT * FROM t WHERE x > 1", PlanMatchPattern.anyTree(PlanMatchPattern.project(PlanMatchPattern.filter((Expression)new Comparison(Comparison.Operator.GREATER_THAN, (Expression)new Call(MULTIPLY_BIGINT, (List)ImmutableList.of((Object)new Reference((Type)BigintType.BIGINT, "orderkey"), (Object)new Constant((Type)BigintType.BIGINT, (Object)2L))), (Expression)new Constant((Type)BigintType.BIGINT, (Object)1L)), PlanMatchPattern.tableScan("orders", (Map<String, String>)ImmutableMap.of((Object)"orderkey", (Object)"orderkey"))))));
        this.assertPlan("with t AS (SELECT orderkey * 2 x, orderkey y FROM orders) SELECT * FROM t WHERE x + y > 1", PlanMatchPattern.anyTree(PlanMatchPattern.project(PlanMatchPattern.filter((Expression)new Comparison(Comparison.Operator.GREATER_THAN, (Expression)new Call(ADD_BIGINT, (List)ImmutableList.of((Object)new Call(MULTIPLY_BIGINT, (List)ImmutableList.of((Object)new Reference((Type)BigintType.BIGINT, "orderkey"), (Object)new Constant((Type)BigintType.BIGINT, (Object)2L))), (Object)new Reference((Type)BigintType.BIGINT, "orderkey"))), (Expression)new Constant((Type)BigintType.BIGINT, (Object)1L)), PlanMatchPattern.tableScan("orders", (Map<String, String>)ImmutableMap.of((Object)"orderkey", (Object)"orderkey"))))));
        this.assertPlan("WITH t AS (SELECT orderkey x FROM orders) SELECT * FROM t WHERE x >1", PlanMatchPattern.anyTree(PlanMatchPattern.filter((Expression)new Comparison(Comparison.Operator.GREATER_THAN, (Expression)new Reference((Type)BigintType.BIGINT, "orderkey"), (Expression)new Constant((Type)BigintType.BIGINT, (Object)1L)), PlanMatchPattern.tableScan("orders", (Map<String, String>)ImmutableMap.of((Object)"orderkey", (Object)"orderkey")))));
        this.assertPlan("WITH t AS (SELECT rand() * orderkey x FROM orders) SELECT * FROM t WHERE x > 5000", PlanMatchPattern.anyTree(PlanMatchPattern.filter((Expression)new Comparison(Comparison.Operator.GREATER_THAN, (Expression)new Reference((Type)DoubleType.DOUBLE, "expr"), (Expression)new Constant((Type)DoubleType.DOUBLE, (Object)5000.0)), PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"expr", (Object)PlanMatchPattern.expression((Expression)new Call(MULTIPLY_DOUBLE, (List)ImmutableList.of((Object)new Call(RANDOM, (List)ImmutableList.of()), (Object)new Cast((Expression)new Reference((Type)BigintType.BIGINT, "orderkey"), (Type)DoubleType.DOUBLE))))), PlanMatchPattern.tableScan("orders", (Map<String, String>)ImmutableMap.of((Object)"orderkey", (Object)"orderkey"))))));
    }

    @Test
    public void testPredicatePushDownOverSymbolReferences() {
        this.assertPlan("WITH t AS (SELECT orderkey x, (orderkey + 1) x2 FROM orders) SELECT * FROM t WHERE x > 1 OR x < 0", PlanMatchPattern.anyTree(PlanMatchPattern.filter((Expression)new Logical(Logical.Operator.OR, (List)ImmutableList.of((Object)new Comparison(Comparison.Operator.LESS_THAN, (Expression)new Reference((Type)BigintType.BIGINT, "orderkey"), (Expression)new Constant((Type)BigintType.BIGINT, (Object)0L)), (Object)new Comparison(Comparison.Operator.GREATER_THAN, (Expression)new Reference((Type)BigintType.BIGINT, "orderkey"), (Expression)new Constant((Type)BigintType.BIGINT, (Object)1L)))), PlanMatchPattern.tableScan("orders", (Map<String, String>)ImmutableMap.of((Object)"orderkey", (Object)"orderkey")))));
    }

    @Test
    public void testConjunctsOrder() {
        this.assertPlan("select partkey from (  select    partkey,    100/(size-1) x  from part  where size <> 1) where x = 2", PlanMatchPattern.anyTree(PlanMatchPattern.filter((Expression)new Logical(Logical.Operator.AND, (List)ImmutableList.of((Object)new Comparison(Comparison.Operator.NOT_EQUAL, (Expression)new Reference((Type)IntegerType.INTEGER, "size"), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)1L)), (Object)new Comparison(Comparison.Operator.EQUAL, (Expression)new Call(DIVIDE_INTEGER, (List)ImmutableList.of((Object)new Constant((Type)IntegerType.INTEGER, (Object)100L), (Object)new Call(SUBTRACT_INTEGER, (List)ImmutableList.of((Object)new Reference((Type)IntegerType.INTEGER, "size"), (Object)new Constant((Type)IntegerType.INTEGER, (Object)1L))))), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)2L)))), PlanMatchPattern.tableScan("part", (Map<String, String>)ImmutableMap.of((Object)"partkey", (Object)"partkey", (Object)"size", (Object)"size")))));
    }

    @Test
    public void testPredicateOnPartitionSymbolsPushedThroughWindow() {
        PlanMatchPattern tableScan = PlanMatchPattern.tableScan("orders", (Map<String, String>)ImmutableMap.of((Object)"CUST_KEY", (Object)"custkey", (Object)"ORDER_KEY", (Object)"orderkey"));
        this.assertPlan("SELECT * FROM (SELECT custkey, orderkey, rank() OVER (PARTITION BY custkey  ORDER BY orderdate ASC)FROM orders) WHERE custkey = 0 AND orderkey > 0", PlanMatchPattern.anyTree(PlanMatchPattern.filter((Expression)new Comparison(Comparison.Operator.GREATER_THAN, (Expression)new Reference((Type)BigintType.BIGINT, "ORDER_KEY"), (Expression)new Constant((Type)BigintType.BIGINT, (Object)0L)), PlanMatchPattern.anyTree(PlanMatchPattern.node(WindowNode.class, PlanMatchPattern.anyTree(PlanMatchPattern.filter((Expression)new Comparison(Comparison.Operator.EQUAL, (Expression)new Reference((Type)BigintType.BIGINT, "CUST_KEY"), (Expression)new Constant((Type)BigintType.BIGINT, (Object)0L)), tableScan)))))));
    }

    @Test
    public void testPredicateOnNonDeterministicSymbolsPushedDown() {
        this.assertPlan("SELECT * FROM (SELECT random_column, orderkey, rank() OVER (PARTITION BY random_column  ORDER BY orderdate ASC)FROM (select round(custkey*rand()) random_column, * from orders) ) WHERE random_column > 100", PlanMatchPattern.anyTree(PlanMatchPattern.node(WindowNode.class, PlanMatchPattern.anyTree(PlanMatchPattern.filter((Expression)new Comparison(Comparison.Operator.GREATER_THAN, (Expression)new Reference((Type)DoubleType.DOUBLE, "ROUND"), (Expression)new Constant((Type)DoubleType.DOUBLE, (Object)100.0)), PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"ROUND", (Object)PlanMatchPattern.expression((Expression)new Call(ROUND, (List)ImmutableList.of((Object)new Call(MULTIPLY_DOUBLE, (List)ImmutableList.of((Object)new Cast((Expression)new Reference((Type)BigintType.BIGINT, "CUST_KEY"), (Type)DoubleType.DOUBLE), (Object)new Call(RANDOM, (List)ImmutableList.of()))))))), PlanMatchPattern.tableScan("orders", (Map<String, String>)ImmutableMap.of((Object)"CUST_KEY", (Object)"custkey"))))))));
    }

    @Test
    public void testNonDeterministicPredicateNotPushedDown() {
        this.assertPlan("SELECT * FROM (SELECT custkey, orderkey, rank() OVER (PARTITION BY custkey  ORDER BY orderdate ASC)FROM orders) WHERE custkey > 100*rand()", PlanMatchPattern.anyTree(PlanMatchPattern.filter((Expression)new Comparison(Comparison.Operator.GREATER_THAN, (Expression)new Cast((Expression)new Reference((Type)BigintType.BIGINT, "CUST_KEY"), (Type)DoubleType.DOUBLE), (Expression)new Call(MULTIPLY_DOUBLE, (List)ImmutableList.of((Object)new Call(RANDOM, (List)ImmutableList.of()), (Object)new Constant((Type)DoubleType.DOUBLE, (Object)100.0)))), PlanMatchPattern.anyTree(PlanMatchPattern.node(WindowNode.class, PlanMatchPattern.anyTree(PlanMatchPattern.tableScan("orders", (Map<String, String>)ImmutableMap.of((Object)"CUST_KEY", (Object)"custkey"))))))));
    }

    @Test
    public void testRemovesRedundantTableScanPredicate() {
        this.assertPlan("SELECT t1.orderstatus FROM (SELECT orderstatus FROM orders WHERE rand() = orderkey AND orderkey = 123) t1, (VALUES 'F', 'K') t2(col) WHERE t1.orderstatus = t2.col AND (t2.col = 'F' OR t2.col = 'K') AND length(t1.orderstatus) < 42", PlanMatchPattern.anyTree(PlanMatchPattern.node(JoinNode.class, PlanMatchPattern.node(ProjectNode.class, PlanMatchPattern.filter((Expression)new Logical(Logical.Operator.AND, (List)ImmutableList.of((Object)new Comparison(Comparison.Operator.EQUAL, (Expression)new Reference((Type)BigintType.BIGINT, "ORDERKEY"), (Expression)new Constant((Type)BigintType.BIGINT, (Object)123L)), (Object)new Comparison(Comparison.Operator.EQUAL, (Expression)new Call(RANDOM, (List)ImmutableList.of()), (Expression)new Cast((Expression)new Reference((Type)BigintType.BIGINT, "ORDERKEY"), (Type)DoubleType.DOUBLE)), (Object)new Comparison(Comparison.Operator.LESS_THAN, (Expression)new Call(LENGTH, (List)ImmutableList.of((Object)new Reference((Type)VarcharType.createVarcharType((int)1), "ORDERSTATUS"))), (Expression)new Constant((Type)BigintType.BIGINT, (Object)42L)))), PlanMatchPattern.tableScan("orders", (Map<String, String>)ImmutableMap.of((Object)"ORDERSTATUS", (Object)"orderstatus", (Object)"ORDERKEY", (Object)"orderkey")))), PlanMatchPattern.values(new String[0]))));
    }

    @Test
    public void testTablePredicateIsExtracted() {
        this.assertPlan("SELECT * FROM orders, nation WHERE orderstatus = CAST(nation.name AS varchar(1)) AND orderstatus BETWEEN 'A' AND 'O'", PlanMatchPattern.anyTree(PlanMatchPattern.node(JoinNode.class, PlanMatchPattern.filter((Expression)new In((Expression)new Reference((Type)VarcharType.createVarcharType((int)1), "ORDERSTATUS"), (List)ImmutableList.of((Object)new Constant((Type)VarcharType.createVarcharType((int)1), (Object)Slices.utf8Slice((String)"F")), (Object)new Constant((Type)VarcharType.createVarcharType((int)1), (Object)Slices.utf8Slice((String)"O")))), PlanMatchPattern.tableScan("orders", (Map<String, String>)ImmutableMap.of((Object)"ORDERSTATUS", (Object)"orderstatus"))), PlanMatchPattern.anyTree(PlanMatchPattern.filter((Expression)new In((Expression)new Cast((Expression)new Reference((Type)VarcharType.VARCHAR, "NAME"), (Type)VarcharType.createVarcharType((int)1)), (List)ImmutableList.of((Object)new Constant((Type)VarcharType.createVarcharType((int)1), (Object)Slices.utf8Slice((String)"F")), (Object)new Constant((Type)VarcharType.createVarcharType((int)1), (Object)Slices.utf8Slice((String)"O")))), PlanMatchPattern.tableScan("nation", (Map<String, String>)ImmutableMap.of((Object)"NAME", (Object)"name")))))));
        PlanMatchPattern ordersTableScan = PlanMatchPattern.tableScan("orders", (Map<String, String>)ImmutableMap.of((Object)"ORDERSTATUS", (Object)"orderstatus"));
        this.assertPlan("SELECT * FROM orders JOIN nation ON orderstatus = CAST(nation.name AS varchar(1))", PlanMatchPattern.anyTree(PlanMatchPattern.node(JoinNode.class, this.enableDynamicFiltering ? PlanMatchPattern.filter((Expression)Booleans.TRUE, ordersTableScan) : ordersTableScan, PlanMatchPattern.anyTree(PlanMatchPattern.filter((Expression)new In((Expression)new Cast((Expression)new Reference((Type)VarcharType.VARCHAR, "NAME"), (Type)VarcharType.createVarcharType((int)1)), (List)ImmutableList.of((Object)new Constant((Type)VarcharType.createVarcharType((int)1), (Object)Slices.utf8Slice((String)"F")), (Object)new Constant((Type)VarcharType.createVarcharType((int)1), (Object)Slices.utf8Slice((String)"O")), (Object)new Constant((Type)VarcharType.createVarcharType((int)1), (Object)Slices.utf8Slice((String)"P")))), PlanMatchPattern.tableScan("nation", (Map<String, String>)ImmutableMap.of((Object)"NAME", (Object)"name")))))));
    }

    @Test
    public void testOnlyNullPredicateIsPushDownThroughJoinFilters() {
        this.assertPlan("WITH t(a) AS (VALUES 'a', 'b')\nSELECT *\nFROM t t1 JOIN t t2 ON true\nWHERE t1.a = 'aa'\n", PlanMatchPattern.output(PlanMatchPattern.values("field", "field_0")));
    }

    @Test
    public void testSimplifyNonInferrableInheritedPredicate() {
        this.assertPlan("SELECT * FROM (SELECT * FROM nation WHERE nationkey = regionkey AND regionkey = 5) a, nation b WHERE a.nationkey = b.nationkey AND a.nationkey + 11 > 15", PlanMatchPattern.output(PlanMatchPattern.join(JoinType.INNER, builder -> builder.equiCriteria((List<ExpectedValueProvider<JoinNode.EquiJoinClause>>)ImmutableList.of()).left(PlanMatchPattern.filter((Expression)new Logical(Logical.Operator.AND, (List)ImmutableList.of((Object)new Comparison(Comparison.Operator.EQUAL, (Expression)new Reference((Type)BigintType.BIGINT, "L_NATIONKEY"), (Expression)new Reference((Type)BigintType.BIGINT, "L_REGIONKEY")), (Object)new Comparison(Comparison.Operator.EQUAL, (Expression)new Reference((Type)BigintType.BIGINT, "L_REGIONKEY"), (Expression)new Constant((Type)BigintType.BIGINT, (Object)5L)))), PlanMatchPattern.tableScan("nation", (Map<String, String>)ImmutableMap.of((Object)"L_NATIONKEY", (Object)"nationkey", (Object)"L_REGIONKEY", (Object)"regionkey")))).right(PlanMatchPattern.anyTree(PlanMatchPattern.filter((Expression)new Comparison(Comparison.Operator.EQUAL, (Expression)new Reference((Type)BigintType.BIGINT, "R_NATIONKEY"), (Expression)new Constant((Type)BigintType.BIGINT, (Object)5L)), PlanMatchPattern.tableScan("nation", (Map<String, String>)ImmutableMap.of((Object)"R_NATIONKEY", (Object)"nationkey"))))))));
    }

    @Test
    public void testDoesNotCreatePredicateFromInferredPredicate() {
        this.assertPlan("SELECT * FROM (SELECT *, nationkey + 1 as nationkey2 FROM nation) a JOIN nation b ON a.nationkey2 = b.nationkey", PlanMatchPattern.output(PlanMatchPattern.join(JoinType.INNER, builder -> builder.equiCriteria("L_NATIONKEY2", "R_NATIONKEY").left(PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"L_NATIONKEY2", (Object)PlanMatchPattern.expression((Expression)new Call(ADD_BIGINT, (List)ImmutableList.of((Object)new Reference((Type)BigintType.BIGINT, "L_NATIONKEY"), (Object)new Constant((Type)BigintType.BIGINT, (Object)1L))))), PlanMatchPattern.tableScan("nation", (Map<String, String>)ImmutableMap.of((Object)"L_NATIONKEY", (Object)"nationkey")))).right(PlanMatchPattern.anyTree(PlanMatchPattern.tableScan("nation", (Map<String, String>)ImmutableMap.of((Object)"R_NATIONKEY", (Object)"nationkey")))))));
        this.assertPlan("SELECT * FROM (SELECT * FROM nation WHERE nationkey = 5) a JOIN (SELECT * FROM nation WHERE nationkey = 5) b ON a.nationkey = b.nationkey", PlanMatchPattern.output(PlanMatchPattern.join(JoinType.INNER, builder -> builder.equiCriteria((List<ExpectedValueProvider<JoinNode.EquiJoinClause>>)ImmutableList.of()).left(PlanMatchPattern.filter((Expression)new Comparison(Comparison.Operator.EQUAL, (Expression)new Reference((Type)BigintType.BIGINT, "L_NATIONKEY"), (Expression)new Constant((Type)BigintType.BIGINT, (Object)5L)), PlanMatchPattern.tableScan("nation", (Map<String, String>)ImmutableMap.of((Object)"L_NATIONKEY", (Object)"nationkey")))).right(PlanMatchPattern.anyTree(PlanMatchPattern.filter((Expression)new Comparison(Comparison.Operator.EQUAL, (Expression)new Reference((Type)BigintType.BIGINT, "R_NATIONKEY"), (Expression)new Constant((Type)BigintType.BIGINT, (Object)5L)), PlanMatchPattern.tableScan("nation", (Map<String, String>)ImmutableMap.of((Object)"R_NATIONKEY", (Object)"nationkey"))))))));
    }

    @Test
    public void testSimplifiesStraddlingPredicate() {
        this.assertPlan("SELECT * FROM (SELECT * FROM NATION WHERE nationkey = 5) a JOIN nation b ON a.nationkey = b.nationkey AND a.nationkey = a.regionkey + b.regionkey", PlanMatchPattern.output(PlanMatchPattern.filter((Expression)new Comparison(Comparison.Operator.EQUAL, (Expression)new Call(ADD_BIGINT, (List)ImmutableList.of((Object)new Reference((Type)BigintType.BIGINT, "L_REGIONKEY"), (Object)new Reference((Type)BigintType.BIGINT, "R_REGIONKEY"))), (Expression)new Constant((Type)BigintType.BIGINT, (Object)5L)), PlanMatchPattern.join(JoinType.INNER, builder -> builder.equiCriteria((List<ExpectedValueProvider<JoinNode.EquiJoinClause>>)ImmutableList.of()).left(PlanMatchPattern.filter((Expression)new Comparison(Comparison.Operator.EQUAL, (Expression)new Reference((Type)BigintType.BIGINT, "L_NATIONKEY"), (Expression)new Constant((Type)BigintType.BIGINT, (Object)5L)), PlanMatchPattern.tableScan("nation", (Map<String, String>)ImmutableMap.of((Object)"L_NATIONKEY", (Object)"nationkey", (Object)"L_REGIONKEY", (Object)"regionkey")))).right(PlanMatchPattern.anyTree(PlanMatchPattern.filter((Expression)new Comparison(Comparison.Operator.EQUAL, (Expression)new Reference((Type)BigintType.BIGINT, "R_NATIONKEY"), (Expression)new Constant((Type)BigintType.BIGINT, (Object)5L)), PlanMatchPattern.tableScan("nation", (Map<String, String>)ImmutableMap.of((Object)"R_NATIONKEY", (Object)"nationkey", (Object)"R_REGIONKEY", (Object)"regionkey")))))))));
    }

    protected Session noSemiJoinRewrite() {
        return Session.builder((Session)this.getPlanTester().getDefaultSession()).setSystemProperty("rewrite_filtering_semi_join_to_inner_join", "false").build();
    }
}

