/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner;

import com.google.common.collect.ImmutableList;
import io.trino.sql.planner.assertions.BasePlanTest;
import io.trino.sql.planner.assertions.PlanMatchPattern;
import io.trino.sql.planner.plan.EnforceSingleRowNode;
import io.trino.sql.planner.plan.ExchangeNode;
import io.trino.sql.planner.plan.FilterNode;
import io.trino.sql.planner.plan.ProjectNode;
import io.trino.sql.planner.plan.RowNumberNode;
import io.trino.sql.planner.plan.SortNode;
import io.trino.sql.planner.plan.TopNNode;
import io.trino.sql.planner.plan.ValuesNode;
import io.trino.sql.tree.SortItem;
import java.util.List;
import org.junit.jupiter.api.Test;

public class TestOrderBy
extends BasePlanTest {
    @Test
    public void testRedundantOrderByInSubquery() {
        this.assertPlan("SELECT * FROM (SELECT * FROM (VALUES 1, 2, 3) t(x) ORDER BY x)", PlanMatchPattern.output(PlanMatchPattern.node(ValuesNode.class, new PlanMatchPattern[0])));
    }

    @Test
    public void testRequiredOrderByInSubquery() {
        this.assertPlan("SELECT * FROM (SELECT * FROM (VALUES 1, 2, 3) t(x) ORDER BY x LIMIT 1)", PlanMatchPattern.output(PlanMatchPattern.node(TopNNode.class, PlanMatchPattern.anyTree(PlanMatchPattern.node(ValuesNode.class, new PlanMatchPattern[0])))));
    }

    @Test
    public void testRedundantOrderByInScalarSubquery() {
        this.assertPlan("SELECT (SELECT * FROM (VALUES 1, 2, 3) t(x) ORDER BY x) FROM (VALUES 10)", PlanMatchPattern.output(PlanMatchPattern.node(EnforceSingleRowNode.class, PlanMatchPattern.node(ValuesNode.class, new PlanMatchPattern[0]))));
    }

    @Test
    public void testRequiredOrderByInScalarSubquery() {
        this.assertPlan("SELECT (SELECT * FROM (VALUES 1, 2, 3) t(x) ORDER BY x LIMIT 1) FROM (VALUES 10)", PlanMatchPattern.output(PlanMatchPattern.anyTree(PlanMatchPattern.node(TopNNode.class, PlanMatchPattern.node(ValuesNode.class, new PlanMatchPattern[0])))));
    }

    @Test
    public void testRequiredOrderByInUnion() {
        this.assertPlan("VALUES 1 UNION ALL VALUES 2 ORDER BY 1 ", PlanMatchPattern.output(PlanMatchPattern.anyTree(PlanMatchPattern.node(SortNode.class, PlanMatchPattern.node(ExchangeNode.class, PlanMatchPattern.node(ValuesNode.class, new PlanMatchPattern[0]), PlanMatchPattern.node(ValuesNode.class, new PlanMatchPattern[0]))))));
    }

    @Test
    public void testRedundantOrderByInUnion() {
        this.assertPlan("SELECT * FROM (   VALUES 1    UNION ALL    VALUES 2    ORDER BY 1 )", PlanMatchPattern.output(PlanMatchPattern.node(ExchangeNode.class, PlanMatchPattern.node(ValuesNode.class, new PlanMatchPattern[0]), PlanMatchPattern.node(ValuesNode.class, new PlanMatchPattern[0]))));
    }

    @Test
    public void testRedundantOrderByInWith() {
        this.assertPlan("WITH t(a) AS (\n    SELECT * FROM (VALUES 2, 1) t(a)\n    ORDER BY a)\nSELECT * FROM t\n", PlanMatchPattern.output(PlanMatchPattern.node(ValuesNode.class, new PlanMatchPattern[0])));
    }

    @Test
    public void testOrderByInWithLimit() {
        this.assertPlan("WITH t(a) AS (\n    SELECT * FROM (VALUES 2, 1) t(a)\n    ORDER BY a\n    LIMIT 1)\nSELECT * FROM t\n", PlanMatchPattern.output(PlanMatchPattern.topN(1L, (List<PlanMatchPattern.Ordering>)ImmutableList.of((Object)PlanMatchPattern.sort("c", SortItem.Ordering.ASCENDING, SortItem.NullOrdering.LAST)), TopNNode.Step.FINAL, PlanMatchPattern.topN(1L, (List<PlanMatchPattern.Ordering>)ImmutableList.of((Object)PlanMatchPattern.sort("c", SortItem.Ordering.ASCENDING, SortItem.NullOrdering.LAST)), TopNNode.Step.PARTIAL, PlanMatchPattern.values("c")))));
    }

    @Test
    public void testOrderByInWithOffset() {
        this.assertPlan("WITH t(a) AS (\n    SELECT * FROM (VALUES (2),(1)) t(a)\n    ORDER BY a\n    OFFSET 1)\nSELECT * FROM t\n", PlanMatchPattern.output(PlanMatchPattern.node(ProjectNode.class, PlanMatchPattern.node(FilterNode.class, PlanMatchPattern.node(RowNumberNode.class, PlanMatchPattern.exchange(ExchangeNode.Scope.LOCAL, PlanMatchPattern.sort(PlanMatchPattern.exchange(ExchangeNode.Scope.LOCAL, PlanMatchPattern.values("c")))))))));
    }
}

