/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner.iterative.rule;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.airlift.slice.Slices;
import io.trino.metadata.ResolvedFunction;
import io.trino.metadata.TestingFunctionResolution;
import io.trino.spi.Plugin;
import io.trino.spi.function.OperatorType;
import io.trino.spi.type.ArrayType;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.IntegerType;
import io.trino.spi.type.Type;
import io.trino.spi.type.VarcharType;
import io.trino.sql.analyzer.TypeSignatureProvider;
import io.trino.sql.ir.Call;
import io.trino.sql.ir.Cast;
import io.trino.sql.ir.Constant;
import io.trino.sql.ir.Expression;
import io.trino.sql.ir.Reference;
import io.trino.sql.planner.Symbol;
import io.trino.sql.planner.assertions.AggregationFunction;
import io.trino.sql.planner.assertions.ExpectedValueProvider;
import io.trino.sql.planner.assertions.ExpressionMatcher;
import io.trino.sql.planner.assertions.PlanMatchPattern;
import io.trino.sql.planner.iterative.Rule;
import io.trino.sql.planner.iterative.rule.DecorrelateLeftUnnestWithGlobalAggregation;
import io.trino.sql.planner.iterative.rule.test.BaseRuleTest;
import io.trino.sql.planner.iterative.rule.test.PlanBuilder;
import io.trino.sql.planner.plan.AggregationNode;
import io.trino.sql.planner.plan.Assignments;
import io.trino.sql.planner.plan.JoinType;
import io.trino.sql.planner.plan.PlanNode;
import io.trino.sql.planner.plan.UnnestNode;
import io.trino.type.JoniRegexpType;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.junit.jupiter.api.Test;

public class TestDecorrelateLeftUnnestWithGlobalAggregation
extends BaseRuleTest {
    private static final TestingFunctionResolution FUNCTIONS = new TestingFunctionResolution();
    private static final ResolvedFunction REGEXP_EXTRACT_ALL = FUNCTIONS.resolveFunction("regexp_extract_all", TypeSignatureProvider.fromTypes((Type[])new Type[]{VarcharType.VARCHAR, VarcharType.VARCHAR}));
    private static final ResolvedFunction ADD_INTEGER = FUNCTIONS.resolveOperator(OperatorType.ADD, (List<? extends Type>)ImmutableList.of((Object)IntegerType.INTEGER, (Object)IntegerType.INTEGER));
    private static final ResolvedFunction ADD_BIGINT = FUNCTIONS.resolveOperator(OperatorType.ADD, (List<? extends Type>)ImmutableList.of((Object)BigintType.BIGINT, (Object)BigintType.BIGINT));
    private static final ResolvedFunction MODULUS_BIGINT = FUNCTIONS.resolveOperator(OperatorType.MODULUS, (List<? extends Type>)ImmutableList.of((Object)BigintType.BIGINT, (Object)BigintType.BIGINT));
    private static final ResolvedFunction NEGATION_BIGINT = FUNCTIONS.resolveOperator(OperatorType.NEGATION, (List<? extends Type>)ImmutableList.of((Object)BigintType.BIGINT));

    public TestDecorrelateLeftUnnestWithGlobalAggregation() {
        super(new Plugin[0]);
    }

    @Test
    public void doesNotFireWithoutGlobalAggregation() {
        this.tester().assertThat((Rule<?>)new DecorrelateLeftUnnestWithGlobalAggregation()).on(p -> p.correlatedJoin((List<Symbol>)ImmutableList.of((Object)p.symbol("corr")), (PlanNode)p.values(p.symbol("corr")), (PlanNode)p.aggregation(builder -> builder.singleGroupingSet(p.symbol("unnested")).source((PlanNode)p.unnest((List<Symbol>)ImmutableList.of(), (List<UnnestNode.Mapping>)ImmutableList.of((Object)new UnnestNode.Mapping(p.symbol("corr"), (List)ImmutableList.of((Object)p.symbol("unnested")))), Optional.empty(), JoinType.LEFT, (PlanNode)p.values(new Symbol[0])))))).doesNotFire();
    }

    @Test
    public void doesNotFireWithoutUnnest() {
        this.tester().assertThat((Rule<?>)new DecorrelateLeftUnnestWithGlobalAggregation()).on(p -> p.correlatedJoin((List<Symbol>)ImmutableList.of((Object)p.symbol("corr")), (PlanNode)p.values(p.symbol("corr")), (PlanNode)p.aggregation(builder -> builder.globalGrouping().source((PlanNode)p.values(p.symbol("a"), p.symbol("b")))))).doesNotFire();
    }

    @Test
    public void doesNotFireOnSourceDependentUnnest() {
        this.tester().assertThat((Rule<?>)new DecorrelateLeftUnnestWithGlobalAggregation()).on(p -> p.correlatedJoin((List<Symbol>)ImmutableList.of((Object)p.symbol("corr")), (PlanNode)p.values(p.symbol("corr")), (PlanNode)p.aggregation(builder -> builder.globalGrouping().source((PlanNode)p.unnest((List<Symbol>)ImmutableList.of(), (List<UnnestNode.Mapping>)ImmutableList.of((Object)new UnnestNode.Mapping(p.symbol("corr"), (List)ImmutableList.of((Object)p.symbol("unnested_corr"))), (Object)new UnnestNode.Mapping(p.symbol("a"), (List)ImmutableList.of((Object)p.symbol("unnested_a")))), Optional.empty(), JoinType.LEFT, (PlanNode)p.values(p.symbol("a"), p.symbol("b"))))))).doesNotFire();
    }

    @Test
    public void testTransformCorrelatedUnnest() {
        this.tester().assertThat((Rule<?>)new DecorrelateLeftUnnestWithGlobalAggregation()).on(p -> p.correlatedJoin((List<Symbol>)ImmutableList.of((Object)p.symbol("corr")), (PlanNode)p.values(p.symbol("corr")), (PlanNode)p.aggregation(builder -> builder.globalGrouping().addAggregation(p.symbol("sum"), PlanBuilder.aggregation("sum", (List<Expression>)ImmutableList.of((Object)new Reference((Type)BigintType.BIGINT, "unnested_corr"))), (List<Type>)ImmutableList.of((Object)BigintType.BIGINT)).source((PlanNode)p.unnest((List<Symbol>)ImmutableList.of(), (List<UnnestNode.Mapping>)ImmutableList.of((Object)new UnnestNode.Mapping(p.symbol("corr"), (List)ImmutableList.of((Object)p.symbol("unnested_corr")))), Optional.empty(), JoinType.LEFT, (PlanNode)p.values((List<Symbol>)ImmutableList.of(), (List<List<Expression>>)ImmutableList.of((Object)ImmutableList.of()))))))).matches(PlanMatchPattern.project(PlanMatchPattern.aggregation(PlanMatchPattern.singleGroupingSet("unique", "corr"), (Map<Optional<String>, ExpectedValueProvider<AggregationFunction>>)ImmutableMap.of(Optional.of("sum"), PlanMatchPattern.aggregationFunction("sum", (List<String>)ImmutableList.of((Object)"unnested_corr"))), (List<String>)ImmutableList.of(), Optional.empty(), AggregationNode.Step.SINGLE, PlanMatchPattern.unnest((List<String>)ImmutableList.of((Object)"corr", (Object)"unique"), (List<PlanMatchPattern.UnnestMapping>)ImmutableList.of((Object)PlanMatchPattern.UnnestMapping.unnestMapping("corr", (List<String>)ImmutableList.of((Object)"unnested_corr"))), Optional.empty(), JoinType.LEFT, PlanMatchPattern.assignUniqueId("unique", PlanMatchPattern.values("corr"))))));
    }

    @Test
    public void testWithMask() {
        this.tester().assertThat((Rule<?>)new DecorrelateLeftUnnestWithGlobalAggregation()).on(p -> p.correlatedJoin((List<Symbol>)ImmutableList.of((Object)p.symbol("corr"), (Object)p.symbol("masks")), (PlanNode)p.values(p.symbol("corr"), p.symbol("masks")), (PlanNode)p.aggregation(builder -> builder.globalGrouping().addAggregation(p.symbol("sum"), PlanBuilder.aggregation("sum", (List<Expression>)ImmutableList.of((Object)new Reference((Type)BigintType.BIGINT, "unnested_corr"))), (List<Type>)ImmutableList.of((Object)BigintType.BIGINT), p.symbol("mask")).source((PlanNode)p.unnest((List<Symbol>)ImmutableList.of(), (List<UnnestNode.Mapping>)ImmutableList.of((Object)new UnnestNode.Mapping(p.symbol("corr"), (List)ImmutableList.of((Object)p.symbol("unnested_corr"))), (Object)new UnnestNode.Mapping(p.symbol("masks"), (List)ImmutableList.of((Object)p.symbol("mask")))), Optional.empty(), JoinType.LEFT, (PlanNode)p.values((List<Symbol>)ImmutableList.of(), (List<List<Expression>>)ImmutableList.of((Object)ImmutableList.of()))))))).matches(PlanMatchPattern.project(PlanMatchPattern.aggregation(PlanMatchPattern.singleGroupingSet("corr", "masks", "unique"), (Map<Optional<String>, ExpectedValueProvider<AggregationFunction>>)ImmutableMap.of(Optional.of("sum"), PlanMatchPattern.aggregationFunction("sum", (List<String>)ImmutableList.of((Object)"unnested_corr"))), (List<String>)ImmutableList.of(), (List<String>)ImmutableList.of((Object)"mask"), Optional.empty(), AggregationNode.Step.SINGLE, PlanMatchPattern.unnest((List<String>)ImmutableList.of((Object)"corr", (Object)"masks", (Object)"unique"), (List<PlanMatchPattern.UnnestMapping>)ImmutableList.of((Object)PlanMatchPattern.UnnestMapping.unnestMapping("corr", (List<String>)ImmutableList.of((Object)"unnested_corr")), (Object)PlanMatchPattern.UnnestMapping.unnestMapping("masks", (List<String>)ImmutableList.of((Object)"mask"))), Optional.empty(), JoinType.LEFT, PlanMatchPattern.assignUniqueId("unique", PlanMatchPattern.values("corr", "masks"))))));
    }

    @Test
    public void testWithOrdinality() {
        this.tester().assertThat((Rule<?>)new DecorrelateLeftUnnestWithGlobalAggregation()).on(p -> p.correlatedJoin((List<Symbol>)ImmutableList.of((Object)p.symbol("corr")), (PlanNode)p.values(p.symbol("corr")), (PlanNode)p.aggregation(builder -> builder.globalGrouping().addAggregation(p.symbol("sum"), PlanBuilder.aggregation("sum", (List<Expression>)ImmutableList.of((Object)new Reference((Type)BigintType.BIGINT, "unnested_corr"))), (List<Type>)ImmutableList.of((Object)BigintType.BIGINT)).source((PlanNode)p.unnest((List<Symbol>)ImmutableList.of(), (List<UnnestNode.Mapping>)ImmutableList.of((Object)new UnnestNode.Mapping(p.symbol("corr"), (List)ImmutableList.of((Object)p.symbol("unnested_corr")))), Optional.of(p.symbol("ordinality")), JoinType.LEFT, (PlanNode)p.values((List<Symbol>)ImmutableList.of(), (List<List<Expression>>)ImmutableList.of((Object)ImmutableList.of()))))))).matches(PlanMatchPattern.project(PlanMatchPattern.aggregation(PlanMatchPattern.singleGroupingSet("unique", "corr"), (Map<Optional<String>, ExpectedValueProvider<AggregationFunction>>)ImmutableMap.of(Optional.of("sum"), PlanMatchPattern.aggregationFunction("sum", (List<String>)ImmutableList.of((Object)"unnested_corr"))), (List<String>)ImmutableList.of(), Optional.empty(), AggregationNode.Step.SINGLE, PlanMatchPattern.unnest((List<String>)ImmutableList.of((Object)"corr", (Object)"unique"), (List<PlanMatchPattern.UnnestMapping>)ImmutableList.of((Object)PlanMatchPattern.UnnestMapping.unnestMapping("corr", (List<String>)ImmutableList.of((Object)"unnested_corr"))), Optional.of("ordinality"), JoinType.LEFT, PlanMatchPattern.assignUniqueId("unique", PlanMatchPattern.values("corr"))))));
    }

    @Test
    public void testMultipleGlobalAggregations() {
        this.tester().assertThat((Rule<?>)new DecorrelateLeftUnnestWithGlobalAggregation()).on(p -> p.correlatedJoin((List<Symbol>)ImmutableList.of((Object)p.symbol("corr")), (PlanNode)p.values(p.symbol("corr")), (PlanNode)p.aggregation(outerBuilder -> outerBuilder.globalGrouping().addAggregation(p.symbol("arbitrary"), PlanBuilder.aggregation("arbitrary", (List<Expression>)ImmutableList.of((Object)new Reference((Type)BigintType.BIGINT, "sum"))), (List<Type>)ImmutableList.of((Object)BigintType.BIGINT)).source((PlanNode)p.aggregation(innerBuilder -> innerBuilder.globalGrouping().addAggregation(p.symbol("sum"), PlanBuilder.aggregation("sum", (List<Expression>)ImmutableList.of((Object)new Reference((Type)BigintType.BIGINT, "unnested_corr"))), (List<Type>)ImmutableList.of((Object)BigintType.BIGINT)).source((PlanNode)p.unnest((List<Symbol>)ImmutableList.of(), (List<UnnestNode.Mapping>)ImmutableList.of((Object)new UnnestNode.Mapping(p.symbol("corr"), (List)ImmutableList.of((Object)p.symbol("unnested_corr")))), Optional.empty(), JoinType.LEFT, (PlanNode)p.values((List<Symbol>)ImmutableList.of(), (List<List<Expression>>)ImmutableList.of((Object)ImmutableList.of()))))))))).matches(PlanMatchPattern.project(PlanMatchPattern.aggregation(PlanMatchPattern.singleGroupingSet("unique", "corr"), (Map<Optional<String>, ExpectedValueProvider<AggregationFunction>>)ImmutableMap.of(Optional.of("any_value"), PlanMatchPattern.aggregationFunction("any_value", (List<String>)ImmutableList.of((Object)"sum"))), (List<String>)ImmutableList.of(), Optional.empty(), AggregationNode.Step.SINGLE, PlanMatchPattern.aggregation(PlanMatchPattern.singleGroupingSet("unique", "corr"), (Map<Optional<String>, ExpectedValueProvider<AggregationFunction>>)ImmutableMap.of(Optional.of("sum"), PlanMatchPattern.aggregationFunction("sum", (List<String>)ImmutableList.of((Object)"unnested_corr"))), (List<String>)ImmutableList.of(), Optional.empty(), AggregationNode.Step.SINGLE, PlanMatchPattern.unnest((List<String>)ImmutableList.of((Object)"corr", (Object)"unique"), (List<PlanMatchPattern.UnnestMapping>)ImmutableList.of((Object)PlanMatchPattern.UnnestMapping.unnestMapping("corr", (List<String>)ImmutableList.of((Object)"unnested_corr"))), Optional.empty(), JoinType.LEFT, PlanMatchPattern.assignUniqueId("unique", PlanMatchPattern.values("corr")))))));
    }

    @Test
    public void testProjectOverGlobalAggregation() {
        this.tester().assertThat((Rule<?>)new DecorrelateLeftUnnestWithGlobalAggregation()).on(p -> p.correlatedJoin((List<Symbol>)ImmutableList.of((Object)p.symbol("corr")), (PlanNode)p.values(p.symbol("corr")), (PlanNode)p.project(Assignments.of((Symbol)p.symbol("sum_1", (Type)IntegerType.INTEGER), (Expression)new Call(ADD_INTEGER, (List)ImmutableList.of((Object)new Reference((Type)IntegerType.INTEGER, "sum"), (Object)new Constant((Type)IntegerType.INTEGER, (Object)1L)))), (PlanNode)p.aggregation(innerBuilder -> innerBuilder.globalGrouping().addAggregation(p.symbol("sum"), PlanBuilder.aggregation("sum", (List<Expression>)ImmutableList.of((Object)new Reference((Type)BigintType.BIGINT, "unnested_corr"))), (List<Type>)ImmutableList.of((Object)BigintType.BIGINT)).source((PlanNode)p.unnest((List<Symbol>)ImmutableList.of(), (List<UnnestNode.Mapping>)ImmutableList.of((Object)new UnnestNode.Mapping(p.symbol("corr"), (List)ImmutableList.of((Object)p.symbol("unnested_corr")))), Optional.empty(), JoinType.LEFT, (PlanNode)p.values((List<Symbol>)ImmutableList.of(), (List<List<Expression>>)ImmutableList.of((Object)ImmutableList.of())))))))).matches(PlanMatchPattern.project(PlanMatchPattern.strictProject((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"corr", (Object)PlanMatchPattern.expression((Expression)new Reference((Type)BigintType.BIGINT, "corr")), (Object)"unique", (Object)PlanMatchPattern.expression((Expression)new Reference((Type)BigintType.BIGINT, "unique")), (Object)"sum_1", (Object)PlanMatchPattern.expression((Expression)new Call(ADD_INTEGER, (List)ImmutableList.of((Object)new Reference((Type)IntegerType.INTEGER, "sum"), (Object)new Constant((Type)IntegerType.INTEGER, (Object)1L))))), PlanMatchPattern.aggregation(PlanMatchPattern.singleGroupingSet("unique", "corr"), (Map<Optional<String>, ExpectedValueProvider<AggregationFunction>>)ImmutableMap.of(Optional.of("sum"), PlanMatchPattern.aggregationFunction("sum", (List<String>)ImmutableList.of((Object)"unnested_corr"))), (List<String>)ImmutableList.of(), Optional.empty(), AggregationNode.Step.SINGLE, PlanMatchPattern.unnest((List<String>)ImmutableList.of((Object)"corr", (Object)"unique"), (List<PlanMatchPattern.UnnestMapping>)ImmutableList.of((Object)PlanMatchPattern.UnnestMapping.unnestMapping("corr", (List<String>)ImmutableList.of((Object)"unnested_corr"))), Optional.empty(), JoinType.LEFT, PlanMatchPattern.assignUniqueId("unique", PlanMatchPattern.values("corr")))))));
    }

    @Test
    public void testPreprojectUnnestSymbol() {
        this.tester().assertThat((Rule<?>)new DecorrelateLeftUnnestWithGlobalAggregation()).on(p -> {
            Symbol corr = p.symbol("corr", (Type)VarcharType.VARCHAR);
            Call regexpExtractAll = new Call(REGEXP_EXTRACT_ALL, (List)ImmutableList.of((Object)corr.toSymbolReference(), (Object)new Cast((Expression)new Constant((Type)VarcharType.VARCHAR, (Object)Slices.utf8Slice((String)".")), (Type)JoniRegexpType.JONI_REGEXP)));
            return p.correlatedJoin((List<Symbol>)ImmutableList.of((Object)corr), (PlanNode)p.values(corr), (PlanNode)p.aggregation(builder -> builder.globalGrouping().addAggregation(p.symbol("max"), PlanBuilder.aggregation("max", (List<Expression>)ImmutableList.of((Object)new Reference((Type)BigintType.BIGINT, "unnested_char"))), (List<Type>)ImmutableList.of((Object)BigintType.BIGINT)).source((PlanNode)p.unnest((List<Symbol>)ImmutableList.of(), (List<UnnestNode.Mapping>)ImmutableList.of((Object)new UnnestNode.Mapping(p.symbol("char_array", (Type)new ArrayType((Type)VarcharType.VARCHAR)), (List)ImmutableList.of((Object)p.symbol("unnested_char")))), Optional.empty(), JoinType.LEFT, (PlanNode)p.project(Assignments.of((Symbol)p.symbol("char_array", (Type)new ArrayType((Type)VarcharType.VARCHAR)), (Expression)regexpExtractAll), (PlanNode)p.values((List<Symbol>)ImmutableList.of(), (List<List<Expression>>)ImmutableList.of((Object)ImmutableList.of())))))));
        }).matches(PlanMatchPattern.project(PlanMatchPattern.aggregation(PlanMatchPattern.singleGroupingSet("corr", "unique", "char_array"), (Map<Optional<String>, ExpectedValueProvider<AggregationFunction>>)ImmutableMap.of(Optional.of("max"), PlanMatchPattern.aggregationFunction("max", (List<String>)ImmutableList.of((Object)"unnested_char"))), (List<String>)ImmutableList.of(), Optional.empty(), AggregationNode.Step.SINGLE, PlanMatchPattern.unnest((List<String>)ImmutableList.of((Object)"corr", (Object)"unique", (Object)"char_array"), (List<PlanMatchPattern.UnnestMapping>)ImmutableList.of((Object)PlanMatchPattern.UnnestMapping.unnestMapping("char_array", (List<String>)ImmutableList.of((Object)"unnested_char"))), Optional.empty(), JoinType.LEFT, PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"char_array", (Object)PlanMatchPattern.expression((Expression)new Call(REGEXP_EXTRACT_ALL, (List)ImmutableList.of((Object)new Reference((Type)VarcharType.VARCHAR, "corr"), (Object)new Cast((Expression)new Constant((Type)VarcharType.VARCHAR, (Object)Slices.utf8Slice((String)".")), (Type)JoniRegexpType.JONI_REGEXP))))), PlanMatchPattern.assignUniqueId("unique", PlanMatchPattern.values("corr")))))));
    }

    @Test
    public void testMultipleNodesOverUnnestInSubquery() {
        this.tester().assertThat((Rule<?>)new DecorrelateLeftUnnestWithGlobalAggregation()).on(p -> p.correlatedJoin((List<Symbol>)ImmutableList.of((Object)p.symbol("groups"), (Object)p.symbol("numbers")), (PlanNode)p.values(p.symbol("groups"), p.symbol("numbers")), (PlanNode)p.project(Assignments.of((Symbol)p.symbol("sum_1", (Type)BigintType.BIGINT), (Expression)new Call(ADD_BIGINT, (List)ImmutableList.of((Object)new Reference((Type)BigintType.BIGINT, "sum"), (Object)new Constant((Type)BigintType.BIGINT, (Object)1L)))), (PlanNode)p.aggregation(globalBuilder -> globalBuilder.globalGrouping().addAggregation(p.symbol("sum"), PlanBuilder.aggregation("sum", (List<Expression>)ImmutableList.of((Object)new Reference((Type)BigintType.BIGINT, "negate"))), (List<Type>)ImmutableList.of((Object)BigintType.BIGINT)).source((PlanNode)p.project(Assignments.builder().put(p.symbol("negate"), (Expression)new Call(NEGATION_BIGINT, (List)ImmutableList.of((Object)new Reference((Type)BigintType.BIGINT, "max")))).build(), (PlanNode)p.aggregation(groupedBuilder -> groupedBuilder.singleGroupingSet(p.symbol("group")).addAggregation(p.symbol("max"), PlanBuilder.aggregation("max", (List<Expression>)ImmutableList.of((Object)new Reference((Type)BigintType.BIGINT, "modulo"))), (List<Type>)ImmutableList.of((Object)BigintType.BIGINT)).source((PlanNode)p.project(Assignments.builder().putIdentities((Iterable)ImmutableList.of((Object)p.symbol("group"), (Object)p.symbol("number"))).put(p.symbol("modulo", (Type)BigintType.BIGINT), (Expression)new Call(MODULUS_BIGINT, (List)ImmutableList.of((Object)new Reference((Type)BigintType.BIGINT, "number"), (Object)new Constant((Type)BigintType.BIGINT, (Object)10L)))).build(), (PlanNode)p.unnest((List<Symbol>)ImmutableList.of(), (List<UnnestNode.Mapping>)ImmutableList.of((Object)new UnnestNode.Mapping(p.symbol("groups"), (List)ImmutableList.of((Object)p.symbol("group"))), (Object)new UnnestNode.Mapping(p.symbol("numbers"), (List)ImmutableList.of((Object)p.symbol("number")))), Optional.empty(), JoinType.LEFT, (PlanNode)p.values((List<Symbol>)ImmutableList.of(), (List<List<Expression>>)ImmutableList.of((Object)ImmutableList.of())))))))))))).matches(PlanMatchPattern.project(PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"sum_1", (Object)PlanMatchPattern.expression((Expression)new Call(ADD_BIGINT, (List)ImmutableList.of((Object)new Reference((Type)BigintType.BIGINT, "sum"), (Object)new Constant((Type)BigintType.BIGINT, (Object)1L))))), PlanMatchPattern.aggregation(PlanMatchPattern.singleGroupingSet("groups", "numbers", "unique"), (Map<Optional<String>, ExpectedValueProvider<AggregationFunction>>)ImmutableMap.of(Optional.of("sum"), PlanMatchPattern.aggregationFunction("sum", (List<String>)ImmutableList.of((Object)"negated"))), (List<String>)ImmutableList.of(), Optional.empty(), AggregationNode.Step.SINGLE, PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"negated", (Object)PlanMatchPattern.expression((Expression)new Call(NEGATION_BIGINT, (List)ImmutableList.of((Object)new Reference((Type)BigintType.BIGINT, "max"))))), PlanMatchPattern.aggregation(PlanMatchPattern.singleGroupingSet("groups", "numbers", "unique", "group"), (Map<Optional<String>, ExpectedValueProvider<AggregationFunction>>)ImmutableMap.of(Optional.of("max"), PlanMatchPattern.aggregationFunction("max", (List<String>)ImmutableList.of((Object)"modulo"))), (List<String>)ImmutableList.of(), (List<String>)ImmutableList.of(), Optional.empty(), AggregationNode.Step.SINGLE, PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"modulo", (Object)PlanMatchPattern.expression((Expression)new Call(MODULUS_BIGINT, (List)ImmutableList.of((Object)new Reference((Type)BigintType.BIGINT, "number"), (Object)new Constant((Type)BigintType.BIGINT, (Object)10L))))), PlanMatchPattern.unnest((List<String>)ImmutableList.of((Object)"groups", (Object)"numbers", (Object)"unique"), (List<PlanMatchPattern.UnnestMapping>)ImmutableList.of((Object)PlanMatchPattern.UnnestMapping.unnestMapping("groups", (List<String>)ImmutableList.of((Object)"group")), (Object)PlanMatchPattern.UnnestMapping.unnestMapping("numbers", (List<String>)ImmutableList.of((Object)"number"))), Optional.empty(), JoinType.LEFT, PlanMatchPattern.assignUniqueId("unique", PlanMatchPattern.values("groups", "numbers"))))))))));
    }
}

