/*
 * Decompiled with CFR 0.152.
 */
package io.trino.type;

import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import io.trino.spi.block.BlockBuilder;
import io.trino.spi.block.ValueBlock;
import io.trino.spi.block.VariableWidthBlockBuilder;
import io.trino.spi.type.Type;
import io.trino.spi.type.VarcharType;
import io.trino.type.AbstractTestType;
import java.util.Optional;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestUnboundedVarcharType
extends AbstractTestType {
    public TestUnboundedVarcharType() {
        super((Type)VarcharType.VARCHAR, String.class, TestUnboundedVarcharType.createTestBlock());
    }

    private static ValueBlock createTestBlock() {
        VariableWidthBlockBuilder blockBuilder = VarcharType.VARCHAR.createBlockBuilder(null, 15);
        VarcharType.VARCHAR.writeString((BlockBuilder)blockBuilder, "apple");
        VarcharType.VARCHAR.writeString((BlockBuilder)blockBuilder, "apple");
        VarcharType.VARCHAR.writeString((BlockBuilder)blockBuilder, "apple");
        VarcharType.VARCHAR.writeString((BlockBuilder)blockBuilder, "banana");
        VarcharType.VARCHAR.writeString((BlockBuilder)blockBuilder, "banana");
        VarcharType.VARCHAR.writeString((BlockBuilder)blockBuilder, "banana");
        VarcharType.VARCHAR.writeString((BlockBuilder)blockBuilder, "banana");
        VarcharType.VARCHAR.writeString((BlockBuilder)blockBuilder, "banana");
        VarcharType.VARCHAR.writeString((BlockBuilder)blockBuilder, "cherry");
        VarcharType.VARCHAR.writeString((BlockBuilder)blockBuilder, "cherry");
        VarcharType.VARCHAR.writeString((BlockBuilder)blockBuilder, "date");
        return blockBuilder.buildValueBlock();
    }

    @Override
    protected Object getGreaterValue(Object value) {
        return Slices.utf8Slice((String)(((Slice)value).toStringUtf8() + "_"));
    }

    @Test
    public void testRange() {
        Assertions.assertThat((Optional)this.type.getRange()).isEmpty();
    }

    @Test
    public void testPreviousValue() {
        Assertions.assertThat((Optional)this.type.getPreviousValue(this.getSampleValue())).isEmpty();
    }

    @Test
    public void testNextValue() {
        Assertions.assertThat((Optional)this.type.getNextValue(this.getSampleValue())).isEmpty();
    }
}

