/*
 * Decompiled with CFR 0.152.
 */
package io.trino.metadata;

import com.google.common.base.MoreObjects;
import com.google.common.base.Strings;
import io.airlift.node.AddressToHostname;
import io.trino.client.NodeVersion;
import io.trino.spi.HostAddress;
import io.trino.spi.Node;
import java.net.InetAddress;
import java.net.URI;
import java.net.UnknownHostException;
import java.util.Objects;
import java.util.Optional;

public class InternalNode
implements Node {
    private final String nodeIdentifier;
    private final URI internalUri;
    private final NodeVersion nodeVersion;
    private final boolean coordinator;

    public InternalNode(String nodeIdentifier, URI internalUri, NodeVersion nodeVersion, boolean coordinator) {
        nodeIdentifier = Strings.emptyToNull((String)Strings.nullToEmpty((String)nodeIdentifier).trim());
        this.nodeIdentifier = Objects.requireNonNull(nodeIdentifier, "nodeIdentifier is null or empty");
        this.internalUri = Objects.requireNonNull(internalUri, "internalUri is null");
        this.nodeVersion = Objects.requireNonNull(nodeVersion, "nodeVersion is null");
        this.coordinator = coordinator;
    }

    public String getNodeIdentifier() {
        return this.nodeIdentifier;
    }

    public String getHost() {
        return this.internalUri.getHost();
    }

    public URI getInternalUri() {
        return this.internalUri;
    }

    public InetAddress getInternalAddress() throws UnknownHostException {
        Optional address = AddressToHostname.tryDecodeHostnameToAddress((String)this.internalUri.getHost());
        if (address.isPresent()) {
            return (InetAddress)address.get();
        }
        return InetAddress.getByName(this.internalUri.getHost());
    }

    public HostAddress getHostAndPort() {
        return HostAddress.fromUri((URI)this.internalUri);
    }

    public String getVersion() {
        return this.nodeVersion.getVersion();
    }

    public boolean isCoordinator() {
        return this.coordinator;
    }

    public NodeVersion getNodeVersion() {
        return this.nodeVersion;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        InternalNode o = (InternalNode)obj;
        return this.coordinator == o.coordinator && Objects.equals(this.nodeIdentifier, o.nodeIdentifier) && Objects.equals(this.internalUri, o.internalUri) && Objects.equals(this.nodeVersion, o.nodeVersion);
    }

    public int hashCode() {
        return Objects.hash(this.nodeIdentifier, this.internalUri, this.nodeVersion, this.coordinator);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("nodeIdentifier", (Object)this.nodeIdentifier).add("internalUri", (Object)this.internalUri).add("nodeVersion", (Object)this.nodeVersion).add("coordinator", this.coordinator).toString();
    }
}

